/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.view;

import com.ibm.ws.dcs.common.ViewId;
import com.ibm.ws.dcs.common.event.DCSNLSEvent;
import com.ibm.ws.dcs.vri.common.nls.AbstractNLSEvent;
import com.ibm.ws.dcs.vri.common.nls.SuspectUnreadableMessageEvent;
import com.ibm.ws.dcs.vri.common.nls.TASuspectThisMemberNotInNewView;
import com.ibm.ws.dcs.vri.common.nls.TASuspectViewConfirmation;
import com.ibm.ws.dcs.vri.common.util.DCSTraceContext;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.common.DCSLogicalChannel;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.events.RmmEvent;

public final class ViewReceiverEvent
extends RmmEvent {
    private final int _configTimeout;
    static final int WRONG_HEADER_FORMAT = 1;
    static final int I_AM_OUT_OF_NEW_VIEW = 2;
    static final int MEMBER_DID_NOT_SEND_MESSAEGS_IN_NEW_VIEW = 3;
    private final DCSLogicalChannel _channel;
    private final ViewId _vid;

    public ViewReceiverEvent(int n, long l, String string, DCSLogicalChannel dCSLogicalChannel, DCSTraceContext dCSTraceContext, ViewId viewId, int n2) {
        super(n, l, string, dCSTraceContext);
        this._channel = dCSLogicalChannel;
        this._vid = viewId;
        this._configTimeout = n2;
    }

    public ViewReceiverEvent(int n, String string, DCSLogicalChannel dCSLogicalChannel, DCSTraceContext dCSTraceContext, ViewId viewId, int n2) {
        this(n, -1L, string, dCSLogicalChannel, dCSTraceContext, viewId, n2);
    }

    public String getEventSource() {
        return (String)super.getSource();
    }

    public String getDescription() {
        String string;
        switch (this._type) {
            case 1: {
                string = "View Receiver name:" + this._channel + ": Source " + this.getEventSource() + " sent Last message with a wrong format header";
                break;
            }
            case 2: {
                string = "View Receiver name:" + this._channel + ": Source " + this.getEventSource() + " sent Last message that doesn't contain this member";
                break;
            }
            case 3: {
                string = "View Receiver name:" + this._channel + ": Source " + this.getEventSource() + " did not send any messaegs on new view";
                break;
            }
            default: {
                string = "View Receiver name:" + this._channel + ": Unknown type";
            }
        }
        return string;
    }

    public DCSNLSEvent toNLSEvent() {
        AbstractNLSEvent abstractNLSEvent = null;
        switch (this._type) {
            case 1: {
                abstractNLSEvent = SuspectUnreadableMessageEvent.badHeader(this._dcsTC, this.getEventSource());
                break;
            }
            case 2: {
                abstractNLSEvent = new TASuspectThisMemberNotInNewView(this._dcsTC, this.getEventSource(), this._vid, this._channel);
                break;
            }
            case 3: {
                abstractNLSEvent = new TASuspectViewConfirmation(this._dcsTC, this.getEventSource(), this._vid, this._configTimeout, this._channel);
                break;
            }
            default: {
                abstractNLSEvent = null;
            }
        }
        return abstractNLSEvent;
    }
}

