/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.view;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.rmm.intrn.util.Sutils;
import com.ibm.rmm.receiver.StreamSelector;
import com.ibm.ws.dcs.vri.common.DCSConstants;
import com.ibm.ws.dcs.vri.common.Utils;
import com.ibm.ws.dcs.vri.common.ViewIdImpl;
import com.ibm.ws.dcs.vri.common.util.DCSTraceBuffer;
import com.ibm.ws.dcs.vri.common.util.DCSTraceContext;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.common.DCSLogicalChannel;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.view.PtpViewChannel;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.view.ViewTopicNameAnalyzer;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.util.HashSet;
import java.util.Set;

public class ViewSelector
implements StreamSelector,
DCSTraceContext {
    private boolean _acceptFromFuture = false;
    private final Set _validMembers = new HashSet();
    private ViewIdImpl _currentViewId = null;
    private ViewIdImpl _oldViewId = null;
    private final Object _mutex = new Object();
    private static TraceComponent TC = Tr.register(ViewSelector.class, "DCS", "com.ibm.ws.dcs.common.event.nls.dcs");
    PtpViewChannel _viewChannel;
    private final ViewTopicNameAnalyzer _topicAnalyzer;
    private final String _thisMemberName;
    private final String _thisStackName;
    private final DCSLogicalChannel _channel;

    ViewSelector(ViewTopicNameAnalyzer viewTopicNameAnalyzer, PtpViewChannel ptpViewChannel, DCSLogicalChannel dCSLogicalChannel, String string, String string2) {
        this._topicAnalyzer = viewTopicNameAnalyzer;
        this._viewChannel = ptpViewChannel;
        this._thisMemberName = string;
        this._thisStackName = string2;
        this._channel = dCSLogicalChannel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean acceptStream(byte[] byArray, int n, long l, InetAddress inetAddress, int n2) {
        Object object;
        String string;
        DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.propertyList();
        dCSTraceBuffer.addProperty("StreamId", l);
        dCSTraceBuffer.addProperty("Port", n2);
        dCSTraceBuffer.addProperty(this._channel);
        if (inetAddress == null) {
            if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer2 = DCSTraceBuffer.internalWarning(this, "Illegal arguments - Null source address", "ViewSelector.acceptStream()", null);
                dCSTraceBuffer2.mergePropertyList(dCSTraceBuffer);
                dCSTraceBuffer2.invoke();
            }
            return false;
        }
        if (byArray == null) {
            if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer3 = DCSTraceBuffer.internalWarning(this, "Illegal arguments - Null tag buffer", "ViewSelector.acceptStream()", null);
                dCSTraceBuffer3.mergePropertyList(dCSTraceBuffer);
                dCSTraceBuffer3.invoke();
            }
            return false;
        }
        dCSTraceBuffer.addProperty("InetAddress", inetAddress.getHostAddress());
        boolean bl = true;
        String string2 = null;
        try {
            string = Sutils.bytesToString(byArray, n);
            dCSTraceBuffer.addProperty("TopicName", Utils.toPrintableString(string));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
                object = DCSTraceBuffer.internalWarning(this, "Got exception", "ViewSelector.acceptStream()", unsupportedEncodingException);
                ((DCSTraceBuffer)object).mergePropertyList(dCSTraceBuffer);
                ((DCSTraceBuffer)object).invoke();
            }
            string = null;
        }
        if (!this._topicAnalyzer.parseIsSameStackPrefix(string)) {
            bl = false;
            string2 = "Stream is not of selector's stack";
        }
        ViewIdImpl viewIdImpl = null;
        object = null;
        if (bl) {
            viewIdImpl = this._topicAnalyzer.parseViewId(string);
            object = this._topicAnalyzer.parseSenderName(string);
            if (viewIdImpl == null) {
                string2 = "Failed to receive view id from the topic name";
                bl = false;
            } else if (object == null) {
                string2 = "Failed to receive Sender name from the topic name";
                bl = false;
            }
        }
        Object object2 = this._mutex;
        synchronized (object2) {
            String string3;
            if (bl) {
                int n3;
                if (!this._validMembers.contains(object) && !this._acceptFromFuture) {
                    bl = false;
                    string2 = "Streams from illegal sender are not accepted";
                } else if (!(this._currentViewId == null && this._acceptFromFuture || (n3 = this._currentViewId.compareTo(viewIdImpl)) == 0)) {
                    if (n3 > 0) {
                        if (this._oldViewId == null || !this._oldViewId.equals(viewIdImpl)) {
                            bl = false;
                            string2 = "Past streams are not accepted";
                        }
                    } else if (!this._acceptFromFuture) {
                        bl = false;
                        string2 = "Not receiving future messages at this point";
                    }
                }
            }
            dCSTraceBuffer.addProperty("MethodResult", bl);
            dCSTraceBuffer.addProperty("Flag", this._acceptFromFuture);
            if (bl) {
                string3 = "Accept";
            } else {
                string3 = "Reject";
                dCSTraceBuffer.addProperty("RejectReason", string2);
            }
            if (DCSTraceBuffer.isEventEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer4 = DCSTraceBuffer.event(this, "ViewSelector.acceptStream()", string3);
                dCSTraceBuffer4.mergePropertyList(dCSTraceBuffer);
                dCSTraceBuffer4.invoke();
            }
            if (bl) {
                this._viewChannel.focus("acceptStream", string3, dCSTraceBuffer);
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String dump() {
        Object object = this._mutex;
        synchronized (object) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.propertyList("ViewSelector.dump");
            dCSTraceBuffer.addProperty(this._currentViewId);
            dCSTraceBuffer.addProperty("ValidMembers", this._validMembers);
            dCSTraceBuffer.addProperty("acceptFromFuture", this._acceptFromFuture);
            return dCSTraceBuffer.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void completeCurrent() {
        Object object = this._mutex;
        synchronized (object) {
            if (DCSTraceBuffer.isEventEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this, "ViewSelector.completeCurrent()", "Setting Flag");
                dCSTraceBuffer.addProperty(this._channel);
                dCSTraceBuffer.invoke();
            }
            this._acceptFromFuture = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void newView(String[] stringArray, ViewIdImpl viewIdImpl) {
        Object object = this._mutex;
        synchronized (object) {
            if (DCSTraceBuffer.isEventEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this, "ViewSelector.newView()", "");
                dCSTraceBuffer.addProperty(this._channel);
                dCSTraceBuffer.addProperty("NVMembers", Utils.toString(stringArray));
                dCSTraceBuffer.addProperty(viewIdImpl);
                dCSTraceBuffer.invoke();
            }
            this._acceptFromFuture = false;
            this._oldViewId = this._currentViewId;
            this._currentViewId = viewIdImpl;
            this._validMembers.clear();
            if (stringArray == null || stringArray.length == 0) {
                return;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                this._validMembers.add(stringArray[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void newViewOK(String[] stringArray, ViewIdImpl viewIdImpl) {
        Object object = this._mutex;
        synchronized (object) {
            if (DCSTraceBuffer.isEventEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this, "ViewSelector.newViewOK()", "Setting Flag");
                dCSTraceBuffer.addProperty(this._channel);
                dCSTraceBuffer.addProperty("NVMembers", Utils.toString(stringArray));
                dCSTraceBuffer.addProperty(viewIdImpl);
                dCSTraceBuffer.invoke();
            }
            this._oldViewId = null;
            this._validMembers.clear();
            if (stringArray == null || stringArray.length == 0) {
                return;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                this._validMembers.add(stringArray[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeMember(String string) {
        Object object = this._mutex;
        synchronized (object) {
            this._validMembers.remove(string);
        }
    }

    public TraceComponent getTraceComponent() {
        return TC;
    }

    public String getStackName() {
        return this._thisStackName;
    }

    public String getMemberName() {
        return this._thisMemberName;
    }

    public String getLayerName() {
        return DCSConstants.TRACE_LAYER_NAMES[1];
    }
}

