/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.vri.vsync;

import com.ibm.ws.dcs.vri.common.Arrayable;
import com.ibm.ws.dcs.vri.common.CCVersion;
import com.ibm.ws.dcs.vri.common.SpaceEfficientIntArray;
import com.ibm.ws.dcs.vri.common.Utils;
import com.ibm.ws.dcs.vri.common.ViewIdImpl;
import com.ibm.ws.dcs.vri.common.util.DCSTraceContext;
import com.ibm.ws.dcs.vri.vsync.VSCCVStatusHeader;

public final class VSCCVAssignmentsHeader
extends VSCCVStatusHeader {
    private CompleterRec[] _completers;
    private AssignmentRec[] _assignments;

    public VSCCVAssignmentsHeader(DCSTraceContext dCSTraceContext, int n) {
        super(dCSTraceContext, n);
    }

    public VSCCVAssignmentsHeader(ViewIdImpl viewIdImpl, int[] nArray, SpaceEfficientIntArray spaceEfficientIntArray, CCVersion cCVersion, CompleterRec[] completerRecArray, AssignmentRec[] assignmentRecArray, DCSTraceContext dCSTraceContext, int n) {
        super(viewIdImpl, nArray, spaceEfficientIntArray, 0, cCVersion, dCSTraceContext, n);
        this._completers = completerRecArray;
        this._assignments = assignmentRecArray;
    }

    public AssignmentRec[] getAssignments() {
        return this._assignments;
    }

    public CompleterRec[] getCompleters() {
        return this._completers;
    }

    public void toArray(byte[] byArray, Utils.Offset offset) {
        int n;
        super.toArray(byArray, offset);
        Utils.int2byteArray(this._completers.length, byArray, offset);
        for (n = 0; n < this._completers.length; ++n) {
            Utils.int2byteArray(this._completers[n]._failedMember, byArray, offset);
            Utils.int2byteArray(this._completers[n]._completer, byArray, offset);
        }
        Utils.int2byteArray(this._assignments.length, byArray, offset);
        for (n = 0; n < this._assignments.length; ++n) {
            Utils.int2byteArray(this._assignments[n]._failedMember, byArray, offset);
            this._assignments[n]._rcvMsgs.toArray(byArray, offset);
        }
    }

    public Arrayable fromArray(byte[] byArray, Utils.Offset offset) {
        int n;
        if (super.fromArray(byArray, offset) == null) {
            return null;
        }
        int n2 = Utils.byteArray2int(byArray, offset);
        this._completers = new CompleterRec[n2];
        for (n = 0; n < n2; ++n) {
            this._completers[n] = new CompleterRec(Utils.byteArray2int(byArray, offset), Utils.byteArray2int(byArray, offset));
        }
        n = Utils.byteArray2int(byArray, offset);
        this._assignments = new AssignmentRec[n];
        for (int i = 0; i < n; ++i) {
            int n3 = Utils.byteArray2int(byArray, offset);
            SpaceEfficientIntArray spaceEfficientIntArray = (SpaceEfficientIntArray)new SpaceEfficientIntArray().fromArray(byArray, offset);
            this._assignments[i] = new AssignmentRec(n3, spaceEfficientIntArray);
        }
        return this;
    }

    public int getLength() {
        int n = Utils.sizeOfInt() + this._completers.length * 2 * Utils.sizeOfInt();
        int n2 = Utils.sizeOfInt();
        for (int i = 0; i < this._assignments.length; ++i) {
            n2 += Utils.sizeOfInt() + this._assignments[i]._rcvMsgs.getLength();
        }
        return super.getLength() + n + n2;
    }

    public static class AssignmentRec {
        public int _failedMember;
        public SpaceEfficientIntArray _rcvMsgs;

        public AssignmentRec(int n, SpaceEfficientIntArray spaceEfficientIntArray) {
            this._failedMember = n;
            this._rcvMsgs = spaceEfficientIntArray;
        }

        public String toString() {
            String string = "Assignment for failed member " + this._failedMember;
            return string + " whose rcv vector is: " + this._rcvMsgs.toString();
        }
    }

    public static class CompleterRec {
        private static String eol = System.getProperty("line.separator");
        public int _failedMember;
        public int _completer;

        public CompleterRec(int n, int n2) {
            this._failedMember = n;
            this._completer = n2;
        }

        public String toString() {
            return "Completer " + this._completer + " for failed member " + this._failedMember + eol;
        }
    }
}

