/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.vri.vsync;

import com.ibm.ws.dcs.vri.common.Arrayable;
import com.ibm.ws.dcs.vri.common.Header;
import com.ibm.ws.dcs.vri.common.Utils;
import com.ibm.ws.dcs.vri.common.ViewIdImpl;
import com.ibm.ws.dcs.vri.common.util.DCSTraceBuffer;
import com.ibm.ws.dcs.vri.common.util.DCSTraceContext;

public abstract class VSHeader
extends Header {
    private ViewIdImpl _viewId = null;
    private final DCSTraceContext _dtc;

    VSHeader(DCSTraceContext dCSTraceContext, int n) {
        this._layer = (byte)2;
        this._dtc = dCSTraceContext;
        this.setVersion(n);
    }

    public ViewIdImpl getViewId() {
        return this._viewId;
    }

    VSHeader(ViewIdImpl viewIdImpl, DCSTraceContext dCSTraceContext, int n) {
        super((byte)2, n);
        this._version = n;
        this._viewId = viewIdImpl;
        this._dtc = dCSTraceContext;
    }

    public void toArray(byte[] byArray, Utils.Offset offset) {
        Utils.int2byteArray(this._version, byArray, offset);
        this._viewId.toArray(byArray, offset);
    }

    public Arrayable fromArray(byte[] byArray, Utils.Offset offset) {
        int n = Utils.byteArray2int(byArray, offset);
        if (n != this._version) {
            if (DCSTraceBuffer.isInternalWarningEnabled(this._dtc.getTraceComponent())) {
                DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.internalWarning(this._dtc, "Incompatible header version", "VSHeader.fromArray()", null);
                dCSTraceBuffer.addProperty("My", "HeaderVersion", Integer.toString(this._version));
                dCSTraceBuffer.addProperty("Sender", "HeaderVersion", Integer.toString(n));
                dCSTraceBuffer.invoke();
            }
            return null;
        }
        this._viewId = (ViewIdImpl)new ViewIdImpl().fromArray(byArray, offset);
        if (this._viewId == null) {
            return null;
        }
        return this;
    }

    public int getLength() {
        return Utils.sizeOfInt() + this._viewId.getLength();
    }
}

