/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.vri.vsync;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.dcs.vri.common.DCSConstants;
import com.ibm.ws.dcs.vri.common.VRIMessage;
import com.ibm.ws.dcs.vri.common.util.DCSTraceBuffer;
import com.ibm.ws.dcs.vri.common.util.DCSTraceContext;
import com.ibm.ws.dcs.vri.vsync.VSGotFutureNotConsecutiveVSMessageException;
import com.ibm.ws.dcs.vri.vsync.VSNotOrigHeader;
import com.ibm.ws.dcs.vri.vsync.VSRBAMessageHasNotBeenReceivedException;
import com.ibm.ws.dcs.vri.vsync.VSRequestedMessagesHaveBeenDeletedException;
import com.ibm.ws.dcs.vri.vsync.VSUnRBAMessageHasBeenDeletedException;
import com.ibm.ws.dcs.vri.vsync.VSync;
import java.util.LinkedList;
import java.util.ListIterator;

public final class VSIncomingSavedMessages
implements DCSTraceContext {
    VSync _vs;
    private static TraceComponent TC = Tr.register(VSIncomingSavedMessages.class, "DCS", "com.ibm.ws.dcs.common.event.nls.dcs");
    private LinkedList[] _savedMessages;
    private int[] _rcvMessagesStatus;
    private int _savedMessagesCounter;
    private int _savedBytesCounter;
    private int _viewSize;
    private String _thisStackName;
    private final String _thisMemberName;

    VSIncomingSavedMessages(String string, String string2, VSync vSync) {
        DCSTraceBuffer dCSTraceBuffer;
        this._thisStackName = string;
        this._thisMemberName = string2;
        this._vs = vSync;
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            dCSTraceBuffer = DCSTraceBuffer.entry(this, "VSIncomingSavedMessages.VSIncomingSavedMessages()", null);
            dCSTraceBuffer.invoke();
        }
        this.newView(1);
        if (DCSTraceBuffer.isExitEnabled(TC)) {
            dCSTraceBuffer = DCSTraceBuffer.exit(this, "VSIncomingSavedMessages.VSIncomingSavedMessages()", null);
            dCSTraceBuffer.invoke();
        }
    }

    void newView(int n) {
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.entry(this, "VSIncomingSavedMessages.newView()", null);
            dCSTraceBuffer.addProperty("viewSize", n);
            dCSTraceBuffer.invoke();
        }
        this._viewSize = n;
        this._savedMessages = new LinkedList[n];
        this._rcvMessagesStatus = new int[n];
        for (int i = 0; i < n; ++i) {
            this._savedMessages[i] = new LinkedList();
            this._rcvMessagesStatus[i] = 0;
        }
        this._savedMessagesCounter = 0;
        this._savedBytesCounter = 0;
        if (DCSTraceBuffer.isExitEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.exit(this, "VSIncomingSavedMessages.newView()", null);
            dCSTraceBuffer.invoke();
        }
    }

    public boolean saveVSMessage(VRIMessage vRIMessage, int n, int n2) throws VSGotFutureNotConsecutiveVSMessageException {
        int n3;
        int n4;
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.entry(this, "VSIncomingSavedMessages.saveVSMessage()", null);
            dCSTraceBuffer.addProperty("Sender", "MemberViewIndex", n);
            dCSTraceBuffer.addProperty("VsyncMessageNumber", n2);
            dCSTraceBuffer.invoke();
        }
        if ((n4 = n2 - (n3 = this._rcvMessagesStatus[n])) <= 0) {
            DCSTraceBuffer dCSTraceBuffer;
            if (DCSTraceBuffer.isDebugEnabled(TC)) {
                dCSTraceBuffer = DCSTraceBuffer.debug(this, "VSIncomingSavedMessages.saveVSMessage()", "Ignore an old message");
                dCSTraceBuffer.invoke();
            }
            if (DCSTraceBuffer.isExitEnabled(TC)) {
                dCSTraceBuffer = DCSTraceBuffer.exit(this, "VSIncomingSavedMessages.saveVSMessage()", "Ignore an old message");
                dCSTraceBuffer.invoke();
            }
            return false;
        }
        if (n4 == 1) {
            Object object;
            if (DCSTraceBuffer.isDebugEnabled(TC)) {
                object = DCSTraceBuffer.debug(this, "VSIncomingSavedMessages.saveVSMessage()", "save consecutive message");
                ((DCSTraceBuffer)object).invoke();
            }
            object = vRIMessage.copy(false);
            this._savedMessages[n].addLast(object);
            int n5 = n;
            this._rcvMessagesStatus[n5] = this._rcvMessagesStatus[n5] + 1;
            int n6 = object.getDataBuffer().length;
            this._savedBytesCounter += n6;
            ++this._savedMessagesCounter;
            if (DCSTraceBuffer.isExitEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.exit(this, "VSIncomingSavedMessages.saveVSMessage()", "save consecutive message");
                dCSTraceBuffer.invoke();
            }
            return true;
        }
        VSGotFutureNotConsecutiveVSMessageException vSGotFutureNotConsecutiveVSMessageException = new VSGotFutureNotConsecutiveVSMessageException(n, n3, n2);
        throw vSGotFutureNotConsecutiveVSMessageException;
    }

    public LinkedList getSavedVSMessages(int n, int n2) throws VSRequestedMessagesHaveBeenDeletedException {
        Object object;
        Object object2;
        int n3;
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.entry(this, "VSIncomingSavedMessages.getSavedVSMessages()", null);
            dCSTraceBuffer.addProperty("Sender", "MemberViewIndex", n);
            dCSTraceBuffer.addProperty("VsyncMessageNumber", n2);
            dCSTraceBuffer.invoke();
        }
        if ((n3 = n2 - this._rcvMessagesStatus[n]) > 0) {
            DCSTraceBuffer dCSTraceBuffer;
            if (DCSTraceBuffer.isEventEnabled(TC)) {
                dCSTraceBuffer = DCSTraceBuffer.event(this, "VSIncomingSavedMessages.getSavedVSMessages()", "requested message has not been received");
                dCSTraceBuffer.invoke();
            }
            if (DCSTraceBuffer.isExitEnabled(TC)) {
                dCSTraceBuffer = DCSTraceBuffer.exit(this, "VSIncomingSavedMessages.getSavedVSMessages()", "requested message has not been received");
                dCSTraceBuffer.invoke();
            }
            return null;
        }
        if (this._savedMessages[n].isEmpty()) {
            VSRequestedMessagesHaveBeenDeletedException vSRequestedMessagesHaveBeenDeletedException = new VSRequestedMessagesHaveBeenDeletedException(n, "No VS messages are saved from sender " + n + ".last rcv msg from sender is " + this._rcvMessagesStatus[n] + ". requested msg is " + n2);
            throw vSRequestedMessagesHaveBeenDeletedException;
        }
        VRIMessage vRIMessage = (VRIMessage)this._savedMessages[n].getFirst();
        int n4 = this.getVSMessageID(vRIMessage);
        n3 = n4 - n2;
        if (n3 > 0) {
            VSRequestedMessagesHaveBeenDeletedException vSRequestedMessagesHaveBeenDeletedException = new VSRequestedMessagesHaveBeenDeletedException(n, "First message stored from sender " + n + " is " + n4 + ", while requested message is " + n2);
            throw vSRequestedMessagesHaveBeenDeletedException;
        }
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            object2 = DCSTraceBuffer.event(this, "VSIncomingSavedMessages.getSavedVSMessages()", "returning requested messages");
            ((DCSTraceBuffer)object2).invoke();
        }
        object2 = this._savedMessages[n].listIterator(this._savedMessages[n].size());
        LinkedList<VRIMessage> linkedList = new LinkedList<VRIMessage>();
        while (object2.hasPrevious() && n2 - this.getVSMessageID((VRIMessage)(object = (VRIMessage)object2.previous())) <= 0) {
            linkedList.addFirst(object.copy(true));
        }
        if (DCSTraceBuffer.isExitEnabled(TC)) {
            object = DCSTraceBuffer.exit(this, "VSIncomingSavedMessages.getSavedVSMessages()", "returning requested messages");
            ((DCSTraceBuffer)object).invoke();
        }
        return linkedList;
    }

    int getLastRcvMessageIDFromSender(int n) {
        return this._rcvMessagesStatus[n];
    }

    public int[] getLastRcvMessagesIDsStatus() {
        return this._rcvMessagesStatus;
    }

    void deleteMessagesByRBA(int[] nArray) throws VSUnRBAMessageHasBeenDeletedException, VSRBAMessageHasNotBeenReceivedException {
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.entry(this, "VSIncomingSavedMessages.deleteMessagesByRBA()", null);
            dCSTraceBuffer.addProperty("VsyncRBAVector", nArray);
            dCSTraceBuffer.invoke();
        }
        for (int i = 0; i < this._viewSize; ++i) {
            this.deleteMessagesFromSender(i, nArray[i]);
        }
        if (DCSTraceBuffer.isExitEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.exit(this, "VSIncomingSavedMessages.deleteMessagesByRBA()", "End of method");
            dCSTraceBuffer.invoke();
        }
    }

    boolean isEmpty() {
        return this._savedMessagesCounter == 0;
    }

    String dump() {
        if (DCSTraceBuffer.isDumpEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.dump(this, "VSIncomingSavedMessages.dump()", null);
            dCSTraceBuffer.addProperty("Status", this.toString());
            return dCSTraceBuffer.toString();
        }
        return "";
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n==================================================\n");
        stringBuffer.append("VSIncomingSavedMessages details:\n");
        stringBuffer.append("--------------------------------\n");
        stringBuffer.append("Dumping saved messages ids\n");
        for (n = 0; n < this._viewSize; ++n) {
            stringBuffer.append("From sender id " + n + ": ");
            if (this._savedMessages[n].isEmpty()) {
                stringBuffer.append("none\n");
                continue;
            }
            VRIMessage vRIMessage = (VRIMessage)this._savedMessages[n].getFirst();
            VRIMessage vRIMessage2 = (VRIMessage)this._savedMessages[n].getLast();
            stringBuffer.append("Total messages: " + this._savedMessages[n].size() + ", First msg is " + this.getVSMessageID(vRIMessage) + ", Last msg is " + this.getVSMessageID(vRIMessage2) + "\n");
        }
        stringBuffer.append("\n");
        stringBuffer.append("--------------------------------\n");
        stringBuffer.append("Dumping rcv messages status:\n");
        for (n = 0; n < this._viewSize; ++n) {
            stringBuffer.append("From sender id " + n + ":" + this._rcvMessagesStatus[n] + "\n");
        }
        stringBuffer.append("--------------------------------\n");
        stringBuffer.append("Saved messages counter:" + this._savedMessagesCounter + "\n");
        stringBuffer.append("Saved bytes counter:" + this._savedBytesCounter + "\n");
        stringBuffer.append("==================================================\n");
        return stringBuffer.toString();
    }

    public boolean check(int[] nArray) {
        int n;
        DCSTraceBuffer dCSTraceBuffer;
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer2 = DCSTraceBuffer.entry(this, "VSIncomingSavedMessages.check()", null);
            dCSTraceBuffer2.addProperty("VsyncRBAVector", nArray);
            dCSTraceBuffer2.invoke();
        }
        int n2 = 0;
        boolean bl = true;
        if (this._rcvMessagesStatus.length != this._viewSize) {
            if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
                dCSTraceBuffer = DCSTraceBuffer.internalWarning(this, "Received message status length is incompatible with the view size", "VSIncomingSavedMessages.check()", null);
                dCSTraceBuffer.addProperty("_rcvMessagesStatus.length", this._rcvMessagesStatus.length);
                dCSTraceBuffer.addProperty("viewSize", this._viewSize);
                dCSTraceBuffer.invoke();
            }
            bl = false;
        }
        if (this._savedMessages.length != this._viewSize) {
            if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
                dCSTraceBuffer = DCSTraceBuffer.internalWarning(this, "Saved message length is incompatible with the view size", "VSIncomingSavedMessages.check()", null);
                dCSTraceBuffer.addProperty("_savedMessages.length", this._savedMessages.length);
                dCSTraceBuffer.addProperty("viewSize", this._viewSize);
                dCSTraceBuffer.invoke();
            }
            bl = false;
        }
        for (n = 0; n < this._viewSize; ++n) {
            if (this._savedMessages[n].isEmpty()) continue;
            int n3 = this.getVSMessageID((VRIMessage)this._savedMessages[n].getFirst()) - 1;
            ListIterator listIterator = this._savedMessages[n].listIterator();
            while (listIterator.hasNext()) {
                int n4 = this.getVSMessageID((VRIMessage)listIterator.next());
                ++n2;
                if (n4 != n3 + 1) {
                    if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
                        DCSTraceBuffer dCSTraceBuffer3 = DCSTraceBuffer.internalWarning(this, "Unconsecutive saved message", "VSIncomingSavedMessages.check()", null);
                        dCSTraceBuffer3.addProperty("Sender", "MemberViewIndex", n);
                        dCSTraceBuffer3.addProperty("Current", "VsyncMessageNumber", n4);
                        dCSTraceBuffer3.addProperty("Previous", "VsyncMessageNumber", n3);
                        dCSTraceBuffer3.invoke();
                    }
                    bl = false;
                }
                n3 = n4;
            }
        }
        if (bl && DCSTraceBuffer.isDebugEnabled(TC)) {
            dCSTraceBuffer = DCSTraceBuffer.debug(this, "VSIncomingSavedMessages.check()", "All msgs are consecutive");
            dCSTraceBuffer.invoke();
        }
        if (n2 != this._savedMessagesCounter) {
            if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
                dCSTraceBuffer = DCSTraceBuffer.internalWarning(this, "Illegal messages counter", "VSIncomingSavedMessages.check()", null);
                dCSTraceBuffer.addProperty("CheckCounter", n2);
                dCSTraceBuffer.addProperty("_savedMessagesCounter", this._savedMessagesCounter);
                dCSTraceBuffer.invoke();
            }
            bl = false;
        } else if (DCSTraceBuffer.isDebugEnabled(TC)) {
            dCSTraceBuffer = DCSTraceBuffer.debug(this, "VSIncomingSavedMessages.check()", "Messages counter is valid");
            dCSTraceBuffer.invoke();
        }
        for (n = 0; n < this._viewSize; ++n) {
            DCSTraceBuffer dCSTraceBuffer4;
            int n5 = nArray[n];
            int n6 = this._rcvMessagesStatus[n];
            if (this._savedMessages[n].isEmpty()) {
                if (n6 == n5) continue;
                if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
                    DCSTraceBuffer dCSTraceBuffer5 = DCSTraceBuffer.internalWarning(this, "Incompatible last received message", "VSIncomingSavedMessages.check()", null);
                    dCSTraceBuffer5.addProperty("Sender", "MemberViewIndex", n);
                    dCSTraceBuffer5.addProperty("Last", "VsyncMessageNumber", n6);
                    dCSTraceBuffer5.addProperty("VsyncRBAVector", n5);
                    dCSTraceBuffer5.invoke();
                }
                bl = false;
                continue;
            }
            int n7 = this.getVSMessageID((VRIMessage)this._savedMessages[n].getFirst());
            int n8 = this.getVSMessageID((VRIMessage)this._savedMessages[n].getLast());
            if (n5 + 1 - n7 < 0 || n8 - n5 < 0) {
                if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
                    dCSTraceBuffer4 = DCSTraceBuffer.internalWarning(this, "The invariant ((RBA + 1 >= M1) && (RBA <= Mk)) doesn't fulfil", "VSIncomingSavedMessages.check()", null);
                    dCSTraceBuffer4.addProperty("Sender", "MemberViewIndex", n);
                    dCSTraceBuffer4.addProperty("M1", n7);
                    dCSTraceBuffer4.addProperty("Mk", n8);
                    dCSTraceBuffer4.addProperty("VsyncRBAVector", n5);
                    dCSTraceBuffer4.invoke();
                }
                bl = false;
            }
            if (n8 == n6) continue;
            if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
                dCSTraceBuffer4 = DCSTraceBuffer.internalWarning(this, "Messages are saved from the sender, yet, Mk != L", "VSIncomingSavedMessages.check()", null);
                dCSTraceBuffer4.addProperty("Sender", "MemberViewIndex", n);
                dCSTraceBuffer4.addProperty("Mk", n8);
                dCSTraceBuffer4.addProperty("Last", "VsyncMessageNumber", n6);
                dCSTraceBuffer4.invoke();
            }
            bl = false;
        }
        if (bl) {
            if (DCSTraceBuffer.isDebugEnabled(TC)) {
                dCSTraceBuffer = DCSTraceBuffer.debug(this, "VSIncomingSavedMessages.check()", "Check succeeded");
                dCSTraceBuffer.invoke();
            }
        } else if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
            dCSTraceBuffer = DCSTraceBuffer.internalWarning(this, "Vsync check failed", "VSIncomingSavedMessages.check()", null);
            dCSTraceBuffer.invoke();
        }
        if (DCSTraceBuffer.isExitEnabled(TC)) {
            dCSTraceBuffer = DCSTraceBuffer.exit(this, "VSIncomingSavedMessages.check()", null);
            dCSTraceBuffer.addProperty("MethodResult", bl);
            dCSTraceBuffer.invoke();
        }
        return bl;
    }

    private void deleteMessagesFromSender(int n, int n2) throws VSUnRBAMessageHasBeenDeletedException, VSRBAMessageHasNotBeenReceivedException {
        Object object;
        int n3;
        int n4;
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.entry(this, "VSIncomingSavedMessages.deleteMessagesFromSender()", null);
            dCSTraceBuffer.addProperty("Sender", "MemberViewIndex", n);
            dCSTraceBuffer.addProperty("VsyncMessageNumber", n2);
            dCSTraceBuffer.invoke();
        }
        if ((n4 = n2 - this._rcvMessagesStatus[n]) > 0) {
            VSRBAMessageHasNotBeenReceivedException vSRBAMessageHasNotBeenReceivedException = new VSRBAMessageHasNotBeenReceivedException(n, "sender: " + n + ".RBAMsgID: " + n2 + ".last received from sender: " + this._rcvMessagesStatus[n]);
            throw vSRBAMessageHasNotBeenReceivedException;
        }
        ListIterator listIterator = this._savedMessages[n].listIterator();
        while (listIterator.hasNext() && (n3 = this.getVSMessageID((VRIMessage)(object = (VRIMessage)listIterator.next()))) <= n2) {
            int n5 = object.getDataBuffer().length;
            this._savedBytesCounter -= n5;
            --this._savedMessagesCounter;
            listIterator.remove();
        }
        n4 = this._rcvMessagesStatus[n] - (n2 + 1);
        if (n4 >= 0) {
            if (this._savedMessages[n].isEmpty()) {
                if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
                    object = DCSTraceBuffer.internalWarning(this, "Status claims that I received a msg but saved msgs are empty", "VSIncomingSavedMessages.deleteMessagesFromSender()", null);
                    ((DCSTraceBuffer)object).addProperty("Sender", "MemberViewIndex", n);
                    ((DCSTraceBuffer)object).addProperty("Last", "VsyncMessageNumber", this._rcvMessagesStatus[n]);
                    ((DCSTraceBuffer)object).addProperty("VsyncRBAVector", n2);
                    ((DCSTraceBuffer)object).invoke();
                }
                object = new VSUnRBAMessageHasBeenDeletedException(n);
                throw object;
            }
            int n6 = this.getVSMessageID((VRIMessage)this._savedMessages[n].getFirst());
            n4 = n6 - (n2 + 1);
            if (n4 > 0) {
                if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
                    DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.internalWarning(this, "Internal problem with the queue of saved msgs, first saved msgs id: " + n6, "VSIncomingSavedMessages.deleteMessagesFromSender()", null);
                    dCSTraceBuffer.addProperty("Sender", "MemberViewIndex", n);
                    dCSTraceBuffer.addProperty("Last", "VsyncMessageNumber", this._rcvMessagesStatus[n]);
                    dCSTraceBuffer.addProperty("VsyncRBAVector", n2);
                    dCSTraceBuffer.invoke();
                }
                VSUnRBAMessageHasBeenDeletedException vSUnRBAMessageHasBeenDeletedException = new VSUnRBAMessageHasBeenDeletedException(n, "RBA is " + n2 + ". first saved msg is " + n6);
                throw vSUnRBAMessageHasBeenDeletedException;
            }
        }
        if (DCSTraceBuffer.isExitEnabled(TC)) {
            object = DCSTraceBuffer.exit(this, "VSIncomingSavedMessages.deleteMessagesFromSender()", null);
            ((DCSTraceBuffer)object).invoke();
        }
    }

    public int getSavedMsgsNumber() {
        return this._savedMessagesCounter;
    }

    private int getVSMessageID(VRIMessage vRIMessage) {
        VSNotOrigHeader vSNotOrigHeader = (VSNotOrigHeader)vRIMessage.getHeader(new VSNotOrigHeader(this, this._vs._version));
        return vSNotOrigHeader.getMsgId();
    }

    public int getSavedBytesNumber() {
        return this._savedBytesCounter;
    }

    public TraceComponent getTraceComponent() {
        return TC;
    }

    public String getStackName() {
        return this._thisStackName;
    }

    public String getMemberName() {
        return this._thisMemberName;
    }

    public String getLayerName() {
        return DCSConstants.TRACE_LAYER_NAMES[2];
    }
}

