/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.vri.vsync;

import com.ibm.ws.dcs.vri.common.Arrayable;
import com.ibm.ws.dcs.vri.common.Utils;
import com.ibm.ws.dcs.vri.common.ViewIdImpl;
import com.ibm.ws.dcs.vri.common.util.DCSTraceContext;
import com.ibm.ws.dcs.vri.vsync.VSHeader;

public final class VSNotOrigHeader
extends VSHeader {
    private static final int DEFAULT_VALUE = -1;
    public static final byte MCAST_DELIVERY = 1;
    public static final byte P2P_DELIVERY = 2;
    private byte _delivery = (byte)-1;
    private int _origSender = -1;
    private int _vsMsgId = -1;
    private VSBitSet _bitSet;

    public VSNotOrigHeader(DCSTraceContext dCSTraceContext, int n) {
        super(dCSTraceContext, n);
        this._bitSet = new VSBitSet();
    }

    VSNotOrigHeader(ViewIdImpl viewIdImpl, DCSTraceContext dCSTraceContext, int n) {
        super(viewIdImpl, dCSTraceContext, n);
        this._delivery = (byte)2;
        this._bitSet = new VSBitSet();
    }

    public VSNotOrigHeader(ViewIdImpl viewIdImpl, int n, int n2, VSBitSet vSBitSet, DCSTraceContext dCSTraceContext, int n3) {
        super(viewIdImpl, dCSTraceContext, n3);
        this._delivery = 1;
        this._origSender = n;
        this._vsMsgId = n2;
        this._bitSet = vSBitSet;
    }

    public int getLength() {
        int n = 1;
        if (this._delivery == 1) {
            n += Utils.sizeOfInt() + Utils.sizeOfInt();
        }
        return n + super.getLength() + (this._version == 0x1000000 ? 0 : this._bitSet.getLength());
    }

    public byte getDelivery() {
        return this._delivery;
    }

    public int getOrigSender() {
        return this._origSender;
    }

    public int getMsgId() {
        return this._vsMsgId;
    }

    public VSBitSet getBitSet() {
        return this._bitSet;
    }

    public void toArray(byte[] byArray, Utils.Offset offset) {
        super.toArray(byArray, offset);
        int n = offset.getValue();
        byArray[n++] = this._delivery;
        offset.setValue(n);
        if (this._version != 0x1000000) {
            this._bitSet.toArray(byArray, offset);
        }
        if (this._delivery == 1) {
            Utils.int2byteArray(this._origSender, byArray, offset);
            Utils.int2byteArray(this._vsMsgId, byArray, offset);
        }
    }

    public Arrayable fromArray(byte[] byArray, Utils.Offset offset) {
        if (super.fromArray(byArray, offset) == null) {
            return null;
        }
        int n = offset.getValue();
        this._delivery = byArray[n++];
        offset.setValue(n);
        if (this._version != 0x1000000) {
            this._bitSet.fromArray(byArray, offset);
        }
        if (this._delivery == 1) {
            this._origSender = Utils.byteArray2int(byArray, offset);
            this._vsMsgId = Utils.byteArray2int(byArray, offset);
        }
        return this;
    }

    public static class VSBitSet
    implements Arrayable {
        private static final int ADDRESS_BITS_PER_UNIT = 3;
        private static final int BITS_PER_UNIT = 8;
        private static final int BIT_INDEX_MASK = 7;
        private byte[] bits;

        private static int unitIndex(int n) {
            return n >> 3;
        }

        private static int bit(int n) {
            return 1 << (n & 7);
        }

        public VSBitSet(int n) {
            if (n < 0) {
                throw new NegativeArraySizeException("nbits < 0: " + n);
            }
            this.bits = new byte[VSBitSet.unitIndex(n - 1) + 1];
        }

        public VSBitSet() {
        }

        public void set(int n) {
            if (n < 0) {
                throw new IndexOutOfBoundsException("bitIndex: " + n);
            }
            int n2 = VSBitSet.unitIndex(n);
            if (n2 >= this.bits.length) {
                throw new IndexOutOfBoundsException("bitIndex: " + n);
            }
            int n3 = n2;
            this.bits[n3] = (byte)(this.bits[n3] | VSBitSet.bit(n));
        }

        public boolean get(int n) {
            if (n < 0) {
                throw new IndexOutOfBoundsException("bitIndex: " + n);
            }
            int n2 = VSBitSet.unitIndex(n);
            if (n2 >= this.bits.length) {
                throw new IndexOutOfBoundsException("bitIndex: " + n);
            }
            return (this.bits[n2] & VSBitSet.bit(n)) != 0;
        }

        public void toArray(byte[] byArray, Utils.Offset offset) {
            if (this.bits == null) {
                Utils.int2byteArray(0, byArray, offset);
                return;
            }
            Utils.int2byteArray(this.bits.length, byArray, offset);
            int n = offset.getValue();
            System.arraycopy(this.bits, 0, byArray, n, this.bits.length);
            offset.setValue(n + this.bits.length);
        }

        public Arrayable fromArray(byte[] byArray, Utils.Offset offset) {
            int n = Utils.byteArray2int(byArray, offset);
            if (n != 0) {
                int n2 = offset.getValue();
                this.bits = new byte[n];
                System.arraycopy(byArray, n2, this.bits, 0, n);
                offset.setValue(n2 + n);
            }
            return this;
        }

        public boolean isSubgroupSend() {
            return this.bits != null;
        }

        public int getLength() {
            return this.bits == null ? Utils.sizeOfInt() : Utils.sizeOfInt() + this.bits.length;
        }
    }
}

