/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.vri.vsync;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.dcs.common.QoS;
import com.ibm.ws.dcs.common.event.DCSSuspectEvent;
import com.ibm.ws.dcs.common.event.DCSTerminationEvent;
import com.ibm.ws.dcs.common.exception.DCSAssertException;
import com.ibm.ws.dcs.common.exception.DCSIllegalParameterException;
import com.ibm.ws.dcs.common.exception.DCSInvalidParametersException;
import com.ibm.ws.dcs.common.exception.DCSTransportLayerException;
import com.ibm.ws.dcs.vri.common.AddDefinedFailedException;
import com.ibm.ws.dcs.vri.common.CCVersion;
import com.ibm.ws.dcs.vri.common.DCSConstants;
import com.ibm.ws.dcs.vri.common.Downcalls;
import com.ibm.ws.dcs.vri.common.Globals;
import com.ibm.ws.dcs.vri.common.LayerLinkage;
import com.ibm.ws.dcs.vri.common.Upcalls;
import com.ibm.ws.dcs.vri.common.Utils;
import com.ibm.ws.dcs.vri.common.VRICheckFailedException;
import com.ibm.ws.dcs.vri.common.VRIIllegalStateException;
import com.ibm.ws.dcs.vri.common.VRIMemberDescription;
import com.ibm.ws.dcs.vri.common.VRIMemberUtils;
import com.ibm.ws.dcs.vri.common.VRIMembersMGR;
import com.ibm.ws.dcs.vri.common.VRIMessage;
import com.ibm.ws.dcs.vri.common.ViewIdImpl;
import com.ibm.ws.dcs.vri.common.event.VRIDownEvent;
import com.ibm.ws.dcs.vri.common.event.VRIUpEvent;
import com.ibm.ws.dcs.vri.common.impl.BaseVRIMessageFactory;
import com.ibm.ws.dcs.vri.common.nls.TerminationEvent;
import com.ibm.ws.dcs.vri.common.nls.VSIgnoreMessage;
import com.ibm.ws.dcs.vri.common.nls.VSSuspectTimeout;
import com.ibm.ws.dcs.vri.common.util.DCSTraceBuffer;
import com.ibm.ws.dcs.vri.common.util.DCSTraceContext;
import com.ibm.ws.dcs.vri.common.util.FFDCDumper;
import com.ibm.ws.dcs.vri.vsync.VSDenialReason;
import com.ibm.ws.dcs.vri.vsync.VSIncomingSavedMessages;
import com.ibm.ws.dcs.vri.vsync.VSInternalException;
import com.ibm.ws.dcs.vri.vsync.VSNotOrigHeader;
import com.ibm.ws.dcs.vri.vsync.VSRBAMessageHasNotBeenReceivedException;
import com.ibm.ws.dcs.vri.vsync.VSState;
import com.ibm.ws.dcs.vri.vsync.VSUnRBAMessageHasBeenDeletedException;
import com.ibm.ws.dcs.vri.vsync.VSViewStatus;
import com.ibm.ws.dcs.vri.vsync.VSyncAlgo;
import com.ibm.ws.dcs.vri.vsync.impl1.VSState1;
import com.ibm.ws.dcs.vri.vsync.impl1.VSViewStatus1;
import com.ibm.ws.dcs.vri.vsync.impl1.VSyncAlgo1;
import com.ibm.ws.dcs.vri.vsync.impl2.VSState2;
import com.ibm.ws.dcs.vri.vsync.impl2.VSViewStatus2;
import com.ibm.ws.dcs.vri.vsync.impl2.VSyncAlgo2;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public final class VSync
implements Downcalls,
Upcalls,
LayerLinkage,
DCSTraceContext {
    public int _version;
    public static int EVENT = 1;
    public static int IN_MSG = 2;
    public static int OUT_MSG = 3;
    private static String[] FOCUS_EVENT_NAMES = new String[]{"", "EVENT   ", "IN_MSG  ", "OUT_MSG "};
    private HashSet _focusReportedEvents = new HashSet();
    private static final int MEMBER_LIVE_IN_VIEW = 1;
    private static final int MEMBER_VS_FAIL = 2;
    private static final int MEMBER_NOT_IN_VIEW = 3;
    private static TraceComponent TC = Tr.register(VSync.class, "DCS", "com.ibm.ws.dcs.common.event.nls.dcs");
    private int _pmiCompleteMsgsCounter;
    private Long _pmiSyncStartTime;
    public Downcalls _down;
    public Upcalls _up;
    private VSyncAlgo _algo;
    private VSViewStatus _viewStatus;
    public VSIncomingSavedMessages _inSavedMsgs;
    private VSState _state;
    private Set _futureSuspectedMembers;
    private VRIMemberDescription _thisMember;
    private String _thisStackName;
    public VRIMembersMGR _membersMgr;
    public int _inRcvVectorMsgsCounter;
    public int _deliveredVSMsgsCounter;
    private final Globals _g;
    public final BaseVRIMessageFactory _msgFactory;

    public VSync(Globals globals) {
        DCSTraceBuffer dCSTraceBuffer;
        this._membersMgr = globals.getVRIMembersMgr();
        this._thisMember = this._membersMgr.getThisMember();
        this._thisStackName = this._membersMgr.getThisStackName();
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            dCSTraceBuffer = DCSTraceBuffer.entry(this, "VSync.VSync()", null);
            dCSTraceBuffer.invoke();
        }
        this._g = globals;
        this._inSavedMsgs = new VSIncomingSavedMessages(this._thisStackName, this._thisMember.getName(), this);
        this._futureSuspectedMembers = new HashSet();
        this._msgFactory = BaseVRIMessageFactory.getInstance(this._g);
        this.createByVersion(this._membersMgr.getProtocolVersion(), 1);
        if (DCSTraceBuffer.isExitEnabled(TC)) {
            dCSTraceBuffer = DCSTraceBuffer.exit(this, "VSync.VSync()", null);
            dCSTraceBuffer.invoke();
        }
    }

    private void createByVersion(int n, int n2) {
        if (n == 51001) {
            this._version = 0x1000000;
            VSState1 vSState1 = new VSState1(this, this._thisStackName, this._thisMember.getName(), n2);
            this._state = vSState1;
            VSViewStatus1 vSViewStatus1 = new VSViewStatus1(this._thisStackName, this._thisMember.getName());
            this._viewStatus = vSViewStatus1;
            this._algo = new VSyncAlgo1(this, vSState1, vSViewStatus1, this._thisMember, this._g);
        } else {
            this._version = 0x2000000;
            VSState2 vSState2 = new VSState2(this, this._thisStackName, this._thisMember.getName(), n2);
            this._state = vSState2;
            VSViewStatus2 vSViewStatus2 = new VSViewStatus2(this._thisStackName, this._thisMember.getName());
            this._viewStatus = vSViewStatus2;
            this._algo = new VSyncAlgo2(this, vSState2, vSViewStatus2, this._thisMember, this._g);
        }
    }

    public void completeCurrent(VRIMemberDescription[] vRIMemberDescriptionArray, CCVersion cCVersion) {
        Object object;
        DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.propertyList();
        dCSTraceBuffer.addProperty(cCVersion).addProperty("failedMembers", Utils.toString(vRIMemberDescriptionArray));
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            object = DCSTraceBuffer.entry(this, "VSync.completeCurrent()", null);
            ((DCSTraceBuffer)object).mergePropertyList(dCSTraceBuffer);
            ((DCSTraceBuffer)object).invoke();
        }
        this.focus(EVENT, "VSync.completeCurrent", dCSTraceBuffer);
        if (this._state.isState(1)) {
            throw new VRIIllegalStateException(2, "VSync.completeCurrent: VS is not initialized");
        }
        if (this._state.isTerminationProcess()) {
            throw new VRIIllegalStateException(2, "VSync.completeCurrent: VS is terminating");
        }
        if (vRIMemberDescriptionArray == null) {
            vRIMemberDescriptionArray = new VRIMemberDescription[]{};
        }
        object = this._algo.completeCurrent(vRIMemberDescriptionArray, cCVersion, dCSTraceBuffer);
        if (DCSTraceBuffer.isExitEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer2 = DCSTraceBuffer.exit(this, "completeCurrent()", (String)(object == null ? "End of method" : object));
            dCSTraceBuffer2.mergePropertyList(dCSTraceBuffer);
            dCSTraceBuffer2.invoke();
        }
    }

    public void newView(VRIMemberDescription[] vRIMemberDescriptionArray, ViewIdImpl viewIdImpl, Map map) {
        Object object;
        DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.propertyList();
        dCSTraceBuffer.addProperty(viewIdImpl).addProperty("viewMembers", Utils.toString(vRIMemberDescriptionArray));
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            object = DCSTraceBuffer.entry(this, "VSync.newView()", null);
            ((DCSTraceBuffer)object).mergePropertyList(dCSTraceBuffer);
            ((DCSTraceBuffer)object).invoke();
        }
        this.focus(EVENT, "newView", dCSTraceBuffer);
        object = null;
        if (map != null) {
            int n = (Integer)map.get("DCSProtocolVersion");
            object = this._algo.getOutgoingQueue();
            this.createByVersion(n, this._state.getState());
        }
        this.initViewScopedVariables(vRIMemberDescriptionArray, viewIdImpl);
        this._algo.newView(vRIMemberDescriptionArray, viewIdImpl, map, (LinkedList)object, dCSTraceBuffer);
        if (DCSTraceBuffer.isExitEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer2 = DCSTraceBuffer.exit(this, "VSync.newView()", null);
            dCSTraceBuffer2.mergePropertyList(dCSTraceBuffer);
            dCSTraceBuffer2.invoke();
        }
    }

    public void mcastMessage(VRIMessage vRIMessage, QoS.QOSMulticast qOSMulticast, ViewIdImpl viewIdImpl) throws DCSInvalidParametersException, DCSTransportLayerException {
        DCSTraceBuffer dCSTraceBuffer;
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            dCSTraceBuffer = DCSTraceBuffer.entry(this, "VSync.mcastMessage()", null);
            dCSTraceBuffer.addProperty("Message", vRIMessage);
            dCSTraceBuffer.addProperty(qOSMulticast);
            dCSTraceBuffer.addProperty(viewIdImpl);
            dCSTraceBuffer.invoke();
        }
        this._algo.mcastMessage(vRIMessage, qOSMulticast, viewIdImpl);
        if (DCSTraceBuffer.isExitEnabled(TC)) {
            dCSTraceBuffer = DCSTraceBuffer.exit(this, "VSync.mcastMessage()", null);
            dCSTraceBuffer.invoke();
        }
    }

    public void sendMessage(VRIMessage vRIMessage, VRIMemberDescription vRIMemberDescription, QoS.QOSUnicast qOSUnicast, ViewIdImpl viewIdImpl) throws DCSInvalidParametersException, DCSTransportLayerException {
        DCSTraceBuffer dCSTraceBuffer;
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            dCSTraceBuffer = DCSTraceBuffer.entry(this, "VSync.sendMessage()", null);
            dCSTraceBuffer.addProperty("Message", vRIMessage);
            dCSTraceBuffer.addProperty("memberName", vRIMemberDescription.getName());
            dCSTraceBuffer.addProperty(qOSUnicast);
            dCSTraceBuffer.addProperty(viewIdImpl);
            dCSTraceBuffer.invoke();
        }
        this._algo.sendMessage(vRIMessage, vRIMemberDescription, qOSUnicast, viewIdImpl);
        if (DCSTraceBuffer.isExitEnabled(TC)) {
            dCSTraceBuffer = DCSTraceBuffer.exit(this, "VSync.sendMessage()", null);
            dCSTraceBuffer.invoke();
        }
    }

    public void mcastMessage(VRIMessage vRIMessage, VRIMemberDescription[] vRIMemberDescriptionArray, QoS.QOSMulticast qOSMulticast, ViewIdImpl viewIdImpl) throws DCSInvalidParametersException, DCSTransportLayerException {
        if (this._version != 0x2000000) {
            this._down.mcastMessage(vRIMessage, vRIMemberDescriptionArray, qOSMulticast, viewIdImpl);
        } else {
            DCSTraceBuffer dCSTraceBuffer;
            if (DCSTraceBuffer.isEntryEnabled(TC)) {
                dCSTraceBuffer = DCSTraceBuffer.entry(this, "VSync.mcastMessage(subgroup)", null);
                dCSTraceBuffer.addProperty("Message", vRIMessage);
                dCSTraceBuffer.addProperty(qOSMulticast);
                dCSTraceBuffer.addProperty(viewIdImpl);
                dCSTraceBuffer.invoke();
            }
            ((VSyncAlgo2)this._algo).mcastMessage(vRIMessage, vRIMemberDescriptionArray, qOSMulticast, viewIdImpl);
            if (DCSTraceBuffer.isExitEnabled(TC)) {
                dCSTraceBuffer = DCSTraceBuffer.exit(this, "VSync.mcastMessage(subgroup)", null);
                dCSTraceBuffer.invoke();
            }
        }
    }

    public void start(ViewIdImpl viewIdImpl) {
        DCSTraceBuffer dCSTraceBuffer;
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            dCSTraceBuffer = DCSTraceBuffer.entry(this, "VSync.start()", null);
            dCSTraceBuffer.invoke();
        }
        this.focus(EVENT, "start");
        if (!this._state.isState(1)) {
            throw new VRIIllegalStateException(2, "VS is already initialized");
        }
        if (viewIdImpl == null) {
            throw new VRIIllegalStateException(2, "VSync.start: null view id");
        }
        if (this._up == null) {
            throw new VRIIllegalStateException(2, "start: up is null");
        }
        if (this._down == null) {
            throw new VRIIllegalStateException(2, "start: down is null");
        }
        this._state.setState(4);
        this.initViewScopedVariables(this._membersMgr.getViewMembers(), viewIdImpl);
        this._algo.initViewScopedVariables(this._membersMgr.getViewMembers(), viewIdImpl, 0);
        this._down.start(viewIdImpl);
        if (DCSTraceBuffer.isExitEnabled(TC)) {
            dCSTraceBuffer = DCSTraceBuffer.exit(this, "VSync.start()", null);
            dCSTraceBuffer.invoke();
        }
    }

    public void terminate(boolean bl, DCSTerminationEvent dCSTerminationEvent) {
        DCSTraceBuffer dCSTraceBuffer;
        DCSTraceBuffer dCSTraceBuffer2 = DCSTraceBuffer.propertyList();
        dCSTraceBuffer2.addProperty("Graceful", bl);
        dCSTraceBuffer2.addProperty("Reason", dCSTerminationEvent);
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            dCSTraceBuffer = DCSTraceBuffer.entry(this, "VSync.terminate()", null);
            dCSTraceBuffer.mergePropertyList(dCSTraceBuffer2);
            dCSTraceBuffer.invoke();
        }
        this.focus(EVENT, "terminate", dCSTraceBuffer2);
        this._algo.cancelAlarm();
        this._state.setState(3);
        this._down.terminate(bl, dCSTerminationEvent);
        if (DCSTraceBuffer.isExitEnabled(TC)) {
            dCSTraceBuffer = DCSTraceBuffer.exit(this, "VSync.terminate()", null);
            dCSTraceBuffer.mergePropertyList(dCSTraceBuffer2);
            dCSTraceBuffer.invoke();
        }
    }

    public void dumpAll(FFDCDumper fFDCDumper) {
        DCSTraceBuffer dCSTraceBuffer;
        Object object;
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            object = DCSTraceBuffer.entry(this, "VSync.dump()", null);
            ((DCSTraceBuffer)object).invoke();
        }
        if (DCSTraceBuffer.isDumpEnabled(TC)) {
            dCSTraceBuffer = DCSTraceBuffer.dump(this, "VSync.dump()", "Dumping VS");
            dCSTraceBuffer.addProperty("Down", "Layer", this._down.getClass().getName());
            dCSTraceBuffer.addProperty("Up", "Layer", this._up.getClass().getName());
            dCSTraceBuffer.addProperty(this._state);
            dCSTraceBuffer.addProperty("Received", "VsyncRcvVectors", this._inRcvVectorMsgsCounter);
            dCSTraceBuffer.addProperty("Delivered", "VsyncMessages", this._deliveredVSMsgsCounter);
            object = dCSTraceBuffer.toString();
        } else {
            object = "";
        }
        object = (String)object + this._algo.dump();
        object = (String)object + this._viewStatus.dump();
        object = (String)object + this._inSavedMsgs.dump();
        fFDCDumper.writeLine((String)object);
        this._down.dumpAll(fFDCDumper);
        if (DCSTraceBuffer.isExitEnabled(TC)) {
            dCSTraceBuffer = DCSTraceBuffer.exit(this, "VSync.dump()", null);
            dCSTraceBuffer.invoke();
        }
    }

    public Object getMutex() {
        return this._g.getMutex();
    }

    public void syncCurrent() {
        DCSAssertException dCSAssertException = new DCSAssertException("VSync.syncCurrent is not implemented");
        if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.internalWarning(this, "Method not implemented", "VSync.syncCurrent()", dCSAssertException);
            dCSTraceBuffer.invoke();
        }
    }

    public VRICheckFailedException check() {
        Object object;
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            object = DCSTraceBuffer.entry(this, "VSync.check()", null);
            ((DCSTraceBuffer)object).invoke();
        }
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            object = DCSTraceBuffer.event(this, "VSync.check()", "Dumping VS incoming");
            ((DCSTraceBuffer)object).addProperty("Incoming", "VsyncMessages", this._inSavedMsgs);
            ((DCSTraceBuffer)object).invoke();
        }
        if (this._state.isState(1)) {
            object = "VSync.check: failed, as VS initializing";
            if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.internalWarning(this, (String)object, "VSync.check()", null);
                dCSTraceBuffer.invoke();
            }
            return new VRICheckFailedException((String)object);
        }
        if (this._state.isTerminationProcess()) {
            object = "VSync.check: failed, as VS terminating. Returning null as DCS stack has already been terminated";
            if (DCSTraceBuffer.isEventEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this, "VSync.check()", (String)object);
                dCSTraceBuffer.invoke();
            }
            return null;
        }
        object = this._algo.check();
        if (DCSTraceBuffer.isExitEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.exit(this, "VSync.check()", null);
            dCSTraceBuffer.addProperty("MethodResult", (Throwable)object);
            dCSTraceBuffer.invoke();
        }
        return object;
    }

    public void connectMembers(VRIMemberDescription[] vRIMemberDescriptionArray) {
        DCSTraceBuffer dCSTraceBuffer;
        DCSTraceBuffer dCSTraceBuffer2 = DCSTraceBuffer.propertyList();
        dCSTraceBuffer2.addProperty("connectedMembers", Utils.toString(vRIMemberDescriptionArray));
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            dCSTraceBuffer = DCSTraceBuffer.entry(this, "VSync.connectMembers()", null);
            dCSTraceBuffer.mergePropertyList(dCSTraceBuffer2);
            dCSTraceBuffer.invoke();
        }
        this.focus(EVENT, "connectMembers", dCSTraceBuffer2);
        if (this._state.isState(1)) {
            throw new VRIIllegalStateException(2, "connectMembers(): VS is not initialized");
        }
        if (this._state.isTerminationProcess()) {
            return;
        }
        this._up.connectMembers(vRIMemberDescriptionArray);
        if (DCSTraceBuffer.isExitEnabled(TC)) {
            dCSTraceBuffer = DCSTraceBuffer.exit(this, "VSync.connectMembers()", null);
            dCSTraceBuffer.mergePropertyList(dCSTraceBuffer2);
            dCSTraceBuffer.invoke();
        }
    }

    public void suspectMembers(DCSSuspectEvent[] dCSSuspectEventArray) {
        VRIMemberDescription[] vRIMemberDescriptionArray;
        DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.propertyList();
        dCSTraceBuffer.addProperty("SuspectedMembers", VRIMemberUtils.getSuspectedMembers(dCSSuspectEventArray));
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            vRIMemberDescriptionArray = DCSTraceBuffer.entry(this, "VSync.suspectMembers()", null);
            vRIMemberDescriptionArray.mergePropertyList(dCSTraceBuffer);
            vRIMemberDescriptionArray.invoke();
        }
        this.focus(EVENT, "suspectMembers", dCSTraceBuffer);
        if (this._state.isState(1)) {
            throw new VRIIllegalStateException(2, "suspectMembers(): VS is not initialized");
        }
        if (this._state.isTerminationProcess()) {
            return;
        }
        vRIMemberDescriptionArray = VRIMemberUtils.getSuspectedMembersDescription(this._membersMgr, dCSSuspectEventArray, false);
        for (int i = 0; i < vRIMemberDescriptionArray.length; ++i) {
            DCSTraceBuffer dCSTraceBuffer2;
            if (vRIMemberDescriptionArray[i].isInView()) {
                if (this._state.areSuspectsQueued()) {
                    if (DCSTraceBuffer.isEventEnabled(TC)) {
                        dCSTraceBuffer2 = DCSTraceBuffer.event(this, "VSync.suspectMembers()", "Added member to future suspects");
                        dCSTraceBuffer2.mergePropertyList(dCSTraceBuffer);
                        dCSTraceBuffer2.addProperty("memberName", vRIMemberDescriptionArray[i].getName());
                        dCSTraceBuffer2.addProperty(this._state);
                        dCSTraceBuffer2.invoke();
                    }
                    this._futureSuspectedMembers.add(dCSSuspectEventArray[i]);
                    continue;
                }
                this._viewStatus.registerVSFailMember(vRIMemberDescriptionArray[i].getIndexInView());
                continue;
            }
            if (!DCSTraceBuffer.isEventEnabled(TC)) continue;
            dCSTraceBuffer2 = DCSTraceBuffer.event(this, "VSync.suspectMembers()", "Ignore suspect call of non view member");
            dCSTraceBuffer2.mergePropertyList(dCSTraceBuffer);
            dCSTraceBuffer2.addProperty("memberName", vRIMemberDescriptionArray[i].getName());
            dCSTraceBuffer2.addProperty(this._state);
            dCSTraceBuffer2.invoke();
        }
        this._up.suspectMembers(dCSSuspectEventArray);
        if (DCSTraceBuffer.isExitEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer3 = DCSTraceBuffer.exit(this, "VSync.suspectMembers()", null);
            dCSTraceBuffer3.mergePropertyList(dCSTraceBuffer);
            dCSTraceBuffer3.invoke();
        }
    }

    public void currentOK(CCVersion cCVersion) {
        Object object;
        DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.propertyList();
        dCSTraceBuffer.addProperty(cCVersion);
        dCSTraceBuffer.addProperty(this._state);
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            object = DCSTraceBuffer.entry(this, "VSync.currentOK()", null);
            ((DCSTraceBuffer)object).mergePropertyList(dCSTraceBuffer);
            ((DCSTraceBuffer)object).invoke();
        }
        this.focus(EVENT, "currentOK", dCSTraceBuffer);
        object = this._algo.currentOK(cCVersion, dCSTraceBuffer);
        if (object == null) {
            return;
        }
        if (DCSTraceBuffer.isExitEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer2 = DCSTraceBuffer.exit(this, "VSync.currentOK()", (String)(((String)object).equals("") ? "End of Method" : object));
            dCSTraceBuffer2.mergePropertyList(dCSTraceBuffer);
            dCSTraceBuffer2.invoke();
        }
    }

    public void newViewOK(VRIMemberDescription[] vRIMemberDescriptionArray, ViewIdImpl viewIdImpl, Map map) {
        DCSTraceBuffer dCSTraceBuffer;
        DCSTraceBuffer dCSTraceBuffer2 = DCSTraceBuffer.propertyList();
        dCSTraceBuffer2.addProperty(viewIdImpl);
        dCSTraceBuffer2.addProperty("viewMembers", Utils.toString(vRIMemberDescriptionArray));
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            dCSTraceBuffer = DCSTraceBuffer.entry(this, "VSync.newViewOK()", null);
            dCSTraceBuffer.mergePropertyList(dCSTraceBuffer2);
            dCSTraceBuffer.invoke();
        }
        this.focus(EVENT, "newViewOK", dCSTraceBuffer2);
        this._algo.newViewOK(vRIMemberDescriptionArray, viewIdImpl, map, dCSTraceBuffer2);
        if (DCSTraceBuffer.isExitEnabled(TC)) {
            dCSTraceBuffer = DCSTraceBuffer.exit(this, "VSync.newViewOK()", null);
            dCSTraceBuffer.invoke();
        }
    }

    public void deliver(VRIMessage vRIMessage) {
        DCSTraceBuffer dCSTraceBuffer = null;
        if (DCSTraceBuffer.isFocustEventEnabled(TC)) {
            dCSTraceBuffer = DCSTraceBuffer.propertyList();
            dCSTraceBuffer.addProperty("Sender", "memberName", vRIMessage.getSender());
        }
        if (!vRIMessage.hasHeader((byte)2)) {
            this._up.deliver(vRIMessage);
            return;
        }
        this._algo.deliverVSmsg(vRIMessage, dCSTraceBuffer);
    }

    public boolean isMemberAlive(String string, DCSTraceBuffer dCSTraceBuffer) {
        if (this.getMemberVSStatus(string) != 1) {
            this.focus(IN_MSG, "deliver_nl_drop", dCSTraceBuffer);
            this.traceNlsIgnoreMessage(string, "Sender is not a live view member");
            return false;
        }
        return true;
    }

    private int getMemberVSStatus(String string) {
        int n = this._membersMgr.getViewMemberIndex(string);
        if (n == -1) {
            return 3;
        }
        if (this._viewStatus.isMemberVSFailed(n)) {
            return 2;
        }
        return 1;
    }

    public void requestTermination(DCSTerminationEvent dCSTerminationEvent) {
        DCSTraceBuffer dCSTraceBuffer;
        DCSTraceBuffer dCSTraceBuffer2 = DCSTraceBuffer.propertyList();
        dCSTraceBuffer2.addProperty("Reason", dCSTerminationEvent);
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            dCSTraceBuffer = DCSTraceBuffer.entry(this, "VSync.requestTermination()", null);
            dCSTraceBuffer.mergePropertyList(dCSTraceBuffer2);
            dCSTraceBuffer.invoke();
        }
        this.focus(EVENT, "requestTermination", dCSTraceBuffer2);
        if (this._state.isTerminationProcess()) {
            return;
        }
        this._state.setState(2);
        this._up.requestTermination(dCSTerminationEvent);
        if (DCSTraceBuffer.isExitEnabled(TC)) {
            dCSTraceBuffer = DCSTraceBuffer.exit(this, "VSync.requestTermination()", null);
            dCSTraceBuffer.mergePropertyList(dCSTraceBuffer2);
            dCSTraceBuffer.invoke();
        }
    }

    public void proposeAgreement(VRIMessage vRIMessage) {
        DCSAssertException dCSAssertException = new DCSAssertException("VSync.proposeAgreement is not implemented");
        if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.internalWarning(this, "Method not implemented", "VSync.proposeAgreement()", dCSAssertException);
            dCSTraceBuffer.invoke();
        }
    }

    public void deliverAgreed(VRIMessage vRIMessage) {
        DCSAssertException dCSAssertException = new DCSAssertException("VSync.deliverAgreed is not implemented");
        if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.internalWarning(this, "Method not implemented", "VSync.deliverAgreed()", dCSAssertException);
            dCSTraceBuffer.invoke();
        }
    }

    public void sendVSCurrentMsg(VRIMessage vRIMessage, QoS qoS, VRIMemberDescription vRIMemberDescription) throws DCSTransportLayerException, DCSInvalidParametersException {
        VSNotOrigHeader vSNotOrigHeader = new VSNotOrigHeader(this._algo.getCurViewId(), this, this._version);
        vRIMessage.addHeader(vSNotOrigHeader);
        this._down.sendMessage(vRIMessage, vRIMemberDescription, (QoS.QOSUnicast)qoS.updateType(QoS.RELIABLE), null);
    }

    public void denyAndSuspect(VRIMemberDescription[] vRIMemberDescriptionArray, VSDenialReason[] vSDenialReasonArray) {
        DCSSuspectEvent[] dCSSuspectEventArray = new DCSSuspectEvent[vRIMemberDescriptionArray.length];
        for (int i = 0; i < vRIMemberDescriptionArray.length; ++i) {
            this.deny(vRIMemberDescriptionArray[i], vSDenialReasonArray[i]);
            dCSSuspectEventArray[i] = vSDenialReasonArray[i].getSuspectlEvent();
        }
        this.suspectMembers(dCSSuspectEventArray);
    }

    public void denyAndSuspect(VRIMemberDescription vRIMemberDescription, VSDenialReason vSDenialReason) {
        DCSTraceBuffer dCSTraceBuffer;
        DCSTraceBuffer dCSTraceBuffer2 = DCSTraceBuffer.propertyList();
        dCSTraceBuffer2.addProperty("memberName", vRIMemberDescription.getName());
        dCSTraceBuffer2.addProperty("Reason", vSDenialReason);
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            dCSTraceBuffer = DCSTraceBuffer.entry(this, "VSync.denyAndSuspect()", null);
            dCSTraceBuffer.mergePropertyList(dCSTraceBuffer2);
            dCSTraceBuffer.invoke();
        }
        this.deny(vRIMemberDescription, vSDenialReason);
        this.suspectMembers(new DCSSuspectEvent[]{vSDenialReason.getSuspectlEvent()});
        if (DCSTraceBuffer.isExitEnabled(TC)) {
            dCSTraceBuffer = DCSTraceBuffer.exit(this, "VSync.denyAndSuspect()", null);
            dCSTraceBuffer.mergePropertyList(dCSTraceBuffer2);
            dCSTraceBuffer.invoke();
        }
    }

    private void deny(VRIMemberDescription vRIMemberDescription, VSDenialReason vSDenialReason) {
        DCSTraceBuffer dCSTraceBuffer;
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            dCSTraceBuffer = DCSTraceBuffer.entry(this, "VSync.deny()", null);
            dCSTraceBuffer.invoke();
        }
        if (vRIMemberDescription == null || vSDenialReason == null) {
            this.handleInternalError(new VSInternalException("VSync.deny: Null parameters"), false);
            return;
        }
        if (vRIMemberDescription.equals(this._thisMember)) {
            this.handleInternalError(new VSInternalException("Deny this member because of " + vSDenialReason), false);
            return;
        }
        vSDenialReason.invokeNLS();
        this._membersMgr.denyMember(vRIMemberDescription.getName(), vSDenialReason);
        if (DCSTraceBuffer.isExitEnabled(TC)) {
            dCSTraceBuffer = DCSTraceBuffer.exit(this, "VSync.deny()", null);
            dCSTraceBuffer.invoke();
        }
    }

    public void denyAndSuspectAllButMeAtTimeout() {
        VRIMemberDescription[] vRIMemberDescriptionArray = VRIMemberUtils.minus(this._algo.getCurViewMembers(), this._thisMember);
        DCSSuspectEvent[] dCSSuspectEventArray = new DCSSuspectEvent[vRIMemberDescriptionArray.length];
        for (int i = 0; i < vRIMemberDescriptionArray.length; ++i) {
            VSSuspectTimeout vSSuspectTimeout = new VSSuspectTimeout((DCSTraceContext)this, vRIMemberDescriptionArray[i].getName());
            this.deny(vRIMemberDescriptionArray[i], new VSDenialReason(vSSuspectTimeout));
            dCSSuspectEventArray[i] = vSSuspectTimeout;
        }
        this.suspectMembers(dCSSuspectEventArray);
    }

    public void setDownLayer(Downcalls downcalls) {
        this._down = downcalls;
    }

    public void setUpperLayer(Upcalls upcalls) {
        this._up = upcalls;
    }

    public void unblock() throws DCSAssertException {
        DCSAssertException dCSAssertException = new DCSAssertException("VSync.unblock is not implemented");
        if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.internalWarning(this, "Method not implemented", "VSync.unblock()", dCSAssertException);
            dCSTraceBuffer.invoke();
        }
    }

    public void updateBehavor(Map map) throws DCSAssertException {
        DCSAssertException dCSAssertException = new DCSAssertException("VSync.updateBehavor is not implemented");
        if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.internalWarning(this, "Method not implemented", "VSync.updateBehavor()", dCSAssertException);
            dCSTraceBuffer.invoke();
        }
    }

    public void handleInternalError(Exception exception, boolean bl) {
        DCSTraceBuffer dCSTraceBuffer;
        if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
            dCSTraceBuffer = DCSTraceBuffer.internalWarning(this, "Got VSync internal error", "VSync.handleInternalError()", exception);
            dCSTraceBuffer.addProperty("Fatal", bl);
            dCSTraceBuffer.invoke();
        }
        if (bl) {
            this.requestTermination(new TerminationEvent((DCSTraceContext)this, "VSync.handleInternalError()", exception));
        } else if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
            dCSTraceBuffer = DCSTraceBuffer.internalWarning(this, "VS Internal Warning", "VSync.handleInternalError()", exception);
            dCSTraceBuffer.invoke();
        }
        if (DCSTraceBuffer.isExitEnabled(TC)) {
            dCSTraceBuffer = DCSTraceBuffer.exit(this, "VSync.handleInternalError()", null);
            dCSTraceBuffer.invoke();
        }
    }

    public void changeDefinedMembers(String[] stringArray, String[] stringArray2) throws AddDefinedFailedException {
        DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.propertyList();
        dCSTraceBuffer.addProperty("AddedMembers", Utils.toString(stringArray)).addProperty("RemovedMembers", Utils.toString(stringArray2));
        this.focus(EVENT, "changeDefinedMembers", dCSTraceBuffer);
        this.assertSanityOfDefinedMembers(stringArray, "AddedMembers");
        this.assertSanityOfDefinedMembers(stringArray2, "RemovedMembers");
        this._down.changeDefinedMembers(stringArray, stringArray2);
    }

    private void assertSanityOfDefinedMembers(String[] stringArray, String string) {
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (string2 != null) continue;
            throw new DCSIllegalParameterException("VSync.assertSanityOfDefinedMembers Array containing null was passed down the stack:" + string + ":" + Utils.toString(stringArray));
        }
    }

    private void initViewScopedVariables(VRIMemberDescription[] vRIMemberDescriptionArray, ViewIdImpl viewIdImpl) {
        int n = vRIMemberDescriptionArray.length;
        this._viewStatus.newView(n);
        this._inSavedMsgs.newView(n);
        this._inRcvVectorMsgsCounter = 0;
        this._deliveredVSMsgsCounter = 0;
        this._pmiSyncStartTime = null;
        this._pmiCompleteMsgsCounter = 0;
        this.handleFutureSuspected();
    }

    private void handleFutureSuspected() {
        Object object;
        DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.propertyList();
        dCSTraceBuffer.addProperty("SuspectedMembers", VRIMemberUtils.getSuspectedMembers(this._futureSuspectedMembers.toArray(new DCSSuspectEvent[0])));
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            object = DCSTraceBuffer.entry(this, "VSync.handleFutureSuspected()", null);
            ((DCSTraceBuffer)object).mergePropertyList(dCSTraceBuffer);
            ((DCSTraceBuffer)object).invoke();
        }
        object = this._futureSuspectedMembers.iterator();
        while (object.hasNext()) {
            DCSSuspectEvent dCSSuspectEvent = (DCSSuspectEvent)object.next();
            VRIMemberDescription vRIMemberDescription = VRIMemberUtils.getSuspectedMemberDescription(this._membersMgr, dCSSuspectEvent);
            if (vRIMemberDescription == null || !vRIMemberDescription.isInView()) continue;
            if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer2 = DCSTraceBuffer.internalWarning(this, "Future suspect is in the new view", "VSync.handleFutureSuspected()", null);
                dCSTraceBuffer2.mergePropertyList(dCSTraceBuffer);
                dCSTraceBuffer2.addProperty("memberName", vRIMemberDescription.getName());
                dCSTraceBuffer2.invoke();
            }
            this._viewStatus.registerVSFailMember(vRIMemberDescription.getIndexInView());
            this._up.suspectMembers(new DCSSuspectEvent[]{dCSSuspectEvent});
        }
        this._futureSuspectedMembers.clear();
    }

    public void activateMessagesDisposer() {
        DCSTraceBuffer dCSTraceBuffer;
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            dCSTraceBuffer = DCSTraceBuffer.entry(this, "VSync.activateMessagesDisposer()", null);
            dCSTraceBuffer.invoke();
        }
        try {
            this._inSavedMsgs.deleteMessagesByRBA(this._viewStatus.getRcvByAllVector());
        }
        catch (VSUnRBAMessageHasBeenDeletedException vSUnRBAMessageHasBeenDeletedException) {
            this._inSavedMsgs.dump();
            VSInternalException vSInternalException = new VSInternalException(vSUnRBAMessageHasBeenDeletedException);
            this.handleInternalError(vSInternalException, false);
            return;
        }
        catch (VSRBAMessageHasNotBeenReceivedException vSRBAMessageHasNotBeenReceivedException) {
            VSInternalException vSInternalException = new VSInternalException(vSRBAMessageHasNotBeenReceivedException);
            this.handleInternalError(vSInternalException, false);
            return;
        }
        if (DCSTraceBuffer.isExitEnabled(TC)) {
            dCSTraceBuffer = DCSTraceBuffer.exit(this, "VSync.activateMessagesDisposer()", null);
            dCSTraceBuffer.invoke();
        }
    }

    public void focus(int n, String string) {
        this.focus(n, string, null);
    }

    public void focus(int n, String string, DCSTraceBuffer dCSTraceBuffer) {
        if (DCSTraceBuffer.isFocustEventEnabled(TC)) {
            Object object;
            if (FOCUS_EVENT_NAMES[n].indexOf("MSG") != -1) {
                object = ((Object)this._state).toString() + string;
                if (this._focusReportedEvents.contains(object)) {
                    return;
                }
                this._focusReportedEvents.add(object);
            }
            object = DCSTraceBuffer.focusEvent(this, null, FOCUS_EVENT_NAMES[n], ((Object)this._state).toString(), string, null);
            ((DCSTraceBuffer)object).mergePropertyList(dCSTraceBuffer);
            ((DCSTraceBuffer)object).invoke();
        }
    }

    public void onVRIDownEvent(VRIDownEvent vRIDownEvent) {
        vRIDownEvent.handle("VSync", null, this._down);
    }

    public void onVRIUpEvent(VRIUpEvent vRIUpEvent) {
        vRIUpEvent.handle("VSync", null, this._up);
    }

    public TraceComponent getTraceComponent() {
        return TC;
    }

    public String getStackName() {
        return this._thisStackName;
    }

    public String getMemberName() {
        return this._thisMember.getName();
    }

    public String getLayerName() {
        return DCSConstants.TRACE_LAYER_NAMES[2];
    }

    public void traceNlsIgnoreMessage(String string, String string2) {
        VSIgnoreMessage vSIgnoreMessage = new VSIgnoreMessage((DCSTraceContext)this, string, string2);
        vSIgnoreMessage.invokeNLSTrace();
    }

    private int pmiComputeViewChangeTime() {
        long l = new Date().getTime() - this._pmiSyncStartTime;
        return (int)l;
    }

    public void startPMI() {
        if (this._pmiSyncStartTime == null) {
            this._pmiSyncStartTime = new Long(new Date().getTime());
        }
    }

    public void endPMI() {
        if (this._g.statsModule != null) {
            this._g.statsModule.onCCOK(this.pmiComputeViewChangeTime(), this._pmiCompleteMsgsCounter);
        }
    }

    public void incrementPMI() {
        ++this._pmiCompleteMsgsCounter;
    }

    public void onVSTimeout() {
        if (this._g.statsModule != null) {
            this._g.statsModule.onVSTimeout();
        }
    }
}

