/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.vri.vsync.impl1;

import com.ibm.ws.dcs.vri.common.Globals;
import com.ibm.ws.dcs.vri.common.nls.VSMemoryExhausted;
import com.ibm.ws.dcs.vri.common.nls.VSMemoryNormal;
import com.ibm.ws.dcs.vri.common.util.DCSTraceBuffer;
import com.ibm.ws.dcs.vri.common.util.DCSTraceContext;
import com.ibm.ws.dcs.vri.vsync.VSync;

public class MessageDisposal1 {
    VSync vs;
    private final int CONFIG_NUM_IN_MESSAGES_TO_SEND_RCV_VECTOR;
    private final int CONFIG_SYNC_NUM_IN_MESSAGES_TO_SEND_RCV_VECTOR;
    private final int CONFIG_VS_MEMORY_LIMIT_BYTES;
    private boolean _mdSyncMode;
    private boolean _memoryExhausted;

    MessageDisposal1(VSync vSync, Globals globals) {
        this.vs = vSync;
        this.CONFIG_NUM_IN_MESSAGES_TO_SEND_RCV_VECTOR = globals.getConfigParamAsInt("VS_DEFAULT_MESSAGES_NUM_TO_SEND_RCV_VECTOR");
        this.CONFIG_SYNC_NUM_IN_MESSAGES_TO_SEND_RCV_VECTOR = globals.getConfigParamAsInt("VS_CC_MESSAGES_NUM_TO_SEND_RCV_VECTOR");
        this.CONFIG_VS_MEMORY_LIMIT_BYTES = globals.getConfigParamAsInt("VS_MAX_MEMORY_KB") * 1024;
        this._mdSyncMode = false;
    }

    void initViewScopedVariables() {
        this._memoryExhausted = false;
    }

    private boolean shouldActivateMD(int n) {
        if (this.isVsMemoryExhausted()) {
            this.traceMemoryExhaustion(false);
            return true;
        }
        return this.vs._inRcvVectorMsgsCounter % n == 0;
    }

    private void checkMemoryNormal() {
        if (this._memoryExhausted && !this.isVsMemoryExhausted()) {
            this._memoryExhausted = false;
            VSMemoryNormal vSMemoryNormal = new VSMemoryNormal(this.vs);
            vSMemoryNormal.invokeNLSTrace();
        }
    }

    boolean shouldSendRcvVector() {
        if (this.isVsMemoryExhausted()) {
            this.traceMemoryExhaustion(false);
            return true;
        }
        if (!this._mdSyncMode) {
            return this.vs._deliveredVSMsgsCounter % this.CONFIG_NUM_IN_MESSAGES_TO_SEND_RCV_VECTOR == 0;
        }
        return this.vs._deliveredVSMsgsCounter % this.CONFIG_SYNC_NUM_IN_MESSAGES_TO_SEND_RCV_VECTOR == 0;
    }

    private void traceMemoryExhaustion(boolean bl) {
        if (bl || !this._memoryExhausted) {
            VSMemoryExhausted vSMemoryExhausted = new VSMemoryExhausted((DCSTraceContext)this.vs, this.CONFIG_VS_MEMORY_LIMIT_BYTES, this.vs._inSavedMsgs.getSavedBytesNumber());
            vSMemoryExhausted.invokeNLSTrace();
            this._memoryExhausted = true;
        }
    }

    private boolean isVsMemoryExhausted() {
        return this.vs._inSavedMsgs.getSavedBytesNumber() > this.CONFIG_VS_MEMORY_LIMIT_BYTES;
    }

    public void setSyncMode(boolean bl) {
        this._mdSyncMode = bl;
    }

    void tryActivation(int n) {
        if (this.shouldActivateMD(n)) {
            this.vs.activateMessagesDisposer();
            this.checkMemoryNormal();
        }
    }

    void traceMemory() {
        DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this.vs, "VSync.check()", "Checking memory consumption");
        dCSTraceBuffer.addProperty("Configured", "Memory", this.CONFIG_VS_MEMORY_LIMIT_BYTES);
        dCSTraceBuffer.addProperty("Used", "Memory", this.vs._inSavedMsgs.getSavedBytesNumber());
        dCSTraceBuffer.invoke();
    }
}

