/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.vri.vsync.impl1;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.dcs.vri.common.CCVersion;
import com.ibm.ws.dcs.vri.common.DCSConstants;
import com.ibm.ws.dcs.vri.common.util.DCSTraceBuffer;
import com.ibm.ws.dcs.vri.common.util.DCSTraceContext;
import com.ibm.ws.dcs.vri.vsync.VSMemberHasVSFailedException;
import com.ibm.ws.dcs.vri.vsync.VSNewRowIsIllegalException;
import com.ibm.ws.dcs.vri.vsync.VSViewStatus;
import com.ibm.ws.dcs.vri.vsync.impl1.VSState1;
import java.util.AbstractCollection;
import java.util.LinkedList;
import java.util.ListIterator;

public final class VSViewStatus1
implements VSViewStatus,
DCSTraceContext {
    private static TraceComponent TC = Tr.register(VSViewStatus1.class, "DCS", "com.ibm.ws.dcs.common.event.nls.dcs");
    private int[][] _viewRcvMessagesMatrix;
    private boolean[] _vsLiveMembers;
    private boolean[] _ccLiveMembers;
    private CCVersion[] _rcvMembersMcastISA;
    private boolean[] _rcvMembersP2PISA;
    private boolean[] _rcvMembersIMS;
    private int _viewSize;
    private final String _thisStackName;
    private final String _thisMemberName;
    private static final int MAXTABLE2PRINT = 10;

    public VSViewStatus1(String string, String string2) {
        DCSTraceBuffer dCSTraceBuffer;
        this._thisStackName = string;
        this._thisMemberName = string2;
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            dCSTraceBuffer = DCSTraceBuffer.entry(this, "VSViewStatus.VSViewStatus()", null);
            dCSTraceBuffer.invoke();
        }
        this.newView(1);
        if (DCSTraceBuffer.isExitEnabled(TC)) {
            dCSTraceBuffer = DCSTraceBuffer.exit(this, "VSViewStatus.VSViewStatus()", null);
            dCSTraceBuffer.invoke();
        }
    }

    public void newView(int n) {
        int n2;
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.entry(this, "VSViewStatus.newView()", null);
            dCSTraceBuffer.addProperty("viewSize", n);
            dCSTraceBuffer.invoke();
        }
        this._viewSize = n;
        this._viewRcvMessagesMatrix = new int[this._viewSize][];
        for (n2 = 0; n2 < this._viewSize; ++n2) {
            this._viewRcvMessagesMatrix[n2] = new int[this._viewSize];
            for (int i = 0; i < this._viewSize; ++i) {
                this._viewRcvMessagesMatrix[n2][i] = 0;
            }
        }
        this._vsLiveMembers = new boolean[this._viewSize];
        this._ccLiveMembers = new boolean[this._viewSize];
        this._rcvMembersMcastISA = new CCVersion[this._viewSize];
        this._rcvMembersP2PISA = new boolean[this._viewSize];
        this._rcvMembersIMS = new boolean[this._viewSize];
        for (n2 = 0; n2 < this._viewSize; ++n2) {
            this._vsLiveMembers[n2] = true;
            this._ccLiveMembers[n2] = true;
            this._rcvMembersMcastISA[n2] = null;
            this._rcvMembersP2PISA[n2] = false;
            this._rcvMembersIMS[n2] = false;
        }
        if (DCSTraceBuffer.isExitEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.exit(this, "VSViewStatus.newView()", null);
            dCSTraceBuffer.invoke();
        }
    }

    void setMatrixRow(int n, int[] nArray) throws VSNewRowIsIllegalException, VSMemberHasVSFailedException {
        Object object;
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            object = DCSTraceBuffer.entry(this, "VSViewStatus.setMatrixRow()", null);
            ((DCSTraceBuffer)object).addProperty("MemberViewIndex", n);
            ((DCSTraceBuffer)object).addProperty("VsyncRcvVector", nArray);
            ((DCSTraceBuffer)object).invoke();
        }
        if (nArray == null || nArray.length != this._viewSize) {
            object = new VSNewRowIsIllegalException(this._viewRcvMessagesMatrix[n], nArray);
            throw object;
        }
        if (!this._vsLiveMembers[n]) {
            object = new VSMemberHasVSFailedException();
            throw object;
        }
        if (!this.isFirstVectorBigger(nArray, this._viewRcvMessagesMatrix[n])) {
            object = new VSNewRowIsIllegalException(this._viewRcvMessagesMatrix[n], nArray);
            throw object;
        }
        for (int i = 0; i < this._viewSize; ++i) {
            this._viewRcvMessagesMatrix[n][i] = nArray[i];
        }
        if (DCSTraceBuffer.isExitEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.exit(this, "VSViewStatus.setMatrixRow()", null);
            dCSTraceBuffer.invoke();
        }
    }

    Integer getRcvByOthersMsgID(int n, int n2) {
        DCSTraceBuffer dCSTraceBuffer;
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            dCSTraceBuffer = DCSTraceBuffer.entry(this, "VSViewStatus.getRcvByOthersMsgID()", null);
            dCSTraceBuffer.addProperty("My", "MemberViewIndex", n);
            dCSTraceBuffer.addProperty("Sender", "MemberViewIndex", n2);
            dCSTraceBuffer.invoke();
        }
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            dCSTraceBuffer = DCSTraceBuffer.event(this, "VSViewStatus.getRcvByOthersMsgID()", "Current Vsync Status");
            dCSTraceBuffer.addProperty("VsyncViewStatus", this.printStatus());
            dCSTraceBuffer.invoke();
        }
        int n3 = 0;
        boolean bl = false;
        for (int i = 0; i < this._viewSize; ++i) {
            if (!this._vsLiveMembers[i] || i == n) continue;
            if (!bl) {
                n3 = this._viewRcvMessagesMatrix[i][n2];
                bl = true;
                continue;
            }
            if (n3 - this._viewRcvMessagesMatrix[i][n2] <= 0) continue;
            n3 = this._viewRcvMessagesMatrix[i][n2];
        }
        if (!bl) {
            return null;
        }
        Integer n4 = new Integer(n3);
        if (DCSTraceBuffer.isExitEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer2 = DCSTraceBuffer.exit(this, "VSViewStatus.getRcvByOthersMsgID()", null);
            dCSTraceBuffer2.addProperty("MethodResult", n4);
            dCSTraceBuffer2.invoke();
        }
        return n4;
    }

    public int[] getRcvByAllVector() {
        Object object;
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            object = DCSTraceBuffer.entry(this, "VSViewStatus.getRcvByAllVector()", null);
            ((DCSTraceBuffer)object).invoke();
        }
        object = new int[this._viewSize];
        boolean bl = false;
        for (int i = 0; i < this._viewSize; ++i) {
            int n;
            if (!this._vsLiveMembers[i]) continue;
            if (!bl) {
                for (n = 0; n < this._viewSize; ++n) {
                    object[n] = this._viewRcvMessagesMatrix[i][n];
                }
                bl = true;
                continue;
            }
            for (n = 0; n < this._viewSize; ++n) {
                if (object[n] - this._viewRcvMessagesMatrix[i][n] <= 0) continue;
                object[n] = this._viewRcvMessagesMatrix[i][n];
            }
        }
        if (DCSTraceBuffer.isExitEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.exit(this, "VSViewStatus.getRcvByAllVector()", null);
            dCSTraceBuffer.addProperty("VsyncRBAVector", (int[])object);
            dCSTraceBuffer.invoke();
        }
        return object;
    }

    public void registerVSFailMember(int n) {
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.entry(this, "VSViewStatus.registerVSFailMember()", null);
            dCSTraceBuffer.addProperty("MemberViewIndex", n);
            dCSTraceBuffer.invoke();
        }
        this._vsLiveMembers[n] = false;
    }

    void registerCCFailMember(int n) {
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.entry(this, "VSViewStatus.registerCCFailMember()", null);
            dCSTraceBuffer.addProperty("MemberViewIndex", n);
            dCSTraceBuffer.invoke();
        }
        this._ccLiveMembers[n] = false;
        this._vsLiveMembers[n] = false;
    }

    public boolean isMemberVSFailed(int n) {
        return !this._vsLiveMembers[n];
    }

    boolean isMemberCCFailed(int n) {
        return !this._ccLiveMembers[n];
    }

    void registerSentMcastISAMsg(int n, CCVersion cCVersion) throws VSMemberHasVSFailedException {
        Object object;
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            object = DCSTraceBuffer.entry(this, "VSViewStatus.registerSentMcastISAMsg()", null);
            ((DCSTraceBuffer)object).addProperty("MemberViewIndex", n);
            ((DCSTraceBuffer)object).addProperty(cCVersion);
            ((DCSTraceBuffer)object).invoke();
        }
        this.dump();
        if (!this._vsLiveMembers[n]) {
            object = new VSMemberHasVSFailedException();
            throw object;
        }
        this._rcvMembersMcastISA[n] = cCVersion;
        this.dump();
        if (DCSTraceBuffer.isExitEnabled(TC)) {
            object = DCSTraceBuffer.exit(this, "VSViewStatus.registerSentMcastISAMsg()", null);
            ((DCSTraceBuffer)object).invoke();
        }
    }

    void registerSentP2pISAMsg(int n) throws VSMemberHasVSFailedException {
        Object object;
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            object = DCSTraceBuffer.entry(this, "VSViewStatus.registerSentP2pISAMsg()", null);
            ((DCSTraceBuffer)object).addProperty("MemberViewIndex", n);
            ((DCSTraceBuffer)object).invoke();
        }
        this.dump();
        if (!this._vsLiveMembers[n]) {
            object = new VSMemberHasVSFailedException();
            throw object;
        }
        this._rcvMembersP2PISA[n] = true;
        this.dump();
        if (DCSTraceBuffer.isExitEnabled(TC)) {
            object = DCSTraceBuffer.exit(this, "VSViewStatus.registerSentP2pISAMsg()", null);
            ((DCSTraceBuffer)object).invoke();
        }
    }

    void registerSentIMSMsg(int n) throws VSMemberHasVSFailedException {
        Object object;
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            object = DCSTraceBuffer.entry(this, "VSViewStatus.registerSentIMSMsg()", null);
            ((DCSTraceBuffer)object).addProperty("MemberViewIndex", n);
            ((DCSTraceBuffer)object).invoke();
        }
        this.dump();
        if (!this._vsLiveMembers[n]) {
            object = new VSMemberHasVSFailedException();
            throw object;
        }
        this._rcvMembersIMS[n] = true;
        this.dump();
        if (DCSTraceBuffer.isExitEnabled(TC)) {
            object = DCSTraceBuffer.exit(this, "VSViewStatus.registerSentIMSMsg()", null);
            ((DCSTraceBuffer)object).invoke();
        }
    }

    boolean everybodySentISA(CCVersion cCVersion) {
        boolean bl = true;
        for (int i = 0; i < this._viewSize; ++i) {
            if (!this._ccLiveMembers[i] || this.memberSentAllISA(i, cCVersion)) continue;
            bl = false;
            break;
        }
        return bl;
    }

    boolean memberSentMcastISA(int n) {
        return this._rcvMembersMcastISA[n] != null;
    }

    boolean memberSentAllISA(int n, CCVersion cCVersion) {
        if (cCVersion == null) {
            return false;
        }
        return cCVersion.equals(this._rcvMembersMcastISA[n]) && this._rcvMembersP2PISA[n];
    }

    boolean memberSentIMS(int n) {
        return this._rcvMembersIMS[n];
    }

    boolean everybodySentIMS() {
        boolean bl = true;
        for (int i = 0; i < this._viewSize; ++i) {
            if (!this._ccLiveMembers[i] || this._rcvMembersIMS[i]) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public String dump() {
        if (DCSTraceBuffer.isDumpEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.dump(this, "VSViewStatus.dump()", "Dump VSViewStatus");
            dCSTraceBuffer.addProperty("VsyncViewStatus", this.printStatus());
            return dCSTraceBuffer.toString();
        }
        return "";
    }

    boolean areRowsEqual(int[] nArray, int[] nArray2) {
        if (nArray == null && nArray2 == null) {
            return true;
        }
        if (nArray == null || nArray2 == null) {
            return false;
        }
        if (nArray.length != nArray2.length) {
            return false;
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == nArray2[i]) continue;
            return false;
        }
        return true;
    }

    private boolean isFirstVectorBigger(int[] nArray, int[] nArray2) {
        for (int i = 0; i < this._viewSize; ++i) {
            if (nArray2[i] - nArray[i] <= 0) continue;
            return false;
        }
        return true;
    }

    private final boolean isProblematicEntry(int n) {
        if (!this._ccLiveMembers[n]) {
            return false;
        }
        return !this._vsLiveMembers[n] || this._rcvMembersMcastISA[n] == null || !this._rcvMembersP2PISA[n] || !this._rcvMembersIMS[n];
    }

    String printStatus() {
        int n;
        int n2;
        boolean bl;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("View Status information\n");
        boolean bl2 = bl = this._viewSize <= 10;
        if (!bl) {
            n2 = 0;
            for (n = 0; n < this._viewSize; ++n) {
                if (!this.isProblematicEntry(n)) continue;
                ++n2;
            }
            if (n2 > 10) {
                stringBuffer.append("Not printing detailed status info because many members (" + n2 + ") are either down or disconnected" + "\n");
                return stringBuffer.toString();
            }
            if (n2 == 0) {
                stringBuffer.append("Not printing detailed status info because all members seem to be communicating correctly");
                return stringBuffer.toString();
            }
        }
        this.printEntry(stringBuffer, "MemberID", false);
        if (bl) {
            for (n2 = 0; n2 < this._viewSize; ++n2) {
                this.printEntry(stringBuffer, "From " + Integer.toString(n2), false);
            }
        }
        this.printEntry(stringBuffer, "VS Live", false);
        this.printEntry(stringBuffer, "CC Live", false);
        this.printEntry(stringBuffer, "rcv M ISA", true);
        this.printEntry(stringBuffer, "rcv P2P ISA", true);
        this.printEntry(stringBuffer, "rcv IMS", true);
        stringBuffer.append("\n");
        for (n2 = 0; n2 < this._viewSize; ++n2) {
            if (!bl && !this.isProblematicEntry(n2)) continue;
            this.printEntry(stringBuffer, Integer.toString(n2), false);
            if (bl) {
                for (n = 0; n < this._viewSize; ++n) {
                    this.printEntry(stringBuffer, Integer.toString(this._viewRcvMessagesMatrix[n2][n]), false);
                }
            }
            this.printEntry(stringBuffer, "" + this._vsLiveMembers[n2], false);
            this.printEntry(stringBuffer, "" + this._ccLiveMembers[n2], false);
            this.printEntry(stringBuffer, "" + this._rcvMembersMcastISA[n2], true);
            this.printEntry(stringBuffer, "" + this._rcvMembersP2PISA[n2], true);
            this.printEntry(stringBuffer, "" + this._rcvMembersIMS[n2], true);
            stringBuffer.append("\n");
        }
        if (bl) {
            this.printEntry(stringBuffer, "RBA vs live", false);
            int[] nArray = this.getRcvByAllVector();
            for (n = 0; n < this._viewSize; ++n) {
                this.printEntry(stringBuffer, Integer.toString(nArray[n]), false);
            }
        }
        return stringBuffer.toString();
    }

    private void printEntry(StringBuffer stringBuffer, String string, boolean bl) {
        int n = 12;
        int n2 = 20;
        stringBuffer.append(string);
        int n3 = bl ? n2 : n;
        for (int i = 0; i < n3 - string.length(); ++i) {
            stringBuffer.append(" ");
        }
    }

    String printIntRow(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < nArray.length; ++i) {
            stringBuffer.append(nArray[i]);
            stringBuffer.append(".");
        }
        return stringBuffer.toString();
    }

    boolean check(int n, VSState1 vSState1, CCVersion cCVersion) {
        DCSTraceBuffer dCSTraceBuffer;
        DCSTraceBuffer dCSTraceBuffer2;
        boolean bl = true;
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            dCSTraceBuffer2 = DCSTraceBuffer.entry(this, "VSViewStatus.check()", null);
            dCSTraceBuffer2.addProperty("My", "MemberViewIndex", n);
            dCSTraceBuffer2.addProperty(vSState1);
            dCSTraceBuffer2.addProperty(cCVersion);
            dCSTraceBuffer2.invoke();
        }
        if (this._ccLiveMembers.length != this._viewSize || this._rcvMembersIMS.length != this._viewSize || this._rcvMembersMcastISA.length != this._viewSize || this._rcvMembersP2PISA.length != this._viewSize || this._viewRcvMessagesMatrix.length != this._viewSize || this._vsLiveMembers.length != this._viewSize) {
            if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
                dCSTraceBuffer2 = DCSTraceBuffer.internalWarning(this, "Found data structure with length not compatible with view size", "VSViewStatus.check()", null);
                dCSTraceBuffer2.addProperty("viewSize", this._viewSize);
                dCSTraceBuffer2.addProperty("_ccLiveMembers.length", this._ccLiveMembers.length);
                dCSTraceBuffer2.addProperty("_rcvMembersIMS.length", this._rcvMembersIMS.length);
                dCSTraceBuffer2.addProperty("_rcvMembersMcastISA.length", this._rcvMembersMcastISA.length);
                dCSTraceBuffer2.addProperty("_rcvMembersP2PISA.length", this._rcvMembersP2PISA.length);
                dCSTraceBuffer2.addProperty("_viewRcvMessagesMatrix.length", this._viewRcvMessagesMatrix.length);
                dCSTraceBuffer2.addProperty("_vsLiveMembers.length", this._vsLiveMembers.length);
                dCSTraceBuffer2.invoke();
            }
            bl = false;
        }
        if (!this._ccLiveMembers[n]) {
            if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
                dCSTraceBuffer2 = DCSTraceBuffer.internalWarning(this, "My member is CC failed", "VSViewStatus.check()", null);
                dCSTraceBuffer2.invoke();
            }
            bl = false;
        }
        if (!this._vsLiveMembers[n]) {
            if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
                dCSTraceBuffer2 = DCSTraceBuffer.internalWarning(this, "My member is VS failed", "VSViewStatus.check()", null);
                dCSTraceBuffer2.invoke();
            }
            bl = false;
        }
        for (int i = 0; i < this._viewSize; ++i) {
            if (this._ccLiveMembers[i] || !this._vsLiveMembers[i]) continue;
            if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
                dCSTraceBuffer = DCSTraceBuffer.internalWarning(this, "Found cc failed member that is VS live", "VSViewStatus.check()", null);
                dCSTraceBuffer.addProperty("MemberViewIndex", i);
                dCSTraceBuffer.invoke();
            }
            bl = false;
        }
        if (this._rcvMembersMcastISA[n] == null) {
            if (vSState1.isState(7) || vSState1.isState(8)) {
                if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
                    DCSTraceBuffer dCSTraceBuffer3 = DCSTraceBuffer.internalWarning(this, "Didn't rcv ISA from this member in state implying otherwise", "VSViewStatus.check()", null);
                    dCSTraceBuffer3.addProperty(vSState1);
                    dCSTraceBuffer3.invoke();
                }
                bl = false;
            }
        } else if (this._rcvMembersMcastISA[n].compareTo(cCVersion) < 0) {
            if (!(vSState1.isState(5) || vSState1.isState(6) || vSState1.isState(8))) {
                if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
                    DCSTraceBuffer dCSTraceBuffer4 = DCSTraceBuffer.internalWarning(this, "Received old ISA from this member at illegal state", "VSViewStatus.check()", null);
                    dCSTraceBuffer4.addProperty("Received", this._rcvMembersMcastISA[n]);
                    dCSTraceBuffer4.addProperty("Current", cCVersion);
                    dCSTraceBuffer4.addProperty(vSState1);
                    dCSTraceBuffer4.invoke();
                }
                bl = false;
            }
        } else if (this._rcvMembersMcastISA[n].compareTo(cCVersion) == 0) {
            if (!vSState1.didGetCCdidntGetNV() || vSState1.isState(5)) {
                if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
                    DCSTraceBuffer dCSTraceBuffer5 = DCSTraceBuffer.internalWarning(this, "Received currnet ISA from this member at illegal state", "VSViewStatus.check()", null);
                    dCSTraceBuffer5.addProperty(this._rcvMembersMcastISA[n]);
                    dCSTraceBuffer5.addProperty(vSState1);
                    dCSTraceBuffer5.invoke();
                }
                bl = false;
            }
        } else {
            if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer6 = DCSTraceBuffer.internalWarning(this, "Received future ISA from this member", "VSViewStatus.check()", null);
                dCSTraceBuffer6.addProperty("Received", this._rcvMembersMcastISA[n]);
                dCSTraceBuffer6.addProperty("Current", cCVersion);
                dCSTraceBuffer6.addProperty(vSState1);
                dCSTraceBuffer6.invoke();
            }
            bl = false;
        }
        if (this._rcvMembersP2PISA[n] && !vSState1.didGetCCdidntGetNV()) {
            if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer7 = DCSTraceBuffer.internalWarning(this, "Received my p2p ISA at illegal state", "VSViewStatus.check()", null);
                dCSTraceBuffer7.addProperty(vSState1);
                dCSTraceBuffer7.invoke();
            }
            bl = false;
        }
        if (!this._rcvMembersP2PISA[n] && (vSState1.isState(7) || vSState1.isState(8))) {
            if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer8 = DCSTraceBuffer.internalWarning(this, "Did not received my p2p isa, when state implies otherwise", "VSViewStatus.check()", null);
                dCSTraceBuffer8.addProperty(vSState1);
                dCSTraceBuffer8.invoke();
            }
            bl = false;
        }
        for (int i = 0; i < this._viewSize; ++i) {
            if (!this._ccLiveMembers[i] || !this.memberSentIMS(i) || this.memberSentMcastISA(i)) continue;
            if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
                dCSTraceBuffer = DCSTraceBuffer.internalWarning(this, "Member sent IMS but not ISA", "VSViewStatus.check()", null);
                dCSTraceBuffer.addProperty("MemberViewIndex", i);
                dCSTraceBuffer.invoke();
            }
            bl = false;
        }
        if (vSState1.isState(8) && !this.everybodySentIMS()) {
            if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer9 = DCSTraceBuffer.internalWarning(this, "State is cok up but not everybody sent IMS", "VSViewStatus.check()", null);
                dCSTraceBuffer9.invoke();
            }
            bl = false;
        }
        if (vSState1.isState(7) && this.everybodySentIMS()) {
            if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer10 = DCSTraceBuffer.internalWarning(this, "State is cok vs ims but everybody already sent IMS", "VSViewStatus.check()", null);
                dCSTraceBuffer10.invoke();
            }
            bl = false;
        }
        if (!bl) {
            this.dump();
        }
        if (DCSTraceBuffer.isExitEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer11 = DCSTraceBuffer.exit(this, "VSViewStatus.check()", null);
            dCSTraceBuffer11.addProperty("MethodResult", bl);
            dCSTraceBuffer11.invoke();
        }
        return bl;
    }

    int[] getSyncHinderingMembers() {
        block19: {
            try {
                Object object;
                if (DCSTraceBuffer.isEventEnabled(TC)) {
                    object = DCSTraceBuffer.event(this, "VSViewStatus.getSyncHinderingMembers()", "Starting Method");
                    ((DCSTraceBuffer)object).addProperty("VsyncViewStatus", this.printStatus());
                    ((DCSTraceBuffer)object).invoke();
                }
                object = new LinkedList();
                boolean bl = false;
                for (int i = 0; i < this._viewSize; ++i) {
                    if (!this._ccLiveMembers[i]) continue;
                    if (this._rcvMembersIMS[i]) {
                        bl = true;
                        continue;
                    }
                    ((LinkedList)object).addLast(new Integer(i));
                }
                if (!((AbstractCollection)object).isEmpty() && bl) {
                    int[] nArray = this.getIntLinkedList2Array((LinkedList)object);
                    if (DCSTraceBuffer.isEventEnabled(TC)) {
                        DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this, "VSViewStatus.getSyncHinderingMembers()", "return members who didn't send IMS. other members did send");
                        dCSTraceBuffer.addProperty("MemberViewIndexes", nArray);
                        dCSTraceBuffer.invoke();
                    }
                    return nArray;
                }
                LinkedList<Integer> linkedList = new LinkedList<Integer>();
                boolean bl2 = false;
                for (int i = 0; i < this._viewSize; ++i) {
                    if (!this._ccLiveMembers[i]) continue;
                    if (this._rcvMembersP2PISA[i]) {
                        bl2 = true;
                        continue;
                    }
                    linkedList.addLast(new Integer(i));
                }
                if (!linkedList.isEmpty() && bl2) {
                    int[] nArray = this.getIntLinkedList2Array(linkedList);
                    if (DCSTraceBuffer.isEventEnabled(TC)) {
                        DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this, "VSViewStatus.getSyncHinderingMembers()", "Return members who didn't send ISA PTP");
                        dCSTraceBuffer.addProperty("MemberViewIndexes", nArray);
                        dCSTraceBuffer.invoke();
                    }
                    return nArray;
                }
                LinkedList<Integer> linkedList2 = new LinkedList<Integer>();
                boolean bl3 = false;
                CCVersion cCVersion = this.getMinCCVersion(this._rcvMembersMcastISA);
                for (int i = 0; i < this._viewSize; ++i) {
                    if (!this._ccLiveMembers[i]) continue;
                    if (this._rcvMembersMcastISA[i] == null || this._rcvMembersMcastISA[i].equals(cCVersion)) {
                        linkedList2.addLast(new Integer(i));
                        continue;
                    }
                    bl3 = true;
                }
                if (!linkedList2.isEmpty() && bl3) {
                    int[] nArray = this.getIntLinkedList2Array(linkedList2);
                    if (DCSTraceBuffer.isEventEnabled(TC)) {
                        DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this, "VSViewStatus.getSyncHinderingMembers()", "Return members who sent minimum MCAST isa");
                        dCSTraceBuffer.addProperty("MemberViewIndexes", nArray);
                        dCSTraceBuffer.invoke();
                    }
                    return nArray;
                }
                LinkedList<Integer> linkedList3 = new LinkedList<Integer>();
                boolean bl4 = false;
                int[] nArray = this.getMaxCCMembersVector();
                for (int i = 0; i < this._viewSize; ++i) {
                    if (!this._ccLiveMembers[i]) continue;
                    if (!this.areRowsEqual(this._viewRcvMessagesMatrix[i], nArray)) {
                        linkedList3.addLast(new Integer(i));
                        continue;
                    }
                    bl4 = true;
                }
                if (!linkedList3.isEmpty() && bl4) {
                    int[] nArray2 = this.getIntLinkedList2Array(linkedList3);
                    if (DCSTraceBuffer.isEventEnabled(TC)) {
                        DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this, "VSViewStatus.getSyncHinderingMembers()", "Return members who didn't send updated vector.");
                        dCSTraceBuffer.addProperty("MemberViewIndexes", nArray2);
                        dCSTraceBuffer.invoke();
                    }
                    return nArray2;
                }
            }
            catch (Throwable throwable) {
                if (!DCSTraceBuffer.isInternalWarningEnabled(TC)) break block19;
                DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.internalWarning(this, "Got exception during method", "VSViewStatus.getSyncHinderingMembers()", throwable);
                dCSTraceBuffer.invoke();
            }
        }
        return this.getCCLiveMembers();
    }

    private int[] getIntLinkedList2Array(LinkedList linkedList) {
        int[] nArray = new int[linkedList.size()];
        ListIterator listIterator = linkedList.listIterator();
        int n = 0;
        while (listIterator.hasNext()) {
            nArray[n] = (Integer)listIterator.next();
            ++n;
        }
        return nArray;
    }

    private int[] getMaxCCMembersVector() {
        boolean bl = false;
        int[] nArray = new int[this._viewSize];
        for (int i = 0; i < this._viewSize; ++i) {
            int n;
            if (!this._ccLiveMembers[i]) continue;
            if (!bl) {
                for (n = 0; n < this._viewSize; ++n) {
                    nArray[n] = this._viewRcvMessagesMatrix[i][n];
                }
                bl = true;
                continue;
            }
            for (n = 0; n < this._viewSize; ++n) {
                if (this._viewRcvMessagesMatrix[i][n] - nArray[n] <= 0) continue;
                nArray[n] = this._viewRcvMessagesMatrix[i][n];
            }
        }
        return nArray;
    }

    private int[] getCCLiveMembers() {
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        for (int i = 0; i < this._viewSize; ++i) {
            if (!this._ccLiveMembers[i]) continue;
            linkedList.addLast(new Integer(i));
        }
        return this.getIntLinkedList2Array(linkedList);
    }

    private CCVersion getMinCCVersion(CCVersion[] cCVersionArray) {
        int n;
        CCVersion cCVersion = null;
        for (n = 0; n < cCVersionArray.length; ++n) {
            if (!this._ccLiveMembers[n]) continue;
            cCVersion = cCVersionArray[n];
            break;
        }
        if (cCVersion == null) {
            return null;
        }
        while (n < cCVersionArray.length) {
            if (this._ccLiveMembers[n]) {
                if (cCVersionArray[n] != null) {
                    if (cCVersionArray[n].compareTo(cCVersion) < 0) {
                        cCVersion = cCVersionArray[n];
                    }
                } else {
                    return null;
                }
            }
            ++n;
        }
        return cCVersion;
    }

    public TraceComponent getTraceComponent() {
        return TC;
    }

    public String getStackName() {
        return this._thisStackName;
    }

    public String getMemberName() {
        return this._thisMemberName;
    }

    public String getLayerName() {
        return DCSConstants.TRACE_LAYER_NAMES[2];
    }
}

