/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.vri.vsync.impl1;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.dcs.common.DCSTraceable;
import com.ibm.ws.dcs.common.QoS;
import com.ibm.ws.dcs.common.exception.DCSIllegalParameterException;
import com.ibm.ws.dcs.common.exception.DCSInvalidMemberException;
import com.ibm.ws.dcs.common.exception.DCSInvalidParametersException;
import com.ibm.ws.dcs.common.exception.DCSInvalidQoSException;
import com.ibm.ws.dcs.common.exception.DCSInvalidViewIDException;
import com.ibm.ws.dcs.common.exception.DCSMemberIsDeniedException;
import com.ibm.ws.dcs.common.exception.DCSMemberIsNotInViewException;
import com.ibm.ws.dcs.common.exception.DCSRuntimeException;
import com.ibm.ws.dcs.common.exception.DCSTransportLayerException;
import com.ibm.ws.dcs.common.exception.DCSUnsupportedQoSException;
import com.ibm.ws.dcs.utils.Alarm;
import com.ibm.ws.dcs.utils.AlarmListener;
import com.ibm.ws.dcs.utils.AlarmManager;
import com.ibm.ws.dcs.vri.common.CCVersion;
import com.ibm.ws.dcs.vri.common.DCSConstants;
import com.ibm.ws.dcs.vri.common.Globals;
import com.ibm.ws.dcs.vri.common.Header;
import com.ibm.ws.dcs.vri.common.Utils;
import com.ibm.ws.dcs.vri.common.VRICheckFailedException;
import com.ibm.ws.dcs.vri.common.VRIIllegalStateException;
import com.ibm.ws.dcs.vri.common.VRIMemberDescription;
import com.ibm.ws.dcs.vri.common.VRIMemberUtils;
import com.ibm.ws.dcs.vri.common.VRIMessage;
import com.ibm.ws.dcs.vri.common.ViewIdImpl;
import com.ibm.ws.dcs.vri.common.nls.AbstractNLSEvent;
import com.ibm.ws.dcs.vri.common.nls.SuspectUnreadableMessageEvent;
import com.ibm.ws.dcs.vri.common.nls.VSSuspectNonconsecutiveMsg;
import com.ibm.ws.dcs.vri.common.nls.VSSuspectProtocolBroke;
import com.ibm.ws.dcs.vri.common.nls.VSSuspectTimeout;
import com.ibm.ws.dcs.vri.common.nls.VSSyncCompletedEvent;
import com.ibm.ws.dcs.vri.common.nls.VSSyncTimeoout;
import com.ibm.ws.dcs.vri.common.util.DCSTraceBuffer;
import com.ibm.ws.dcs.vri.common.util.DCSTraceContext;
import com.ibm.ws.dcs.vri.vsync.VSDenialReason;
import com.ibm.ws.dcs.vri.vsync.VSGotFutureNotConsecutiveVSMessageException;
import com.ibm.ws.dcs.vri.vsync.VSHeader;
import com.ibm.ws.dcs.vri.vsync.VSInternalException;
import com.ibm.ws.dcs.vri.vsync.VSMemberHasVSFailedException;
import com.ibm.ws.dcs.vri.vsync.VSNewRowIsIllegalException;
import com.ibm.ws.dcs.vri.vsync.VSNotOrigHeader;
import com.ibm.ws.dcs.vri.vsync.VSRcvVectorCCVHeader;
import com.ibm.ws.dcs.vri.vsync.VSRcvVectorHeader;
import com.ibm.ws.dcs.vri.vsync.VSRequestedMessagesHaveBeenDeletedException;
import com.ibm.ws.dcs.vri.vsync.VSync;
import com.ibm.ws.dcs.vri.vsync.VSyncAlgo;
import com.ibm.ws.dcs.vri.vsync.impl1.MessageDisposal1;
import com.ibm.ws.dcs.vri.vsync.impl1.VSState1;
import com.ibm.ws.dcs.vri.vsync.impl1.VSViewStatus1;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;

public final class VSyncAlgo1
implements VSyncAlgo,
AlarmListener,
DCSTraceContext {
    public static final int VERSION = 0x1000000;
    private final VSync vs;
    private final VSState1 _state;
    private final VSViewStatus1 _viewStatus;
    private VRIMemberDescription _thisMember;
    CCVersion _curCCV;
    ViewIdImpl _curViewId;
    VRIMemberDescription[] _curViewMembers;
    private int _viewSize;
    private int _nextVSMsgId;
    private int _myViewIndex;
    CCVersion _waitCCV;
    VRIMemberDescription[] _waitFailedMembers;
    private LinkedList _inQueuedMsgs;
    private LinkedList _outQueuedMsgs;
    private static final byte MEMBER_RCV_VECTOR_MSG = 1;
    private static final byte CC_ISA_MCAST_MSG = 2;
    private static final byte CC_ISA_P2P_MSG = 3;
    private static final byte CC_IMS_MSG = 4;
    static final String[] VS_ORIG_MSGS_NAMES = new String[]{"NOT_DEFINED", "MEMBER_RCV_VECTOR_MSG", "CC_ISA_MCAST_MSG", "CC_ISA_P2P_MSG", "CC_IMS_MSG"};
    private final QoS.QOSUnicast VS_ORIG_MSG_UNICAST_QOS;
    private final QoS.QOSMulticast VS_ORIG_MSG_MULTICAST_QOS;
    MessageDisposal1 _md;
    private Alarm _timeoutAlarm;
    private final int CONFIG_TIMEOUT_SEC;
    private Object _mutex;
    private static TraceComponent TC = Tr.register(VSyncAlgo1.class, "DCS", "com.ibm.ws.dcs.common.event.nls.dcs");

    public VSyncAlgo1(VSync vSync, VSState1 vSState1, VSViewStatus1 vSViewStatus1, VRIMemberDescription vRIMemberDescription, Globals globals) {
        this.vs = vSync;
        this._state = vSState1;
        this._viewStatus = vSViewStatus1;
        this._thisMember = vRIMemberDescription;
        this._waitCCV = null;
        this._outQueuedMsgs = new LinkedList();
        this._inQueuedMsgs = new LinkedList();
        try {
            this.VS_ORIG_MSG_UNICAST_QOS = QoS.getUnicastQoS(QoS.RELIABLE, QoS.FIFO);
            this.VS_ORIG_MSG_MULTICAST_QOS = QoS.getMulticastQoS(QoS.RELIABLE, QoS.FIFO);
        }
        catch (DCSUnsupportedQoSException dCSUnsupportedQoSException) {
            throw new DCSIllegalParameterException("VSyncAlgo1.VSync(): VS qos is not supported: " + dCSUnsupportedQoSException);
        }
        this._md = new MessageDisposal1(vSync, globals);
        this._timeoutAlarm = null;
        this.CONFIG_TIMEOUT_SEC = globals.getConfigParamAsInt("VS_CC_TIMEOUT_SEC");
        this._mutex = globals.getMutex();
    }

    public void initViewScopedVariables(VRIMemberDescription[] vRIMemberDescriptionArray, ViewIdImpl viewIdImpl, int n) {
        this._curViewId = viewIdImpl;
        this._viewSize = vRIMemberDescriptionArray.length;
        this._curViewMembers = new VRIMemberDescription[this._viewSize];
        System.arraycopy(vRIMemberDescriptionArray, 0, this._curViewMembers, 0, vRIMemberDescriptionArray.length);
        this._myViewIndex = n;
        this._nextVSMsgId = 1;
        this._curCCV = null;
        this._md.initViewScopedVariables();
    }

    public String completeCurrent(VRIMemberDescription[] vRIMemberDescriptionArray, CCVersion cCVersion, DCSTraceBuffer dCSTraceBuffer) {
        if (this._state.isNewViewProcess()) {
            this._state.setCCInState();
            this._waitCCV = new CCVersion(cCVersion);
            this._waitFailedMembers = new VRIMemberDescription[vRIMemberDescriptionArray.length];
            System.arraycopy(vRIMemberDescriptionArray, 0, this._waitFailedMembers, 0, vRIMemberDescriptionArray.length);
            return "Saved ccv and failed members";
        }
        this.assertSanityOfFailedMembers(vRIMemberDescriptionArray);
        this.vs.startPMI();
        this._curCCV = cCVersion;
        for (int i = 0; i < vRIMemberDescriptionArray.length; ++i) {
            this._viewStatus.registerCCFailMember(vRIMemberDescriptionArray[i].getIndexInView());
        }
        if (!this._state.isState(8)) {
            if (this._timeoutAlarm != null) {
                this._timeoutAlarm.cancel();
                this._timeoutAlarm = null;
            }
            this.sendVSOriginatedMsg((byte)1);
            this._md.setSyncMode(true);
            this._state.setState(5);
            if (DCSTraceBuffer.isEventEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer2 = DCSTraceBuffer.event(this, "VSyncAlgo1.completeCurrent()", "Calling down with cc()");
                dCSTraceBuffer2.mergePropertyList(dCSTraceBuffer);
                dCSTraceBuffer2.invoke();
            }
            this.vs._down.completeCurrent(vRIMemberDescriptionArray, this._curCCV);
        } else {
            if (DCSTraceBuffer.isEventEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer3 = DCSTraceBuffer.event(this, "VSyncAlgo1.completeCurrent()", "Mcast ISA MCast, and call cok()");
                dCSTraceBuffer3.mergePropertyList(dCSTraceBuffer);
                dCSTraceBuffer3.invoke();
            }
            this.sendVSOriginatedMsg((byte)2);
            this.vs._up.currentOK(this._curCCV);
        }
        return null;
    }

    public void newView(VRIMemberDescription[] vRIMemberDescriptionArray, ViewIdImpl viewIdImpl, Map map, LinkedList linkedList, DCSTraceBuffer dCSTraceBuffer) {
        if (!this._state.isState(8)) {
            VRIIllegalStateException vRIIllegalStateException = new VRIIllegalStateException(2, "VSyncAlgo1.newView: cant new view in state: " + this._state);
            throw vRIIllegalStateException;
        }
        this.initViewScopedVariables(vRIMemberDescriptionArray, viewIdImpl, this._thisMember.getIndexInView());
        if (linkedList != null) {
            this._outQueuedMsgs = linkedList;
        }
        this.vs._membersMgr.unDenyAll((byte)2, new int[0], true);
        this._state.setState(9);
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer2 = DCSTraceBuffer.event(this, "VSyncAlgo1.newView()", "Calling down with nv()");
            dCSTraceBuffer2.mergePropertyList(dCSTraceBuffer);
            dCSTraceBuffer2.invoke();
        }
        this.vs._down.newView(vRIMemberDescriptionArray, viewIdImpl, map);
    }

    public void mcastMessage(VRIMessage vRIMessage, QoS.QOSMulticast qOSMulticast, ViewIdImpl viewIdImpl) throws DCSInvalidParametersException, DCSTransportLayerException {
        if (qOSMulticast.getChannelType() == QoS.CONNECTED) {
            if (qOSMulticast.isVS()) {
                this.vs.focus(VSync.OUT_MSG, "mcast_vs_con");
                DCSInvalidQoSException dCSInvalidQoSException = new DCSInvalidQoSException("VSyncAlgo1.mcastMessage: Can't send VS message in the connected channel");
                throw dCSInvalidQoSException;
            }
            this.vs._down.mcastMessage(vRIMessage, qOSMulticast, viewIdImpl);
            this.vs.focus(VSync.OUT_MSG, "mcast_nvs");
            return;
        }
        if (qOSMulticast.getChannelType() == QoS.VIEW) {
            if (!qOSMulticast.isVS()) {
                this.vs._down.mcastMessage(vRIMessage, qOSMulticast, viewIdImpl);
                this.vs.focus(VSync.OUT_MSG, "mcast_nvs");
                return;
            }
            if (this._state.areOutVSMsgsQueued()) {
                if (qOSMulticast.getGuaranteeType() == QoS.VS_CURRENT) {
                    this.vs.focus(VSync.OUT_MSG, "mcast_cur_view_change");
                    throw new DCSInvalidViewIDException(viewIdImpl, null, "VSyncAlgo1.mcastMessage: View is changing");
                }
                this.vs.focus(VSync.OUT_MSG, "mcast_any_save");
                this._outQueuedMsgs.addLast(new VSyncAlgo.MsgAndQos(vRIMessage, qOSMulticast));
                return;
            }
            if (qOSMulticast.getGuaranteeType() == QoS.VS_CURRENT) {
                if (!this._curViewId.equals(viewIdImpl)) {
                    this.vs.focus(VSync.OUT_MSG, "mcast_cur_wrong");
                    throw new DCSInvalidViewIDException(viewIdImpl, this._curViewId, "Wrong View");
                }
                this.vs.focus(VSync.OUT_MSG, "mcast_cur_ok");
            } else {
                this.vs.focus(VSync.OUT_MSG, "mcast_any_ok");
            }
            this.mcastVSMsg(vRIMessage, qOSMulticast);
            return;
        }
    }

    public void sendMessage(VRIMessage vRIMessage, VRIMemberDescription vRIMemberDescription, QoS.QOSUnicast qOSUnicast, ViewIdImpl viewIdImpl) throws DCSInvalidParametersException, DCSTransportLayerException {
        if (!qOSUnicast.isVS()) {
            this.vs.focus(VSync.OUT_MSG, "send_nvs");
            this.vs._down.sendMessage(vRIMessage, vRIMemberDescription, qOSUnicast, viewIdImpl);
            return;
        }
        if (qOSUnicast.getGuaranteeType() == QoS.VS_ANY) {
            this.vs.focus(VSync.OUT_MSG, "send_any_exc");
            throw new DCSInvalidQoSException("VSyncAlgo1.sendMessage: can't send point to point VS_ANY msg");
        }
        if (qOSUnicast.getChannelType() == QoS.CONNECTED) {
            this.vs.focus(VSync.OUT_MSG, "send_cur_con");
            throw new DCSInvalidQoSException("VSyncAlgo1.sendMessage: can't send VS_CURRENT in the connected channel");
        }
        if (this._state.areOutVSMsgsQueued()) {
            this.vs.focus(VSync.OUT_MSG, "send_cur_view_change");
            throw new DCSInvalidViewIDException(viewIdImpl, null, "view is changing");
        }
        if (!this._curViewId.equals(viewIdImpl)) {
            this.vs.focus(VSync.OUT_MSG, "send_cur_wrong_view");
            throw new DCSInvalidViewIDException(viewIdImpl, this._curViewId, "wrong view");
        }
        if (!vRIMemberDescription.isInView()) {
            this.vs.focus(VSync.OUT_MSG, "send_cur_not_view_trg");
            DCSMemberIsNotInViewException dCSMemberIsNotInViewException = new DCSMemberIsNotInViewException(vRIMemberDescription.getName(), VRIMemberUtils.getMemberNames(this._curViewMembers));
            throw dCSMemberIsNotInViewException;
        }
        if (vRIMemberDescription.isDenied((byte)2)) {
            this.vs.focus(VSync.OUT_MSG, "send_cur_den_trg");
            DCSMemberIsDeniedException dCSMemberIsDeniedException = new DCSMemberIsDeniedException(vRIMemberDescription.getName(), VRIMemberUtils.getMemberNames(VRIMemberUtils.minus(this._curViewMembers, this.vs._membersMgr.getDeniedMembers((byte)2, true))));
            throw dCSMemberIsDeniedException;
        }
        this.vs.focus(VSync.OUT_MSG, "send_cur_ok");
        this.vs.sendVSCurrentMsg(vRIMessage, qOSUnicast, vRIMemberDescription);
    }

    public String currentOK(CCVersion cCVersion, DCSTraceBuffer dCSTraceBuffer) {
        if (this._state.isTerminationProcess()) {
            return "Terminating";
        }
        if (!this._state.isState(5)) {
            VRIIllegalStateException vRIIllegalStateException = new VRIIllegalStateException(2, "VSyncAlgo1.currentOK: called with currentOK, when state is " + this._state);
            this.vs.handleInternalError(vRIIllegalStateException, false);
            return null;
        }
        int n = cCVersion.compareTo(this._curCCV);
        if (n > 0) {
            VRIIllegalStateException vRIIllegalStateException = new VRIIllegalStateException(2, "VSyncAlgo1.currentOK: the layer below delivered future ccv");
            this.vs.handleInternalError(vRIIllegalStateException, false);
            return null;
        }
        if (n < 0) {
            return "Old CCV";
        }
        try {
            for (int i = 0; i < this._viewSize; ++i) {
                if (!this._viewStatus.isMemberCCFailed(i)) continue;
                Integer n2 = this._viewStatus.getRcvByOthersMsgID(this._myViewIndex, i);
                if (n2 != null) {
                    LinkedList linkedList = null;
                    linkedList = this.vs._inSavedMsgs.getSavedVSMessages(i, n2 + 1);
                    if (linkedList == null) continue;
                    ListIterator listIterator = linkedList.listIterator();
                    while (listIterator.hasNext()) {
                        VRIMessage vRIMessage = (VRIMessage)listIterator.next();
                        this.mcastCompleteMsg(vRIMessage);
                    }
                    continue;
                }
                break;
            }
        }
        catch (VSRequestedMessagesHaveBeenDeletedException vSRequestedMessagesHaveBeenDeletedException) {
            VSInternalException vSInternalException = new VSInternalException(vSRequestedMessagesHaveBeenDeletedException);
            this.vs.handleInternalError(vSInternalException, false);
            return null;
        }
        catch (DCSTransportLayerException dCSTransportLayerException) {
            this.vs.handleInternalError(dCSTransportLayerException, false);
            return null;
        }
        catch (DCSInvalidParametersException dCSInvalidParametersException) {
            this.vs.handleInternalError(dCSInvalidParametersException, false);
            return null;
        }
        this.sendVSOriginatedMsg((byte)2);
        this.sendVSOriginatedMsg((byte)3);
        this._state.setState(6);
        this._timeoutAlarm = AlarmManager.create(AlarmManager.GENERAL_ALARM, this.CONFIG_TIMEOUT_SEC * 1000, this._mutex, this, this._curCCV);
        return "";
    }

    public void newViewOK(VRIMemberDescription[] vRIMemberDescriptionArray, ViewIdImpl viewIdImpl, Map map, DCSTraceBuffer dCSTraceBuffer) {
        Object object;
        if (this._state.isTerminationProcess()) {
            return;
        }
        if (!this._state.isState(9) && !this._state.isState(10)) {
            VRIIllegalStateException vRIIllegalStateException = new VRIIllegalStateException(2, "VSyncAlgo1.newViewOK: illegal state: " + this._state);
            this.vs.handleInternalError(vRIIllegalStateException, false);
            return;
        }
        if (!this._curViewId.equals(viewIdImpl)) {
            this.vs.handleInternalError(new DCSIllegalParameterException("VSyncAlgo1.newViewOK: view id passed in nv(): " + this._curViewId + ". different the in view id: " + viewIdImpl), false);
            return;
        }
        if (!VRIMemberUtils.contains(this._curViewMembers, vRIMemberDescriptionArray)) {
            this.vs.handleInternalError(new DCSIllegalParameterException("VSyncAlgo1.newViewOK: new view ok members not included in  new view members"), false);
            return;
        }
        if (!VRIMemberUtils.contains(vRIMemberDescriptionArray, this._thisMember)) {
            this.vs.handleInternalError(new DCSIllegalParameterException("VSyncAlgo1.newViewOK: this member not included in newview ok members"), false);
            return;
        }
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            object = DCSTraceBuffer.event(this, "VSyncAlgo1.newViewOK()", "Mcast outgoing queued messages");
            ((DCSTraceBuffer)object).mergePropertyList(dCSTraceBuffer);
            ((DCSTraceBuffer)object).addProperty(this._state);
            ((DCSTraceBuffer)object).invoke();
        }
        try {
            while (!this._outQueuedMsgs.isEmpty()) {
                object = (VSyncAlgo.MsgAndQos)this._outQueuedMsgs.removeFirst();
                this.mcastVSMsg(((VSyncAlgo.MsgAndQos)object).getMsg(), ((VSyncAlgo.MsgAndQos)object).getQoS());
            }
        }
        catch (DCSTransportLayerException dCSTransportLayerException) {
            this.vs.handleInternalError(dCSTransportLayerException, true);
        }
        catch (DCSInvalidParametersException dCSInvalidParametersException) {
            this.vs.handleInternalError(dCSInvalidParametersException, true);
        }
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            object = DCSTraceBuffer.event(this, "VSyncAlgo1.newViewOK()", "Call up with nvok");
            ((DCSTraceBuffer)object).mergePropertyList(dCSTraceBuffer);
            ((DCSTraceBuffer)object).addProperty(this._state);
            ((DCSTraceBuffer)object).invoke();
        }
        if (this._state.isState(9)) {
            this._state.setState(11);
        } else {
            this._state.setState(13);
        }
        this.vs._up.newViewOK(vRIMemberDescriptionArray, viewIdImpl, map);
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            object = DCSTraceBuffer.event(this, "VSyncAlgo1.newViewOK()", "Deliver incoming queued messages");
            ((DCSTraceBuffer)object).mergePropertyList(dCSTraceBuffer);
            ((DCSTraceBuffer)object).addProperty("Incoming", "MessageQueueSize", this._inQueuedMsgs.size());
            ((DCSTraceBuffer)object).addProperty(this._state);
            ((DCSTraceBuffer)object).invoke();
        }
        if (this._state.isState(11)) {
            this._state.setState(12);
        } else {
            this._state.setState(14);
        }
        if (!this._inQueuedMsgs.isEmpty()) {
            if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
                object = DCSTraceBuffer.internalWarning(this, "There are queued incoming message in newViewOK. The messages will not be delivered", null);
                ((DCSTraceBuffer)object).invoke();
            }
            this._inQueuedMsgs.clear();
        }
        boolean bl = this._state.isState(14);
        this._state.setState(4);
        if (bl) {
            CCVersion cCVersion = this._waitCCV;
            Object[] objectArray = this._waitFailedMembers;
            this._waitCCV = null;
            this._waitFailedMembers = null;
            if (DCSTraceBuffer.isEventEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer2 = DCSTraceBuffer.event(this, "VSyncAlgo1.newViewOK()", "Doing saved complete current");
                dCSTraceBuffer2.mergePropertyList(dCSTraceBuffer);
                dCSTraceBuffer2.addProperty(cCVersion).addProperty("failedMembers", Utils.toString(objectArray));
                dCSTraceBuffer2.addProperty(this._state);
                dCSTraceBuffer2.invoke();
            }
            this.vs.completeCurrent((VRIMemberDescription[])objectArray, cCVersion);
        }
    }

    private void mcastVSMsg(VRIMessage vRIMessage, QoS qoS) throws DCSTransportLayerException, DCSInvalidParametersException {
        Object object;
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            object = DCSTraceBuffer.entry(this, "VSyncAlgo1.mcastVSMsg()", null);
            ((DCSTraceBuffer)object).addProperty("Message", vRIMessage);
            ((DCSTraceBuffer)object).addProperty(qoS);
            ((DCSTraceBuffer)object).invoke();
        }
        object = new VSNotOrigHeader(this._curViewId, this._myViewIndex, this._nextVSMsgId++, null, this, this.vs._version);
        vRIMessage.addHeader((Header)object);
        this.vs._down.mcastMessage(vRIMessage, (QoS.QOSMulticast)qoS.updateType(QoS.RELIABLE), null);
    }

    public void deliverVSmsg(VRIMessage vRIMessage, DCSTraceBuffer dCSTraceBuffer) {
        if (this._state.areInVSMsgsQueued()) {
            this._inQueuedMsgs.add(vRIMessage);
            if (DCSTraceBuffer.isEventEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer2 = DCSTraceBuffer.event(this, "VSyncAlgo1.deliver()", "Queued message");
                dCSTraceBuffer2.invoke();
            }
            this.vs.focus(VSync.IN_MSG, "deliver_save", dCSTraceBuffer);
            return;
        }
        String string = vRIMessage.getSender();
        if (!this.vs.isMemberAlive(string, dCSTraceBuffer)) {
            return;
        }
        VRIMemberDescription vRIMemberDescription = this.vs._membersMgr.getViewMember(string);
        int n = vRIMemberDescription.getIndexInView();
        VSHeader vSHeader = null;
        vSHeader = this.retreiveMsgVSHeader(vRIMessage);
        if (vSHeader == null) {
            this.vs.denyAndSuspect(vRIMemberDescription, new VSDenialReason(SuspectUnreadableMessageEvent.badHeader(this, vRIMemberDescription.getName())));
            this.vs.focus(VSync.IN_MSG, "deliver_format", dCSTraceBuffer);
            return;
        }
        ViewIdImpl viewIdImpl = vSHeader.getViewId();
        if (!this._curViewId.equals(viewIdImpl)) {
            this.vs.focus(VSync.IN_MSG, "deliver_nc_l_drop", dCSTraceBuffer);
            if (vRIMessage.getOriginatorLayer() != 2) {
                this.vs.traceNlsIgnoreMessage(string, "The View Id of the message " + viewIdImpl + " is not the current View Id " + this._curViewId);
            }
            return;
        }
        if (vRIMessage.getOriginatorLayer() != 2) {
            this.dealWithVSNotOrigMsg(vRIMessage, vSHeader, string, vRIMemberDescription, n, dCSTraceBuffer);
            return;
        }
        this.dealWithVSOrigMsg(vRIMessage, vSHeader, string, vRIMemberDescription, n, dCSTraceBuffer);
    }

    private VSHeader retreiveMsgVSHeader(VRIMessage vRIMessage) {
        VSHeader vSHeader = null;
        if (vRIMessage.getOriginatorLayer() != 2) {
            vSHeader = new VSNotOrigHeader(this, this.vs._version);
        } else if (vRIMessage.getMessageType() == 2) {
            vSHeader = new VSRcvVectorCCVHeader(this, this.vs._version);
        } else if (vRIMessage.getMessageType() == 1 || vRIMessage.getMessageType() == 4 || vRIMessage.getMessageType() == 3) {
            vSHeader = new VSRcvVectorHeader(this, this.vs._version);
        }
        if (vSHeader != null) {
            vSHeader = (VSHeader)vRIMessage.getHeader(vSHeader);
        }
        return vSHeader;
    }

    private void allSentIMS() {
        Object object;
        DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.propertyList();
        dCSTraceBuffer.addProperty(this._curCCV).addProperty(this._state);
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            object = DCSTraceBuffer.entry(this, "VSyncAlgo1.allSentIMS()", null);
            ((DCSTraceBuffer)object).mergePropertyList(dCSTraceBuffer);
            ((DCSTraceBuffer)object).invoke();
        }
        this.vs.focus(VSync.EVENT, "syncIsOver", dCSTraceBuffer);
        if (this._state.isTerminationProcess()) {
            return;
        }
        if (!this._state.isState(7)) {
            object = new VSInternalException("VSyncAlgo1.allSentIMS: Illegal state: " + this._state);
            this.vs.handleInternalError((Exception)object, false);
            return;
        }
        if (this._timeoutAlarm != null) {
            this._timeoutAlarm.cancel();
            this._timeoutAlarm = null;
        }
        this.vs.activateMessagesDisposer();
        this._md.setSyncMode(false);
        this._state.setState(8);
        this.vs.endPMI();
        object = new VSSyncCompletedEvent((DCSTraceContext)this, this._curViewId);
        ((AbstractNLSEvent)object).invokeNLSTrace();
        this.vs._up.currentOK(this._curCCV);
    }

    private void allSentISA() {
        Object object;
        DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.propertyList();
        dCSTraceBuffer.addProperty(this._curCCV).addProperty(this._state);
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            object = DCSTraceBuffer.entry(this, "VSyncAlgo1.allSentISA()", null);
            ((DCSTraceBuffer)object).mergePropertyList(dCSTraceBuffer);
            ((DCSTraceBuffer)object).invoke();
        }
        this.vs.focus(VSync.EVENT, "allSentISA", dCSTraceBuffer);
        if (this._state.isTerminationProcess()) {
            return;
        }
        if (!this._state.isState(6)) {
            object = new VSInternalException("VSyncAlgo1.allSentISA: Illegal state: " + this._state);
            this.vs.handleInternalError((Exception)object, false);
            return;
        }
        this.sendVSOriginatedMsg((byte)4);
        this._state.setState(7);
        if (DCSTraceBuffer.isExitEnabled(TC)) {
            object = DCSTraceBuffer.exit(this, "VSyncAlgo1.allSentISA()", null);
            ((DCSTraceBuffer)object).invoke();
        }
    }

    private void dealWithVSNotOrigMsg(VRIMessage vRIMessage, VSHeader vSHeader, String string, VRIMemberDescription vRIMemberDescription, int n, DCSTraceBuffer dCSTraceBuffer) {
        if (this._state.isState(7)) {
            if (DCSTraceBuffer.isExitEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer2 = DCSTraceBuffer.exit(this, "VSyncAlgo1.dealWithVSNotOrigMsg()", "Don't deal with VS NotOrig msgs, as IMS");
                dCSTraceBuffer2.invoke();
            }
            this.vs.focus(VSync.IN_MSG, "deliver_state_ims", dCSTraceBuffer);
            return;
        }
        VSNotOrigHeader vSNotOrigHeader = (VSNotOrigHeader)vSHeader;
        byte by = vSNotOrigHeader.getDelivery();
        if (by == 2) {
            vRIMessage.extractHeader(vSNotOrigHeader);
            this.vs._up.deliver(vRIMessage);
            return;
        }
        if (by == 1) {
            int n2 = vSNotOrigHeader.getMsgId();
            int n3 = vSNotOrigHeader.getOrigSender();
            if (n3 < 0 || n3 >= this._viewSize) {
                this.vs.denyAndSuspect(vRIMemberDescription, new VSDenialReason(new VSSuspectProtocolBroke((DCSTraceContext)this, vRIMemberDescription.getName(), "The index of the message original sender - " + n3 + " - is illegal ")));
                if (DCSTraceBuffer.isExitEnabled(TC)) {
                    DCSTraceBuffer dCSTraceBuffer3 = DCSTraceBuffer.exit(this, "VSyncAlgo1.dealWithVSNotOrigMsg()", "Denied sender, as original index is not legal: ");
                    dCSTraceBuffer3.addProperty("MemberViewIndex", n3);
                    dCSTraceBuffer3.invoke();
                }
                this.vs.focus(VSync.IN_MSG, "deliver_index", dCSTraceBuffer);
                return;
            }
            boolean bl = false;
            try {
                bl = this.vs._inSavedMsgs.saveVSMessage(vRIMessage, n3, n2);
            }
            catch (VSGotFutureNotConsecutiveVSMessageException vSGotFutureNotConsecutiveVSMessageException) {
                this.vs.denyAndSuspect(vRIMemberDescription, new VSDenialReason(new VSSuspectNonconsecutiveMsg(this, vRIMemberDescription.getName(), vSGotFutureNotConsecutiveVSMessageException.getCurrentNum(), vSGotFutureNotConsecutiveVSMessageException.getPreviousNum())));
                if (DCSTraceBuffer.isExitEnabled(TC)) {
                    DCSTraceBuffer dCSTraceBuffer4 = DCSTraceBuffer.exit(this, "VSyncAlgo1.dealWithVSNotOrigMsg()", "Unconsecutive message");
                    dCSTraceBuffer4.addProperty("ReasonException", vSGotFutureNotConsecutiveVSMessageException);
                    dCSTraceBuffer4.invoke();
                }
                this.vs.focus(VSync.IN_MSG, "deliver_future", dCSTraceBuffer);
                return;
            }
            if (bl) {
                Object object;
                vRIMessage.extractHeader(vSNotOrigHeader);
                if (n3 != n) {
                    object = this._curViewMembers[n3].getName();
                    vRIMessage.changeSender((String)object);
                    if (DCSTraceBuffer.isEventEnabled(TC)) {
                        DCSTraceBuffer dCSTraceBuffer5 = DCSTraceBuffer.event(this, "VSyncAlgo1.dealWithVSNotOrigMsg()", "Changed original sender");
                        dCSTraceBuffer5.addProperty("Old", "memberName", string);
                        dCSTraceBuffer5.addProperty("New", "memberName", object);
                        dCSTraceBuffer5.invoke();
                    }
                    this.vs.focus(VSync.IN_MSG, "deliver_change", dCSTraceBuffer);
                }
                ++this.vs._deliveredVSMsgsCounter;
                if (this._md.shouldSendRcvVector()) {
                    this.sendVSOriginatedMsg((byte)1);
                }
                if (DCSTraceBuffer.isExitEnabled(TC)) {
                    object = DCSTraceBuffer.exit(this, "VSyncAlgo1.dealWithVSNotOrigMsg()", "Pass VS Multicast message upwards");
                    ((DCSTraceBuffer)object).invoke();
                }
                this.vs._up.deliver(vRIMessage);
                return;
            }
            if (DCSTraceBuffer.isExitEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer6 = DCSTraceBuffer.exit(this, "VSyncAlgo1.dealWithVSNotOrigMsg()", "Drop old message");
                dCSTraceBuffer6.invoke();
            }
            this.vs.focus(VSync.IN_MSG, "deliver_old", dCSTraceBuffer);
            return;
        }
        this.vs.denyAndSuspect(vRIMemberDescription, new VSDenialReason(SuspectUnreadableMessageEvent.badMessageType(this, vRIMemberDescription.getName(), "VS Not originated delivery type", vSNotOrigHeader.getDelivery())));
        this.vs.focus(VSync.IN_MSG, "deliver_format", dCSTraceBuffer);
    }

    private void dealWithVSOrigMsg(VRIMessage vRIMessage, VSHeader vSHeader, String string, VRIMemberDescription vRIMemberDescription, int n, DCSTraceBuffer dCSTraceBuffer) {
        Object object;
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            object = DCSTraceBuffer.entry(this, "VSyncAlgo1.dealWithVSOrigMsg()", null);
            ((DCSTraceBuffer)object).addProperty("Message", vRIMessage);
            ((DCSTraceBuffer)object).addProperty("Header", vSHeader.getClass().getName());
            ((DCSTraceBuffer)object).addProperty("Sender", string);
            ((DCSTraceBuffer)object).addProperty("Sender", "MemberViewIndex", n);
            ((DCSTraceBuffer)object).invoke();
        }
        ++this.vs._inRcvVectorMsgsCounter;
        object = (VSRcvVectorHeader)vSHeader;
        int[] nArray = ((VSRcvVectorHeader)object).getLastDlvMsgs();
        try {
            if (vRIMessage.getMessageType() != 3) {
                this._viewStatus.setMatrixRow(n, nArray);
            }
            this._md.tryActivation(this._viewSize);
            if (vRIMessage.getMessageType() == 2 || vRIMessage.getMessageType() == 3) {
                Object object2;
                if (vRIMessage.getMessageType() == 2) {
                    object2 = (VSRcvVectorCCVHeader)object;
                    this._viewStatus.registerSentMcastISAMsg(n, ((VSRcvVectorCCVHeader)object2).getCcv());
                    this.vs.focus(VSync.IN_MSG, "deliver_isa_m", dCSTraceBuffer);
                } else {
                    this.vs.focus(VSync.IN_MSG, "deliver_isa_p2p", dCSTraceBuffer);
                    this._viewStatus.registerSentP2pISAMsg(n);
                }
                if (this._state.isState(6) && this._viewStatus.everybodySentISA(this._curCCV)) {
                    this.allSentISA();
                }
                if (DCSTraceBuffer.isExitEnabled(TC)) {
                    object2 = DCSTraceBuffer.exit(this, "VSyncAlgo1.dealWithVSOrigMsg()", "Handled ISA");
                    ((DCSTraceBuffer)object2).invoke();
                }
                return;
            }
            if (vRIMessage.getMessageType() == 4) {
                if (!this._viewStatus.memberSentMcastISA(n)) {
                    this.vs.denyAndSuspect(vRIMemberDescription, new VSDenialReason(new VSSuspectProtocolBroke((DCSTraceContext)this, vRIMemberDescription.getName(), "Member sent IMS before sending Mcast ISA")));
                    this.vs.focus(VSync.IN_MSG, "deliver_protocol_break", dCSTraceBuffer);
                    return;
                }
                this.vs.focus(VSync.IN_MSG, "deliver_ims", dCSTraceBuffer);
                this._viewStatus.registerSentIMSMsg(n);
                if (this._state.isState(7) && this._viewStatus.everybodySentIMS()) {
                    this.allSentIMS();
                }
                if (DCSTraceBuffer.isExitEnabled(TC)) {
                    DCSTraceBuffer dCSTraceBuffer2 = DCSTraceBuffer.exit(this, "VSyncAlgo1.dealWithVSOrigMsg()", "Handled IMS");
                    dCSTraceBuffer2.invoke();
                }
                return;
            }
            if (vRIMessage.getMessageType() == 1) {
                if (DCSTraceBuffer.isExitEnabled(TC)) {
                    DCSTraceBuffer dCSTraceBuffer3 = DCSTraceBuffer.exit(this, "VSyncAlgo1.dealWithVSOrigMsg()", "Handled RCV Vector");
                    dCSTraceBuffer3.invoke();
                }
                this.vs.focus(VSync.IN_MSG, "deliver_rcv_vector", dCSTraceBuffer);
                return;
            }
            VSDenialReason vSDenialReason = new VSDenialReason(SuspectUnreadableMessageEvent.badMessageType(this, vRIMemberDescription.getName(), "VS Originated message type", vRIMessage.getMessageType()));
            this.vs.denyAndSuspect(vRIMemberDescription, vSDenialReason);
            this.vs.focus(VSync.IN_MSG, "deliver_format", dCSTraceBuffer);
            return;
        }
        catch (VSNewRowIsIllegalException vSNewRowIsIllegalException) {
            this.vs.denyAndSuspect(vRIMemberDescription, new VSDenialReason(new VSSuspectProtocolBroke((DCSTraceContext)this, vRIMemberDescription.getName(), "Received illegal vector")));
            return;
        }
        catch (VSMemberHasVSFailedException vSMemberHasVSFailedException) {
            VSInternalException vSInternalException = new VSInternalException(vSMemberHasVSFailedException);
            this.vs.handleInternalError(vSInternalException, false);
            return;
        }
    }

    private void assertSanityOfFailedMembers(VRIMemberDescription[] vRIMemberDescriptionArray) throws VRIIllegalStateException {
        Object object;
        DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.propertyList();
        dCSTraceBuffer.addProperty("failedMembers", Utils.toString(vRIMemberDescriptionArray));
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            object = DCSTraceBuffer.entry(this, "VSyncAlgo1.assertSanityOfFailedMembers()", null);
            ((DCSTraceBuffer)object).mergePropertyList(dCSTraceBuffer);
            ((DCSTraceBuffer)object).invoke();
        }
        if (VRIMemberUtils.contains(vRIMemberDescriptionArray, this._thisMember)) {
            object = new VRIIllegalStateException(2, "VSyncAlgo1.assertSanityOfFailedMembers: this member is contained in the failed members.");
            throw object;
        }
        if (!VRIMemberUtils.contains(this._curViewMembers, vRIMemberDescriptionArray)) {
            object = new VRIIllegalStateException(2, "VSyncAlgo1.assertSanityOfFailedMembers: not all failed members are in view");
            throw object;
        }
        for (int i = 0; i < this._viewSize; ++i) {
            if (!this._viewStatus.isMemberCCFailed(i) || VRIMemberUtils.contains(vRIMemberDescriptionArray, this._curViewMembers[i])) continue;
            VRIIllegalStateException vRIIllegalStateException = new VRIIllegalStateException(2, "VSyncAlgo1.assertSanityOfFailedMembers: Member has CC failed before - " + i + " is not CC failed now");
            throw vRIIllegalStateException;
        }
        if (DCSTraceBuffer.isExitEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer2 = DCSTraceBuffer.exit(this, "VSyncAlgo1.assertSanityOfFailedMembers()", null);
            dCSTraceBuffer2.invoke();
        }
    }

    void denyAndSuspectHinderingCCMembers() {
        int[] nArray = this._viewStatus.getSyncHinderingMembers();
        if (nArray.length == 0) {
            if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.internalWarning(this, "VSync failed to determine which member to be blame for sync failure. Hence, all members are suspects", "VSyncAlgo1.denyAndSuspectHinderingCCMembers()", null);
                dCSTraceBuffer.addProperty("Timeout", this.CONFIG_TIMEOUT_SEC);
                dCSTraceBuffer.invoke();
            }
            this.vs.denyAndSuspectAllButMeAtTimeout();
            return;
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != this._myViewIndex) continue;
            if (nArray.length == 1) {
                if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
                    DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.internalWarning(this, "VSync timeout expired when the view contains only this member. This indicates heavy load on the local member. Timeout expiration is ignored.", "VSyncAlgo1.denyAndSuspectHinderingCCMembers()", null);
                    dCSTraceBuffer.addProperty("Timeout", this.CONFIG_TIMEOUT_SEC);
                    dCSTraceBuffer.invoke();
                }
            } else {
                this.vs.denyAndSuspectAllButMeAtTimeout();
            }
            return;
        }
        VRIMemberDescription[] vRIMemberDescriptionArray = new VRIMemberDescription[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            vRIMemberDescriptionArray[i] = this._curViewMembers[nArray[i]];
        }
        VSDenialReason[] vSDenialReasonArray = new VSDenialReason[vRIMemberDescriptionArray.length];
        for (int i = 0; i < vRIMemberDescriptionArray.length; ++i) {
            vSDenialReasonArray[i] = new VSDenialReason(new VSSuspectTimeout((DCSTraceContext)this, vRIMemberDescriptionArray[i].getName()));
        }
        this.vs.denyAndSuspect(vRIMemberDescriptionArray, vSDenialReasonArray);
    }

    private void sendVSOriginatedMsg(byte by) {
        Object object;
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            object = DCSTraceBuffer.entry(this, "VSyncAlgo1.sendVSOriginatedMsg()", null);
            ((DCSTraceBuffer)object).addProperty("MessageType", by);
            ((DCSTraceBuffer)object).invoke();
        }
        object = this.vs._inSavedMsgs.getLastRcvMessagesIDsStatus();
        VSRcvVectorHeader vSRcvVectorHeader = null;
        switch (by) {
            case 1: 
            case 3: 
            case 4: {
                vSRcvVectorHeader = new VSRcvVectorHeader(this._curViewId, (int[])object, this, this.vs._version);
                break;
            }
            case 2: {
                vSRcvVectorHeader = new VSRcvVectorCCVHeader(this._curViewId, (int[])object, this._curCCV, this, this.vs._version);
            }
        }
        VRIMessage vRIMessage = this.vs._msgFactory.getMessage(by, (byte)2, this._thisMember.getName());
        vRIMessage.addHeader(vSRcvVectorHeader);
        try {
            switch (by) {
                case 1: 
                case 2: 
                case 4: {
                    this.vs._down.mcastMessage(vRIMessage, this.VS_ORIG_MSG_MULTICAST_QOS, null);
                    break;
                }
                case 3: {
                    for (int i = 0; i < this._curViewMembers.length; ++i) {
                        try {
                            if (this._viewStatus.isMemberVSFailed(i)) continue;
                            VRIMessage vRIMessage2 = vRIMessage.copy(true);
                            this.vs._down.sendMessage(vRIMessage2, this._curViewMembers[i], this.VS_ORIG_MSG_UNICAST_QOS, null);
                            continue;
                        }
                        catch (DCSInvalidMemberException dCSInvalidMemberException) {
                            if (DCSTraceBuffer.isEventEnabled(TC)) {
                                DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this, "VSyncAlgo1.sendVSOriginatedMsg()", "Can not send the message to another member, failing it");
                                dCSTraceBuffer.addProperty("MemberViewIndex", i);
                                dCSTraceBuffer.invoke();
                            }
                            this._viewStatus.registerVSFailMember(i);
                        }
                    }
                    break;
                }
                default: {
                    this.vs.handleInternalError(new VSInternalException("VSyncAlgo1.sendVSOriginatedMsg: Unknown type " + by), false);
                    return;
                }
            }
        }
        catch (DCSInvalidParametersException dCSInvalidParametersException) {
            this.vs.handleInternalError(dCSInvalidParametersException, false);
            return;
        }
        catch (DCSTransportLayerException dCSTransportLayerException) {
            this.vs.handleInternalError(dCSTransportLayerException, false);
            return;
        }
    }

    private void mcastCompleteMsg(VRIMessage vRIMessage) throws DCSTransportLayerException, DCSInvalidParametersException {
        Object object;
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            object = DCSTraceBuffer.entry(this, "VSyncAlgo1.mcastCompleteMsg()", null);
            ((DCSTraceBuffer)object).addProperty("Message", vRIMessage);
            ((DCSTraceBuffer)object).invoke();
        }
        this.vs.incrementPMI();
        object = vRIMessage.copy(true);
        this.vs._down.mcastMessage((VRIMessage)object, this.VS_ORIG_MSG_MULTICAST_QOS, null);
    }

    public void alarm(Object object) {
        DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.propertyList();
        dCSTraceBuffer.addProperty("AlarmContext", object);
        dCSTraceBuffer.addProperty(this._curCCV);
        if (this._state.isTerminationProcess()) {
            return;
        }
        try {
            DCSTraceable dCSTraceable;
            if (object instanceof CCVersion && ((CCVersion)(dCSTraceable = (CCVersion)object)).equals(this._curCCV)) {
                if (DCSTraceBuffer.isEventEnabled(TC)) {
                    DCSTraceBuffer dCSTraceBuffer2 = DCSTraceBuffer.event(this, "VSyncAlgo1.alarm()", "Relevant Alarm Context");
                    dCSTraceBuffer2.mergePropertyList(dCSTraceBuffer);
                    dCSTraceBuffer2.invoke();
                }
                this.timeoutExpired();
                return;
            }
            if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
                dCSTraceable = DCSTraceBuffer.internalWarning(this, "Irrelevant VS Alarm Context", "VSyncAlgo1.alarm()", null);
                ((DCSTraceBuffer)dCSTraceable).mergePropertyList(dCSTraceBuffer);
                ((DCSTraceBuffer)dCSTraceable).invoke();
            }
            return;
        }
        catch (RuntimeException runtimeException) {
            this.vs.handleInternalError(new DCSRuntimeException(runtimeException), false);
            return;
        }
    }

    private void timeoutExpired() {
        this.vs.focus(VSync.EVENT, "timeoutExpired");
        VSSyncTimeoout vSSyncTimeoout = new VSSyncTimeoout((DCSTraceContext)this, this.CONFIG_TIMEOUT_SEC, this._viewStatus.printStatus());
        vSSyncTimeoout.invokeNLSTrace();
        this.vs.onVSTimeout();
        if (this._timeoutAlarm == null) {
            return;
        }
        this._timeoutAlarm = null;
        if (!this._state.isCokVS()) {
            VSInternalException vSInternalException = new VSInternalException("Timeout fired in state " + this._state);
            this.vs.handleInternalError(vSInternalException, false);
            return;
        }
        this.denyAndSuspectHinderingCCMembers();
    }

    public void cancelAlarm() {
        if (this._timeoutAlarm != null) {
            this._timeoutAlarm.cancel();
            this._timeoutAlarm = null;
        }
    }

    public VRICheckFailedException check() {
        Object object;
        boolean bl;
        boolean bl2 = true;
        if (this._waitFailedMembers != null && this._waitCCV == null) {
            if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.internalWarning(this, "VSyncAlgo1.check failed: wait ccv is null, while failed members not null", "VSyncAlgo1.check()", null);
                dCSTraceBuffer.invoke();
            }
            bl2 = false;
        }
        boolean bl3 = bl = this._waitCCV != null;
        if (bl != this._state.didSaveCC()) {
            if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
                object = DCSTraceBuffer.internalWarning(this, "VSyncAlgo1.check failed as saved cc is not compatible with the state", "VSyncAlgo1.check()", null);
                ((DCSTraceBuffer)object).addProperty(this._waitCCV).addProperty(this._state);
                ((DCSTraceBuffer)object).invoke();
            }
            bl2 = false;
        }
        if (this._curCCV != null != this._state.didGetCCdidntGetNV()) {
            if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
                object = DCSTraceBuffer.internalWarning(this, "VSyncAlgo1.check failed: Inconsistency between current ccv and the state", "VSyncAlgo1.check()", null);
                ((DCSTraceBuffer)object).addProperty(this._curCCV).addProperty(this._state);
                ((DCSTraceBuffer)object).invoke();
            }
            bl2 = false;
        }
        if (this._state.areInVSMsgsQueued()) {
            if (this.vs._inSavedMsgs.getSavedMsgsNumber() != 0) {
                if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
                    object = DCSTraceBuffer.internalWarning(this, "VSyncAlgo1.check failed: saved msgs while state is in vs queueing.", "VSyncAlgo1.check()", null);
                    ((DCSTraceBuffer)object).addProperty(this._state);
                    ((DCSTraceBuffer)object).addProperty("Saved", "MessageQueueSize", this.vs._inSavedMsgs.getSavedMsgsNumber());
                    ((DCSTraceBuffer)object).invoke();
                }
                bl2 = false;
            }
        } else if (this._inQueuedMsgs.size() != 0) {
            if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
                object = DCSTraceBuffer.internalWarning(this, "VSyncAlgo1.check failed: queued msgs while state is NOT vs queueing.", "VSyncAlgo1.check()", null);
                ((DCSTraceBuffer)object).addProperty(this._state);
                ((DCSTraceBuffer)object).addProperty("Saved", "MessageQueueSize", this._inQueuedMsgs.size());
                ((DCSTraceBuffer)object).invoke();
            }
            bl2 = false;
        }
        if ((this._state.isState(9) || this._state.isState(10)) && this.vs._deliveredVSMsgsCounter != 0) {
            if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
                object = DCSTraceBuffer.internalWarning(this, "VSyncAlgo1.check failed: delivered VS msgs while state is NV_DOWN*", "VSyncAlgo1.check()", null);
                ((DCSTraceBuffer)object).invoke();
            }
            bl2 = false;
        }
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            this._md.traceMemory();
        }
        bl2 = bl2 && this._viewStatus.check(this._myViewIndex, this._state, this._curCCV);
        bl2 = bl2 && this.vs._inSavedMsgs.check(this._viewStatus.getRcvByAllVector());
        object = this.vs._up.check();
        Object object2 = null;
        if (!bl2) {
            object2 = new VRICheckFailedException("VSyncAlgo1.check: FAILED");
            ((VRICheckFailedException)object2).setUpperLayerExcetion((VRICheckFailedException)object);
        } else {
            object2 = object;
        }
        return object2;
    }

    public ViewIdImpl getCurViewId() {
        return this._curViewId;
    }

    public VRIMemberDescription[] getCurViewMembers() {
        return this._curViewMembers;
    }

    public String dump() {
        if (DCSTraceBuffer.isDumpEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.dump(this, "VSyncAlgo1.dump()", "Dump VSyncAlgo1");
            dCSTraceBuffer.addProperty("Future", this._waitCCV);
            dCSTraceBuffer.addProperty("Current", this._curCCV);
            dCSTraceBuffer.addProperty("Future", "memberNames", this._waitFailedMembers);
            dCSTraceBuffer.addProperty("Incoming", "MessageQueueSize", this._inQueuedMsgs.size());
            dCSTraceBuffer.addProperty("Outgoing", "MessageQueueSize", this._outQueuedMsgs.size());
            dCSTraceBuffer.addProperty("Current", this._curViewId);
            dCSTraceBuffer.addProperty("viewSize", this._viewSize);
            dCSTraceBuffer.addProperty("Current", "viewMembers", Utils.toString(this._curViewMembers));
            dCSTraceBuffer.addProperty("Next", "VsyncMessageNumber", this._nextVSMsgId);
            dCSTraceBuffer.addProperty("My", "MemberViewIndex", this._myViewIndex);
            dCSTraceBuffer.addProperty("Alarm", this._timeoutAlarm);
            dCSTraceBuffer.addProperty("Unicast", this.VS_ORIG_MSG_UNICAST_QOS);
            dCSTraceBuffer.addProperty("Multicast", this.VS_ORIG_MSG_MULTICAST_QOS);
            return dCSTraceBuffer.toString();
        }
        return "";
    }

    public TraceComponent getTraceComponent() {
        return TC;
    }

    public String getStackName() {
        return this.vs.getStackName();
    }

    public String getMemberName() {
        return this._thisMember.getName();
    }

    public String getLayerName() {
        return DCSConstants.TRACE_LAYER_NAMES[2];
    }

    public LinkedList getOutgoingQueue() {
        return this._outQueuedMsgs;
    }
}

