/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.vri.vsync.impl2;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.dcs.common.exception.DCSRuntimeException;
import com.ibm.ws.dcs.utils.Alarm;
import com.ibm.ws.dcs.utils.AlarmListener;
import com.ibm.ws.dcs.utils.AlarmManager;
import com.ibm.ws.dcs.vri.common.CCVersion;
import com.ibm.ws.dcs.vri.common.DCSConstants;
import com.ibm.ws.dcs.vri.common.VRIMemberDescription;
import com.ibm.ws.dcs.vri.common.nls.TerminationEvent;
import com.ibm.ws.dcs.vri.common.nls.VSSuspectTimeout;
import com.ibm.ws.dcs.vri.common.nls.VSSyncTimeoout;
import com.ibm.ws.dcs.vri.common.util.DCSTraceBuffer;
import com.ibm.ws.dcs.vri.common.util.DCSTraceContext;
import com.ibm.ws.dcs.vri.vsync.VSDenialReason;
import com.ibm.ws.dcs.vri.vsync.VSInternalException;
import com.ibm.ws.dcs.vri.vsync.VSync;
import com.ibm.ws.dcs.vri.vsync.impl2.VSyncAlgo2;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

public final class VSAlarm2
implements AlarmListener,
DCSTraceContext {
    private static final int MBRRCVASSIGN = 1;
    private static final int MBRRCVMISSING = 2;
    private static final int LDRRCVSTATUS = 3;
    static final String[] TIMEOUT_TYPE_NAMES = new String[]{"NOT_DEFINED", "MEMBER_RCV_ASSIGN_TIMEOUT", "MEMBER_RCV_MISSING_TIMEOUT", "LEADER_RCV_STATUS_TIMEOUT"};
    private Alarm _memberAlarm;
    private int _type;
    private Alarm _leaderAlarm;
    private final int CONFIG_TIMEOUT_SEC;
    private Object _mutex;
    private final VSync _vs;
    private final VSyncAlgo2 _algo;
    private static TraceComponent TC = Tr.register(VSAlarm2.class, "DCS", "com.ibm.ws.dcs.common.event.nls.dcs");

    VSAlarm2(VSync vSync, VSyncAlgo2 vSyncAlgo2, int n, Object object) {
        this._vs = vSync;
        this._algo = vSyncAlgo2;
        this._leaderAlarm = null;
        this._memberAlarm = null;
        this.CONFIG_TIMEOUT_SEC = n;
        this._mutex = object;
    }

    private final void checkAlarm(int n, Alarm alarm) {
        if (alarm != null) {
            VSInternalException vSInternalException = new VSInternalException("Creating a vsync alarm of type " + TIMEOUT_TYPE_NAMES[n] + " before canceling the previous one");
            this._vs.handleInternalError(vSInternalException, false);
        }
    }

    private final Alarm create(int n, CCVersion cCVersion, int n2) {
        AlarmRec alarmRec = new AlarmRec(n, cCVersion, n2);
        return AlarmManager.create(AlarmManager.GENERAL_ALARM, n == 3 ? (long)(this.CONFIG_TIMEOUT_SEC * 1000) : (long)(this.CONFIG_TIMEOUT_SEC * 2000), this._mutex, this, alarmRec);
    }

    void createRcvAssignments(CCVersion cCVersion, int n) {
        this.checkAlarm(1, this._memberAlarm);
        this._memberAlarm = this.create(1, cCVersion, n);
        this._type = 1;
    }

    void createRcvMissing(CCVersion cCVersion, int n) {
        this.checkAlarm(2, this._memberAlarm);
        this._memberAlarm = this.create(2, cCVersion, n);
        this._type = 2;
    }

    void createRcvStatus(CCVersion cCVersion, int n) {
        this.checkAlarm(3, this._leaderAlarm);
        this._leaderAlarm = this.create(3, cCVersion, n);
    }

    private void cancelClient(int n) {
        if (this._memberAlarm != null && this._type != n) {
            VSInternalException vSInternalException = new VSInternalException("Canceling a vsync alarm of incorrect type: cancelling " + n + ", current: " + this._type);
            this._vs.handleInternalError(vSInternalException, false);
            return;
        }
        this.cancelAnyClient();
    }

    void cancelRcvAssignments() {
        this.cancelClient(1);
    }

    void cancelRcvMissing() {
        this.cancelClient(2);
    }

    void cancelRcvStatus() {
        if (this._leaderAlarm != null) {
            this._leaderAlarm.cancel();
            this._leaderAlarm = null;
        }
    }

    private void cancelAnyClient() {
        if (this._memberAlarm != null) {
            this._memberAlarm.cancel();
            this._memberAlarm = null;
        }
    }

    void cancelAny() {
        this.cancelAnyClient();
        this.cancelRcvStatus();
    }

    public void alarm(Object object) {
        Object object2;
        if (this._algo._state.isTerminationProcess()) {
            return;
        }
        DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.propertyList();
        dCSTraceBuffer.addProperty("AlarmContext", object);
        dCSTraceBuffer.addProperty(this._algo._curCCV);
        if (!(object instanceof AlarmRec)) {
            VSInternalException vSInternalException = new VSInternalException("VSAlarm.alarm(): irrelevant VS Alarm Context");
            this._vs.handleInternalError(vSInternalException, false);
            return;
        }
        AlarmRec alarmRec = (AlarmRec)object;
        this._vs.focus(VSync.EVENT, "timeoutExpired");
        VSSyncTimeoout vSSyncTimeoout = new VSSyncTimeoout((DCSTraceContext)this, this.CONFIG_TIMEOUT_SEC, this._algo._viewStatus.printStatus());
        vSSyncTimeoout.invokeNLSTrace();
        this._vs.onVSTimeout();
        if (!alarmRec.ccv.equals(this._algo._curCCV)) {
            return;
        }
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            object2 = DCSTraceBuffer.event(this, "VSync.alarm()", "Relevant Alarm Context");
            ((DCSTraceBuffer)object2).mergePropertyList(dCSTraceBuffer);
            ((DCSTraceBuffer)object2).invoke();
        }
        if (this._algo._viewSize == 1) {
            this._vs.requestTermination(new TerminationEvent((DCSTraceContext)this, "VSAlarm2.alarm()", new DCSRuntimeException("The view member does not receive self messages in a singleton view")));
            return;
        }
        if (alarmRec.type == 3) {
            this.rcvStatusExpired();
            return;
        }
        if (this._memberAlarm != null && this._type != alarmRec.type) {
            object2 = new VSInternalException("Canceling a vsync alarm of incorrect type: cancelling " + alarmRec.type + ", current: " + this._type);
            this._vs.handleInternalError((Exception)object2, false);
            return;
        }
        if (this._memberAlarm == null) {
            return;
        }
        this._memberAlarm = null;
        if (!this._algo._state.isState(alarmRec.state)) {
            object2 = DCSTraceBuffer.event(this, "Timeout fired in state " + this._algo._state, "VSync.alarm()");
            ((DCSTraceBuffer)object2).invoke();
        }
        if (alarmRec.type == 1) {
            this.rcvAssignExpired();
        } else {
            this.rcvMissingExpired();
        }
    }

    private void rcvStatusExpired() {
        Object object;
        if (!this._algo._viewStatus.hasSentStatus(this._algo._myViewIndex)) {
            this._vs.denyAndSuspectAllButMeAtTimeout();
            return;
        }
        Vector<VRIMemberDescription> vector = new Vector<VRIMemberDescription>();
        for (int i = 0; i < this._algo._viewSize; ++i) {
            if (this._algo._viewStatus.isMemberCCFailed(i) || this._algo._viewStatus.hasSentStatus(i)) continue;
            vector.add(this._algo._curViewMembers[i]);
        }
        VRIMemberDescription[] vRIMemberDescriptionArray = new VRIMemberDescription[vector.size()];
        vector.toArray(vRIMemberDescriptionArray);
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            object = DCSTraceBuffer.event(this, "VSAlarm2.rcvStatusExpired()", " suspecting " + vRIMemberDescriptionArray.length + " members as the vsync leader");
            ((DCSTraceBuffer)object).invoke();
        }
        object = new VSDenialReason[vRIMemberDescriptionArray.length];
        for (int i = 0; i < vRIMemberDescriptionArray.length; ++i) {
            object[i] = new VSDenialReason(new VSSuspectTimeout((DCSTraceContext)this, vRIMemberDescriptionArray[i].getName()));
        }
        this._vs.denyAndSuspect(vRIMemberDescriptionArray, (VSDenialReason[])object);
    }

    private void rcvAssignExpired() {
        if (this._algo._leader.isThisMember()) {
            this._vs.denyAndSuspectAllButMeAtTimeout();
            return;
        }
        VRIMemberDescription vRIMemberDescription = this._algo._curViewMembers[this._algo._leader.getLeaderIndex()];
        this._vs.denyAndSuspect(vRIMemberDescription, new VSDenialReason(new VSSuspectTimeout((DCSTraceContext)this, vRIMemberDescription.getName())));
    }

    private void rcvMissingExpired() {
        Object object;
        Object[] objectArray;
        Set set = this._algo._viewStatus.getFailedCompleters(this._vs._inSavedMsgs.getLastRcvMessagesIDsStatus());
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            objectArray = (Object[])iterator.next();
            if (objectArray.intValue() != this._algo._myViewIndex) continue;
            this._vs.denyAndSuspectAllButMeAtTimeout();
            return;
        }
        iterator = set.iterator();
        objectArray = new VRIMemberDescription[set.size()];
        VSDenialReason[] vSDenialReasonArray = new VSDenialReason[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            object = (Integer)iterator.next();
            objectArray[i] = this._algo._curViewMembers[(Integer)object];
            vSDenialReasonArray[i] = new VSDenialReason(new VSSuspectTimeout((DCSTraceContext)this, objectArray[i].getName()));
        }
        DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.propertyList();
        dCSTraceBuffer.addProperty("memberNames", objectArray);
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            object = DCSTraceBuffer.event(this, "VSAlarm2.rcvMissingExpired()", "Relevant Alarm Context");
            ((DCSTraceBuffer)object).mergePropertyList(dCSTraceBuffer);
            ((DCSTraceBuffer)object).invoke();
        }
        this._vs.denyAndSuspect((VRIMemberDescription[])objectArray, vSDenialReasonArray);
    }

    String dump() {
        if (DCSTraceBuffer.isDumpEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.dump(this, "VSyncAlgo1.dump()", "Dump VSyncAlgo1");
            dCSTraceBuffer.addProperty("Alarm", this._memberAlarm);
            return dCSTraceBuffer.toString();
        }
        return "";
    }

    public TraceComponent getTraceComponent() {
        return TC;
    }

    public String getStackName() {
        return this._vs.getStackName();
    }

    public String getMemberName() {
        return this._vs.getMemberName();
    }

    public String getLayerName() {
        return DCSConstants.TRACE_LAYER_NAMES[2];
    }

    private class AlarmRec {
        int type;
        CCVersion ccv;
        int state;

        AlarmRec(int n, CCVersion cCVersion, int n2) {
            this.type = n;
            this.ccv = cCVersion;
            this.state = n2;
        }
    }
}

