/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.vri.vsync.impl2;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.dcs.common.DCSTraceable;
import com.ibm.ws.dcs.vri.common.CCVersion;
import com.ibm.ws.dcs.vri.common.DCSConstants;
import com.ibm.ws.dcs.vri.common.SpaceEfficientIntArray;
import com.ibm.ws.dcs.vri.common.nls.VSSuspectProtocolBroke;
import com.ibm.ws.dcs.vri.common.util.DCSTraceBuffer;
import com.ibm.ws.dcs.vri.common.util.DCSTraceContext;
import com.ibm.ws.dcs.vri.vsync.VSCCVAssignmentsHeader;
import com.ibm.ws.dcs.vri.vsync.VSCCVStatusHeader;
import com.ibm.ws.dcs.vri.vsync.VSDenialReason;
import com.ibm.ws.dcs.vri.vsync.VSHeader;
import com.ibm.ws.dcs.vri.vsync.VSInternalException;
import com.ibm.ws.dcs.vri.vsync.VSMemberHasVSFailedException;
import com.ibm.ws.dcs.vri.vsync.VSNewRowIsIllegalException;
import com.ibm.ws.dcs.vri.vsync.VSync;
import com.ibm.ws.dcs.vri.vsync.impl2.VSAlarm2;
import com.ibm.ws.dcs.vri.vsync.impl2.VSyncAlgo2;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;

public final class VSLeader2
implements DCSTraceContext {
    private final VSync _vs;
    private final VSyncAlgo2 _algo;
    private final VSAlarm2 _vsAlarm;
    private final String _leaderElectionPolicy;
    private boolean _isThisMember;
    private int _leaderInd;
    private SortedMap _queuedStatusMsgs;
    private int[][] _sentUcastMsgs;
    private int[] _sentMcastMsgs;
    private static TraceComponent TC = Tr.register(VSLeader2.class, "DCS", "com.ibm.ws.dcs.common.event.nls.dcs");

    VSLeader2(VSync vSync, VSyncAlgo2 vSyncAlgo2, VSAlarm2 vSAlarm2, String string) {
        this._vs = vSync;
        this._algo = vSyncAlgo2;
        this._vsAlarm = vSAlarm2;
        this._leaderElectionPolicy = string;
        this._queuedStatusMsgs = new TreeMap();
    }

    void completeCurrent(CCVersion cCVersion, int n) {
        int n2;
        this.deleteOldStatusMsgs(cCVersion);
        if (this._isThisMember) {
            this._vsAlarm.cancelRcvStatus();
        }
        this.pickLeader(n);
        if (!this._isThisMember) {
            return;
        }
        if (this._sentUcastMsgs == null) {
            this._sentUcastMsgs = new int[this._algo._viewSize][];
            this._sentMcastMsgs = new int[this._algo._viewSize];
            for (n2 = 0; n2 < this._algo._viewSize; ++n2) {
                this._sentUcastMsgs[n2] = new int[this._algo._viewSize];
                for (int i = 0; i < this._algo._viewSize; ++i) {
                    this._sentUcastMsgs[n2][i] = 0;
                }
            }
        }
        for (n2 = 0; n2 < this._algo._viewSize; ++n2) {
            this._sentMcastMsgs[n2] = 0;
        }
        this._algo._viewStatus.initSentStatusMembers();
        this.deliverQueuedStatusMsgs(cCVersion);
        this._vsAlarm.createRcvStatus(cCVersion, this._algo._state.getState());
    }

    void newView(int n) {
        this.deleteAllStatusMsgs();
        if (this._isThisMember) {
            this._vsAlarm.cancelRcvStatus();
        }
        this._sentUcastMsgs = null;
        this._sentMcastMsgs = null;
        this.pickLeader(n);
    }

    private void pickLeader(int n) {
        if (this._leaderElectionPolicy.equals("FIRST")) {
            this._leaderInd = this._algo._viewStatus.firstCCLiveMember();
        } else if (this._leaderElectionPolicy.equals("LAST")) {
            this._leaderInd = this._algo._viewStatus.lastCCLiveMember();
        }
        this._isThisMember = this._leaderInd == n;
    }

    private void queueStatusMsg(CCVersion cCVersion, SpaceEfficientIntArray spaceEfficientIntArray, int n, int n2) {
        Vector<StatusRec> vector = (Vector<StatusRec>)this._queuedStatusMsgs.get(cCVersion);
        if (vector == null) {
            vector = new Vector<StatusRec>();
            this._queuedStatusMsgs.put(cCVersion, vector);
        }
        vector.add(new StatusRec(n2, spaceEfficientIntArray, n));
    }

    private void deliverQueuedStatusMsgs(CCVersion cCVersion) {
        Vector vector = (Vector)this._queuedStatusMsgs.remove(cCVersion);
        if (vector == null) {
            return;
        }
        for (int i = 0; i < vector.size(); ++i) {
            StatusRec statusRec = (StatusRec)vector.elementAt(i);
            this.handleStatusMsg(statusRec._lastSentUcastMsgs, statusRec._lastSentMcastMsg, statusRec._senderInd);
        }
    }

    private void deleteOldStatusMsgs(CCVersion cCVersion) {
        this._queuedStatusMsgs.headMap(cCVersion).clear();
    }

    private void deleteAllStatusMsgs() {
        this._queuedStatusMsgs.clear();
    }

    void deliverStatusMsg(VSCCVStatusHeader vSCCVStatusHeader, int n) {
        DCSTraceable dCSTraceable;
        DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.propertyList();
        dCSTraceBuffer.addProperty(this._algo._curCCV).addProperty(this._algo._state).addProperty("VsyncStatusUcastVector", vSCCVStatusHeader.getLastSentUcastMsgs()).addProperty("VsyncStatusMcastVector", vSCCVStatusHeader.getLastDlvMsgs()).addProperty("Sender", this._algo._curViewMembers[n].getName());
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            dCSTraceable = DCSTraceBuffer.entry(this, "VSLeader2.deliverStatusMsg()", null);
            ((DCSTraceBuffer)dCSTraceable).mergePropertyList(dCSTraceBuffer);
            ((DCSTraceBuffer)dCSTraceable).invoke();
        }
        this._vs.focus(VSync.EVENT, "deliverStatusMsg", dCSTraceBuffer);
        if (this._algo._state.isTerminationProcess()) {
            return;
        }
        dCSTraceable = vSCCVStatusHeader.getCcv();
        if (this._algo._curCCV != null && ((CCVersion)dCSTraceable).compareTo(this._algo._curCCV) < 0) {
            if (DCSTraceBuffer.isExitEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer2 = DCSTraceBuffer.exit(this, "VSLeader2.handleStatusMsg()", null);
                dCSTraceBuffer2.invoke();
            }
            return;
        }
        if (((CCVersion)dCSTraceable).equals(this._algo._curCCV)) {
            this.handleStatusMsg(vSCCVStatusHeader.getLastSentUcastMsgs(), vSCCVStatusHeader.getLastSentMcastMsg(), n);
        } else {
            this.queueStatusMsg((CCVersion)dCSTraceable, vSCCVStatusHeader.getLastSentUcastMsgs(), vSCCVStatusHeader.getLastSentMcastMsg(), n);
        }
        if (DCSTraceBuffer.isExitEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer3 = DCSTraceBuffer.exit(this, "VSLeader2.deliverStatusMsg()", null);
            dCSTraceBuffer3.invoke();
        }
    }

    private void handleStatusMsg(SpaceEfficientIntArray spaceEfficientIntArray, int n, int n2) {
        if (!this._algo._viewStatus.isMemberVSFailed(n2) && this._algo._viewStatus.hasSentStatus(n2) || !this._isThisMember) {
            this._vs.denyAndSuspect(this._algo._curViewMembers[n2], new VSDenialReason(new VSSuspectProtocolBroke((DCSTraceContext)this, this._algo._curViewMembers[n2].getName(), "received an unexpected status message")));
            return;
        }
        try {
            this._algo._viewStatus.registerSentStatus(n2);
        }
        catch (VSMemberHasVSFailedException vSMemberHasVSFailedException) {
            VSInternalException vSInternalException = new VSInternalException(vSMemberHasVSFailedException);
            this._vs.handleInternalError(vSInternalException, false);
            return;
        }
        try {
            this.setMatrixRow(n2, spaceEfficientIntArray);
        }
        catch (VSNewRowIsIllegalException vSNewRowIsIllegalException) {
            VSInternalException vSInternalException = new VSInternalException(vSNewRowIsIllegalException);
            this._vs.handleInternalError(vSInternalException, false);
            return;
        }
        this._sentMcastMsgs[n2] = n;
        if (this._algo._viewStatus.everybodySentStatus()) {
            this.handleAllSentStatus();
        }
    }

    private void setMatrixRow(int n, SpaceEfficientIntArray spaceEfficientIntArray) throws VSNewRowIsIllegalException {
        if (!spaceEfficientIntArray.isGreaterThanOrEqual(this._sentUcastMsgs[n])) {
            VSNewRowIsIllegalException vSNewRowIsIllegalException = new VSNewRowIsIllegalException(this._sentUcastMsgs[n], this._sentUcastMsgs[n]);
            throw vSNewRowIsIllegalException;
        }
        this._sentUcastMsgs[n] = spaceEfficientIntArray.fillOrReplace(this._sentUcastMsgs[n]);
    }

    private void handleAllSentStatus() {
        int n;
        Object object;
        DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.propertyList();
        dCSTraceBuffer.addProperty(this._algo._curCCV).addProperty(this._algo._state);
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            object = DCSTraceBuffer.entry(this, "VSLeader2.handleAllSentStatus()", null);
            ((DCSTraceBuffer)object).mergePropertyList(dCSTraceBuffer);
            ((DCSTraceBuffer)object).invoke();
        }
        this._vs.focus(VSync.EVENT, "handleAllSentStatus " + this._algo._viewStatus.printStatus(), dCSTraceBuffer);
        if (!this._algo._state.isState(6) && !this._algo._state.isState(8)) {
            object = new VSInternalException("VSLeader2.handleAllSentStatus(): Illegal state: " + this._algo._state);
            this._vs.handleInternalError((Exception)object, false);
            return;
        }
        this._vsAlarm.cancelRcvStatus();
        object = this._algo._viewStatus.getMaxCCMembersVector();
        for (int i = 0; i < this._algo._viewSize; ++i) {
            if (this._sentMcastMsgs[i] == 0) continue;
            object[i] = this._sentMcastMsgs[i];
        }
        int[] nArray = new int[this._algo._viewSize];
        int n2 = -1;
        for (n = 0; n < this._algo._viewSize; ++n) {
            if (!this._algo._viewStatus.isMemberCCFailed(n) || this._algo._viewStatus.allReached(n, (int)object[n])) {
                nArray[n] = -1;
                continue;
            }
            n2 = nArray[n] = this._algo._viewStatus.findMostAdvancedStartingFrom(n, (int)object[n], n2);
        }
        for (n = 0; n < this._algo._viewSize; ++n) {
            Object object2;
            Object[] objectArray;
            if (this._algo._viewStatus.isMemberVSFailed(n)) continue;
            int[] nArray2 = new int[this._algo._viewSize];
            Vector<VSCCVAssignmentsHeader.CompleterRec> vector = new Vector<VSCCVAssignmentsHeader.CompleterRec>();
            Vector<VSCCVAssignmentsHeader.AssignmentRec> vector2 = new Vector<VSCCVAssignmentsHeader.AssignmentRec>();
            for (int i = 0; i < this._algo._viewSize; ++i) {
                nArray2[i] = this._sentUcastMsgs[i][n];
                if (nArray[i] != -1 && !this._algo._viewStatus.reached(n, i, (int)object[i])) {
                    vector.add(new VSCCVAssignmentsHeader.CompleterRec(i, nArray[i]));
                }
                if (nArray[i] != n) continue;
                objectArray = this._algo._viewStatus.getRcvMsgs(i);
                vector2.add(new VSCCVAssignmentsHeader.AssignmentRec(i, new SpaceEfficientIntArray((int[])objectArray, 4)));
            }
            Object[] objectArray2 = new VSCCVAssignmentsHeader.CompleterRec[vector.size()];
            vector.toArray(objectArray2);
            objectArray = new VSCCVAssignmentsHeader.AssignmentRec[vector2.size()];
            vector2.toArray(objectArray);
            if (DCSTraceBuffer.isEventEnabled(TC)) {
                object2 = DCSTraceBuffer.event(this, "VSLeader.handleAllSentStatus", "Sending an assignment msg");
                ((DCSTraceBuffer)object2).addProperty("VsyncAssignMcastVector", (int[])object).addProperty("VsyncAssignUcastVector", nArray2).addProperty("VsyncCompletersVector", objectArray2).addProperty("VsyncAssignmentsVector", objectArray);
                ((DCSTraceBuffer)object2).invoke();
            }
            object2 = new VSCCVAssignmentsHeader(this._algo._curViewId, (int[])object, new SpaceEfficientIntArray(nArray2), this._algo._curCCV, (VSCCVAssignmentsHeader.CompleterRec[])objectArray2, (VSCCVAssignmentsHeader.AssignmentRec[])objectArray, this, this._vs._version);
            this._algo.sendVSOriginatedMsg((byte)3, (VSHeader)object2, n);
        }
        if (DCSTraceBuffer.isExitEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer2 = DCSTraceBuffer.exit(this, "VSLeader2.handleAllSentStatus()", null);
            dCSTraceBuffer2.invoke();
        }
    }

    boolean isThisMember() {
        return this._isThisMember;
    }

    boolean isLeaderIndex(int n) {
        return this._leaderInd == n;
    }

    int getLeaderIndex() {
        return this._leaderInd;
    }

    public TraceComponent getTraceComponent() {
        return TC;
    }

    public String getStackName() {
        return this._vs.getStackName();
    }

    public String getMemberName() {
        return this._algo.getMemberName();
    }

    public String getLayerName() {
        return DCSConstants.TRACE_LAYER_NAMES[2];
    }

    private class StatusRec {
        int _senderInd;
        SpaceEfficientIntArray _lastSentUcastMsgs;
        int _lastSentMcastMsg;

        StatusRec(int n, SpaceEfficientIntArray spaceEfficientIntArray, int n2) {
            this._senderInd = n;
            this._lastSentUcastMsgs = spaceEfficientIntArray;
            this._lastSentMcastMsg = n2;
        }
    }
}

