/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.vri.vsync.impl2;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.dcs.vri.common.CCVersion;
import com.ibm.ws.dcs.vri.common.DCSConstants;
import com.ibm.ws.dcs.vri.common.SpaceEfficientIntArray;
import com.ibm.ws.dcs.vri.common.util.DCSTraceBuffer;
import com.ibm.ws.dcs.vri.common.util.DCSTraceContext;
import com.ibm.ws.dcs.vri.vsync.VSCCVAssignmentsHeader;
import com.ibm.ws.dcs.vri.vsync.VSMemberHasVSFailedException;
import com.ibm.ws.dcs.vri.vsync.VSNewRowIsIllegalException;
import com.ibm.ws.dcs.vri.vsync.VSViewStatus;
import com.ibm.ws.dcs.vri.vsync.impl2.VSState2;
import java.util.HashSet;
import java.util.Set;

public final class VSViewStatus2
implements VSViewStatus,
DCSTraceContext {
    private static TraceComponent TC = Tr.register(VSViewStatus2.class, "DCS", "com.ibm.ws.dcs.common.event.nls.dcs");
    private int[][] _viewRcvMessagesMatrix;
    private int[] _rcvedUcastMsgs;
    private boolean[] _vsLiveMembers;
    private boolean[] _ccLiveMembers;
    private boolean[] _sentStatusMembers;
    private int _firstIndWoStatus;
    private int[] _sentUcast;
    private int _sentMcast;
    private int[] _mcastMax;
    private int[] _ucastMax;
    private int[] _completers;
    private int _firstUnreachedInd;
    private int _viewSize;
    private final String _thisStackName;
    private final String _thisMemberName;

    public VSViewStatus2(String string, String string2) {
        DCSTraceBuffer dCSTraceBuffer;
        this._thisStackName = string;
        this._thisMemberName = string2;
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            dCSTraceBuffer = DCSTraceBuffer.entry(this, "VSViewStatus.VSViewStatus()", null);
            dCSTraceBuffer.invoke();
        }
        this.newView(1);
        if (DCSTraceBuffer.isExitEnabled(TC)) {
            dCSTraceBuffer = DCSTraceBuffer.exit(this, "VSViewStatus.VSViewStatus()", null);
            dCSTraceBuffer.invoke();
        }
    }

    public void newView(int n) {
        int n2;
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.entry(this, "VSViewStatus.newView()", null);
            dCSTraceBuffer.addProperty("viewSize", n);
            dCSTraceBuffer.invoke();
        }
        this._viewSize = n;
        this._viewRcvMessagesMatrix = new int[this._viewSize][];
        for (n2 = 0; n2 < this._viewSize; ++n2) {
            this._viewRcvMessagesMatrix[n2] = new int[this._viewSize];
            for (int i = 0; i < this._viewSize; ++i) {
                this._viewRcvMessagesMatrix[n2][i] = 0;
            }
        }
        this._rcvedUcastMsgs = new int[this._viewSize];
        this._vsLiveMembers = new boolean[this._viewSize];
        this._ccLiveMembers = new boolean[this._viewSize];
        this._sentUcast = new int[this._viewSize];
        this._sentMcast = 0;
        this._completers = null;
        this._ucastMax = null;
        this._mcastMax = null;
        this._firstUnreachedInd = 0;
        for (n2 = 0; n2 < this._viewSize; ++n2) {
            this._vsLiveMembers[n2] = true;
            this._ccLiveMembers[n2] = true;
            this._sentUcast[n2] = 0;
            this._rcvedUcastMsgs[n2] = 0;
        }
        if (DCSTraceBuffer.isExitEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.exit(this, "VSViewStatus.newView()", null);
            dCSTraceBuffer.invoke();
        }
    }

    void initSentStatusMembers() {
        this._sentStatusMembers = new boolean[this._viewSize];
        for (int i = 0; i < this._viewSize; ++i) {
            this._sentStatusMembers[i] = false;
        }
        this._firstIndWoStatus = 0;
    }

    void setMatrixRow(int n, int[] nArray) throws VSNewRowIsIllegalException, VSMemberHasVSFailedException {
        Object object;
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            object = DCSTraceBuffer.entry(this, "VSViewStatus.setMatrixRow()", null);
            ((DCSTraceBuffer)object).addProperty("MemberViewIndex", n);
            ((DCSTraceBuffer)object).addProperty("VsyncRcvVector", nArray);
            ((DCSTraceBuffer)object).invoke();
        }
        if (nArray == null || nArray.length != this._viewSize) {
            object = new VSNewRowIsIllegalException(this._viewRcvMessagesMatrix[n], nArray);
            throw object;
        }
        if (!this._vsLiveMembers[n]) {
            object = new VSMemberHasVSFailedException();
            throw object;
        }
        if (!SpaceEfficientIntArray.isFirstVectorGreaterOrEqual(nArray, this._viewRcvMessagesMatrix[n])) {
            object = new VSNewRowIsIllegalException(this._viewRcvMessagesMatrix[n], nArray);
            throw object;
        }
        for (int i = 0; i < this._viewSize; ++i) {
            this._viewRcvMessagesMatrix[n][i] = nArray[i];
        }
        if (DCSTraceBuffer.isExitEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.exit(this, "VSViewStatus.setMatrixRow()", null);
            dCSTraceBuffer.invoke();
        }
    }

    void incrementSentMcast(int n) {
        ++this._sentMcast;
    }

    int getSentMcast() {
        return this._sentMcast;
    }

    void incrementSentUcast(int n) {
        int n2 = n;
        this._sentUcast[n2] = this._sentUcast[n2] + 1;
    }

    int[] getSentUcast() {
        return this._sentUcast;
    }

    void incrementRcvedUcast(int n) {
        int n2 = n;
        this._rcvedUcastMsgs[n2] = this._rcvedUcastMsgs[n2] + 1;
    }

    void registerViewMax(int[] nArray, int[] nArray2) {
        this._mcastMax = nArray;
        this._ucastMax = nArray2;
    }

    public int[] getRcvByAllVector() {
        Object object;
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            object = DCSTraceBuffer.entry(this, "VSViewStatus.getRcvByAllVector()", null);
            ((DCSTraceBuffer)object).invoke();
        }
        object = new int[this._viewSize];
        boolean bl = false;
        for (int i = 0; i < this._viewSize; ++i) {
            int n;
            if (!this._vsLiveMembers[i]) continue;
            if (!bl) {
                for (n = 0; n < this._viewSize; ++n) {
                    object[n] = this._viewRcvMessagesMatrix[i][n];
                }
                bl = true;
                continue;
            }
            for (n = 0; n < this._viewSize; ++n) {
                if (object[n] - this._viewRcvMessagesMatrix[i][n] <= 0) continue;
                object[n] = this._viewRcvMessagesMatrix[i][n];
            }
        }
        if (DCSTraceBuffer.isExitEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.exit(this, "VSViewStatus.getRcvByAllVector()", null);
            dCSTraceBuffer.addProperty("VsyncRBAVector", (int[])object);
            dCSTraceBuffer.invoke();
        }
        return object;
    }

    public boolean allReached(int n, int n2) {
        boolean bl = true;
        for (int i = 0; i < this._viewSize; ++i) {
            if (!this._vsLiveMembers[i] || this._viewRcvMessagesMatrix[i][n] >= n2) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public int findMostAdvancedStartingFrom(int n, int n2, int n3) {
        int n4;
        for (n4 = n3 + 1; n4 < this._viewSize; ++n4) {
            if (!this._vsLiveMembers[n4] || this._viewRcvMessagesMatrix[n4][n] < n2) continue;
            return n4;
        }
        for (n4 = 0; n4 <= n3; ++n4) {
            if (!this._vsLiveMembers[n4] || this._viewRcvMessagesMatrix[n4][n] < n2) continue;
            return n4;
        }
        return -1;
    }

    public boolean reached(int n, int n2, int n3) {
        return this._viewRcvMessagesMatrix[n][n2] >= n3;
    }

    public int[] getRcvMsgs(int n) {
        int[] nArray = new int[this._viewSize];
        for (int i = 0; i < this._viewSize; ++i) {
            nArray[i] = this._viewRcvMessagesMatrix[i][n];
        }
        return nArray;
    }

    public void registerVSFailMember(int n) {
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.entry(this, "VSViewStatus.registerVSFailMember()", null);
            dCSTraceBuffer.addProperty("MemberViewIndex", n);
            dCSTraceBuffer.invoke();
        }
        this._vsLiveMembers[n] = false;
    }

    void registerCCFailMember(int n) {
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.entry(this, "VSViewStatus.registerCCFailMember()", null);
            dCSTraceBuffer.addProperty("MemberViewIndex", n);
            dCSTraceBuffer.invoke();
        }
        this._ccLiveMembers[n] = false;
        this._vsLiveMembers[n] = false;
    }

    public boolean isMemberVSFailed(int n) {
        return !this._vsLiveMembers[n];
    }

    boolean isMemberCCFailed(int n) {
        return !this._ccLiveMembers[n];
    }

    int lastCCLiveMember() {
        for (int i = this._viewSize - 1; i >= 0; --i) {
            if (!this._ccLiveMembers[i]) continue;
            return i;
        }
        return -1;
    }

    int firstCCLiveMember() {
        for (int i = 0; i < this._viewSize; ++i) {
            if (!this._ccLiveMembers[i]) continue;
            return i;
        }
        return -1;
    }

    void registerSentStatus(int n) throws VSMemberHasVSFailedException {
        if (!this._ccLiveMembers[n]) {
            VSMemberHasVSFailedException vSMemberHasVSFailedException = new VSMemberHasVSFailedException();
            throw vSMemberHasVSFailedException;
        }
        this._sentStatusMembers[n] = true;
    }

    boolean hasSentStatus(int n) {
        return this._sentStatusMembers[n];
    }

    void registerCompleters(VSCCVAssignmentsHeader.CompleterRec[] completerRecArray) {
        int n;
        this._completers = new int[this._viewSize];
        for (n = 0; n < this._viewSize; ++n) {
            this._completers[n] = -1;
        }
        for (n = 0; n < completerRecArray.length; ++n) {
            this._completers[completerRecArray[n]._failedMember] = completerRecArray[n]._completer;
        }
    }

    boolean everybodySentStatus() {
        boolean bl = true;
        for (int i = this._firstIndWoStatus; i < this._viewSize; ++i) {
            if (!this._ccLiveMembers[i] || this._sentStatusMembers[i]) continue;
            this._firstIndWoStatus = i;
            bl = false;
            break;
        }
        return bl;
    }

    public String dump() {
        if (DCSTraceBuffer.isDumpEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.dump(this, "VSViewStatus.dump()", "Dump VSViewStatus");
            dCSTraceBuffer.addProperty("VsyncViewStatus", this.printStatus());
            return dCSTraceBuffer.toString();
        }
        return "";
    }

    boolean areRowsEqual(int[] nArray, int[] nArray2) {
        if (nArray == null && nArray2 == null) {
            return true;
        }
        if (nArray == null || nArray2 == null) {
            return false;
        }
        if (nArray.length != nArray2.length) {
            return false;
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == nArray2[i]) continue;
            return false;
        }
        return true;
    }

    boolean areAllMsgsRcved(int[] nArray) {
        boolean bl = true;
        for (int i = this._firstUnreachedInd; i < this._viewSize; ++i) {
            if (this._mcastMax[i] == nArray[i] && (!this._ccLiveMembers[i] || this._ucastMax[i] == this._rcvedUcastMsgs[i])) continue;
            this._firstUnreachedInd = i;
            bl = false;
            break;
        }
        return bl;
    }

    Set getFailedCompleters(int[] nArray) {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (int i = this._firstUnreachedInd; i < this._viewSize; ++i) {
            if (this._ccLiveMembers[i] && this._ucastMax[i] != this._rcvedUcastMsgs[i]) {
                hashSet.add(new Integer(i));
            }
            if (this._mcastMax[i] == nArray[i]) continue;
            if (this._ccLiveMembers[i]) {
                hashSet.add(new Integer(i));
                continue;
            }
            hashSet.add(new Integer(this._completers[i]));
        }
        return hashSet;
    }

    String printStatus() {
        int n;
        int n2;
        if (this._viewSize > 10) {
            return "Not printing detailed view status info for a large view";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("View Status information\n");
        this.printEntry(stringBuffer, "MemberID", false);
        for (n2 = 0; n2 < this._viewSize; ++n2) {
            this.printEntry(stringBuffer, "From " + Integer.toString(n2), false);
        }
        this.printEntry(stringBuffer, "VS Live", false);
        this.printEntry(stringBuffer, "CC Live", false);
        stringBuffer.append("\n");
        for (n2 = 0; n2 < this._viewSize; ++n2) {
            this.printEntry(stringBuffer, Integer.toString(n2), false);
            for (n = 0; n < this._viewSize; ++n) {
                this.printEntry(stringBuffer, Integer.toString(this._viewRcvMessagesMatrix[n2][n]), false);
            }
            this.printEntry(stringBuffer, "" + this._vsLiveMembers[n2], false);
            this.printEntry(stringBuffer, "" + this._ccLiveMembers[n2], false);
            stringBuffer.append("\n");
        }
        this.printEntry(stringBuffer, "RBA vs live", false);
        int[] nArray = this.getRcvByAllVector();
        for (n = 0; n < this._viewSize; ++n) {
            this.printEntry(stringBuffer, Integer.toString(nArray[n]), false);
        }
        return stringBuffer.toString();
    }

    private void printEntry(StringBuffer stringBuffer, String string, boolean bl) {
        int n = 12;
        int n2 = 20;
        stringBuffer.append(string);
        int n3 = bl ? n2 : n;
        for (int i = 0; i < n3 - string.length(); ++i) {
            stringBuffer.append(" ");
        }
    }

    String printIntRow(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < nArray.length; ++i) {
            stringBuffer.append(nArray[i]);
            stringBuffer.append(".");
        }
        return stringBuffer.toString();
    }

    boolean check(int n, VSState2 vSState2, CCVersion cCVersion) {
        DCSTraceBuffer dCSTraceBuffer;
        boolean bl = true;
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            dCSTraceBuffer = DCSTraceBuffer.entry(this, "VSViewStatus.check()", null);
            dCSTraceBuffer.addProperty("My", "MemberViewIndex", n);
            dCSTraceBuffer.addProperty(vSState2);
            dCSTraceBuffer.addProperty(cCVersion);
            dCSTraceBuffer.invoke();
        }
        if (this._ccLiveMembers.length != this._viewSize || this._rcvedUcastMsgs.length != this._viewSize || this._sentUcast.length != this._viewSize || this._viewRcvMessagesMatrix.length != this._viewSize || this._vsLiveMembers.length != this._viewSize) {
            if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
                dCSTraceBuffer = DCSTraceBuffer.internalWarning(this, "Found data structure with length not compatible with view size", "VSViewStatus.check()", null);
                dCSTraceBuffer.addProperty("viewSize", this._viewSize);
                dCSTraceBuffer.addProperty("_ccLiveMembers.length", this._ccLiveMembers.length);
                dCSTraceBuffer.addProperty("_viewRcvMessagesMatrix.length", this._viewRcvMessagesMatrix.length);
                dCSTraceBuffer.addProperty("_vsLiveMembers.length", this._vsLiveMembers.length);
                dCSTraceBuffer.invoke();
            }
            bl = false;
        }
        if (!this._ccLiveMembers[n]) {
            if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
                dCSTraceBuffer = DCSTraceBuffer.internalWarning(this, "My member is CC failed", "VSViewStatus.check()", null);
                dCSTraceBuffer.invoke();
            }
            bl = false;
        }
        if (!this._vsLiveMembers[n]) {
            if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
                dCSTraceBuffer = DCSTraceBuffer.internalWarning(this, "My member is VS failed", "VSViewStatus.check()", null);
                dCSTraceBuffer.invoke();
            }
            bl = false;
        }
        for (int i = 0; i < this._viewSize; ++i) {
            if (this._ccLiveMembers[i] || !this._vsLiveMembers[i]) continue;
            if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer2 = DCSTraceBuffer.internalWarning(this, "Found cc failed member that is VS live", "VSViewStatus.check()", null);
                dCSTraceBuffer2.addProperty("MemberViewIndex", i);
                dCSTraceBuffer2.invoke();
            }
            bl = false;
        }
        if (!bl) {
            this.dump();
        }
        if (DCSTraceBuffer.isExitEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer3 = DCSTraceBuffer.exit(this, "VSViewStatus.check()", null);
            dCSTraceBuffer3.addProperty("MethodResult", bl);
            dCSTraceBuffer3.invoke();
        }
        return bl;
    }

    int[] getMaxCCMembersVector() {
        boolean bl = false;
        int[] nArray = new int[this._viewSize];
        for (int i = 0; i < this._viewSize; ++i) {
            int n;
            if (!this._ccLiveMembers[i]) continue;
            if (!bl) {
                for (n = 0; n < this._viewSize; ++n) {
                    nArray[n] = this._viewRcvMessagesMatrix[i][n];
                }
                bl = true;
                continue;
            }
            for (n = 0; n < this._viewSize; ++n) {
                if (this._viewRcvMessagesMatrix[i][n] - nArray[n] <= 0) continue;
                nArray[n] = this._viewRcvMessagesMatrix[i][n];
            }
        }
        return nArray;
    }

    public TraceComponent getTraceComponent() {
        return TC;
    }

    public String getStackName() {
        return this._thisStackName;
    }

    public String getMemberName() {
        return this._thisMemberName;
    }

    public String getLayerName() {
        return DCSConstants.TRACE_LAYER_NAMES[2];
    }
}

