/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.vri.vsync.impl2;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.dcs.common.QoS;
import com.ibm.ws.dcs.common.exception.DCSIllegalParameterException;
import com.ibm.ws.dcs.common.exception.DCSInvalidMemberException;
import com.ibm.ws.dcs.common.exception.DCSInvalidParametersException;
import com.ibm.ws.dcs.common.exception.DCSInvalidQoSException;
import com.ibm.ws.dcs.common.exception.DCSInvalidViewIDException;
import com.ibm.ws.dcs.common.exception.DCSMemberIsDeniedException;
import com.ibm.ws.dcs.common.exception.DCSMemberIsNotInViewException;
import com.ibm.ws.dcs.common.exception.DCSTransportLayerException;
import com.ibm.ws.dcs.common.exception.DCSUnsupportedQoSException;
import com.ibm.ws.dcs.vri.common.CCVersion;
import com.ibm.ws.dcs.vri.common.DCSConstants;
import com.ibm.ws.dcs.vri.common.Globals;
import com.ibm.ws.dcs.vri.common.SpaceEfficientIntArray;
import com.ibm.ws.dcs.vri.common.Utils;
import com.ibm.ws.dcs.vri.common.VRICheckFailedException;
import com.ibm.ws.dcs.vri.common.VRIIllegalStateException;
import com.ibm.ws.dcs.vri.common.VRIMemberDescription;
import com.ibm.ws.dcs.vri.common.VRIMemberUtils;
import com.ibm.ws.dcs.vri.common.VRIMessage;
import com.ibm.ws.dcs.vri.common.ViewIdImpl;
import com.ibm.ws.dcs.vri.common.nls.SuspectUnreadableMessageEvent;
import com.ibm.ws.dcs.vri.common.nls.VSSuspectNonconsecutiveMsg;
import com.ibm.ws.dcs.vri.common.nls.VSSuspectProtocolBroke;
import com.ibm.ws.dcs.vri.common.nls.VSSyncCompletedEvent;
import com.ibm.ws.dcs.vri.common.util.DCSTraceBuffer;
import com.ibm.ws.dcs.vri.common.util.DCSTraceContext;
import com.ibm.ws.dcs.vri.vsync.VSCCVAssignmentsHeader;
import com.ibm.ws.dcs.vri.vsync.VSCCVStatusHeader;
import com.ibm.ws.dcs.vri.vsync.VSDenialReason;
import com.ibm.ws.dcs.vri.vsync.VSGotFutureNotConsecutiveVSMessageException;
import com.ibm.ws.dcs.vri.vsync.VSHeader;
import com.ibm.ws.dcs.vri.vsync.VSInternalException;
import com.ibm.ws.dcs.vri.vsync.VSMemberHasVSFailedException;
import com.ibm.ws.dcs.vri.vsync.VSNewRowIsIllegalException;
import com.ibm.ws.dcs.vri.vsync.VSNotOrigHeader;
import com.ibm.ws.dcs.vri.vsync.VSRcvVectorHeader;
import com.ibm.ws.dcs.vri.vsync.VSRequestedMessagesHaveBeenDeletedException;
import com.ibm.ws.dcs.vri.vsync.VSync;
import com.ibm.ws.dcs.vri.vsync.VSyncAlgo;
import com.ibm.ws.dcs.vri.vsync.impl2.MessageDisposal2;
import com.ibm.ws.dcs.vri.vsync.impl2.VSAlarm2;
import com.ibm.ws.dcs.vri.vsync.impl2.VSLeader2;
import com.ibm.ws.dcs.vri.vsync.impl2.VSState2;
import com.ibm.ws.dcs.vri.vsync.impl2.VSViewStatus2;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.Vector;

public final class VSyncAlgo2
implements VSyncAlgo,
DCSTraceContext {
    public static final int VERSION = 0x2000000;
    private final VSync vs;
    final VSState2 _state;
    final VSViewStatus2 _viewStatus;
    private VRIMemberDescription _thisMember;
    final VSLeader2 _leader;
    CCVersion _curCCV;
    ViewIdImpl _curViewId;
    VRIMemberDescription[] _curViewMembers;
    int _viewSize;
    private int _nextVSMsgId;
    int _myViewIndex;
    private CCVersion _waitCCV;
    private VRIMemberDescription[] _waitFailedMembers;
    private LinkedList _inQueuedMsgs;
    private LinkedList _outQueuedMsgs;
    private static final byte MEMBER_RCV_VECTOR_MSG = 1;
    private static final byte CC_STATUS_MSG = 2;
    static final byte CC_ASSIGNMENT_MSG = 3;
    static final String[] VS_ORIG_MSGS_NAMES = new String[]{"NOT_DEFINED", "MEMBER_RCV_VECTOR_MSG", "CC_STATUS_MSG", "CC_ASSIGNMENTS_MSG"};
    final QoS.QOSUnicast VS_ORIG_MSG_UNICAST_QOS;
    private final QoS.QOSMulticast VS_ORIG_MSG_MULTICAST_QOS;
    MessageDisposal2 _md;
    private final VSAlarm2 _vsAlarm;
    private static TraceComponent TC = Tr.register(VSyncAlgo2.class, "DCS", "com.ibm.ws.dcs.common.event.nls.dcs");

    public VSyncAlgo2(VSync vSync, VSState2 vSState2, VSViewStatus2 vSViewStatus2, VRIMemberDescription vRIMemberDescription, Globals globals) {
        this.vs = vSync;
        this._state = vSState2;
        this._viewStatus = vSViewStatus2;
        this._thisMember = vRIMemberDescription;
        this._waitCCV = null;
        this._outQueuedMsgs = new LinkedList();
        this._inQueuedMsgs = new LinkedList();
        try {
            this.VS_ORIG_MSG_UNICAST_QOS = QoS.getUnicastQoS(QoS.RELIABLE, QoS.FIFO);
            this.VS_ORIG_MSG_MULTICAST_QOS = QoS.getMulticastQoS(QoS.RELIABLE, QoS.FIFO);
        }
        catch (DCSUnsupportedQoSException dCSUnsupportedQoSException) {
            throw new DCSIllegalParameterException("VSyncAlgo2.VSyncAlgo2(): VS qos is not supported: " + dCSUnsupportedQoSException);
        }
        this._md = new MessageDisposal2(vSync, globals);
        this._vsAlarm = new VSAlarm2(vSync, this, globals.getConfigParamAsInt("VS_CC_TIMEOUT_SEC"), globals.getMutex());
        this._leader = new VSLeader2(vSync, this, this._vsAlarm, globals.getConfigParamAsString("VSLeaderPolicy"));
    }

    public void initViewScopedVariables(VRIMemberDescription[] vRIMemberDescriptionArray, ViewIdImpl viewIdImpl, int n) {
        this._curViewId = viewIdImpl;
        this._viewSize = vRIMemberDescriptionArray.length;
        this._curViewMembers = new VRIMemberDescription[this._viewSize];
        System.arraycopy(vRIMemberDescriptionArray, 0, this._curViewMembers, 0, this._viewSize);
        this._myViewIndex = n;
        this._nextVSMsgId = 1;
        this._curCCV = null;
        this._md.initViewScopedVariables();
    }

    public String completeCurrent(VRIMemberDescription[] vRIMemberDescriptionArray, CCVersion cCVersion, DCSTraceBuffer dCSTraceBuffer) {
        if (this._state.isNewViewProcess()) {
            this._state.setCCInState();
            this._waitCCV = new CCVersion(cCVersion);
            this._waitFailedMembers = new VRIMemberDescription[vRIMemberDescriptionArray.length];
            System.arraycopy(vRIMemberDescriptionArray, 0, this._waitFailedMembers, 0, vRIMemberDescriptionArray.length);
            return "Saved ccv and failed members";
        }
        this.assertSanityOfFailedMembers(vRIMemberDescriptionArray);
        this.vs.startPMI();
        this._curCCV = cCVersion;
        for (int i = 0; i < vRIMemberDescriptionArray.length; ++i) {
            this._viewStatus.registerCCFailMember(vRIMemberDescriptionArray[i].getIndexInView());
        }
        this._leader.completeCurrent(cCVersion, this._myViewIndex);
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer2 = DCSTraceBuffer.event(this, "VSyncAlgo2.completeCurrent()", "sending Status msg to " + this._leader.getLeaderIndex());
            dCSTraceBuffer2.mergePropertyList(dCSTraceBuffer);
            dCSTraceBuffer2.invoke();
        }
        if (!this._state.isState(8)) {
            if (this._state.isState(7)) {
                this._vsAlarm.cancelRcvMissing();
            } else {
                this._vsAlarm.cancelRcvAssignments();
            }
            this.sendStatusOrGCMessage((byte)2);
            this._md.setSyncMode(true);
            this._state.setState(5);
            if (DCSTraceBuffer.isEventEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer3 = DCSTraceBuffer.event(this, "VSyncAlgo2.completeCurrent()", "Calling down with cc()");
                dCSTraceBuffer3.mergePropertyList(dCSTraceBuffer);
                dCSTraceBuffer3.invoke();
            }
            this.vs._down.completeCurrent(vRIMemberDescriptionArray, this._curCCV);
        } else {
            this.sendStatusOrGCMessage((byte)2);
            this.vs._up.currentOK(this._curCCV);
        }
        return null;
    }

    public void newView(VRIMemberDescription[] vRIMemberDescriptionArray, ViewIdImpl viewIdImpl, Map map, LinkedList linkedList, DCSTraceBuffer dCSTraceBuffer) {
        if (!this._state.isState(8)) {
            VRIIllegalStateException vRIIllegalStateException = new VRIIllegalStateException(2, "VSyncAlgo2.newView: cannot new view in state: " + this._state);
            throw vRIIllegalStateException;
        }
        this.initViewScopedVariables(vRIMemberDescriptionArray, viewIdImpl, this._thisMember.getIndexInView());
        if (linkedList != null) {
            this._outQueuedMsgs = linkedList;
            this._md.setSyncMode(true);
        }
        this.vs._membersMgr.unDenyAll((byte)2, new int[0], true);
        this._leader.newView(this._myViewIndex);
        this._state.setState(9);
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer2 = DCSTraceBuffer.event(this, "VSyncAlgo2.newView()", "Calling down with nv()");
            dCSTraceBuffer2.mergePropertyList(dCSTraceBuffer);
            dCSTraceBuffer2.invoke();
        }
        this.vs._down.newView(vRIMemberDescriptionArray, viewIdImpl, map);
    }

    public void mcastMessage(VRIMessage vRIMessage, QoS.QOSMulticast qOSMulticast, ViewIdImpl viewIdImpl) throws DCSInvalidParametersException, DCSTransportLayerException {
        this.mcastMessage(vRIMessage, null, qOSMulticast, viewIdImpl);
    }

    private boolean doSendChecks(QoS.QOSUnicast qOSUnicast, ViewIdImpl viewIdImpl) throws DCSInvalidParametersException {
        if (!qOSUnicast.isVS()) {
            return false;
        }
        if (qOSUnicast.getGuaranteeType() == QoS.VS_ANY) {
            this.vs.focus(VSync.OUT_MSG, "send_any_exc");
            throw new DCSInvalidQoSException("VSyncAlgo2.sendMessage: can't send point to point VS_ANY msg");
        }
        if (qOSUnicast.getChannelType() == QoS.CONNECTED) {
            this.vs.focus(VSync.OUT_MSG, "send_cur_con");
            throw new DCSInvalidQoSException("VSyncAlgo2.sendMessage: can't send VS_CURRENT in the connected channel");
        }
        if (this._state.areOutVSMsgsQueued()) {
            this.vs.focus(VSync.OUT_MSG, "send_cur_view_change");
            throw new DCSInvalidViewIDException(viewIdImpl, null, "view is changing");
        }
        if (!this._curViewId.equals(viewIdImpl)) {
            this.vs.focus(VSync.OUT_MSG, "send_cur_wrong_view");
            throw new DCSInvalidViewIDException(viewIdImpl, this._curViewId, "wrong view");
        }
        return true;
    }

    private void sendMessageAfterChecks(VRIMessage vRIMessage, VRIMemberDescription vRIMemberDescription, QoS.QOSUnicast qOSUnicast) throws DCSInvalidParametersException, DCSTransportLayerException {
        if (!vRIMemberDescription.isInView()) {
            this.vs.focus(VSync.OUT_MSG, "send_cur_not_view_trg");
            DCSMemberIsNotInViewException dCSMemberIsNotInViewException = new DCSMemberIsNotInViewException(vRIMemberDescription.getName(), VRIMemberUtils.getMemberNames(this._curViewMembers));
            throw dCSMemberIsNotInViewException;
        }
        if (vRIMemberDescription.isDenied((byte)2)) {
            this.vs.focus(VSync.OUT_MSG, "send_cur_den_trg");
            DCSMemberIsDeniedException dCSMemberIsDeniedException = new DCSMemberIsDeniedException(vRIMemberDescription.getName(), VRIMemberUtils.getMemberNames(VRIMemberUtils.minus(this._curViewMembers, this.vs._membersMgr.getDeniedMembers((byte)2, true))));
            throw dCSMemberIsDeniedException;
        }
        this.vs.focus(VSync.OUT_MSG, "send_cur_ok");
        this.vs.sendVSCurrentMsg(vRIMessage, qOSUnicast, vRIMemberDescription);
        this._viewStatus.incrementSentUcast(this.vs._membersMgr.getViewMemberIndex(vRIMemberDescription.getName()));
    }

    public void sendMessage(VRIMessage vRIMessage, VRIMemberDescription vRIMemberDescription, QoS.QOSUnicast qOSUnicast, ViewIdImpl viewIdImpl) throws DCSInvalidParametersException, DCSTransportLayerException {
        if (!this.doSendChecks(qOSUnicast, viewIdImpl)) {
            this.vs.focus(VSync.OUT_MSG, "send_nvs");
            this.vs._down.sendMessage(vRIMessage, vRIMemberDescription, qOSUnicast, viewIdImpl);
            return;
        }
        this.sendMessageAfterChecks(vRIMessage, vRIMemberDescription, qOSUnicast);
    }

    public void sendMessage(VRIMessage vRIMessage, VRIMemberDescription[] vRIMemberDescriptionArray, QoS.QOSUnicast qOSUnicast, ViewIdImpl viewIdImpl) throws DCSInvalidParametersException, DCSTransportLayerException {
        if (!this.doSendChecks(qOSUnicast, viewIdImpl)) {
            return;
        }
        for (int i = 0; i < vRIMemberDescriptionArray.length - 1; ++i) {
            VRIMessage vRIMessage2 = vRIMessage.copy(true);
            this.sendMessageAfterChecks(vRIMessage2, vRIMemberDescriptionArray[i], qOSUnicast);
        }
        if (vRIMemberDescriptionArray.length > 0) {
            this.sendMessageAfterChecks(vRIMessage, vRIMemberDescriptionArray[vRIMemberDescriptionArray.length - 1], qOSUnicast);
        }
    }

    public void mcastMessage(VRIMessage vRIMessage, VRIMemberDescription[] vRIMemberDescriptionArray, QoS.QOSMulticast qOSMulticast, ViewIdImpl viewIdImpl) throws DCSInvalidParametersException, DCSTransportLayerException {
        if (qOSMulticast.getChannelType() == QoS.CONNECTED) {
            if (qOSMulticast.isVS()) {
                this.vs.focus(VSync.OUT_MSG, "mcast_vs_con");
                DCSInvalidQoSException dCSInvalidQoSException = new DCSInvalidQoSException("VSyncAlgo2.mcastMessage: Can't send VS message in the connected channel");
                throw dCSInvalidQoSException;
            }
            if (vRIMemberDescriptionArray != null) {
                this.vs._down.mcastMessage(vRIMessage, vRIMemberDescriptionArray, qOSMulticast, viewIdImpl);
            } else {
                this.vs._down.mcastMessage(vRIMessage, qOSMulticast, viewIdImpl);
            }
            return;
        }
        if (qOSMulticast.getChannelType() == QoS.VIEW) {
            if (!qOSMulticast.isVS()) {
                if (vRIMemberDescriptionArray != null) {
                    this.vs._down.mcastMessage(vRIMessage, vRIMemberDescriptionArray, qOSMulticast, viewIdImpl);
                } else {
                    this.vs._down.mcastMessage(vRIMessage, qOSMulticast, viewIdImpl);
                }
                return;
            }
            if (this._state.areOutVSMsgsQueued()) {
                if (qOSMulticast.getGuaranteeType() == QoS.VS_CURRENT) {
                    this.vs.focus(VSync.OUT_MSG, "mcast_cur_view_change");
                    throw new DCSInvalidViewIDException(viewIdImpl, null, "VSyncAlgo2.mcastMessage: View is changing");
                }
                this.vs.focus(VSync.OUT_MSG, "mcast_any_save");
                this._outQueuedMsgs.addLast(new VSyncAlgo.MsgAndQos(vRIMessage, qOSMulticast));
                return;
            }
            if (qOSMulticast.getGuaranteeType() == QoS.VS_CURRENT) {
                if (!this._curViewId.equals(viewIdImpl)) {
                    this.vs.focus(VSync.OUT_MSG, "mcast_cur_wrong");
                    throw new DCSInvalidViewIDException(viewIdImpl, this._curViewId, "Wrong View");
                }
                this.vs.focus(VSync.OUT_MSG, "mcast_cur_ok");
            } else {
                this.vs.focus(VSync.OUT_MSG, "mcast_any_ok");
            }
            this.mcastVSMsg(vRIMessage, vRIMemberDescriptionArray, qOSMulticast);
            return;
        }
    }

    public String currentOK(CCVersion cCVersion, DCSTraceBuffer dCSTraceBuffer) {
        if (this._state.isTerminationProcess()) {
            return "Terminating";
        }
        if (!this._state.isState(5)) {
            VRIIllegalStateException vRIIllegalStateException = new VRIIllegalStateException(2, "VSyncAlgo2.currentOK: called with currentOK, when state is " + this._state);
            this.vs.handleInternalError(vRIIllegalStateException, false);
            return null;
        }
        int n = cCVersion.compareTo(this._curCCV);
        if (n > 0) {
            VRIIllegalStateException vRIIllegalStateException = new VRIIllegalStateException(2, "VSyncAlgo2.currentOK: the layer below delivered future ccv");
            this.vs.handleInternalError(vRIIllegalStateException, false);
            return null;
        }
        if (n < 0) {
            return "Old CCV";
        }
        this._state.setState(6);
        this._vsAlarm.createRcvAssignments(this._curCCV, this._state.getState());
        return "";
    }

    public void newViewOK(VRIMemberDescription[] vRIMemberDescriptionArray, ViewIdImpl viewIdImpl, Map map, DCSTraceBuffer dCSTraceBuffer) {
        Object object;
        if (this._state.isTerminationProcess()) {
            return;
        }
        if (!this._state.isState(9) && !this._state.isState(10)) {
            VRIIllegalStateException vRIIllegalStateException = new VRIIllegalStateException(2, "VSyncAlgo2.newViewOK: illegal state: " + this._state);
            this.vs.handleInternalError(vRIIllegalStateException, false);
            return;
        }
        if (!this._curViewId.equals(viewIdImpl)) {
            this.vs.handleInternalError(new DCSIllegalParameterException("VSyncAlgo2.newViewOK: view id passed in nv(): " + this._curViewId + ". different the in view id: " + viewIdImpl), false);
            return;
        }
        if (!VRIMemberUtils.contains(this._curViewMembers, vRIMemberDescriptionArray)) {
            this.vs.handleInternalError(new DCSIllegalParameterException("VSyncAlgo2.newViewOK: new view ok members not included in  new view members"), false);
            return;
        }
        if (!VRIMemberUtils.contains(vRIMemberDescriptionArray, this._thisMember)) {
            this.vs.handleInternalError(new DCSIllegalParameterException("VSyncAlgo2.newViewOK: this member not included in newview ok members"), false);
            return;
        }
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            object = DCSTraceBuffer.event(this, "VSyncAlgo2.newViewOK()", "Mcast outgoing queued messages");
            ((DCSTraceBuffer)object).mergePropertyList(dCSTraceBuffer);
            ((DCSTraceBuffer)object).addProperty(this._state);
            ((DCSTraceBuffer)object).invoke();
        }
        try {
            while (!this._outQueuedMsgs.isEmpty()) {
                object = (VSyncAlgo.MsgAndQos)this._outQueuedMsgs.removeFirst();
                this.mcastVSMsg(((VSyncAlgo.MsgAndQos)object).getMsg(), null, ((VSyncAlgo.MsgAndQos)object).getQoS());
            }
        }
        catch (DCSTransportLayerException dCSTransportLayerException) {
            this.vs.handleInternalError(dCSTransportLayerException, true);
        }
        catch (DCSInvalidParametersException dCSInvalidParametersException) {
            this.vs.handleInternalError(dCSInvalidParametersException, true);
        }
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            object = DCSTraceBuffer.event(this, "VSyncAlgo2.newViewOK()", "Call up with nvok");
            ((DCSTraceBuffer)object).mergePropertyList(dCSTraceBuffer);
            ((DCSTraceBuffer)object).addProperty(this._state);
            ((DCSTraceBuffer)object).invoke();
        }
        if (this._state.isState(9)) {
            this._state.setState(11);
        } else {
            this._state.setState(13);
        }
        this.vs._up.newViewOK(vRIMemberDescriptionArray, viewIdImpl, map);
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            object = DCSTraceBuffer.event(this, "VSyncAlgo2.newViewOK()", "Deliver incoming queued messages");
            ((DCSTraceBuffer)object).mergePropertyList(dCSTraceBuffer);
            ((DCSTraceBuffer)object).addProperty("Incoming", "MessageQueueSize", this._inQueuedMsgs.size());
            ((DCSTraceBuffer)object).addProperty(this._state);
            ((DCSTraceBuffer)object).invoke();
        }
        if (this._state.isState(11)) {
            this._state.setState(12);
        } else {
            this._state.setState(14);
        }
        if (!this._inQueuedMsgs.isEmpty()) {
            if (DCSTraceBuffer.isInternalInfoEnabled(TC)) {
                object = DCSTraceBuffer.internalInfo(this, "There are queued incoming message in newViewOK. The messages will not be delivered");
                ((DCSTraceBuffer)object).invoke();
            }
            this._inQueuedMsgs.clear();
        }
        boolean bl = this._state.isState(14);
        this._state.setState(4);
        if (bl) {
            CCVersion cCVersion = this._waitCCV;
            Object[] objectArray = this._waitFailedMembers;
            this._waitCCV = null;
            this._waitFailedMembers = null;
            if (DCSTraceBuffer.isEventEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer2 = DCSTraceBuffer.event(this, "VSyncAlgo2.newViewOK()", "Doing saved complete current");
                dCSTraceBuffer2.mergePropertyList(dCSTraceBuffer);
                dCSTraceBuffer2.addProperty(cCVersion).addProperty("failedMembers", Utils.toString(objectArray));
                dCSTraceBuffer2.addProperty(this._state);
                dCSTraceBuffer2.invoke();
            }
            this.vs.completeCurrent((VRIMemberDescription[])objectArray, cCVersion);
        } else {
            this._md.setSyncMode(false);
        }
    }

    private void mcastVSMsg(VRIMessage vRIMessage, VRIMemberDescription[] vRIMemberDescriptionArray, QoS.QOSMulticast qOSMulticast) throws DCSTransportLayerException, DCSInvalidParametersException {
        Object object;
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            object = DCSTraceBuffer.entry(this, "VSyncAlgo2.mcastVSMsg()", null);
            ((DCSTraceBuffer)object).addProperty("Message", vRIMessage);
            ((DCSTraceBuffer)object).addProperty(qOSMulticast);
            ((DCSTraceBuffer)object).invoke();
        }
        object = null;
        if (vRIMemberDescriptionArray == null) {
            object = new VSNotOrigHeader.VSBitSet();
        } else {
            object = new VSNotOrigHeader.VSBitSet(this._viewSize);
            int n = 0;
            for (int i = 0; i < vRIMemberDescriptionArray.length; ++i) {
                while (n < this._viewSize && !this._curViewMembers[n].equals(vRIMemberDescriptionArray[i])) {
                    ++n;
                }
                if (n == this._viewSize) {
                    // empty if block
                }
                ((VSNotOrigHeader.VSBitSet)object).set(n);
            }
        }
        VSNotOrigHeader vSNotOrigHeader = new VSNotOrigHeader(this._curViewId, this._myViewIndex, this._nextVSMsgId++, (VSNotOrigHeader.VSBitSet)object, this, this.vs._version);
        vRIMessage.addHeader(vSNotOrigHeader);
        this.vs._down.mcastMessage(vRIMessage, (QoS.QOSMulticast)qOSMulticast.updateType(QoS.RELIABLE), null);
        this._viewStatus.incrementSentMcast(this._myViewIndex);
        if (DCSTraceBuffer.isExitEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.exit(this, "VSyncAlgo2.mcastVSMsg()", null);
            dCSTraceBuffer.invoke();
        }
    }

    public void deliverVSmsg(VRIMessage vRIMessage, DCSTraceBuffer dCSTraceBuffer) {
        Object object;
        boolean bl;
        boolean bl2 = bl = vRIMessage.getOriginatorLayer() == 2;
        if (!bl && (this._state.isState(9) || this._state.isState(10))) {
            object = new VSInternalException("got VS message in state: " + this._state);
            this.vs.handleInternalError((Exception)object, false);
        }
        if (this._state.areInVSMsgsQueued(bl)) {
            this._inQueuedMsgs.add(vRIMessage);
            if (DCSTraceBuffer.isEventEnabled(TC)) {
                object = DCSTraceBuffer.event(this, "VSyncAlgo2.deliver()", "Queued message");
                ((DCSTraceBuffer)object).invoke();
            }
            this.vs.focus(VSync.IN_MSG, "deliver_save", dCSTraceBuffer);
            return;
        }
        object = vRIMessage.getSender();
        VRIMemberDescription vRIMemberDescription = null;
        int n = -1;
        for (int i = 0; i < this._viewSize; ++i) {
            if (!((String)object).equals(this._curViewMembers[i].getName())) continue;
            vRIMemberDescription = this._curViewMembers[i];
            n = i;
        }
        if (this._viewStatus.isMemberVSFailed(n)) {
            return;
        }
        VSHeader vSHeader = null;
        vSHeader = this.retreiveMsgVSHeader(vRIMessage);
        if (vSHeader == null) {
            this.vs.denyAndSuspect(vRIMemberDescription, new VSDenialReason(SuspectUnreadableMessageEvent.badHeader(this, vRIMemberDescription.getName())));
            this.vs.focus(VSync.IN_MSG, "deliver_format", dCSTraceBuffer);
            return;
        }
        ViewIdImpl viewIdImpl = vSHeader.getViewId();
        if (!this._curViewId.equals(viewIdImpl)) {
            this.vs.focus(VSync.IN_MSG, "deliver_nc_l_drop", dCSTraceBuffer);
            if (vRIMessage.getOriginatorLayer() != 2) {
                this.vs.traceNlsIgnoreMessage((String)object, "The View Id of the message " + viewIdImpl + " is not the current View Id " + this._curViewId);
            }
            return;
        }
        if (vRIMessage.getOriginatorLayer() != 2) {
            this.dealWithVSNotOrigMsg(vRIMessage, vSHeader, (String)object, vRIMemberDescription, n, dCSTraceBuffer);
            return;
        }
        this.dealWithVSOrigMsg(vRIMessage, vSHeader, (String)object, vRIMemberDescription, n, dCSTraceBuffer);
    }

    private VSHeader retreiveMsgVSHeader(VRIMessage vRIMessage) {
        VSHeader vSHeader = null;
        if (vRIMessage.getOriginatorLayer() != 2) {
            vSHeader = new VSNotOrigHeader(this, this.vs._version);
        } else if (vRIMessage.getMessageType() == 2) {
            vSHeader = new VSCCVStatusHeader(this, this.vs._version);
        } else if (vRIMessage.getMessageType() == 3) {
            vSHeader = new VSCCVAssignmentsHeader(this, this.vs._version);
        } else if (vRIMessage.getMessageType() == 1) {
            vSHeader = new VSRcvVectorHeader(this, this.vs._version);
        }
        if (vSHeader != null) {
            vSHeader = (VSHeader)vRIMessage.getHeader(vSHeader);
        }
        return vSHeader;
    }

    private void handleAssignmentMsg(VSCCVAssignmentsHeader vSCCVAssignmentsHeader, int n) {
        Object object;
        DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.propertyList();
        dCSTraceBuffer.addProperty(this._curCCV).addProperty(this._state).addProperty("Sender", n);
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            object = DCSTraceBuffer.entry(this, "VSyncAlgo2.handleAssignmentMsg()", null);
            ((DCSTraceBuffer)object).mergePropertyList(dCSTraceBuffer);
            ((DCSTraceBuffer)object).invoke();
        }
        this.vs.focus(VSync.EVENT, "assignments", dCSTraceBuffer);
        if (this._state.isTerminationProcess()) {
            return;
        }
        if (!(this._state.isState(6) || this._state.isState(8) || this._state.isState(7))) {
            object = new VSInternalException("VSyncAlgo2.handleAssignmentMsg: Illegal state: " + this._state);
            this.vs.handleInternalError((Exception)object, false);
            return;
        }
        object = vSCCVAssignmentsHeader.getCcv();
        int n2 = ((CCVersion)object).compareTo(this._curCCV);
        if (n2 < 0) {
            if (DCSTraceBuffer.isExitEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer2 = DCSTraceBuffer.exit(this, "VSyncAlgo2.handleAssignmentMsg()", "received and ignored an assignment from the past");
                dCSTraceBuffer2.invoke();
            }
            return;
        }
        if (n2 > 0) {
            this.vs.denyAndSuspect(this._curViewMembers[n], new VSDenialReason(new VSSuspectProtocolBroke((DCSTraceContext)this, this._curViewMembers[n].getName(), "received an assignment from the future " + object)));
            this.vs.focus(VSync.IN_MSG, "received an assignment from the future", dCSTraceBuffer);
            return;
        }
        if (this._state.isState(7)) {
            VSInternalException vSInternalException = new VSInternalException("VSyncAlgo2.handleAssignmentMsg: Illegal state: " + this._state);
            this.vs.handleInternalError(vSInternalException, false);
            return;
        }
        if (!this._leader.isLeaderIndex(n)) {
            this.vs.denyAndSuspect(this._curViewMembers[n], new VSDenialReason(new VSSuspectProtocolBroke((DCSTraceContext)this, this._curViewMembers[n].getName(), "received an assignment from a non-leader")));
            this.vs.focus(VSync.IN_MSG, "received an assignment from a non-leader", dCSTraceBuffer);
            return;
        }
        if (this._state.isState(6)) {
            this._vsAlarm.cancelRcvAssignments();
            this._viewStatus.registerViewMax(vSCCVAssignmentsHeader.getLastDlvMsgs(), vSCCVAssignmentsHeader.getLastSentUcastMsgs().getNonCompressedGuaranteed());
            if (this._viewStatus.areAllMsgsRcved(this.vs._inSavedMsgs.getLastRcvMessagesIDsStatus())) {
                this.handleReceivedAllMsgs();
            } else {
                this._viewStatus.registerCompleters(vSCCVAssignmentsHeader.getCompleters());
                this._state.setState(7);
            }
        }
        VSCCVAssignmentsHeader.AssignmentRec[] assignmentRecArray = vSCCVAssignmentsHeader.getAssignments();
        for (int i = 0; i < assignmentRecArray.length; ++i) {
            this.doAssignment(assignmentRecArray[i]._failedMember, assignmentRecArray[i]._rcvMsgs);
        }
        if (this._state.isState(7)) {
            this._vsAlarm.createRcvMissing((CCVersion)object, this._state.getState());
        }
        if (DCSTraceBuffer.isExitEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer3 = DCSTraceBuffer.exit(this, "VSyncALgo2.handleAssignmentMsg()", null);
            dCSTraceBuffer3.invoke();
        }
    }

    private void handleReceivedAllMsgs() {
        this._state.setState(8);
        this.vs.endPMI();
        VSSyncCompletedEvent vSSyncCompletedEvent = new VSSyncCompletedEvent((DCSTraceContext)this, this._curViewId, "The leader equals " + this._curViewMembers[this._leader.getLeaderIndex()].getName() + ", ccv equals " + this._curCCV);
        vSSyncCompletedEvent.invokeNLSTrace();
        this.vs._up.currentOK(this._curCCV);
    }

    private void doAssignment(int n, SpaceEfficientIntArray spaceEfficientIntArray) {
        int n2 = Integer.MAX_VALUE;
        int n3 = -1;
        int n4 = 0;
        int n5 = 0;
        Iterator iterator = spaceEfficientIntArray.getIterator();
        while (iterator.hasNext()) {
            int n6 = (Integer)iterator.next();
            if (!this._viewStatus.isMemberVSFailed(n5)) {
                ++n4;
                if (n2 > n6) {
                    n2 = n6;
                }
                if (n3 < n6) {
                    n3 = n6;
                }
            }
            ++n5;
        }
        int n7 = spaceEfficientIntArray.elementAt(this._myViewIndex);
        if (n7 != n3) {
            this.vs.denyAndSuspect(this._curViewMembers[this._leader.getLeaderIndex()], new VSDenialReason(new VSSuspectProtocolBroke((DCSTraceContext)this, this._curViewMembers[this._leader.getLeaderIndex()].getName(), "received an assignment when not having all messages, failed member " + this._curViewMembers[n].getName() + ", have " + n7 + ", must have " + n3)));
            return;
        }
        if (n2 == n3) {
            return;
        }
        LinkedList linkedList = null;
        try {
            linkedList = this.vs._inSavedMsgs.getSavedVSMessages(n, n2 + 1);
        }
        catch (VSRequestedMessagesHaveBeenDeletedException vSRequestedMessagesHaveBeenDeletedException) {
            VSInternalException vSInternalException = new VSInternalException(vSRequestedMessagesHaveBeenDeletedException);
            this.vs.handleInternalError(vSInternalException, false);
            return;
        }
        if (linkedList == null || linkedList.size() != n3 - n2) {
            VSInternalException vSInternalException = new VSInternalException("VSyncAlgo2.doAssignments: do not have all messages required for retransmission");
            this.vs.handleInternalError(vSInternalException, false);
            return;
        }
        ListIterator listIterator = linkedList.listIterator();
        Object[] objectArray = new CompleteRec[n4];
        int n8 = -1;
        n5 = 0;
        Iterator iterator2 = spaceEfficientIntArray.getIterator();
        while (iterator2.hasNext()) {
            int n9 = (Integer)iterator2.next();
            if (!this._viewStatus.isMemberVSFailed(n5)) {
                objectArray[++n8] = new CompleteRec(n5, n9);
            }
            ++n5;
        }
        Arrays.sort(objectArray);
        int n10 = n2;
        Vector<VRIMemberDescription> vector = new Vector<VRIMemberDescription>();
        vector.add(this._curViewMembers[((CompleteRec)objectArray[0])._ind]);
        for (int i = 1; i < objectArray.length; ++i) {
            if (((CompleteRec)objectArray[i])._val > n10) {
                VRIMemberDescription[] vRIMemberDescriptionArray = new VRIMemberDescription[vector.size()];
                vector.toArray(vRIMemberDescriptionArray);
                for (int j = n10; j < ((CompleteRec)objectArray[i])._val; ++j) {
                    VRIMessage vRIMessage = (VRIMessage)listIterator.next();
                    this.sendCompleteMsg(vRIMessage, vRIMemberDescriptionArray);
                }
            }
            n10 = ((CompleteRec)objectArray[i])._val;
            vector.add(this._curViewMembers[((CompleteRec)objectArray[i])._ind]);
        }
    }

    private void sendCompleteMsg(VRIMessage vRIMessage, VRIMemberDescription[] vRIMemberDescriptionArray) {
        Object object;
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            object = DCSTraceBuffer.entry(this, "VSyncAlgo2.sendCompleteMsg()", null);
            ((DCSTraceBuffer)object).addProperty("Message", vRIMessage);
            ((DCSTraceBuffer)object).invoke();
        }
        this.vs.incrementPMI();
        object = vRIMessage.copy(true);
        try {
            this.vs._down.mcastMessage((VRIMessage)object, vRIMemberDescriptionArray, this.VS_ORIG_MSG_MULTICAST_QOS, null);
        }
        catch (DCSTransportLayerException dCSTransportLayerException) {
            this.vs.handleInternalError(dCSTransportLayerException, false);
            return;
        }
        catch (DCSInvalidParametersException dCSInvalidParametersException) {
            this.vs.handleInternalError(dCSInvalidParametersException, false);
            return;
        }
        if (DCSTraceBuffer.isExitEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.exit(this, "VSyncAlgo2.sendCompleteMsg()", null);
            dCSTraceBuffer.invoke();
        }
    }

    private void dealWithVSNotOrigMsg(VRIMessage vRIMessage, VSHeader vSHeader, String string, VRIMemberDescription vRIMemberDescription, int n, DCSTraceBuffer dCSTraceBuffer) {
        if (this._state.isState(8)) {
            if (DCSTraceBuffer.isExitEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer2 = DCSTraceBuffer.exit(this, "VSyncAlgo2.dealWithVSNotOrigMsg()", "already have all msgs in CURRENT_OK_UP");
                dCSTraceBuffer2.invoke();
            }
            this.vs.focus(VSync.IN_MSG, "deliver_state_ims", dCSTraceBuffer);
            return;
        }
        VSNotOrigHeader vSNotOrigHeader = (VSNotOrigHeader)vSHeader;
        byte by = vSNotOrigHeader.getDelivery();
        if (by == 2) {
            vRIMessage.extractHeader(vSNotOrigHeader);
            this.vs._up.deliver(vRIMessage);
            this._viewStatus.incrementRcvedUcast(n);
            if (this._state.isState(7) && this._viewStatus.areAllMsgsRcved(this.vs._inSavedMsgs.getLastRcvMessagesIDsStatus())) {
                this._vsAlarm.cancelRcvMissing();
                this.handleReceivedAllMsgs();
            }
            return;
        }
        if (by == 1) {
            int n2 = vSNotOrigHeader.getMsgId();
            int n3 = vSNotOrigHeader.getOrigSender();
            if (n3 < 0 || n3 >= this._viewSize) {
                this.vs.denyAndSuspect(vRIMemberDescription, new VSDenialReason(new VSSuspectProtocolBroke((DCSTraceContext)this, vRIMemberDescription.getName(), "The index of the message original sender - " + n3 + " - is illegal ")));
                if (DCSTraceBuffer.isExitEnabled(TC)) {
                    DCSTraceBuffer dCSTraceBuffer3 = DCSTraceBuffer.exit(this, "VSyncAlgo2.dealWithVSNotOrigMsg()", "Denied sender, as original index is not legal: ");
                    dCSTraceBuffer3.addProperty("MemberViewIndex", n3);
                    dCSTraceBuffer3.invoke();
                }
                this.vs.focus(VSync.IN_MSG, "deliver_index", dCSTraceBuffer);
                return;
            }
            boolean bl = false;
            try {
                bl = this.vs._inSavedMsgs.saveVSMessage(vRIMessage, n3, n2);
            }
            catch (VSGotFutureNotConsecutiveVSMessageException vSGotFutureNotConsecutiveVSMessageException) {
                this.vs.denyAndSuspect(vRIMemberDescription, new VSDenialReason(new VSSuspectNonconsecutiveMsg(this, vRIMemberDescription.getName(), vSGotFutureNotConsecutiveVSMessageException.getCurrentNum(), vSGotFutureNotConsecutiveVSMessageException.getPreviousNum())));
                if (DCSTraceBuffer.isExitEnabled(TC)) {
                    DCSTraceBuffer dCSTraceBuffer4 = DCSTraceBuffer.exit(this, "VSyncAlgo2.dealWithVSNotOrigMsg()", "Unconsecutive message");
                    dCSTraceBuffer4.addProperty("ReasonException", vSGotFutureNotConsecutiveVSMessageException);
                    dCSTraceBuffer4.invoke();
                }
                this.vs.focus(VSync.IN_MSG, "deliver_future", dCSTraceBuffer);
                return;
            }
            if (bl) {
                Object object;
                vRIMessage.extractHeader(vSNotOrigHeader);
                if (n3 != n) {
                    object = this._curViewMembers[n3].getName();
                    vRIMessage.changeSender((String)object);
                    if (DCSTraceBuffer.isEventEnabled(TC)) {
                        DCSTraceBuffer dCSTraceBuffer5 = DCSTraceBuffer.event(this, "VSyncAlgo2.dealWithVSNotOrigMsg()", "Changed original sender");
                        dCSTraceBuffer5.addProperty("Old", "memberName", string);
                        dCSTraceBuffer5.addProperty("New", "memberName", object);
                        dCSTraceBuffer5.invoke();
                    }
                    this.vs.focus(VSync.IN_MSG, "deliver_change", dCSTraceBuffer);
                }
                ++this.vs._deliveredVSMsgsCounter;
                if (this._md.shouldSendRcvVector()) {
                    this.sendStatusOrGCMessage((byte)1);
                }
                if (DCSTraceBuffer.isExitEnabled(TC)) {
                    object = DCSTraceBuffer.exit(this, "VSyncAlgo2.dealWithVSNotOrigMsg()", "Pass VS Multicast message upwards");
                    ((DCSTraceBuffer)object).invoke();
                }
                if (!((VSNotOrigHeader.VSBitSet)(object = vSNotOrigHeader.getBitSet())).isSubgroupSend() || ((VSNotOrigHeader.VSBitSet)object).get(this._myViewIndex)) {
                    this.vs._up.deliver(vRIMessage);
                }
                if (this._state.isState(7) && this._viewStatus.areAllMsgsRcved(this.vs._inSavedMsgs.getLastRcvMessagesIDsStatus())) {
                    this._vsAlarm.cancelRcvMissing();
                    this.handleReceivedAllMsgs();
                }
                return;
            }
            if (DCSTraceBuffer.isExitEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer6 = DCSTraceBuffer.exit(this, "VSyncAlgo2.dealWithVSNotOrigMsg()", "Drop old message");
                dCSTraceBuffer6.invoke();
            }
            this.vs.focus(VSync.IN_MSG, "deliver_old", dCSTraceBuffer);
            return;
        }
        this.vs.denyAndSuspect(vRIMemberDescription, new VSDenialReason(SuspectUnreadableMessageEvent.badMessageType(this, vRIMemberDescription.getName(), "VS Not originated delivery type", vSNotOrigHeader.getDelivery())));
        this.vs.focus(VSync.IN_MSG, "deliver_format", dCSTraceBuffer);
    }

    private void dealWithVSOrigMsg(VRIMessage vRIMessage, VSHeader vSHeader, String string, VRIMemberDescription vRIMemberDescription, int n, DCSTraceBuffer dCSTraceBuffer) {
        Object object;
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            object = DCSTraceBuffer.entry(this, "VSyncAlgo2.dealWithVSOrigMsg()", null);
            ((DCSTraceBuffer)object).addProperty("Message", vRIMessage);
            ((DCSTraceBuffer)object).addProperty("Header", vSHeader.getClass().getName());
            ((DCSTraceBuffer)object).addProperty("Sender", string);
            ((DCSTraceBuffer)object).addProperty("Sender", "MemberViewIndex", n);
            ((DCSTraceBuffer)object).invoke();
        }
        ++this.vs._inRcvVectorMsgsCounter;
        object = (VSRcvVectorHeader)vSHeader;
        int[] nArray = ((VSRcvVectorHeader)object).getLastDlvMsgs();
        try {
            if (vRIMessage.getMessageType() != 3) {
                this._viewStatus.setMatrixRow(n, nArray);
            }
            this._md.tryActivation(this._viewSize);
            if (vRIMessage.getMessageType() == 2) {
                VSCCVStatusHeader vSCCVStatusHeader = (VSCCVStatusHeader)object;
                this._leader.deliverStatusMsg(vSCCVStatusHeader, n);
                this.vs.focus(VSync.IN_MSG, "deliver_status", dCSTraceBuffer);
                if (DCSTraceBuffer.isExitEnabled(TC)) {
                    DCSTraceBuffer dCSTraceBuffer2 = DCSTraceBuffer.exit(this, "VSyncAlgo2.dealWithVSOrigMsg()", "Handled Status");
                    dCSTraceBuffer2.invoke();
                }
                return;
            }
            if (vRIMessage.getMessageType() == 3) {
                this.handleAssignmentMsg((VSCCVAssignmentsHeader)object, n);
                this.vs.focus(VSync.IN_MSG, "deliver_assignment", dCSTraceBuffer);
                if (DCSTraceBuffer.isExitEnabled(TC)) {
                    DCSTraceBuffer dCSTraceBuffer3 = DCSTraceBuffer.exit(this, "VSyncAlgo2.dealWithVSOrigMsg()", "Handled Assignment Msg");
                    dCSTraceBuffer3.invoke();
                }
                return;
            }
            if (vRIMessage.getMessageType() == 1) {
                if (DCSTraceBuffer.isExitEnabled(TC)) {
                    DCSTraceBuffer dCSTraceBuffer4 = DCSTraceBuffer.exit(this, "VSyncAlgo2.dealWithVSOrigMsg()", "Handled RCV Vector");
                    dCSTraceBuffer4.invoke();
                }
                this.vs.focus(VSync.IN_MSG, "deliver_rcv_vector", dCSTraceBuffer);
                return;
            }
            VSDenialReason vSDenialReason = new VSDenialReason(SuspectUnreadableMessageEvent.badMessageType(this, vRIMemberDescription.getName(), "VS Originated message type", vRIMessage.getMessageType()));
            this.vs.denyAndSuspect(vRIMemberDescription, vSDenialReason);
            this.vs.focus(VSync.IN_MSG, "deliver_format", dCSTraceBuffer);
            return;
        }
        catch (VSNewRowIsIllegalException vSNewRowIsIllegalException) {
            this.vs.denyAndSuspect(vRIMemberDescription, new VSDenialReason(new VSSuspectProtocolBroke((DCSTraceContext)this, vRIMemberDescription.getName(), "Received illegal vector")));
            return;
        }
        catch (VSMemberHasVSFailedException vSMemberHasVSFailedException) {
            VSInternalException vSInternalException = new VSInternalException(vSMemberHasVSFailedException);
            this.vs.handleInternalError(vSInternalException, false);
            return;
        }
    }

    private void assertSanityOfFailedMembers(VRIMemberDescription[] vRIMemberDescriptionArray) throws VRIIllegalStateException {
        Object object;
        DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.propertyList();
        dCSTraceBuffer.addProperty("failedMembers", Utils.toString(vRIMemberDescriptionArray));
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            object = DCSTraceBuffer.entry(this, "VSyncALgo2.assertSanityOfFailedMembers()", null);
            ((DCSTraceBuffer)object).mergePropertyList(dCSTraceBuffer);
            ((DCSTraceBuffer)object).invoke();
        }
        if (VRIMemberUtils.contains(vRIMemberDescriptionArray, this._thisMember)) {
            object = new VRIIllegalStateException(2, "VSyncAlgo2.assertSanityOfFailedMembers: this member is contained in the failed members.");
            throw object;
        }
        if (!VRIMemberUtils.contains(this._curViewMembers, vRIMemberDescriptionArray)) {
            object = new VRIIllegalStateException(2, "VSyncALgo2.assertSanityOfFailedMembers: not all failed members are in view");
            throw object;
        }
        for (int i = 0; i < this._viewSize; ++i) {
            if (!this._viewStatus.isMemberCCFailed(i) || VRIMemberUtils.contains(vRIMemberDescriptionArray, this._curViewMembers[i])) continue;
            VRIIllegalStateException vRIIllegalStateException = new VRIIllegalStateException(2, "VSyncAlgo2.assertSanityOfFailedMembers: Member has CC failed before - " + i + " is not CC failed now");
            throw vRIIllegalStateException;
        }
        if (DCSTraceBuffer.isExitEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer2 = DCSTraceBuffer.exit(this, "VSyncAlgo2.assertSanityOfFailedMembers()", null);
            dCSTraceBuffer2.invoke();
        }
    }

    private void sendStatusOrGCMessage(byte by) {
        Object object;
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            object = DCSTraceBuffer.entry(this, "VSyncAlgo2.sendStatusOrGCMessage()", null);
            ((DCSTraceBuffer)object).addProperty("MessageType", by);
            ((DCSTraceBuffer)object).invoke();
        }
        object = this.vs._inSavedMsgs.getLastRcvMessagesIDsStatus();
        VSRcvVectorHeader vSRcvVectorHeader = null;
        int n = -1;
        switch (by) {
            case 2: {
                vSRcvVectorHeader = new VSCCVStatusHeader(this._curViewId, (int[])object, new SpaceEfficientIntArray(this._viewStatus.getSentUcast()), this._viewStatus.getSentMcast(), this._curCCV, this, this.vs._version);
                n = this._leader.getLeaderIndex();
                break;
            }
            case 1: {
                vSRcvVectorHeader = new VSRcvVectorHeader(this._curViewId, (int[])object, this, this.vs._version);
                break;
            }
            default: {
                this.vs.handleInternalError(new VSInternalException("VSyncAlgo2.sendVSOriginatedMsg: Unknown type " + by), false);
                return;
            }
        }
        this.sendVSOriginatedMsg(by, vSRcvVectorHeader, n);
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.exit(this, "VSyncAlgo2.sendStatusOrGCMessage()", null);
            dCSTraceBuffer.invoke();
        }
    }

    void sendVSOriginatedMsg(byte by, VSHeader vSHeader, int n) {
        VRIMessage vRIMessage = this.vs._msgFactory.getMessage(by, (byte)2, this._thisMember.getName());
        vRIMessage.addHeader(vSHeader);
        try {
            if (n == -1) {
                this.vs._down.mcastMessage(vRIMessage, this.VS_ORIG_MSG_MULTICAST_QOS, null);
            } else if (!this._viewStatus.isMemberVSFailed(n)) {
                try {
                    this.vs._down.sendMessage(vRIMessage, this._curViewMembers[n], this.VS_ORIG_MSG_UNICAST_QOS, null);
                }
                catch (DCSInvalidMemberException dCSInvalidMemberException) {
                    if (DCSTraceBuffer.isEventEnabled(TC)) {
                        DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this, "VSyncAlgo2.sendVSOriginatedMsg()", "Can not send the message to another member, failing it");
                        dCSTraceBuffer.addProperty("MemberViewIndex", n);
                        dCSTraceBuffer.invoke();
                    }
                    this._viewStatus.registerVSFailMember(n);
                }
            }
        }
        catch (DCSInvalidParametersException dCSInvalidParametersException) {
            this.vs.handleInternalError(dCSInvalidParametersException, false);
            return;
        }
        catch (DCSTransportLayerException dCSTransportLayerException) {
            this.vs.handleInternalError(dCSTransportLayerException, false);
            return;
        }
    }

    public void cancelAlarm() {
        this._vsAlarm.cancelAny();
    }

    public VRICheckFailedException check() {
        Object object;
        boolean bl;
        boolean bl2 = true;
        if (this._waitFailedMembers != null && this._waitCCV == null) {
            if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.internalWarning(this, "VSyncAlgo2.check failed: wait ccv is null, while failed members not null", "VSyncAlgo2.check()", null);
                dCSTraceBuffer.invoke();
            }
            bl2 = false;
        }
        boolean bl3 = bl = this._waitCCV != null;
        if (bl != this._state.didSaveCC()) {
            if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
                object = DCSTraceBuffer.internalWarning(this, "VSyncAlgo2.check failed as saved cc is not compatible with the state", "VSyncAlgo2.check()", null);
                ((DCSTraceBuffer)object).addProperty(this._waitCCV).addProperty(this._state);
                ((DCSTraceBuffer)object).invoke();
            }
            bl2 = false;
        }
        if (this._curCCV != null != this._state.didGetCCdidntGetNV()) {
            if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
                object = DCSTraceBuffer.internalWarning(this, "VSyncAlgo2.check failed: Inconsistency between current ccv and the state", "VSyncAlgo2.check()", null);
                ((DCSTraceBuffer)object).addProperty(this._curCCV).addProperty(this._state);
                ((DCSTraceBuffer)object).invoke();
            }
            bl2 = false;
        }
        if (!this._state.areInVSMsgsQueued(false) && this._inQueuedMsgs.size() != 0) {
            if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
                object = DCSTraceBuffer.internalWarning(this, "VSyncAlgo2.check failed: queued msgs while state is NOT vs queueing.", "VSyncAlgo2.check()", null);
                ((DCSTraceBuffer)object).addProperty(this._state);
                ((DCSTraceBuffer)object).addProperty("Saved", "MessageQueueSize", this._inQueuedMsgs.size());
                ((DCSTraceBuffer)object).invoke();
            }
            bl2 = false;
        }
        if ((this._state.isState(9) || this._state.isState(10)) && this.vs._deliveredVSMsgsCounter != 0) {
            if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
                object = DCSTraceBuffer.internalWarning(this, "VSyncAlgo2.check failed: delivered VS msgs while state is NV_DOWN*", "VSyncAlgo2.check()", null);
                ((DCSTraceBuffer)object).invoke();
            }
            bl2 = false;
        }
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            this._md.traceMemory();
        }
        bl2 = bl2 && this._viewStatus.check(this._myViewIndex, this._state, this._curCCV);
        bl2 = bl2 && this.vs._inSavedMsgs.check(this._viewStatus.getRcvByAllVector());
        object = this.vs._up.check();
        Object object2 = null;
        if (!bl2) {
            object2 = new VRICheckFailedException("VSyncAlgo2.check: FAILED");
            ((VRICheckFailedException)object2).setUpperLayerExcetion((VRICheckFailedException)object);
        } else {
            object2 = object;
        }
        return object2;
    }

    public ViewIdImpl getCurViewId() {
        return this._curViewId;
    }

    public VRIMemberDescription[] getCurViewMembers() {
        return this._curViewMembers;
    }

    public String dump() {
        String string;
        if (DCSTraceBuffer.isDumpEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.dump(this, "VSyncAlgo2.dump()", "Dump VSyncAlgo2");
            dCSTraceBuffer.addProperty("Future", this._waitCCV);
            dCSTraceBuffer.addProperty("Current", this._curCCV);
            dCSTraceBuffer.addProperty("Future", "memberNames", this._waitFailedMembers);
            dCSTraceBuffer.addProperty("Incoming", "MessageQueueSize", this._inQueuedMsgs.size());
            dCSTraceBuffer.addProperty("Outgoing", "MessageQueueSize", this._outQueuedMsgs.size());
            dCSTraceBuffer.addProperty("Current", this._curViewId);
            dCSTraceBuffer.addProperty("viewSize", this._viewSize);
            dCSTraceBuffer.addProperty("Current", "viewMembers", Utils.toString(this._curViewMembers));
            dCSTraceBuffer.addProperty("Next", "VsyncMessageNumber", this._nextVSMsgId);
            dCSTraceBuffer.addProperty("My", "MemberViewIndex", this._myViewIndex);
            dCSTraceBuffer.addProperty("Unicast", this.VS_ORIG_MSG_UNICAST_QOS);
            dCSTraceBuffer.addProperty("Multicast", this.VS_ORIG_MSG_MULTICAST_QOS);
            string = dCSTraceBuffer.toString();
        } else {
            string = "";
        }
        return string + this._vsAlarm.dump();
    }

    public TraceComponent getTraceComponent() {
        return TC;
    }

    public String getStackName() {
        return this.vs.getStackName();
    }

    public String getMemberName() {
        return this._thisMember.getName();
    }

    public String getLayerName() {
        return DCSConstants.TRACE_LAYER_NAMES[2];
    }

    public LinkedList getOutgoingQueue() {
        return this._outQueuedMsgs;
    }

    private class CompleteRec
    implements Comparable {
        int _val;
        int _ind;

        CompleteRec(int n, int n2) {
            this._val = n2;
            this._ind = n;
        }

        public int compareTo(Object object) {
            CompleteRec completeRec = (CompleteRec)object;
            if (this._val < completeRec._val) {
                return -1;
            }
            if (this._val == completeRec._val) {
                return 0;
            }
            return 1;
        }
    }
}

