/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.drs;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.drs.DRSGlobals;
import com.ibm.ws.drs.DRSInstance;
import com.ibm.ws.drs.message.DRSBootstrapMsgImpl;
import com.ibm.ws.drs.message.DRSCacheMsgImpl;
import com.ibm.ws.drs.model.DRSEntries;
import com.ibm.ws.drs.model.DRSGroup;
import com.ibm.ws.drs.model.DRSGroups;
import com.ibm.ws.drs.pool.DRSPool;
import com.ibm.ws.drs.stack.DRSStack;
import com.ibm.ws.drs.utils.DRSBoolWrapper;
import com.ibm.ws.drs.utils.DRSConstants;
import com.ibm.wsspi.cluster.Identity;
import com.ibm.wsspi.cluster.adapter.IdentityMapping;
import com.ibm.wsspi.drs.DRSBootstrapMsg;
import com.ibm.wsspi.drs.DRSDataXfer;
import com.ibm.wsspi.drs.DRSJvmId;
import com.ibm.wsspi.drs.DRSMiscInterface;
import com.ibm.wsspi.drs.exception.DRSCongestedException;
import com.ibm.wsspi.drs.exception.DRSNotReadyException;
import com.ibm.wsspi.hamanager.GroupMemberId;
import com.ibm.wsspi.hamanager.agent.Agent;
import com.ibm.wsspi.hamanager.datastack.DataStackMemberException;
import com.ibm.wsspi.hamanager.datastack.DataStackMembershipChangingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class DRSDataXferImpl
implements DRSDataXfer,
DRSMiscInterface {
    private static TraceComponent tc = Tr.register(DRSDataXferImpl.class.getName(), "DRS", "com.ibm.ws.drs.resources.drs");
    private static boolean _loggedVersion = false;
    private DRSInstance _drsInstance = null;
    private String _drsInstanceName = null;
    private DRSEntries _drsEntries = null;
    private DRSGroups _drsGroups = null;
    private DRSStack _sendStack;
    private DRSStack _getStack;
    private DRSStack _globalSendStack;
    private DRSStack _broadcastStack;
    private DRSPool _dcmPool;
    private long _drsInstanceId;
    private Long _drsInstanceID;
    private short _mode;
    private IdentityMapping _identityMapping = null;
    private boolean _suppressImplicitAnnounce = false;
    private boolean _removesViaSendStack = false;

    public DRSDataXferImpl(DRSInstance dRSInstance) {
        if (tc.isDebugEnabled() && !_loggedVersion) {
            Tr.debug(tc, "CMVC Version 1.43 1/2/07 15:19:49");
            _loggedVersion = true;
        }
        this._drsInstance = dRSInstance;
        this._drsInstanceName = dRSInstance.getName();
        this._drsEntries = dRSInstance.getDRSEntries();
        this._drsGroups = dRSInstance.getDRSGroups();
        this._sendStack = dRSInstance.getSendStack();
        this._getStack = dRSInstance.getGetStack();
        this._globalSendStack = dRSInstance.getGlobalSendStack();
        this._broadcastStack = dRSInstance.getBroadcastStack();
        this._dcmPool = dRSInstance.getDcmPool();
        this._drsInstanceId = dRSInstance.getInstanceId();
        this._drsInstanceID = new Long(this._drsInstanceId);
        this._mode = dRSInstance.getDRSMode();
        this._identityMapping = DRSGlobals.getSingleton().getIdentityMapping();
        this._removesViaSendStack = this._drsInstance.getRemovesViaSendStack();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createEntry(Object object, Object object2) throws DRSCongestedException, DRSNotReadyException {
        String string = "createEntry: ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry. drsInstanceName=" + this._drsInstanceName + " entryKey=" + object);
        }
        if (!this.drsIsUpAndRunning()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, string + "Exit. Replication is not up.");
            }
            return;
        }
        DRSCacheMsgImpl dRSCacheMsgImpl = (DRSCacheMsgImpl)this._dcmPool.get();
        dRSCacheMsgImpl.populateContents(this._drsInstance.getDomain().getName(), this._drsInstance.getInstanceId(), this._drsInstance.getName(), (short)1, object, null, object2);
        try {
            dRSCacheMsgImpl = (DRSCacheMsgImpl)this._sendStack.processSendMessage(dRSCacheMsgImpl);
            this.implicitAnnounceEntry(object);
        }
        catch (DRSCongestedException dRSCongestedException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + "Error. Caught throwable. t=" + dRSCongestedException);
            }
            throw dRSCongestedException;
        }
        catch (Throwable throwable) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + "Error. Caught throwable. t=" + throwable);
            }
        }
        finally {
            this._dcmPool.ret(dRSCacheMsgImpl);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, string + "Exit.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createEntryProp(Object object, Object object2, Object object3) throws DRSCongestedException, DRSNotReadyException {
        String string = "createEntryProp: ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry. drsInstanceName=" + this._drsInstanceName + " entryKey=" + object);
        }
        if (!this.drsIsUpAndRunning()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, string + "Exit. Replication is not up.");
            }
            return;
        }
        DRSCacheMsgImpl dRSCacheMsgImpl = (DRSCacheMsgImpl)this._dcmPool.get();
        dRSCacheMsgImpl.populateContents(this._drsInstance.getDomain().getName(), this._drsInstance.getInstanceId(), this._drsInstance.getName(), (short)2, object, object2, object3);
        try {
            dRSCacheMsgImpl = (DRSCacheMsgImpl)this._sendStack.processSendMessage(dRSCacheMsgImpl);
            if (this._drsEntries.getNeedsAnnounce(object)) {
                this.implicitAnnounceEntry(object);
            }
        }
        catch (DRSCongestedException dRSCongestedException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + "Error. Caught throwable. t=" + dRSCongestedException);
            }
            throw dRSCongestedException;
        }
        catch (Throwable throwable) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + "Error. Caught throwable. t=" + throwable);
            }
        }
        finally {
            this._dcmPool.ret(dRSCacheMsgImpl);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, string + "Exit.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateEntry(Object object, Object object2) throws DRSCongestedException, DRSNotReadyException {
        String string = "updateEntry: ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry. drsInstanceName=" + this._drsInstanceName + " entryKey=" + object);
        }
        if (!this.drsIsUpAndRunning()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, string + "Exit. Replication is not up.");
            }
            return;
        }
        DRSCacheMsgImpl dRSCacheMsgImpl = (DRSCacheMsgImpl)this._dcmPool.get();
        dRSCacheMsgImpl.populateContents(this._drsInstance.getDomain().getName(), this._drsInstance.getInstanceId(), this._drsInstance.getName(), (short)3, object, null, object2);
        try {
            dRSCacheMsgImpl = (DRSCacheMsgImpl)this._sendStack.processSendMessage(dRSCacheMsgImpl);
            if (this._drsEntries.getNeedsAnnounce(object)) {
                this.implicitAnnounceEntry(object);
            }
        }
        catch (DRSCongestedException dRSCongestedException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + "Error. Caught throwable. t=" + dRSCongestedException);
            }
            throw dRSCongestedException;
        }
        catch (Throwable throwable) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + "Error. Caught throwable. t=" + throwable);
            }
        }
        finally {
            this._dcmPool.ret(dRSCacheMsgImpl);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, string + "Exit.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateEntryProp(Object object, Object object2, Object object3) throws DRSCongestedException, DRSNotReadyException {
        String string = "updateEntryProp: ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry. drsInstanceName=" + this._drsInstanceName + " entryKey=" + object + " propKey=" + object2);
        }
        if (!this.drsIsUpAndRunning()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, string + "Exit. Replication is not up.");
            }
            return;
        }
        DRSCacheMsgImpl dRSCacheMsgImpl = (DRSCacheMsgImpl)this._dcmPool.get();
        dRSCacheMsgImpl.populateContents(this._drsInstance.getDomain().getName(), this._drsInstance.getInstanceId(), this._drsInstance.getName(), (short)4, object, object2, object3);
        try {
            dRSCacheMsgImpl = (DRSCacheMsgImpl)this._sendStack.processSendMessage(dRSCacheMsgImpl);
            if (this._drsEntries.getNeedsAnnounce(object)) {
                this.implicitAnnounceEntry(object);
            }
        }
        catch (DRSCongestedException dRSCongestedException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + "Error. Caught throwable. t=" + dRSCongestedException);
            }
            throw dRSCongestedException;
        }
        catch (Throwable throwable) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + "Error. Caught throwable. t=" + throwable);
            }
        }
        finally {
            this._dcmPool.ret(dRSCacheMsgImpl);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, string + "Exit.");
            }
        }
    }

    public Object getEntry(Object object) throws DRSCongestedException, DRSNotReadyException {
        return this.getEntry(object, null);
    }

    public Object getEntry(Object object, DRSJvmId dRSJvmId) throws DRSCongestedException, DRSNotReadyException {
        String string = "getEntry: ";
        DRSBoolWrapper dRSBoolWrapper = new DRSBoolWrapper();
        Object object2 = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry. drsInstanceName=" + this._drsInstanceName + " entryKey=" + object + " jvmId=" + dRSJvmId);
        }
        if (!this.drsIsUpAndRunning()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, string + "Exit. Replication is not up.");
            }
            return null;
        }
        if (dRSJvmId != null && (dRSJvmId.getZOSLocal() || dRSJvmId.getGroupMemberId() == null)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + "Invalid JvmId parameter. getEntry aborted.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, string + "Exit - Invalid JvmId parameter : " + dRSJvmId);
            }
            return null;
        }
        for (int i = 0; i < 2; ++i) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + "Attempting to get entry. attempt=" + i);
            }
            if (null != (object2 = this.getHelper((short)5, object, null, dRSJvmId, dRSBoolWrapper)) || !dRSBoolWrapper.boolValue) break;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + "Attempt failed.  Sleeping briefly before retry.");
            }
            try {
                Thread.sleep(987L);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Exit. retObj=" + object2);
        }
        return object2;
    }

    public Object getEntryProp(Object object, Object object2) throws DRSCongestedException, DRSNotReadyException {
        String string = "getEntryProp: ";
        DRSBoolWrapper dRSBoolWrapper = new DRSBoolWrapper();
        Object object3 = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry. drsInstanceName=" + this._drsInstanceName + " entryKey=" + object + " propKey=" + object2);
        }
        if (!this.drsIsUpAndRunning()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, string + "Exit. Replication is not up.");
            }
            return null;
        }
        for (int i = 0; i < 2; ++i) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + "Attempting to get entry.  attempt=" + i);
            }
            if (null != (object3 = this.getHelper((short)7, object, object2, null, dRSBoolWrapper)) || !dRSBoolWrapper.boolValue) break;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + "Attempt failed.  Sleeping briefly before retry.");
            }
            try {
                Thread.sleep(987L);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Exit. retObj=" + object3);
        }
        return object3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEntry(Object object) throws DRSCongestedException, DRSNotReadyException {
        String string = "removeEntry: ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry. drsInstanceName=" + this._drsInstanceName + " entryKey=" + object);
        }
        if (!this.drsIsUpAndRunning()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, string + "Exit. Replication is not up.");
            }
            return;
        }
        DRSCacheMsgImpl dRSCacheMsgImpl = (DRSCacheMsgImpl)this._dcmPool.get();
        dRSCacheMsgImpl.populateContents(this._drsInstance.getDomain().getName(), this._drsInstance.getInstanceId(), this._drsInstance.getName(), (short)9, object, null, null);
        try {
            dRSCacheMsgImpl = this._removesViaSendStack ? (DRSCacheMsgImpl)this._sendStack.processSendMessage(dRSCacheMsgImpl) : (DRSCacheMsgImpl)this._globalSendStack.processSendMessage(dRSCacheMsgImpl);
        }
        catch (DRSCongestedException dRSCongestedException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + "Error. Caught throwable. t=" + dRSCongestedException);
            }
            throw dRSCongestedException;
        }
        catch (Throwable throwable) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + "Error. Caught throwable. t=" + throwable);
            }
        }
        finally {
            this._dcmPool.ret(dRSCacheMsgImpl);
        }
        this._drsEntries.removeEntry(object);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Exit.");
        }
    }

    public void removeLocalEntry(Object object) {
        String string = "removeLocalEntry: ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry. drsInstanceName=" + this._drsInstanceName + " entryKey=" + object);
        }
        this._drsEntries.removeEntry(object);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Exit.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEntryProp(Object object, Object object2, Object object3) throws DRSCongestedException, DRSNotReadyException {
        String string = "removeEntryProp: ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry. drsInstanceName=" + this._drsInstanceName + " entryKey=" + object + " propKey=" + object2);
        }
        if (!this.drsIsUpAndRunning()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, string + "Exit. Replication is not up.");
            }
            return;
        }
        DRSCacheMsgImpl dRSCacheMsgImpl = (DRSCacheMsgImpl)this._dcmPool.get();
        dRSCacheMsgImpl.populateContents(this._drsInstance.getDomain().getName(), this._drsInstance.getInstanceId(), this._drsInstance.getName(), (short)10, object, object2, object3);
        try {
            dRSCacheMsgImpl = this._removesViaSendStack ? (DRSCacheMsgImpl)this._sendStack.processSendMessage(dRSCacheMsgImpl) : (DRSCacheMsgImpl)this._globalSendStack.processSendMessage(dRSCacheMsgImpl);
            if (this._drsEntries.getNeedsAnnounce(object)) {
                this.implicitAnnounceEntry(object);
            }
        }
        catch (DRSCongestedException dRSCongestedException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + "Error. Caught throwable. t=" + dRSCongestedException);
            }
            throw dRSCongestedException;
        }
        catch (Throwable throwable) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + "Error. Caught throwable. t=" + throwable);
            }
        }
        finally {
            this._dcmPool.ret(dRSCacheMsgImpl);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, string + "Exit.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean entryIDExists(Object object) throws DRSCongestedException, DRSNotReadyException {
        String string = "entryIDExists(obj): ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry. drsInstanceName=" + this._drsInstanceName + " entryKey=" + object);
        }
        if (!this.drsIsUpAndRunning()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, string + "Exit. Replication is not up. Returning false.");
            }
            return false;
        }
        if (!this.shouldPull(object)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + "Exact entry key is not in the entries table");
            }
            return false;
        }
        DRSCacheMsgImpl dRSCacheMsgImpl = (DRSCacheMsgImpl)this._dcmPool.get();
        dRSCacheMsgImpl.populateContents(this._drsInstance.getDomain().getName(), this._drsInstance.getInstanceId(), this._drsInstance.getName(), (short)11, object, null, null);
        dRSCacheMsgImpl.destinationAddress = this._drsEntries.getHouserGMIDsArray(object);
        Boolean bl = Boolean.FALSE;
        Long l = Long.getLong("DRS_STACKEXCEPTION_SLEEP_TIME", 1000L);
        try {
            dRSCacheMsgImpl = (DRSCacheMsgImpl)this._getStack.processSendMessage(dRSCacheMsgImpl);
            if (null != dRSCacheMsgImpl.objValue) {
                bl = (Boolean)dRSCacheMsgImpl.objValue;
            }
        }
        catch (DataStackMemberException dataStackMemberException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + "Error. Caught throwable. t=" + dataStackMemberException + " Retrying send");
            }
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string + "Retrying sendMessage() after sleeping: " + l + "ms");
                }
                Thread.sleep(l);
                dRSCacheMsgImpl.destinationAddress = this._drsEntries.getHouserGMIDsArray(object);
                dRSCacheMsgImpl = (DRSCacheMsgImpl)this._getStack.processSendMessage(dRSCacheMsgImpl);
                if (null != dRSCacheMsgImpl.objValue) {
                    bl = (Boolean)dRSCacheMsgImpl.objValue;
                }
            }
            catch (Throwable throwable) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string + "Error. Caught throwable. t=" + throwable);
                }
            }
        }
        catch (DataStackMembershipChangingException dataStackMembershipChangingException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + "Error. Caught throwable. t=" + dataStackMembershipChangingException + " Retrying send");
            }
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string + "Retrying sendMessage() after sleeping: " + l + "ms");
                }
                Thread.sleep(l);
                dRSCacheMsgImpl.destinationAddress = this._drsEntries.getHouserGMIDsArray(object);
                dRSCacheMsgImpl = (DRSCacheMsgImpl)this._getStack.processSendMessage(dRSCacheMsgImpl);
                if (null != dRSCacheMsgImpl.objValue) {
                    bl = (Boolean)dRSCacheMsgImpl.objValue;
                }
            }
            catch (Throwable throwable) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string + "Error. Caught throwable. t=" + throwable);
                }
            }
        }
        catch (DRSCongestedException dRSCongestedException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + "Error. Caught throwable. t=" + dRSCongestedException);
            }
            throw dRSCongestedException;
        }
        catch (Throwable throwable) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + "Error. Caught throwable. t=" + throwable);
            }
        }
        finally {
            this._dcmPool.ret(dRSCacheMsgImpl);
        }
        boolean bl2 = bl;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Exit. Returning entryIDExists=" + bl2);
        }
        return bl2;
    }

    public boolean entryIDExists(Object object, boolean bl) throws ClassCastException {
        String string = "entryIDExists(obj,bool): ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry. drsInstanceName=" + this._drsInstanceName + " substringMatch=" + bl + " entryKey=" + object);
        }
        boolean bl2 = true;
        if (this._drsInstance.isInstanceShuttingDown()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, string + "Exit. Replication is not up. Returning false.");
            }
            return false;
        }
        if (!this.shouldPull(object)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + "Exact Key is not in the entries table.");
            }
            bl2 = bl ? this._drsEntries.findEntrySubString((String)object) : false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Exit. foundEntry=" + bl2);
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean propIDExists(Object object, Object object2) throws DRSCongestedException, DRSNotReadyException {
        String string = "propIDExists: ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry. drsInstanceName=" + this._drsInstanceName + " entryKey=" + object + " propKey=" + object2);
        }
        if (!this.drsIsUpAndRunning()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, string + "Exit. Replication is not up. Returning false.");
            }
            return false;
        }
        if (!this.shouldPull(object)) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, string + "Exit. Key is not in table. Returning false.");
            }
            return false;
        }
        DRSCacheMsgImpl dRSCacheMsgImpl = (DRSCacheMsgImpl)this._dcmPool.get();
        dRSCacheMsgImpl.populateContents(this._drsInstance.getDomain().getName(), this._drsInstance.getInstanceId(), this._drsInstance.getName(), (short)13, object, object2, null);
        Boolean bl = Boolean.FALSE;
        try {
            dRSCacheMsgImpl = (DRSCacheMsgImpl)this._getStack.processSendMessage(dRSCacheMsgImpl);
            if (null != dRSCacheMsgImpl.objValue) {
                bl = (Boolean)dRSCacheMsgImpl.objValue;
            }
        }
        catch (DRSCongestedException dRSCongestedException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + "Error. Caught throwable. t=" + dRSCongestedException);
            }
            throw dRSCongestedException;
        }
        catch (Throwable throwable) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + "Error. Caught throwable. t=" + throwable);
            }
        }
        finally {
            this._dcmPool.ret(dRSCacheMsgImpl);
        }
        boolean bl2 = bl;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Exit. Returning propIDExists=" + bl2);
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void implicitAnnounceEntry(Object object) throws DRSCongestedException, DRSNotReadyException {
        String string = "implicitAnnounceEntry: ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry. drsInstanceName=" + this._drsInstanceName + " entryKey=" + object);
        }
        if (!this.drsIsUpAndRunning()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, string + "Exit. Replication is not up.");
            }
            return;
        }
        if (!this._suppressImplicitAnnounce) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(object);
            HashMap hashMap = this._drsEntries.getHouserGMIDs(object);
            if (hashMap == null) {
                hashMap = new HashMap();
            }
            DRSJvmId dRSJvmId = new DRSJvmId(DRSGlobals.getSingleton().getMyGMID(), "", false);
            DRSCacheMsgImpl dRSCacheMsgImpl = (DRSCacheMsgImpl)this._dcmPool.get();
            dRSCacheMsgImpl.populateContents(this._drsInstance.getDomain().getName(), this._drsInstance.getInstanceId(), this._drsInstance.getName(), (short)22, dRSJvmId, hashMap, arrayList);
            try {
                dRSCacheMsgImpl = (DRSCacheMsgImpl)this._globalSendStack.processSendMessage(dRSCacheMsgImpl);
            }
            catch (DRSCongestedException dRSCongestedException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string + "Error. Caught throwable. t=" + dRSCongestedException);
                }
                throw dRSCongestedException;
            }
            catch (Throwable throwable) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string + "Error. Caught throwable. t=" + throwable);
                }
            }
            finally {
                this._dcmPool.ret(dRSCacheMsgImpl);
            }
            this._drsEntries.setNeedsAnnounce(object, false);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, string + "Exit.");
            }
        } else if (tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Exit. Implicit announce is suppressed.");
        }
    }

    public void announceEntries(ArrayList arrayList) throws DRSCongestedException, DRSNotReadyException {
        this.announceEntries(arrayList, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DRSJvmId announceEntries(ArrayList arrayList, String string) throws DRSCongestedException, DRSNotReadyException {
        String string2 = "announceEntries: ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string2 + "Entry. drsInstanceName=" + this._drsInstanceName + " servantToken=" + string + " entryKeyList.size=" + arrayList.size());
        }
        if (!this.drsIsUpAndRunning()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, string2 + "Exit. Replication is not up.");
            }
            return null;
        }
        HashMap hashMap = this._drsInstance.getDomain().getBroadcastGroup().getMyGroupMemberID();
        DRSJvmId dRSJvmId = new DRSJvmId(DRSGlobals.getSingleton().getMyGMID(), string, false);
        DRSCacheMsgImpl dRSCacheMsgImpl = (DRSCacheMsgImpl)this._dcmPool.get();
        dRSCacheMsgImpl.populateContents(this._drsInstance.getDomain().getName(), this._drsInstance.getInstanceId(), this._drsInstance.getName(), (short)22, dRSJvmId, hashMap, arrayList);
        try {
            dRSCacheMsgImpl = (DRSCacheMsgImpl)this._globalSendStack.processSendMessage(dRSCacheMsgImpl);
        }
        catch (DRSCongestedException dRSCongestedException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string2 + "Error. Caught throwable. t=" + dRSCongestedException);
            }
            throw dRSCongestedException;
        }
        catch (Throwable throwable) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string2 + "Error. Caught throwable. t=" + throwable);
            }
            throwable.printStackTrace();
        }
        finally {
            this._dcmPool.ret(dRSCacheMsgImpl);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, string2 + "Exit. Returning jvmId=" + dRSJvmId);
            }
        }
        return dRSJvmId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renounceEntries(ArrayList arrayList) throws DRSCongestedException, DRSNotReadyException {
        String string = "renounceEntries: ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry. drsInstanceName=" + this._drsInstanceName + " entryKeyList=" + arrayList);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, string + "entryKey[" + i + "]=" + arrayList.get(i));
        }
        if (!this.drsIsUpAndRunning()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, string + "Exit. Replication is not up.");
            }
            return;
        }
        DRSCacheMsgImpl dRSCacheMsgImpl = (DRSCacheMsgImpl)this._dcmPool.get();
        dRSCacheMsgImpl.populateContents(this._drsInstance.getDomain().getName(), this._drsInstance.getInstanceId(), this._drsInstance.getName(), (short)23, null, null, arrayList);
        try {
            this._drsEntries.removeEntries(arrayList);
            dRSCacheMsgImpl = (DRSCacheMsgImpl)this._globalSendStack.processSendMessage(dRSCacheMsgImpl);
        }
        catch (DRSCongestedException dRSCongestedException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + "Error. Caught throwable. t=" + dRSCongestedException);
            }
            throw dRSCongestedException;
        }
        catch (Throwable throwable) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + "Error. Caught throwable. t=" + throwable);
            }
            throwable.printStackTrace();
        }
        finally {
            this._dcmPool.ret(dRSCacheMsgImpl);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, string + "Exit.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void broadcast(Object object) throws DRSCongestedException, DRSNotReadyException {
        String string = "broadcast: ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry. drsInstanceName=" + this._drsInstanceName + " key=" + object);
        }
        if (!this.drsIsUpAndRunning()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, string + "Exit. Replication is not up.");
            }
            return;
        }
        DRSCacheMsgImpl dRSCacheMsgImpl = (DRSCacheMsgImpl)this._dcmPool.get();
        dRSCacheMsgImpl.populateContents(this._drsInstance.getDomain().getName(), this._drsInstance.getInstanceId(), this._drsInstance.getName(), (short)24, object, null, null);
        try {
            dRSCacheMsgImpl = (DRSCacheMsgImpl)this._globalSendStack.processSendMessage(dRSCacheMsgImpl);
        }
        catch (DRSCongestedException dRSCongestedException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + "Error. Caught throwable. t=" + dRSCongestedException);
            }
            throw dRSCongestedException;
        }
        catch (Throwable throwable) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + "Error. Caught throwable. t=" + throwable);
            }
        }
        finally {
            this._dcmPool.ret(dRSCacheMsgImpl);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, string + "Exit.");
            }
        }
    }

    public boolean isMyCopyCurrent(Object object) {
        String string = "isMyCopyCurrent: ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry. drsInstanceName=" + this._drsInstanceName);
        }
        if (this._drsEntries.isMyEntry(object)) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, string + "Exit. Returning true.");
            }
            return true;
        }
        HashMap hashMap = this._drsEntries.getHouserGMIDs(object);
        String string2 = DRSGlobals.getSingleton().getHamServerId();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, string + "My HAM server id = " + string2);
        }
        if (hashMap != null && hashMap.containsKey(string2)) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, string + "Exit. Returning true.");
            }
            return true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Exit. Returning false.");
        }
        return false;
    }

    public long getInstanceId() {
        return this._drsInstanceId;
    }

    public String getInstanceName() {
        return this._drsInstance.getName();
    }

    public DRSInstance getInstance() {
        return this._drsInstance;
    }

    public String toString() {
        return this._drsInstance.toString();
    }

    private Map getAgentId(Object object) {
        Agent agent;
        DRSGroup dRSGroup;
        String string = "getAgentId: ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry. drsInstanceName=" + this._drsInstanceName + " entryKey=" + object);
        }
        if ((dRSGroup = this._drsEntries.getDRSGroup(object)) == null) {
            dRSGroup = this._drsGroups.getNextPrimaryGroup();
            if (null == dRSGroup) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, string + "Exit. Error. Could not get next primary group. Returning null.");
                }
                return null;
            }
            this._drsEntries.createEntry(object, dRSGroup, null, dRSGroup.getPartnerGroupMemberIDs());
        }
        if (null == (agent = dRSGroup.getAgent(1234L))) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, string + "Exit. Error. Could not get agent from group. Returning null. group=" + dRSGroup);
            }
            return null;
        }
        Map map = agent.getInstanceId();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Exit. agentIdMap=" + map);
        }
        return map;
    }

    public long getPartition(Object object) {
        String string = "getPartition: ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry. drsInstanceName=" + this._drsInstanceName + " entryKey=" + object);
        }
        long l = -1L;
        if (object == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + "Called with null. Returning -1.");
            }
            return -1L;
        }
        Map map = this.getAgentId(object);
        Identity identity = this._drsGroups.getWLMIdentity(map);
        if (identity == null && map != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + "Identity not found in instance. Getting identity from WLM.");
            }
            identity = DRSGlobals.getSingleton().getMbd().getIdentity(map);
        }
        if (identity != null) {
            l = this._identityMapping.getUID(identity);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Exit. Returning partition=" + l);
        }
        return l;
    }

    public Identity getWLMIdentity(Object object) {
        return this.getWLMIdentity(object, false);
    }

    public Identity getWLMIdentity(Object object, boolean bl) {
        Map map;
        String string = "getWLMIdentity: ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry. drsInstanceName=" + this._drsInstanceName + " forceCreation=" + bl + " entryKey=" + object);
        }
        Identity identity = null;
        if (this._drsInstance.isInstanceShuttingDown()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, string + "Exit. Replication is not up.");
            }
            return null;
        }
        if (object == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, string + "Exit. Error. Called with null. Returning null.");
            }
            return null;
        }
        DRSGroup dRSGroup = null;
        if (this._drsInstance.getDRSEntries().entryExists(object) && null == (dRSGroup = this._drsInstance.getDRSEntries().getDRSGroup(object)) && bl) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + "Getting new group.");
            }
            if (null != (dRSGroup = this._drsInstance.getDRSGroups().getNextPrimaryGroup())) {
                this._drsInstance.getDRSEntries().updateEntry(object, dRSGroup);
                this._drsInstance.getDRSEntries().becomeOwner(object);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + "Error getting next primary group. group is null.");
            }
        }
        if (null != dRSGroup) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + "Getting identity from group.");
            }
            map = dRSGroup.getAgent().getInstanceId();
            identity = this._drsInstance.getDRSGroups().getWLMIdentity(map);
            if (identity == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string + "Identity not found in instance. Getting identity from WLM.");
                }
                identity = DRSGlobals.getSingleton().getMbd().getIdentity(map);
            }
        }
        if (null == identity && bl) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + "Forcing new identity from group.");
            }
            map = this._drsInstance.getDRSGroups().createAgentIdMap(1);
            identity = DRSGlobals.getSingleton().getMbd().getIdentity(map);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Exit. identity=" + identity);
        }
        return identity;
    }

    public boolean shouldPull(Object object) {
        String string = "shouldPull: ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry. drsInstanceName=" + this._drsInstanceName + " entryKey=" + object);
        }
        boolean bl = this._drsEntries.entryExists(object);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Exit. Returning shouldPull=" + bl);
        }
        return bl;
    }

    public boolean isReplicationUp() {
        String string = "isReplicationUp: ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry. drsInstanceName=" + this._drsInstanceName);
        }
        boolean bl = false;
        if (null != this._drsInstance) {
            bl = this._drsInstance.getDRSGroups().isHamUp();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Exit. Returning isUp=" + bl);
        }
        return bl;
    }

    public boolean isCongested() {
        String string = "isCongested: ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry. drsInstanceName=" + this._drsInstanceName);
        }
        boolean bl = false;
        if (null != this._drsInstance) {
            bl = this._drsInstance.getDRSGroups().isTransportCongested();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Exit. Returning rc=" + bl);
        }
        return bl;
    }

    private boolean drsIsUpAndRunning() throws DRSNotReadyException, DRSCongestedException {
        DRSGroups dRSGroups = this._drsInstance.getDRSGroups();
        if (this._mode == 2 || null == dRSGroups || this._drsInstance.isInstanceShuttingDown()) {
            return false;
        }
        if (!dRSGroups.isHamUp()) {
            throw new DRSNotReadyException();
        }
        if (dRSGroups.isTransportCongested()) {
            throw new DRSCongestedException();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getHelper(short s, Object object, Object object2, DRSJvmId dRSJvmId, DRSBoolWrapper dRSBoolWrapper) throws DRSCongestedException, DRSNotReadyException {
        Object object3;
        String string = "getHelper: ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry. drsInstanceName=" + this._drsInstanceName + " action=" + DRSConstants.getActionString(s) + " entryKey=" + object + " propKey=" + object2 + " jvmId=" + dRSJvmId);
        }
        dRSBoolWrapper.boolValue = false;
        if (!this.drsIsUpAndRunning()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, string + "Exit. Replication is not up. Returning null.");
            }
            return null;
        }
        if (null == dRSJvmId && !this.shouldPull(object)) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, string + "Exit. Key is not in table. Returning null.");
            }
            return null;
        }
        DRSCacheMsgImpl dRSCacheMsgImpl = (DRSCacheMsgImpl)this._dcmPool.get();
        dRSCacheMsgImpl.populateContents(this._drsInstance.getDomain().getName(), this._drsInstance.getInstanceId(), this._drsInstance.getName(), s, object, object2, dRSJvmId);
        if (null != dRSJvmId) {
            object3 = new GroupMemberId[]{dRSJvmId.getGroupMemberId()};
            dRSCacheMsgImpl.destinationAddress = object3;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + "Using consumer-specified destination. gmid=" + object3[0]);
            }
        } else {
            dRSCacheMsgImpl.destinationAddress = this._drsEntries.getHouserGMIDsArray(object);
        }
        object3 = null;
        try {
            dRSCacheMsgImpl = (DRSCacheMsgImpl)this._getStack.processSendMessage(dRSCacheMsgImpl);
            object3 = dRSCacheMsgImpl.objValue;
        }
        catch (DRSCongestedException dRSCongestedException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + "Error. Caught throwable. t=" + dRSCongestedException);
            }
            throw dRSCongestedException;
        }
        catch (DataStackMemberException dataStackMemberException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + "Error. Caught throwable. t=" + dataStackMemberException);
            }
            dRSBoolWrapper.boolValue = true;
        }
        catch (DataStackMembershipChangingException dataStackMembershipChangingException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + "Error. Caught throwable. t=" + dataStackMembershipChangingException);
            }
            dRSBoolWrapper.boolValue = true;
        }
        catch (Throwable throwable) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + "Error. Caught throwable. t=" + throwable);
            }
        }
        finally {
            this._dcmPool.ret(dRSCacheMsgImpl);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Exit. mayRetry=" + dRSBoolWrapper + " retObj=" + object3);
        }
        return object3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateBootstrapResponse(DRSBootstrapMsg dRSBootstrapMsg) throws DRSCongestedException, DRSNotReadyException {
        DRSGroups dRSGroups;
        String string = "generateBootstrapResponse: ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry. drsInstanceName=" + this._drsInstanceName);
        }
        if (null == (dRSGroups = this._drsInstance.getDRSGroups()) || this._drsInstance.isInstanceShuttingDown()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, string + "Exit. Replication is stopping.");
            }
            return;
        }
        DRSBootstrapMsgImpl dRSBootstrapMsgImpl = (DRSBootstrapMsgImpl)dRSBootstrapMsg;
        DRSCacheMsgImpl dRSCacheMsgImpl = (DRSCacheMsgImpl)this._dcmPool.get();
        dRSCacheMsgImpl.populateContents(this._drsInstance.getDomain().getName(), this._drsInstanceId, this._drsInstanceName, (short)21, null, null, null);
        dRSCacheMsgImpl.destinationAddress = dRSBootstrapMsgImpl.getDestinationGMIDs();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, string + "destinationAddress=" + dRSCacheMsgImpl.destinationAddress);
        }
        if (null == dRSBootstrapMsgImpl.getJvmId()) {
            dRSBootstrapMsgImpl.setJvmId(new DRSJvmId(DRSGlobals.getSingleton().getMyGMID(), "", false));
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + "Attached new jvmId object.");
            }
        } else {
            dRSBootstrapMsgImpl.getJvmId().setGroupMemberId(DRSGlobals.getSingleton().getMyGMID());
        }
        dRSCacheMsgImpl.objValue = dRSBootstrapMsgImpl;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, string + " Sending bootstrap response - dbm:" + dRSBootstrapMsgImpl);
        }
        try {
            dRSCacheMsgImpl = (DRSCacheMsgImpl)this._broadcastStack.processSendMessage(dRSCacheMsgImpl);
        }
        catch (DRSNotReadyException dRSNotReadyException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + "Error. DRS not ready: " + dRSNotReadyException);
            }
            throw dRSNotReadyException;
        }
        catch (DRSCongestedException dRSCongestedException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + "Error. Congestion: " + dRSCongestedException);
            }
            throw dRSCongestedException;
        }
        catch (Throwable throwable) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + "Error. Caught throwable. t=" + throwable);
            }
        }
        finally {
            this._dcmPool.ret(dRSCacheMsgImpl);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Exit.");
        }
    }

    public void setSuppressImplicitAnnounce(boolean bl) {
        this._suppressImplicitAnnounce = bl;
    }

    public void bootstrapRequestByClientInstance() {
        String string = "bootstrapRequestByClientInstance: ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry. ");
        }
        this._drsInstance.getBootstrapManager().resetBootStrapInitiatedForZ();
        this._drsInstance.getBootstrapManager().initiateBootstrap();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Exit.");
        }
    }

    public void shutdownInstance() {
        DRSGroups dRSGroups;
        String string = "shutdownInstance: ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry. drsInstanceName=" + this._drsInstance.getName());
        }
        if (null == (dRSGroups = this._drsInstance.getDRSGroups()) || this._drsInstance.isInstanceShuttingDown()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, string + "Exit. Replication is already stopping.");
            }
            return;
        }
        this._drsInstance.shutdownInstance();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Exit.");
        }
    }
}

