/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.drs;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.multibroker.drsclient.DataReplication;
import com.ibm.ws.drs.DRSInstance;
import com.ibm.ws.drs.ha.DRSAgentClassEvents;
import com.ibm.ws.drs.managers.DRSBuddyManager;
import com.ibm.ws.drs.message.DRSCacheMsgImpl;
import com.ibm.ws.drs.message.DRSDomainMetrics;
import com.ibm.ws.drs.message.DRSMessageHelper;
import com.ibm.ws.drs.model.DRSGroup;
import com.ibm.ws.drs.utils.DRSActionStats;
import com.ibm.ws.drs.utils.DRSAlarm;
import com.ibm.ws.drs.utils.DRSAlarmInterface;
import com.ibm.ws.drs.utils.DRSConstants;
import com.ibm.ws.drs.utils.DRSCrypto;
import com.ibm.ws.drs.utils.DRSThreadLocal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;

public class DRSDomain
implements DRSAlarmInterface {
    TraceComponent tc = Tr.register(DRSDomain.class.getName(), "DRS", "com.ibm.ws.drs.resources.drs");
    private static boolean _loggedVersion = false;
    private String _name = null;
    private boolean _initialized = false;
    private int _numOfReplicas = 1;
    private int _requestTimeout = 0;
    private int _transportType = 174;
    private short _drsMode;
    private boolean _useEncryption = false;
    private DRSCrypto _drsCrypto = null;
    private HashMap _drsInstances = null;
    private DRSGroup _broadcastGroup;
    private DRSMessageHelper _messageHelper = null;
    private DRSAgentClassEvents _agentClassEvents = null;
    private HashMap _pendingSecondaryGroups = null;
    private HashMap _pendingBootstrapResponses = null;
    private boolean _colocate = false;
    private static DRSThreadLocal _currentThreadGroupKey = null;
    private DRSBuddyManager _buddyManager = null;
    private ArrayList _pendingPrimaryAgents = null;
    private DRSActionStats _sentMessageStats = null;
    private DRSActionStats _receiveMessageStats = null;

    public DRSDomain(String string, DataReplication dataReplication) {
        String string2 = "constructor: ";
        if (this.tc.isEntryEnabled()) {
            Tr.entry(this.tc, string2 + "Entry. domainName=" + string + " dataReplication=" + dataReplication);
        }
        if (this.tc.isDebugEnabled() && !_loggedVersion) {
            Tr.debug(this.tc, "CMVC Version 1.23 6/14/06 15:12:57");
            _loggedVersion = true;
        }
        this._name = string;
        this._drsInstances = new HashMap();
        this._pendingSecondaryGroups = new HashMap();
        this._pendingPrimaryAgents = new ArrayList();
        this._numOfReplicas = dataReplication.getNumberOfReplicas();
        if (this._numOfReplicas == -1) {
            this._numOfReplicas = 12345;
        }
        this._requestTimeout = dataReplication.getRequestTimeout() * 1000;
        this._sentMessageStats = new DRSActionStats(this._name + ":SentMessageStats");
        this._receiveMessageStats = new DRSActionStats(this._name + ":RcvMessageStats");
        this._colocate = false;
        try {
            int n = dataReplication.getEncryptionType().getValue();
            String string3 = dataReplication.getEncryptionKeyValue();
            if (n != 0 && !string3.equalsIgnoreCase("")) {
                this._useEncryption = true;
                this._drsCrypto = new DRSCrypto(n == 2, DRSCrypto.getSecretKey(dataReplication.getEncryptionKeyValue()));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this._broadcastGroup = new DRSGroup(this._name);
        this._messageHelper = new DRSMessageHelper(this._useEncryption, this._drsCrypto);
        this._buddyManager = new DRSBuddyManager(this._numOfReplicas, this._drsInstances, string, this._broadcastGroup, this._messageHelper, this._sentMessageStats, this._pendingSecondaryGroups);
        this._agentClassEvents = new DRSAgentClassEvents(this);
        if (Boolean.getBoolean("ENABLE_DRS_STATS_LOGGING")) {
            this.kickoffStatsLogger();
        }
        this._pendingBootstrapResponses = new HashMap();
        if (this.tc.isEntryEnabled()) {
            Tr.exit(this.tc, string2 + "Exit. _numOfReplicas=" + this._numOfReplicas + " _requestTimeout=" + this._requestTimeout + " useEncryption=" + this._useEncryption);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            stringBuffer.append("DRSDomain: ").append("\nhashcode=").append(this.hashCode()).append("\n_name=").append(this._name).append("\n_numOfReplicas=").append(this._numOfReplicas).append("\n_requestTimeout=").append(this._requestTimeout).append("\n_useEncryption=").append(this._useEncryption).append("\n_colocate=").append(this._colocate);
        }
        catch (Exception exception) {
            return "" + exception;
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap removePendingBootstrapResponses(String string) {
        String string2 = "removePendingBootstrapResponses: ";
        HashMap hashMap = null;
        if (this.tc.isEntryEnabled()) {
            Tr.entry(this.tc, string2 + " Entry. domainName=" + this._name + " drsInstanceName=" + string + " pendingBootstrapResponses = " + this._pendingBootstrapResponses);
        }
        HashMap hashMap2 = this._pendingBootstrapResponses;
        synchronized (hashMap2) {
            hashMap = (HashMap)this._pendingBootstrapResponses.remove(string);
        }
        if (this.tc.isEntryEnabled()) {
            Tr.exit(this.tc, string2 + " Exit. pendingBootstrapResponses = " + this._pendingBootstrapResponses);
        }
        return hashMap;
    }

    public boolean getColocate() {
        return this._colocate;
    }

    public void setMode(short s) {
        this._drsMode = s;
        this._buddyManager.setMode(s);
    }

    public short getMode() {
        return this._drsMode;
    }

    public DRSCrypto getDrsCrypto() {
        return this._drsCrypto;
    }

    public String getName() {
        return this._name;
    }

    public int getNumOfReplicas() {
        return this._numOfReplicas;
    }

    public int getRequestTimeout() {
        return this._requestTimeout;
    }

    public boolean useEncryption() {
        return this._useEncryption;
    }

    public int getTransportType() {
        return this._transportType;
    }

    public HashMap getDRSInstances() {
        return this._drsInstances;
    }

    public DRSInstance getDRSInstance(String string) {
        String string2 = "getDrsInstance: ";
        if (this.tc.isEntryEnabled()) {
            Tr.entry(this.tc, string2 + "Entry. domainName=" + this._name + " drsInstanceName=" + string);
        }
        DRSInstance dRSInstance = null;
        dRSInstance = (DRSInstance)this._drsInstances.get(string);
        if (this.tc.isEntryEnabled()) {
            Tr.exit(this.tc, string2 + "Exit. drsInstance=" + dRSInstance);
        }
        return dRSInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDRSInstance(String string, DRSInstance dRSInstance) {
        HashMap hashMap = this._drsInstances;
        synchronized (hashMap) {
            this._drsInstances.put(string, dRSInstance);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDRSInstance(String string) {
        HashMap hashMap = this._drsInstances;
        synchronized (hashMap) {
            this._drsInstances.remove(string);
        }
    }

    public DRSGroup getBroadcastGroup() {
        return this._broadcastGroup;
    }

    public void setBroadcastGroup(DRSGroup dRSGroup) {
        this._broadcastGroup = dRSGroup;
    }

    public DRSAgentClassEvents getAgentClassEvents() {
        return this._agentClassEvents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageReceived(DRSCacheMsgImpl dRSCacheMsgImpl) {
        String string = "messageReceived: ";
        if (this.tc.isEntryEnabled()) {
            Tr.entry(this.tc, string + "Entry. domainName=" + this._name);
        }
        short s = dRSCacheMsgImpl.getAction();
        if (this.tc.isDebugEnabled()) {
            Tr.debug(this.tc, string + "action=" + DRSConstants.getActionString(s));
        }
        switch (s) {
            case 28: {
                this._buddyManager.handleDomainMetricsRequest((DRSDomainMetrics)dRSCacheMsgImpl.objValue);
                if (this.tc.isEntryEnabled()) {
                    Tr.exit(this.tc, string + "Exit after handline domain metrics request.");
                }
                return;
            }
            case 29: {
                this._buddyManager.handleDomainMetricsResponse((DRSDomainMetrics)dRSCacheMsgImpl.objValue);
                if (this.tc.isEntryEnabled()) {
                    Tr.exit(this.tc, string + "Exit after handling domain metrics response.");
                }
                return;
            }
        }
        DRSInstance dRSInstance = this.findBestMessageHandler(dRSCacheMsgImpl.drsInstanceName);
        if (null != dRSInstance) {
            if (dRSInstance.isInstanceShuttingDown()) {
                if (this.tc.isDebugEnabled()) {
                    Tr.debug(this.tc, string + "Instance, " + dRSCacheMsgImpl.drsInstanceName + ", is shutting down.");
                }
            } else {
                if (this.tc.isDebugEnabled()) {
                    Tr.debug(this.tc, string + "Found DRS instance. Calling messageReceived. dcaName=" + dRSInstance.getName());
                }
                dRSInstance.getRecvStack().processRcvMessage(dRSCacheMsgImpl);
            }
        } else {
            if (this.tc.isDebugEnabled()) {
                Tr.debug(this.tc, string + "Did not find matching DRS instance for received message. Will only process bootstrap_requests.");
            }
            if (s == 15) {
                ArrayList arrayList = null;
                HashMap hashMap = this._pendingSecondaryGroups;
                synchronized (hashMap) {
                    arrayList = (ArrayList)this._pendingSecondaryGroups.get(dRSCacheMsgImpl.drsInstanceName);
                }
                if (null != arrayList) {
                    if (this.tc.isDebugEnabled()) {
                        Tr.debug(this.tc, string + "Received bootstrap request for instance:" + dRSCacheMsgImpl.drsInstanceName + " Adding to pending list.");
                    }
                    hashMap = this._pendingBootstrapResponses;
                    synchronized (hashMap) {
                        HashMap<Long, DRSCacheMsgImpl> hashMap2 = (HashMap<Long, DRSCacheMsgImpl>)this._pendingBootstrapResponses.get(dRSCacheMsgImpl.drsInstanceName);
                        if (null == hashMap2) {
                            hashMap2 = new HashMap<Long, DRSCacheMsgImpl>();
                            this._pendingBootstrapResponses.put(dRSCacheMsgImpl.drsInstanceName, hashMap2);
                        }
                        HashMap<Long, DRSCacheMsgImpl> hashMap3 = hashMap2;
                        synchronized (hashMap3) {
                            hashMap2.put(new Long(dRSCacheMsgImpl.instanceID), dRSCacheMsgImpl);
                        }
                    }
                }
            }
        }
        if (this.tc.isEntryEnabled()) {
            Tr.exit(this.tc, string + "Exit.");
        }
    }

    public DRSInstance findBestMessageHandler(String string) {
        String string2 = "findBestMessageHandler: ";
        if (this.tc.isEntryEnabled()) {
            Tr.entry(this.tc, string2 + "Entry. domainName=" + this._name + " Desired drsInstanceName=" + string);
        }
        DRSInstance dRSInstance = null;
        if (this._drsInstances.containsKey(string)) {
            dRSInstance = (DRSInstance)this._drsInstances.get(string);
            if (this.tc.isEntryEnabled()) {
                Tr.exit(this.tc, string2 + "Found exact match:dcaName=" + dRSInstance.getName());
            }
            return dRSInstance;
        }
        if (0 != this._drsMode) {
            Iterator iterator = this._drsInstances.values().iterator();
            while (iterator.hasNext()) {
                dRSInstance = (DRSInstance)iterator.next();
                if (this.tc.isDebugEnabled()) {
                    Tr.debug(this.tc, string2 + "dcaName=" + dRSInstance.getName() + " mode=" + dRSInstance.getDRSMode());
                }
                if (string.indexOf(dRSInstance.getName()) == -1) continue;
                if (this.tc.isEntryEnabled()) {
                    Tr.exit(this.tc, string2 + "Found subset match:dcaName=" + dRSInstance.getName());
                }
                return dRSInstance;
            }
            iterator = this._drsInstances.values().iterator();
            while (iterator.hasNext()) {
                dRSInstance = (DRSInstance)iterator.next();
                if (this.tc.isDebugEnabled()) {
                    Tr.debug(this.tc, string2 + "dcaName=" + dRSInstance.getName() + " mode=" + dRSInstance.getDRSMode());
                }
                if (dRSInstance.getName().indexOf(string) == -1) continue;
                if (this.tc.isEntryEnabled()) {
                    Tr.exit(this.tc, string2 + "Found superset match:dcaName=" + dRSInstance.getName());
                }
                return dRSInstance;
            }
        }
        if (this.tc.isEntryEnabled()) {
            Tr.exit(this.tc, string2 + "Exit. Warning: Match not found. Returning null.");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DRSInstance findBestDRSInstanceForSecondary(String string) {
        String string2 = "findBestDrsInstanceForSecondary: ";
        if (this.tc.isEntryEnabled()) {
            Tr.entry(this.tc, string2 + "Entry. domainName=" + this._name + " Desired drsInstanceName=" + string);
        }
        DRSInstance dRSInstance = null;
        if (this._drsInstances.containsKey(string)) {
            dRSInstance = (DRSInstance)this._drsInstances.get(string);
            if (dRSInstance.getDRSMode() == 1) {
                if (this.tc.isEntryEnabled()) {
                    Tr.exit(this.tc, string2 + "Error: Found exact match when mode is Client-only.");
                }
                return null;
            }
            if (this.tc.isEntryEnabled()) {
                Tr.exit(this.tc, string2 + "Found exact match:dcaName=" + dRSInstance.getName());
            }
            return dRSInstance;
        }
        HashMap hashMap = this._drsInstances;
        synchronized (hashMap) {
            Iterator iterator = this._drsInstances.values().iterator();
            while (iterator.hasNext()) {
                dRSInstance = (DRSInstance)iterator.next();
                if (this.tc.isDebugEnabled()) {
                    Tr.debug(this.tc, string2 + "dcaName=" + dRSInstance.getName() + " mode=" + dRSInstance.getDRSMode());
                }
                if (dRSInstance.getDRSMode() != 2 || string.indexOf(dRSInstance.getName()) == -1) continue;
                if (this.tc.isEntryEnabled()) {
                    Tr.exit(this.tc, string2 + "Found subset match:dcaName=" + dRSInstance.getName());
                }
                return dRSInstance;
            }
        }
        if (this.tc.isEntryEnabled()) {
            Tr.exit(this.tc, string2 + "Exit. rc = null.");
        }
        return null;
    }

    public DRSInstance findDRSInstance(String string) {
        String string2 = "findDrsInstance: ";
        if (this.tc.isEntryEnabled()) {
            Tr.entry(this.tc, string2 + "Entry. domainName=" + this._name + " Desired dcaName=" + string);
        }
        DRSInstance dRSInstance = null;
        dRSInstance = (DRSInstance)this._drsInstances.get(string);
        if (this.tc.isEntryEnabled()) {
            Tr.exit(this.tc, string2 + "Exit. drsInstance = " + dRSInstance);
        }
        return dRSInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList removePendingSecondaryGroups(String string) {
        String string2 = "removePendingSecondaryGroups: ";
        if (this.tc.isEntryEnabled()) {
            Tr.entry(this.tc, string2 + "Entry. domainName=" + this._name + " drsInstanceName=" + string);
        }
        ArrayList arrayList = null;
        HashMap hashMap = this._pendingSecondaryGroups;
        synchronized (hashMap) {
            arrayList = (ArrayList)this._pendingSecondaryGroups.get(string);
            if (null != arrayList) {
                if (this.tc.isDebugEnabled()) {
                    Tr.debug(this.tc, string2 + "Found secondaryGroups for drsInstance.  Removing from table.");
                }
                this._pendingSecondaryGroups.remove(string);
            } else if (this.tc.isDebugEnabled()) {
                Tr.debug(this.tc, string2 + "Did not find any secondaryGroups for drsInstance.");
            }
        }
        if (this.tc.isEntryEnabled()) {
            Tr.exit(this.tc, string2 + "Exit. arrayList=" + arrayList);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DRSGroup removePendingSecondaryGroup(String string, String string2) {
        String string3 = "removePendingSecondaryGroup: ";
        if (this.tc.isEntryEnabled()) {
            Tr.entry(this.tc, string3 + "Entry. domainName=" + this._name + " drsInstanceName=" + string + " groupName=" + string2);
        }
        ArrayList arrayList = null;
        DRSGroup dRSGroup = null;
        boolean bl = false;
        HashMap hashMap = this._pendingSecondaryGroups;
        synchronized (hashMap) {
            ArrayList arrayList2 = arrayList = (ArrayList)this._pendingSecondaryGroups.get(string);
            synchronized (arrayList2) {
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    dRSGroup = (DRSGroup)iterator.next();
                    if (!dRSGroup.getGroupName().equals(string2)) continue;
                    arrayList.remove(dRSGroup);
                    bl = true;
                    break;
                }
            }
        }
        if (this.tc.isEntryEnabled()) {
            Tr.exit(this.tc, string3 + "Exit. Foundgroup=" + bl + " Removed group=" + dRSGroup);
        }
        return dRSGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPendingSecondaryGroup(String string, DRSGroup dRSGroup) {
        String string2 = "addPendingSecondaryGroup: ";
        if (this.tc.isEntryEnabled()) {
            Tr.entry(this.tc, string2 + "Entry. domainName=" + this._name + " drsInstanceName=" + string);
        }
        ArrayList<DRSGroup> arrayList = null;
        HashMap hashMap = this._pendingSecondaryGroups;
        synchronized (hashMap) {
            arrayList = (ArrayList<DRSGroup>)this._pendingSecondaryGroups.get(string);
            if (null == arrayList) {
                if (this.tc.isDebugEnabled()) {
                    Tr.debug(this.tc, string2 + "Creating new arrayList for drsInstance.");
                }
                arrayList = new ArrayList<DRSGroup>();
                arrayList.add(dRSGroup);
                this._pendingSecondaryGroups.put(string, arrayList);
            } else {
                ArrayList<DRSGroup> arrayList2 = arrayList;
                synchronized (arrayList2) {
                    arrayList.add(dRSGroup);
                }
            }
        }
        if (this.tc.isEntryEnabled()) {
            Tr.exit(this.tc, string2 + "Exit. arrayList.size=" + arrayList.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DRSGroup getPendingSecondaryGroupForInstance(String string, String string2) {
        String string3 = "getPendingSecondaryGroupForInstance: ";
        if (this.tc.isEntryEnabled()) {
            Tr.entry(this.tc, string3 + "Entry. domainName=" + this._name + " drsInstanceName=" + string + " groupName=" + string2);
        }
        ArrayList arrayList = null;
        DRSGroup dRSGroup = null;
        HashMap hashMap = this._pendingSecondaryGroups;
        synchronized (hashMap) {
            arrayList = (ArrayList)this._pendingSecondaryGroups.get(string);
            if (null != arrayList) {
                if (this.tc.isDebugEnabled()) {
                    Tr.debug(this.tc, string3 + "Found pendingSecondaryGroupList for instance:" + string + ".");
                }
                ArrayList arrayList2 = arrayList;
                synchronized (arrayList2) {
                    Iterator iterator = arrayList.iterator();
                    while (iterator.hasNext() && !(dRSGroup = (DRSGroup)iterator.next()).getGroupName().equals(string2)) {
                    }
                }
            }
        }
        if (this.tc.isEntryEnabled()) {
            Tr.exit(this.tc, string3 + "Exit. group=" + dRSGroup);
        }
        return dRSGroup;
    }

    public DRSThreadLocal getCurrentThreadGroupKey() {
        return _currentThreadGroupKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setColocate() {
        String string = "setColocate: ";
        if (this.tc.isEntryEnabled()) {
            Tr.entry(this.tc, string + "Entry. domainName=" + this._name);
        }
        DRSInstance dRSInstance = null;
        if (!this._colocate) {
            this._colocate = true;
            _currentThreadGroupKey = new DRSThreadLocal();
            if (this.tc.isDebugEnabled()) {
                Tr.debug(this.tc, string + "_currentThreadGroupKey=" + _currentThreadGroupKey);
            }
            HashMap hashMap = this._drsInstances;
            synchronized (hashMap) {
                if (this.tc.isDebugEnabled()) {
                    Tr.debug(this.tc, string + "_drsInstances.size=" + this._drsInstances.size());
                }
                Iterator iterator = this._drsInstances.values().iterator();
                while (iterator.hasNext()) {
                    dRSInstance = (DRSInstance)iterator.next();
                    if (this.tc.isDebugEnabled()) {
                        Tr.debug(this.tc, string + "dcaName=" + dRSInstance.getName() + " mode=" + dRSInstance.getDRSMode());
                    }
                    dRSInstance.setColocate();
                }
            }
        }
        if (this.tc.isEntryEnabled()) {
            Tr.exit(this.tc, string + "Exit.");
        }
    }

    public DRSBuddyManager getBuddyManager() {
        return this._buddyManager;
    }

    public boolean isInitialized() {
        return this._initialized;
    }

    public void markInitialized() {
        this._initialized = true;
    }

    public void createPrimaryAgents() {
        this.createPrimaryAgents(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createPrimaryAgents(DRSInstance dRSInstance) {
        String string;
        block20: {
            Object object;
            string = "createPrimaryAgents: ";
            if (this.tc.isEntryEnabled()) {
                Tr.entry(this.tc, string + "Entry. domainName=" + this._name + " numPending=" + this._pendingPrimaryAgents.size() + " drsInstance=" + (null == dRSInstance ? "null" : dRSInstance.getName()));
            }
            if (null != dRSInstance) {
                object = this._pendingPrimaryAgents;
                synchronized (object) {
                    if (this.tc.isDebugEnabled()) {
                        Tr.debug(this.tc, string + "Adding instance to pending table.");
                    }
                    this._pendingPrimaryAgents.add(dRSInstance);
                }
            }
            if (this._agentClassEvents.domainMetricsResponsesTimeoutExpired()) {
                if (this.tc.isDebugEnabled()) {
                    Tr.debug(this.tc, string + "Timeout expired.");
                }
                object = this._pendingPrimaryAgents;
                synchronized (object) {
                    while (0 < this._pendingPrimaryAgents.size()) {
                        dRSInstance = (DRSInstance)this._pendingPrimaryAgents.remove(0);
                        if (this.tc.isDebugEnabled()) {
                            Tr.debug(this.tc, string + "Creating primary agents inline. drsInstanceName=" + dRSInstance.getName());
                        }
                        dRSInstance.getDRSGroups().createPrimaryAgents();
                    }
                }
            }
            if (this._agentClassEvents.initiatedDomainMetricsRequest()) {
                if (this.tc.isDebugEnabled()) {
                    Tr.debug(this.tc, string + "Creating Alarm.");
                }
                try {
                    object = "DRSDomain/createPrimaryAgents/run: ";
                    ArrayList arrayList = this.getPendingPrimaryAgents();
                    if (this.tc.isEntryEnabled()) {
                        Tr.entry(this.tc, (String)object + "Entry. task=" + this.hashCode() + " domainName=" + this.getName() + " numPending=" + arrayList.size());
                    }
                    DRSAlarm dRSAlarm = null;
                    dRSAlarm = new DRSAlarm(this, 567L, 0L, new String("createAgents"));
                    dRSAlarm.start();
                    if (this.tc.isDebugEnabled()) {
                        Tr.debug(this.tc, string + "Dispatched creation of primary agents to separate thread. task=" + dRSAlarm.hashCode());
                    }
                }
                catch (Exception exception) {
                    if (!this.tc.isDebugEnabled()) break block20;
                    Tr.debug(this.tc, "Error: Caught exception starting thread task. e=" + exception);
                }
            }
        }
        if (this.tc.isEntryEnabled()) {
            Tr.exit(this.tc, string + "Exit. numPending=" + this._pendingPrimaryAgents.size());
        }
    }

    public DRSMessageHelper getMessageHelper() {
        return this._messageHelper;
    }

    public ArrayList getPendingPrimaryAgents() {
        return this._pendingPrimaryAgents;
    }

    public DRSActionStats getReceiveMessageStats() {
        return this._receiveMessageStats;
    }

    public DRSActionStats getSentMessageStats() {
        return this._sentMessageStats;
    }

    public void removeEntryMembers(LinkedList linkedList) {
        String string = "removeEntryMembers: ";
        if (this.tc.isEntryEnabled()) {
            Tr.entry(this.tc, string + "Entry. domainName=" + this._name + " removedMembers.size=" + linkedList.size());
        }
        if (0 < linkedList.size()) {
            Iterator iterator = this._drsInstances.values().iterator();
            while (iterator.hasNext()) {
                DRSInstance dRSInstance = (DRSInstance)iterator.next();
                if (this.tc.isDebugEnabled()) {
                    Tr.debug(this.tc, string + "dcaName=" + dRSInstance.getName());
                }
                dRSInstance.getDRSEntries().removeEntryMembers(linkedList);
            }
        }
        if (this.tc.isEntryEnabled()) {
            Tr.exit(this.tc, string + "Exit.");
        }
    }

    private void kickoffStatsLogger() {
        block3: {
            String string = "kickoffStatsLogger: ";
            try {
                DRSAlarm dRSAlarm = null;
                Integer n = Integer.getInteger("DRS_STATS_LOGGER_INTERVAL", 60);
                dRSAlarm = new DRSAlarm(this, n.intValue(), 0L, new String("stats"));
                dRSAlarm.start();
                if (this.tc.isDebugEnabled()) {
                    Tr.debug(this.tc, string + "Dispatched stats logger for domain:" + this._name + " task=" + dRSAlarm.hashCode());
                }
            }
            catch (Exception exception) {
                if (!this.tc.isDebugEnabled()) break block3;
                Tr.debug(this.tc, "Error: Caught exception starting thread task. e=" + exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldRetry(int n, Object object) {
        boolean bl = true;
        String string = (String)object;
        if (this.tc.isDebugEnabled()) {
            Tr.debug(this.tc, "Woke up. task=" + this.hashCode() + " domain=" + this._name + " consumer=" + string.toString());
        }
        if (string.equals("stats")) {
            this.getSentMessageStats().printStats();
            this.getReceiveMessageStats().printStats();
        } else if (string.equals("createAgents")) {
            if (this.getAgentClassEvents().domainMetricsResponsesTimeoutExpired()) {
                ArrayList arrayList;
                ArrayList arrayList2 = arrayList = this.getPendingPrimaryAgents();
                synchronized (arrayList2) {
                    while (0 < arrayList.size()) {
                        DRSInstance dRSInstance = (DRSInstance)arrayList.remove(0);
                        if (this.tc.isDebugEnabled()) {
                            Tr.debug(this.tc, "Creating primary agents in thread. drsInstanceName=" + dRSInstance.getName());
                        }
                        dRSInstance.getDRSGroups().createPrimaryAgents();
                    }
                }
                bl = false;
            }
        } else if (this.tc.isDebugEnabled()) {
            Tr.debug(this.tc, "Woke up. task=" + this.hashCode() + " domain=" + this._name + " consumer unknown");
        }
        return bl;
    }
}

