/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.drs;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.models.config.applicationserver.webcontainer.DRSSettings;
import com.ibm.ws.drs.DRSDataXferImpl;
import com.ibm.ws.drs.DRSDomain;
import com.ibm.ws.drs.DRSGlobals;
import com.ibm.ws.drs.managers.DRSBootstrapManager;
import com.ibm.ws.drs.managers.DRSSolicitor;
import com.ibm.ws.drs.model.DRSEntries;
import com.ibm.ws.drs.model.DRSGroup;
import com.ibm.ws.drs.model.DRSGroups;
import com.ibm.ws.drs.pool.DRSPool;
import com.ibm.ws.drs.stack.DRSAsyncAckReceive;
import com.ibm.ws.drs.stack.DRSAsyncAckSend;
import com.ibm.ws.drs.stack.DRSAsyncSend;
import com.ibm.ws.drs.stack.DRSBroadcastGroupSelection;
import com.ibm.ws.drs.stack.DRSClientCallback;
import com.ibm.ws.drs.stack.DRSColocateGroupSelection;
import com.ibm.ws.drs.stack.DRSGenerateAck;
import com.ibm.ws.drs.stack.DRSGetGroupSelection;
import com.ibm.ws.drs.stack.DRSGroupExtraction;
import com.ibm.ws.drs.stack.DRSGroupSelection;
import com.ibm.ws.drs.stack.DRSStack;
import com.ibm.ws.drs.stack.DRSSyncAckReceive;
import com.ibm.ws.drs.stack.DRSSyncAckSend;
import com.ibm.ws.drs.stack.DRSSyncGet;
import com.ibm.ws.drs.utils.DRSConstants;
import com.ibm.wsspi.cluster.Identity;
import com.ibm.wsspi.drs.DRSBootstrap;
import com.ibm.wsspi.drs.DRSCacheMsgListener;
import com.ibm.wsspi.drs.DRSDataXfer;
import com.ibm.wsspi.drs.DRSOverflowListener;
import com.ibm.wsspi.drs.DRSStackLayer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class DRSInstance {
    private static TraceComponent tc = Tr.register(DRSInstance.class.getName(), "DRS", "com.ibm.ws.drs.resources.drs");
    private static boolean _loggedVersion = false;
    private String _name;
    private long _identifier;
    private DRSCacheMsgListener _msgListener;
    private DRSBootstrap _bootstrapAdapter;
    private DRSOverflowListener _overflowListener;
    private DRSDomain _domain = null;
    private short _drsMode = 0;
    private DRSEntries _drsEntries = null;
    private DRSGroups _drsGroups = null;
    private DRSStack _getStack;
    private DRSStack _recvStack;
    private DRSStack _sendStack;
    private DRSStack _broadcastStack;
    private DRSStack _ackStack;
    private DRSStack _globalSendStack;
    private DRSStack _responseStack;
    private DRSPool _dcmPool;
    private DRSDataXfer _ddx = null;
    private HashMap _pendingAcks = null;
    private DRSSolicitor _solicitor = null;
    private DRSBootstrapManager _bootstrapManager = null;
    private Map _miscParms = null;
    private boolean _instanceShuttingDown = false;
    private boolean _removesViaSendStack = false;
    private boolean _singleThreadRcvProc = false;
    private LinkedList _receivedMessageList = new LinkedList();
    private boolean _joinClusterInvoked = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DRSInstance(String string, DRSStackLayer dRSStackLayer, int n, short s, DRSCacheMsgListener dRSCacheMsgListener, DRSBootstrap dRSBootstrap, DRSOverflowListener dRSOverflowListener, DRSSettings dRSSettings, Map map) {
        Cloneable cloneable;
        boolean bl;
        Object object;
        int n2;
        String string2 = "constructor: ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string2 + "Entry. name=" + string + " drsSettings=" + dRSSettings);
        }
        if (tc.isDebugEnabled() && !_loggedVersion) {
            Tr.debug(tc, "CMVC Version 1.16.1.1 7/21/08 12:05:13");
            _loggedVersion = true;
        }
        this._name = string;
        this._msgListener = dRSCacheMsgListener;
        this._bootstrapAdapter = dRSBootstrap;
        this._overflowListener = dRSOverflowListener;
        this._identifier = (long)this.hashCode() + System.currentTimeMillis();
        this._pendingAcks = new HashMap();
        this._miscParms = map;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, string2 + "Getting globals.");
        }
        DRSGlobals dRSGlobals = DRSGlobals.getSingleton();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, string2 + "Getting domain.");
        }
        this._domain = dRSGlobals.getDomain(dRSSettings.getMessageBrokerDomainName());
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, string2 + "_domain=" + this._domain);
        }
        if ((n2 = dRSSettings.getDataReplicationMode().getValue()) == 1) {
            this._drsMode = 1;
        }
        if (n2 == 2) {
            this._drsMode = (short)2;
        }
        if (n2 == 0) {
            this._drsMode = 0;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, string2 + "_drsMode=" + DRSConstants.getDrsModeString(this._drsMode));
        }
        this._drsGroups = new DRSGroups(this);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, string2 + "Instantiating dcm pool.");
        }
        this._dcmPool = new DRSPool(true, "com.ibm.ws.drs.message.DRSCacheMsgImpl", null, 100, "dcmPool");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, string2 + "Instantiating entries and groups.");
        }
        this._drsEntries = new DRSEntries(new Long(this._identifier));
        this._removesViaSendStack = Boolean.getBoolean("DRS_USE_SINGLE_SEND_STACK");
        this._singleThreadRcvProc = Boolean.getBoolean("DRS_USE_SINGLE_THREAD_RCV_PROC");
        if (null != map && map.containsKey(object = "DRS_MISC_PARM_REMOVES_VIA_SEND_STACK")) {
            bl = (Boolean)map.get(object);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string2 + "MiscParm: Accepted key=" + (String)object + " value=" + bl);
            }
            this._removesViaSendStack = bl;
        }
        if (null != map && map.containsKey(object = "DRS_MISC_PARM_SINGLE_THREAD_RCV_PROC")) {
            bl = (Boolean)map.get(object);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string2 + "MiscParm: Accepted key=" + (String)object + " value=" + bl);
            }
            this._singleThreadRcvProc = bl;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, string2 + "Creating stacks.");
        }
        this._responseStack = new DRSStack("responseStack");
        this._responseStack.addTop(new DRSAsyncSend(this._domain.getMessageHelper(), this._domain.getSentMessageStats()));
        if ((n & 0x1000000) != 0) {
            this._responseStack.addTop(dRSStackLayer);
        }
        this._getStack = new DRSStack("getStack");
        this._getStack.addTop(new DRSSyncGet(this));
        if ((n & 0x10) != 0) {
            this._getStack.addTop(dRSStackLayer);
        }
        this._getStack.addTop(new DRSGetGroupSelection(this._domain.getBroadcastGroup(), this._domain.getDRSInstances()));
        this._broadcastStack = new DRSStack("broadcastStack");
        this._broadcastStack.addTop(new DRSAsyncSend(this._domain.getMessageHelper(), this._domain.getSentMessageStats()));
        if ((n & 0x1000) != 0) {
            this._broadcastStack.addTop(dRSStackLayer);
        }
        this._broadcastStack.addTop(new DRSBroadcastGroupSelection(this));
        this._ackStack = new DRSStack("ackStack");
        if ((n & 0x10000) != 0) {
            this._ackStack.addTop(dRSStackLayer);
        }
        if (s == 1) {
            this._ackStack.addTop(new DRSAsyncAckReceive(this));
        }
        if (s == 2) {
            this._ackStack.addTop(new DRSSyncAckReceive(this));
        }
        this._recvStack = new DRSStack("recvStack");
        if (s == 1 || s == 2) {
            this._recvStack.addTop(new DRSAsyncSend(this._domain.getMessageHelper(), this._domain.getSentMessageStats()));
            this._recvStack.addTop(new DRSGenerateAck(this._identifier, this._name, this._domain.getMessageHelper(), this._domain.getSentMessageStats()));
        }
        object = new DRSClientCallback(this);
        this._recvStack.addTop((DRSStackLayer)object);
        if ((n & 0x100) != 0) {
            this._recvStack.addTop(dRSStackLayer);
        }
        this._recvStack.addTop(new DRSGroupExtraction(this));
        this._sendStack = new DRSStack("sendStack");
        if (s == 2) {
            this._sendStack.addTop(new DRSSyncAckSend(this));
        } else {
            this._sendStack.addTop(new DRSAsyncSend(this._domain.getMessageHelper(), this._domain.getSentMessageStats()));
            if (s == 1) {
                this._sendStack.addTop(new DRSAsyncAckSend(this));
            }
        }
        if ((n & 1) != 0) {
            this._sendStack.addTop(dRSStackLayer);
        }
        if (this._domain.getColocate()) {
            this._sendStack.addTop(new DRSColocateGroupSelection(new Long(this._identifier), this._drsEntries, this._drsGroups, this._domain.getCurrentThreadGroupKey()));
        } else {
            this._sendStack.addTop(new DRSGroupSelection(new Long(this._identifier), this._drsEntries, this._drsGroups));
        }
        this._globalSendStack = new DRSStack("globalSendStack");
        if (s == 2) {
            this._globalSendStack.addTop(new DRSSyncAckSend(this));
        } else {
            this._globalSendStack.addTop(new DRSAsyncSend(this._domain.getMessageHelper(), this._domain.getSentMessageStats()));
            if (s == 1) {
                this._globalSendStack.addTop(new DRSAsyncAckSend(this));
            }
        }
        if ((n & 0x100000) != 0) {
            this._globalSendStack.addTop(dRSStackLayer);
        }
        this._globalSendStack.addTop(new DRSBroadcastGroupSelection(this));
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, string2 + "_getStack=" + this._getStack);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, string2 + "_recvStack=" + this._recvStack);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, string2 + "_sendStack=" + this._sendStack);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, string2 + "_broadcastStack=" + this._broadcastStack);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, string2 + "_ackStack=" + this._ackStack);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, string2 + "_globalSendStack=" + this._globalSendStack);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, string2 + "_responseStack=" + this._responseStack);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, string2 + "Creating new ddx.");
        }
        this._ddx = new DRSDataXferImpl(this);
        bl = false;
        if (null != map && map.containsKey("MISC_PARM_SUPPRESS_IMPLICIT_ANNOUNCE")) {
            bl = (Boolean)map.get("MISC_PARM_SUPPRESS_IMPLICIT_ANNOUNCE");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string2 + "MiscParm: suppressImplicitAnnounce=" + bl);
            }
        }
        if (null != this._ddx) {
            ((DRSDataXferImpl)this._ddx).setSuppressImplicitAnnounce(bl);
        }
        boolean bl2 = false;
        if (null != map && map.containsKey("MISC_PARM_JOIN_CLUSTER")) {
            bl2 = (Boolean)map.get("MISC_PARM_JOIN_CLUSTER");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string2 + "MiscParm: joinCluster=" + bl2);
            }
        }
        if (bl2) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string2 + "MiscParm: joinCluster=" + bl2);
            }
            this._joinClusterInvoked = true;
            this.joinWLMCluster();
        }
        this._solicitor = new DRSSolicitor(this._domain.getName(), this._name, this._identifier, this._drsGroups, this._drsEntries, this._dcmPool, this._bootstrapAdapter, this._domain.getMessageHelper(), this._domain.getSentMessageStats());
        ((DRSClientCallback)object).setSolicitor(this._solicitor);
        this._bootstrapManager = new DRSBootstrapManager(this._domain.getName(), this._name, this._identifier, this._drsGroups, this._drsEntries, this._dcmPool, this._bootstrapAdapter, this._broadcastStack, this._drsMode, this._domain.getBroadcastGroup(), this._msgListener);
        ((DRSClientCallback)object).setBootstrapManager(this._bootstrapManager);
        ArrayList arrayList = this._domain.removePendingSecondaryGroups(this._name);
        if (null != arrayList) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string2 + "Processing secondary groups. num=" + arrayList.size());
            }
            cloneable = arrayList;
            synchronized (cloneable) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    DRSGroup dRSGroup = (DRSGroup)arrayList.get(i);
                    this._drsGroups.addSecondaryGroup(dRSGroup);
                    this._domain.getAgentClassEvents().addAgentOwner(dRSGroup.getGroupName(), this);
                    this._solicitor.kickoffSolicitor(dRSGroup);
                }
            }
        }
        cloneable = this._domain.removePendingBootstrapResponses(this._name);
        this._bootstrapManager.setPendingBootstrapResponses((HashMap)cloneable);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string2 + "Exit success. name=" + string);
        }
    }

    public void setColocate() {
        String string = "setColocate: ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry. _name=" + this._name);
        }
        if (this._sendStack.contains(DRSGroupSelection.class.getName())) {
            this._sendStack.swap(new DRSColocateGroupSelection(new Long(this._identifier), this._drsEntries, this._drsGroups, this._domain.getCurrentThreadGroupKey()), DRSGroupSelection.class.getName());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Exit.");
        }
    }

    public String getName() {
        return this._name;
    }

    public long getInstanceId() {
        return this._identifier;
    }

    public DRSEntries getDRSEntries() {
        return this._drsEntries;
    }

    public DRSGroups getDRSGroups() {
        return this._drsGroups;
    }

    public HashMap getPendingAcks() {
        return this._pendingAcks;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            stringBuffer.append("DRSInstance:").append("\n_name=").append(this._name).append("\n_identifier=").append(this._identifier).append("\n_drsMode=").append(DRSConstants.getDrsModeString(this._drsMode)).append("\n_drsEntries=").append(this._drsEntries).append("\n_drsGroups=").append(this._drsGroups).append("\n_pendingAcks.size=").append(this._pendingAcks.size()).append("\n_removesViaSendStack=").append(this._removesViaSendStack).append("\n_singleThreadRcvProc=").append(this._singleThreadRcvProc);
        }
        catch (Throwable throwable) {
            return "Error. Could not append to StringBuffer in DRSInstance.";
        }
        return stringBuffer.toString();
    }

    public DRSDomain getDomain() {
        return this._domain;
    }

    public DRSBootstrap getBootstrapAdapter() {
        return this._bootstrapAdapter;
    }

    public short getDRSMode() {
        return this._drsMode;
    }

    public void setBootstrapAdapter(DRSBootstrap dRSBootstrap) {
        this._bootstrapAdapter = dRSBootstrap;
    }

    public DRSPool getDcmPool() {
        return this._dcmPool;
    }

    public DRSStack getRecvStack() {
        return this._recvStack;
    }

    public DRSStack getSendStack() {
        return this._sendStack;
    }

    public DRSStack getGetStack() {
        return this._getStack;
    }

    public DRSStack getGlobalSendStack() {
        return this._globalSendStack;
    }

    public DRSCacheMsgListener getMsgListener() {
        return this._msgListener;
    }

    public DRSDataXfer getDRSDataXfer() {
        return this._ddx;
    }

    public DRSStack getAckStack() {
        return this._ackStack;
    }

    public DRSStack getBroadcastStack() {
        return this._broadcastStack;
    }

    public DRSStack getResponseStack() {
        return this._responseStack;
    }

    public DRSOverflowListener getOverflowListener() {
        return this._overflowListener;
    }

    public DRSSolicitor getSolicitor() {
        return this._solicitor;
    }

    public DRSBootstrapManager getBootstrapManager() {
        return this._bootstrapManager;
    }

    public Map getMiscParms() {
        return this._miscParms;
    }

    public boolean isInstanceShuttingDown() {
        return this._instanceShuttingDown;
    }

    public boolean joinClusterInvoked() {
        return this._joinClusterInvoked;
    }

    public boolean getRemovesViaSendStack() {
        return this._removesViaSendStack;
    }

    public boolean getSingleThreadRcvProc() {
        return this._singleThreadRcvProc;
    }

    public LinkedList getReceivedMessageList() {
        return this._receivedMessageList;
    }

    public void shutdownInstance() {
        String string = "shutdownInstance: ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry. _name=" + this._name);
        }
        this._instanceShuttingDown = true;
        DRSGroups dRSGroups = this.getDRSGroups();
        dRSGroups.shutdownInstanceGroups();
        this._solicitor.shutdownSolicitor();
        this._bootstrapManager.shutdownBootstrapManager();
        this._getStack.shutdownStack();
        this._recvStack.shutdownStack();
        this._sendStack.shutdownStack();
        this._broadcastStack.shutdownStack();
        this._ackStack.shutdownStack();
        this._globalSendStack.shutdownStack();
        this._responseStack.shutdownStack();
        this._domain.removeDRSInstance(this._name);
        this._msgListener = null;
        this._bootstrapAdapter = null;
        this._overflowListener = null;
        this._pendingAcks = null;
        this._drsEntries = null;
        this._drsGroups = null;
        this._getStack = null;
        this._recvStack = null;
        this._sendStack = null;
        this._broadcastStack = null;
        this._ackStack = null;
        this._globalSendStack = null;
        this._responseStack = null;
        this._solicitor = null;
        this._bootstrapManager = null;
        this._dcmPool = null;
        this._ddx = null;
        this._name = null;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Exit.");
        }
    }

    private void joinWLMCluster() {
        String string = "joinWLMCluster: ";
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry. index=" + 1);
        }
        String string2 = AdminServiceFactory.getAdminService().getProcessName();
        String string3 = this.getName();
        Long l = new Long(this.getInstanceId());
        String string4 = l.toString().substring(7);
        String string5 = string2 + "\\" + string3 + "\\" + string4 + "\\" + 1;
        short s = this.getDRSMode();
        String string6 = new Short(s).toString();
        hashMap.put("_ham.serverid", DRSGlobals.getSingleton().getHamServerId());
        hashMap.put("drs_agent_id", string5);
        hashMap.put("drs_inst_id", l.toString());
        hashMap.put("drs_inst_name", this.getName());
        hashMap.put("drs_mode", string6);
        hashMap.put("ibm_agent.seq", "1");
        Identity identity = DRSGlobals.getSingleton().getMbd().joinWLMCluster(hashMap);
        this._drsGroups.addWLMIdentity(hashMap, identity);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Exit. agentId=" + hashMap);
        }
    }
}

