/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.drs.managers;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.drs.DRSGlobals;
import com.ibm.ws.drs.message.DRSBootstrapMsgImpl;
import com.ibm.ws.drs.message.DRSCacheMsgImpl;
import com.ibm.ws.drs.model.DRSEntries;
import com.ibm.ws.drs.model.DRSGroup;
import com.ibm.ws.drs.model.DRSGroups;
import com.ibm.ws.drs.pool.DRSPool;
import com.ibm.ws.drs.pool.DRSPoolElementIntf;
import com.ibm.ws.drs.stack.DRSStack;
import com.ibm.ws.drs.utils.DRSAlarm;
import com.ibm.ws.drs.utils.DRSAlarmInterface;
import com.ibm.ws.drs.utils.DRSConstants;
import com.ibm.wsspi.drs.DRSBootstrap;
import com.ibm.wsspi.drs.DRSBootstrapMsg;
import com.ibm.wsspi.drs.DRSCacheMsg;
import com.ibm.wsspi.drs.DRSCacheMsgListener;
import com.ibm.wsspi.drs.DRSEventObject;
import com.ibm.wsspi.drs.DRSJvmId;
import com.ibm.wsspi.hamanager.GroupMemberId;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public class DRSBootstrapManager
implements DRSAlarmInterface {
    private static TraceComponent tc = Tr.register(DRSBootstrapManager.class.getName(), "DRS", "com.ibm.ws.drs.resources.drs");
    private static boolean _loggedVersion = false;
    private String _domainName = null;
    private String _drsInstanceName = null;
    private long _drsInstanceId = 0L;
    private DRSBootstrap _bootstrapAdapter = null;
    private DRSStack _broadcastStack = null;
    private DRSGroups _groups = null;
    private DRSEntries _entries = null;
    private int _numReceivedBootstrapResponses = 0;
    private boolean _minimalBootstrapComplete = false;
    private DRSPool _dcmPool = null;
    private short _mode = 0;
    private DRSCacheMsgListener _msgListener = null;
    private boolean _initiatedBootstrap = false;
    private DRSGroup _broadcastGroup = null;
    private HashMap _pendingBootstrapResponses = null;
    private LinkedList _registeredIdentities = null;
    private DRSAlarm _bootstrapAlarm = null;

    public DRSBootstrapManager(String string, String string2, long l, DRSGroups dRSGroups, DRSEntries dRSEntries, DRSPool dRSPool, DRSBootstrap dRSBootstrap, DRSStack dRSStack, short s, DRSGroup dRSGroup, DRSCacheMsgListener dRSCacheMsgListener) {
        if (tc.isDebugEnabled() && !_loggedVersion) {
            Tr.debug(tc, "CMVC Version 1.21 4/21/06 10:05:21");
            _loggedVersion = true;
        }
        this._domainName = string;
        this._drsInstanceName = string2;
        this._drsInstanceId = l;
        this._groups = dRSGroups;
        this._entries = dRSEntries;
        this._dcmPool = dRSPool;
        this._mode = s;
        this._bootstrapAdapter = dRSBootstrap;
        this._broadcastStack = dRSStack;
        this._broadcastGroup = dRSGroup;
        this._msgListener = dRSCacheMsgListener;
        this._registeredIdentities = new LinkedList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initiateBootstrap() {
        String string = "initiateBootstrap: ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry. drsInstanceName=" + this._drsInstanceName + " mode=" + DRSConstants.getDrsModeString(this._mode));
        }
        if (DRSGlobals.getSingleton().getDomain(this._domainName).getDRSInstance(this._drsInstanceName).isInstanceShuttingDown()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, string + "Exit. Instance, " + this._drsInstanceName + ", shutting down. ");
            }
            return;
        }
        if (this._initiatedBootstrap || 2 == this._mode) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, string + "Exit. Server-only DRS OR Bootstrap performed previously.");
            }
            return;
        }
        this._initiatedBootstrap = true;
        DRSCacheMsgImpl dRSCacheMsgImpl = (DRSCacheMsgImpl)this._dcmPool.get();
        dRSCacheMsgImpl.populateContents(this._domainName, this._drsInstanceId, this._drsInstanceName, (short)15, null, null, null);
        DRSBootstrapMsgImpl dRSBootstrapMsgImpl = new DRSBootstrapMsgImpl();
        dRSBootstrapMsgImpl._isSolicit = false;
        dRSBootstrapMsgImpl.mode = this._mode;
        dRSBootstrapMsgImpl.instanceId = this._drsInstanceId;
        dRSBootstrapMsgImpl.gmi = null;
        if (0 == this._mode) {
            dRSBootstrapMsgImpl.primaryAgentIdMaps = this._groups.getWLMIdentityMaps();
        }
        this._bootstrapAdapter.bootstrapRequest(dRSBootstrapMsgImpl);
        dRSCacheMsgImpl.objValue = dRSBootstrapMsgImpl;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, string + "Initiating bootstrap. Using dbm:" + dRSBootstrapMsgImpl);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, string + "Sending client bootstrap message via bootstrapStack.");
        }
        try {
            dRSCacheMsgImpl = (DRSCacheMsgImpl)this._broadcastStack.processSendMessage(dRSCacheMsgImpl);
        }
        catch (Throwable throwable) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + "Error. Caught throwable. t=" + throwable);
            }
        }
        finally {
            this._dcmPool.ret(dRSCacheMsgImpl);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, string + "Number of expected responses=" + this._broadcastGroup.getNumGroupMembers());
        }
        if (null != this._pendingBootstrapResponses) {
            this.dispatchBootstrapResponses();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Exit.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchBootstrapResponses() {
        HashMap hashMap = this._pendingBootstrapResponses;
        synchronized (hashMap) {
            Iterator iterator = this._pendingBootstrapResponses.values().iterator();
            DRSCacheMsg dRSCacheMsg = null;
            while (iterator.hasNext()) {
                dRSCacheMsg = (DRSCacheMsg)iterator.next();
                this.handleBootstrapRequest((DRSBootstrapMsgImpl)dRSCacheMsg.getObjValue(), (GroupMemberId[])dRSCacheMsg.getReturnAddress());
            }
        }
        this._pendingBootstrapResponses = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleBootstrapRequest(DRSBootstrapMsgImpl dRSBootstrapMsgImpl, GroupMemberId[] groupMemberIdArray) {
        Object object;
        Object object2;
        String string = "handleBootstrapRequest: ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry. drsInstanceName=" + this._drsInstanceName + " dbm: " + dRSBootstrapMsgImpl + "\ndestinationAddress: " + groupMemberIdArray);
        }
        if (0 == this._mode && null != dRSBootstrapMsgImpl.primaryAgentIdMaps) {
            object2 = dRSBootstrapMsgImpl.primaryAgentIdMaps.iterator();
            while (object2.hasNext()) {
                object = (Map)object2.next();
                if (!this.mayRegisterInterest((Map)object)) continue;
                DRSGlobals.getSingleton().getMbd().registerInterestWithWLMCluster((Map)object, this._groups.getClusterObserver());
            }
        }
        object2 = (DRSCacheMsgImpl)this._dcmPool.get();
        ((DRSCacheMsgImpl)object2).populateContents(this._domainName, this._drsInstanceId, this._drsInstanceName, (short)21, null, null, null);
        ((DRSCacheMsgImpl)object2).destinationAddress = groupMemberIdArray;
        dRSBootstrapMsgImpl._destinationGMIDs = groupMemberIdArray;
        dRSBootstrapMsgImpl._jvmId = new DRSJvmId(DRSGlobals.getSingleton().getMyGMID(), "", false);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, string + "Attached new jvmId object.");
        }
        if (1 != this._mode) {
            dRSBootstrapMsgImpl.myKeys.addAll(this._entries.getReplicaEntryKeys());
        }
        if (0 == this._mode) {
            dRSBootstrapMsgImpl.primaryAgentIdMaps = this._groups.getWLMIdentityMaps();
        }
        ((DRSCacheMsgImpl)object2).objValue = dRSBootstrapMsgImpl;
        object = dRSBootstrapMsgImpl.getComponentData();
        dRSBootstrapMsgImpl.setComponentData(null);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, string + " Sending initial bootstrap response - dbm:" + dRSBootstrapMsgImpl);
        }
        try {
            object2 = (DRSCacheMsgImpl)this._broadcastStack.processSendMessage((DRSCacheMsg)object2);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + "Calling consumer DRSBootstrapAdapter.");
            }
            dRSBootstrapMsgImpl.myKeys = null;
            dRSBootstrapMsgImpl.primaryAgentIdMaps = null;
            dRSBootstrapMsgImpl.setComponentData((Serializable)object);
            this._bootstrapAdapter.handleBootstrapRequest(dRSBootstrapMsgImpl);
            if (null != dRSBootstrapMsgImpl.getComponentData()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string + "Sending consumer bootstrap data now.");
                }
                object2 = (DRSCacheMsgImpl)this._broadcastStack.processSendMessage((DRSCacheMsg)object2);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + "No consumer bootstrap data provided.");
            }
        }
        catch (Throwable throwable) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + "Error. Caught throwable. t=" + throwable);
            }
            if (tc.isDebugEnabled()) {
                throwable.printStackTrace();
            }
        }
        finally {
            this._dcmPool.ret((DRSPoolElementIntf)object2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Exit success. ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleBootstrapResponse(DRSCacheMsgImpl dRSCacheMsgImpl) {
        Object object;
        String string = "handleBootstrapResponse: ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry. drsInstanceName=" + this._drsInstanceName + " dcm: " + dRSCacheMsgImpl);
        }
        Object object2 = this;
        synchronized (object2) {
            ++this._numReceivedBootstrapResponses;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, string + "Number of received bootstrap responses: " + this._numReceivedBootstrapResponses);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, string + "Number of members in the datastack: " + this._broadcastGroup.getNumGroupMembers());
        }
        object2 = (DRSBootstrapMsgImpl)dRSCacheMsgImpl.objValue;
        if (null != ((DRSBootstrapMsgImpl)object2).primaryAgentIdMaps) {
            object = ((DRSBootstrapMsgImpl)object2).primaryAgentIdMaps.iterator();
            while (object.hasNext()) {
                Map map = (Map)object.next();
                if (!this.mayRegisterInterest(map)) continue;
                DRSGlobals.getSingleton().getMbd().registerInterestWithWLMCluster(map, this._groups.getClusterObserver());
            }
        }
        if (null != ((DRSBootstrapMsgImpl)object2).myKeys) {
            this._entries.addHouserGMID(((DRSBootstrapMsgImpl)object2).myKeys, dRSCacheMsgImpl.getSenderServerID(), dRSCacheMsgImpl.destinationAddress[0]);
        }
        this._bootstrapAdapter.bootstrapResponse((DRSBootstrapMsg)object2);
        object = this;
        synchronized (object) {
            if (!this._minimalBootstrapComplete) {
                Tr.audit(tc, "drs.launched", this._drsInstanceName);
                this._minimalBootstrapComplete = true;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string + "Setting HAM flag up.");
                }
                this._groups.setHamUp();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string + "Low or medium watermark. Setting congested false.");
                }
                this._groups.setTransportIsCongested(false);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string + "Calling DCMListener with event REPLICATION IS UP");
                }
                this._msgListener.event(new DRSEventObject(1, this));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Exit success. ");
        }
    }

    public void kickoffBootstrap() {
        block6: {
            String string = "kickoffBootstrap: ";
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, string + " Entry. drsInstanceName=" + this._drsInstanceName);
            }
            if (this._initiatedBootstrap) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, string + " Looks like a bootstrap is already in progress. Exit.");
                }
                return;
            }
            try {
                this.initiateBootstrap();
                this._bootstrapAlarm = new DRSAlarm(this, 8000L, 4000L, null);
                this._bootstrapAlarm.start();
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, string + "Exit. Dispatched bootstrapManager thread. task=" + this._bootstrapAlarm.hashCode() + " DRS Instance:" + this._drsInstanceName);
                }
            }
            catch (Exception exception) {
                if (!tc.isEntryEnabled()) break block6;
                Tr.exit(tc, "Exit. Error: Caught exception starting thread task. e=" + exception);
            }
        }
    }

    public boolean hasInitiatedBootstrap() {
        return this._initiatedBootstrap;
    }

    public boolean isMinimalBootstrapComplete() {
        return this._minimalBootstrapComplete;
    }

    public HashMap getPendingBootstrapResponses() {
        return this._pendingBootstrapResponses;
    }

    public void setPendingBootstrapResponses(HashMap hashMap) {
        this._pendingBootstrapResponses = hashMap;
    }

    private boolean mayRegisterInterest(Map map) {
        boolean bl;
        String string = "mayRegisterInterest: ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "Entry. agentIDMap=" + map);
        }
        if (this._registeredIdentities.contains(map)) {
            bl = false;
        } else {
            this._registeredIdentities.addLast(map);
            if (8 < this._registeredIdentities.size()) {
                Map map2 = (Map)this._registeredIdentities.removeFirst();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "List is full. Purged oldest element. purgedMap=" + map2);
                }
            }
            bl = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "Exit. Returning rc=" + bl);
        }
        return bl;
    }

    public void resetBootStrapInitiatedForZ() {
        String string = "resetBootstrapInitiatedForZ";
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, string + "Resetting _initiatedBootstrap for z/OS.");
        }
        this._initiatedBootstrap = false;
    }

    public int getNumReceivedResponses() {
        return this._numReceivedBootstrapResponses;
    }

    public boolean shouldRetry(int n, Object object) {
        boolean bl = false;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Woke up. task=" + this._bootstrapAlarm.hashCode() + " drsInstanceName=" + this._drsInstanceName);
        }
        if (DRSGlobals.getSingleton().getDomain(this._domainName).getDRSInstance(this._drsInstanceName).isInstanceShuttingDown()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "shouldRetry: Exit. Instance, " + this._drsInstanceName + ", shutting down. ");
            }
            return false;
        }
        int n2 = this.getNumReceivedResponses();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Received " + n2 + " responses.  attempts= " + n);
        }
        if (n2 == 0 && n < 3) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Setting _initiatedBootstrap to false.");
            }
            this._initiatedBootstrap = false;
            this.initiateBootstrap();
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public void shutdownBootstrapManager() {
        String string = "shutdownBootstrapManager: ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry. domainName=" + this._domainName);
        }
        this._domainName = null;
        this._drsInstanceName = null;
        this._groups = null;
        this._entries = null;
        this._dcmPool = null;
        this._bootstrapAdapter = null;
        this._broadcastStack = null;
        this._broadcastGroup = null;
        this._msgListener = null;
        this._registeredIdentities = null;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Exit. Success.");
        }
    }
}

