/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.drs.managers;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.drs.DRSGlobals;
import com.ibm.ws.drs.DRSInstance;
import com.ibm.ws.drs.message.DRSCacheMsgImpl;
import com.ibm.ws.drs.message.DRSDomainMetrics;
import com.ibm.ws.drs.message.DRSMessageHelper;
import com.ibm.ws.drs.model.DRSGroup;
import com.ibm.ws.drs.pool.DRSPool;
import com.ibm.ws.drs.utils.DRSActionStats;
import com.ibm.ws.drs.utils.DRSConstants;
import com.ibm.wsspi.hamanager.GroupMemberId;
import com.ibm.wsspi.hamanager.agent.Agent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class DRSBuddyManager {
    private static TraceComponent tc = Tr.register(DRSBuddyManager.class.getName(), "DRS", "com.ibm.ws.drs.resources.drs");
    private static boolean _loggedVersion = false;
    private int _numberOfReplicas = 0;
    private ArrayList _buddyList = null;
    private ArrayList _serverList = null;
    private static HashMap _membershipChangeMessageList = null;
    private String _domainName = null;
    private short _mode;
    private DRSPool _dcmPool;
    private DRSGroup _broadcastGroup = null;
    private HashMap _drsInstances = null;
    private HashMap _buddyDomainMetrics = null;
    private HashMap _secondaryGroups = null;
    private DRSMessageHelper _messageHelper;
    private DRSActionStats _senderStats;

    public DRSBuddyManager(int n, HashMap hashMap, String string, DRSGroup dRSGroup, DRSMessageHelper dRSMessageHelper, DRSActionStats dRSActionStats, HashMap hashMap2) {
        if (tc.isDebugEnabled() && !_loggedVersion) {
            Tr.debug(tc, "CMVC Version 1.11 6/5/06 13:51:04");
            _loggedVersion = true;
        }
        this._buddyList = new ArrayList();
        this._serverList = new ArrayList();
        if (null == _membershipChangeMessageList) {
            _membershipChangeMessageList = new HashMap();
        }
        this._numberOfReplicas = n;
        this._drsInstances = hashMap;
        this._domainName = string;
        this._buddyDomainMetrics = new HashMap();
        this._broadcastGroup = dRSGroup;
        this._messageHelper = dRSMessageHelper;
        this._senderStats = dRSActionStats;
        this._secondaryGroups = hashMap2;
        this._dcmPool = new DRSPool(true, "com.ibm.ws.drs.message.DRSCacheMsgImpl", null, 5, "dcmPool");
    }

    public void setMode(short s) {
        this._mode = s;
    }

    public synchronized int findBestBackupServer(Agent agent, GroupMemberId[] groupMemberIdArray) {
        Object object;
        int n;
        Object object2;
        Object object3;
        int n2;
        String string = "findBestBackupServer: ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry. domainName=" + this._domainName + " numMembers=" + groupMemberIdArray.length + "\nAgent=" + agent);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, string + this.getBuddyListString());
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, string + this.getBuddyDomainMetricsString());
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (n2 = 0; n2 < groupMemberIdArray.length; ++n2) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + "members[" + n2 + "]=" + groupMemberIdArray[n2]);
            }
            object3 = groupMemberIdArray[n2].getMemberProperties();
            object2 = (String)object3.get("_ham.serverid");
            String string2 = (String)object3.get("drs_mode");
            n = new Short(string2).shortValue();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + "memberMode=" + DRSConstants.getDrsModeString((short)n));
            }
            if (n == 1) continue;
            object = new CandidateInfo();
            ((CandidateInfo)object).index = n2;
            ((CandidateInfo)object).hamServerID = object2;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + "Found server. candidateInfo=" + object);
            }
            arrayList.add(object);
        }
        if (0 == arrayList.size()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, string + "Exit. No server-capable candidates in offered member list. Returning HAM_RC_NO_SECONDARY=" + -2);
            }
            return -2;
        }
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            object3 = (CandidateInfo)arrayList.get(n2);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + "i=" + n2 + " candidateInfo=" + object3);
            }
            if (!this._buddyList.contains(((CandidateInfo)object3).hamServerID)) continue;
            object2 = (DRSDomainMetrics)this._buddyDomainMetrics.get(((CandidateInfo)object3).hamServerID);
            ((DRSDomainMetrics)object2).incrementNumberOfSecondaries();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, string + "Exit. Found candidate in buddyList. Returning index " + ((CandidateInfo)object3).index + ". New metrics=" + object2);
            }
            return ((CandidateInfo)object3).index;
        }
        if (this._buddyList.size() < this._numberOfReplicas) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + "Space is available in the buddy list. _buddyList.size=" + this._buddyList.size() + " _numberOfReplicas=" + this._numberOfReplicas);
            }
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            int n3 = 0;
            int n4 = 99999;
            for (n = 0; n < arrayList.size(); ++n) {
                object3 = (CandidateInfo)arrayList.get(n);
                object = (DRSDomainMetrics)this._buddyDomainMetrics.get(((CandidateInfo)object3).hamServerID);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string + "i=" + n + " candidateInfo=" + object3 + " metrics=" + object);
                }
                if (null == object) continue;
                if (((DRSDomainMetrics)object).getNumberOfSecondaries() < n4) {
                    n3 = n;
                    n4 = ((DRSDomainMetrics)object).getNumberOfSecondaries();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, string + "Accepted new secondary. selectedIndex=" + n3 + " selectedNumSecondaries=" + n4);
                    }
                    arrayList2 = new ArrayList();
                    arrayList2.add(object3);
                    continue;
                }
                if (((DRSDomainMetrics)object).getNumberOfSecondaries() != n4) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string + "Accepted additional secondary. selectedIndex=" + n3 + " selectedNumSecondaries=" + n4);
                }
                arrayList2.add(object3);
            }
            if (0 < arrayList2.size()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string + "Selecting random candidate from list. size=" + arrayList2.size());
                }
                object3 = (CandidateInfo)arrayList2.get(DRSGlobals.getSingleton().getRandomInt(arrayList2.size()));
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string + "Using candidate per selected index. selectedIndex=" + n3);
                }
                object3 = (CandidateInfo)arrayList.get(n3);
            }
            DRSDomainMetrics dRSDomainMetrics = (DRSDomainMetrics)this._buddyDomainMetrics.get(((CandidateInfo)object3).hamServerID);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + "Selected candidateInfo=" + object3 + " metrics=" + dRSDomainMetrics);
            }
            if (null != dRSDomainMetrics) {
                dRSDomainMetrics.incrementNumberOfSecondaries();
            } else {
                dRSDomainMetrics = new DRSDomainMetrics(((CandidateInfo)object3).hamServerID, this._mode, 1);
                this._buddyDomainMetrics.put(((CandidateInfo)object3).hamServerID, dRSDomainMetrics);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, string + "Exit. Adding candidate to buddyList. Returning index=" + ((CandidateInfo)object3).index);
            }
            this._buddyList.add(((CandidateInfo)object3).hamServerID);
            return ((CandidateInfo)object3).index;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Exit. No candidates in buddyList. Returning HAM_RC_NO_SECONDARY=" + -2);
        }
        return -2;
    }

    public synchronized int getNumberServerListMembers() {
        return this._serverList.size();
    }

    public synchronized void updateBuddies(GroupMemberId[] groupMemberIdArray) {
        int n;
        String string;
        Map map;
        int n2;
        String string2 = "updateBuddies: ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string2 + "Entry. domainName=" + this._domainName + "\ncurrentMembers.length=" + groupMemberIdArray.length);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, string2 + this.getBuddyListString());
        }
        String string3 = DRSGlobals.getSingleton().getHamServerId();
        for (n2 = 0; n2 < groupMemberIdArray.length; ++n2) {
            map = groupMemberIdArray[n2].getMemberProperties();
            string = (String)map.get("_ham.serverid");
            if (string.equals(string3) || this._serverList.contains(string)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string2 + "New buddy in currentMembers array. buddy=" + string);
            }
            if (!this.logMessage(string, "join")) continue;
            Tr.audit(tc, "drs.membership", string);
            Tr.audit(tc, "drs.active", string);
        }
        this._serverList.clear();
        for (n2 = 0; n2 < groupMemberIdArray.length; ++n2) {
            map = groupMemberIdArray[n2].getMemberProperties();
            string = (String)map.get("_ham.serverid");
            if (string.equals(string3)) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, string2 + "i=" + n2 + " Skipping 'this' server. memberServer=" + string);
                continue;
            }
            String string4 = (String)map.get("drs_mode");
            short s = new Short(string4);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string2 + "i=" + n2 + "memberServer=" + string + " memberMode=" + DRSConstants.getDrsModeString(s));
            }
            if (s == 1) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string2 + "Added non client-only member to list of offered servers.");
            }
            this._serverList.add(string);
        }
        ArrayList arrayList = (ArrayList)this._buddyList.clone();
        for (n = 0; n < arrayList.size(); ++n) {
            string = (String)arrayList.get(n);
            if (!this._serverList.contains(string)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string2 + "Removing server from buddyList. buddy=" + string);
                }
                this._buddyList.remove(string);
                if (!this.logMessage(string, "leave")) continue;
                Tr.audit(tc, "drs.membership", string);
                Tr.audit(tc, "drs.terminated", string);
                continue;
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, string2 + "Preserving server in buddyList. buddy=" + string);
        }
        for (n = 0; n < this._buddyList.size(); ++n) {
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, string2 + "_buddyList[" + n + "]=" + this._buddyList.get(n));
        }
        for (n = 0; n < this._serverList.size(); ++n) {
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, string2 + "_serverList[" + n + "]=" + this._serverList.get(n));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string2 + "Exit.");
        }
    }

    public void initiateDomainMetricRequest() {
        String string = "initiateDomainMetricRequest: ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry. domainName=" + this._domainName);
        }
        this.sendDomainMetricsMessage((short)28);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Exit.");
        }
    }

    public void handleDomainMetricsRequest(DRSDomainMetrics dRSDomainMetrics) {
        String string = "handleDomainMetricsRequest: ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry. domainName=" + this._domainName + " domainMetrics=" + dRSDomainMetrics);
        }
        this.extractDomainMetrics(dRSDomainMetrics);
        this.sendDomainMetricsMessage((short)29);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Exit success. ");
        }
    }

    public void handleDomainMetricsResponse(DRSDomainMetrics dRSDomainMetrics) {
        String string = "handleDomainMetricsResponse: ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry. domainName=" + this._domainName + " domainMetrics=" + dRSDomainMetrics);
        }
        this.extractDomainMetrics(dRSDomainMetrics);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Exit success. ");
        }
    }

    private int getNumberOfSecondaries() {
        int n;
        String string = "getNumberOfSecondaries: ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry. domainName=" + this._domainName);
        }
        int n2 = 0;
        Iterator iterator = this._drsInstances.values().iterator();
        while (iterator.hasNext()) {
            DRSInstance dRSInstance = (DRSInstance)iterator.next();
            n = dRSInstance.getDRSGroups().getNumberOfSecondaries();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + "dcaName=" + dRSInstance.getName() + " numInstanceSecondaries=" + n);
            }
            n2 += n;
        }
        iterator = this._secondaryGroups.values().iterator();
        while (iterator.hasNext()) {
            ArrayList arrayList = (ArrayList)iterator.next();
            n = arrayList.size();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + "numInstanceSecondaries=" + n);
            }
            n2 += n;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Exit. numSecondaries=" + n2);
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void sendDomainMetricsMessage(short s) {
        byte[] byArray;
        String string = "sendDomainMetricsMessage: ";
        DRSDomainMetrics dRSDomainMetrics = new DRSDomainMetrics(DRSGlobals.getSingleton().getHamServerId(), this._mode, this.getNumberOfSecondaries());
        DRSCacheMsgImpl dRSCacheMsgImpl = (DRSCacheMsgImpl)this._dcmPool.get();
        dRSCacheMsgImpl.populateContents(this._domainName, 0L, null, s, null, null, dRSDomainMetrics);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, string + "Sending domain metric request. domainName=" + this._domainName + " domainMetrics=" + dRSDomainMetrics);
        }
        if (null != (byArray = this._messageHelper.getSerializedForm(dRSCacheMsgImpl))) {
            this._senderStats.update(dRSCacheMsgImpl.getAction());
            try {
                this._broadcastGroup.send(byArray);
                return;
            }
            catch (Throwable throwable) {
                if (!tc.isDebugEnabled()) return;
                Tr.debug(tc, string + "Error. Caught throwable. t=" + throwable);
                return;
            }
            finally {
                this._dcmPool.ret(dRSCacheMsgImpl);
            }
        } else {
            this._dcmPool.ret(dRSCacheMsgImpl);
            if (!tc.isDebugEnabled()) return;
            Tr.debug(tc, string + "Serialization failed, message not sent.");
        }
    }

    private void extractDomainMetrics(DRSDomainMetrics dRSDomainMetrics) {
        String string = "extractDomainMetrics: ";
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, string + "Adding domain metric to list. domainName=" + this._domainName + " domainMetrics=" + dRSDomainMetrics);
        }
        this._buddyDomainMetrics.put(dRSDomainMetrics.getHamServerID(), dRSDomainMetrics);
    }

    private String getBuddyListString() {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            stringBuffer.append("_buddyList: ");
            for (int i = 0; i < this._buddyList.size(); ++i) {
                stringBuffer.append("\ni=").append(i).append(" server=").append(this._buddyList.get(i));
            }
        }
        catch (Exception exception) {
            return "_buddyList " + exception;
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfBuddies() {
        ArrayList arrayList = this._buddyList;
        synchronized (arrayList) {
            return this._buddyList.size();
        }
    }

    private String getBuddyDomainMetricsString() {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            stringBuffer.append("_buddyDomainMetrics: ").append("\n_domainName=").append(this._domainName);
            Iterator iterator = this._buddyDomainMetrics.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                DRSDomainMetrics dRSDomainMetrics = (DRSDomainMetrics)this._buddyDomainMetrics.get(string);
                stringBuffer.append("\nserver=").append(string).append("\nmetrics=").append(dRSDomainMetrics);
            }
        }
        catch (Exception exception) {
            return "_buddyDomainMetrics " + exception;
        }
        return stringBuffer.toString();
    }

    private boolean logMessage(String string, String string2) {
        boolean bl = false;
        Integer n = Integer.getInteger("DRS_MEMBERSHIP_CHANGE_LOG_THRESHOLD", 10000);
        int n2 = n;
        if (!_membershipChangeMessageList.containsKey(string + "/" + string2)) {
            _membershipChangeMessageList.put(string + "/" + string2, new Long(System.currentTimeMillis()));
            bl = true;
        } else {
            long l = (Long)_membershipChangeMessageList.get(string + "/" + string2);
            if (System.currentTimeMillis() - l > (long)n2) {
                bl = true;
            }
        }
        return bl;
    }

    private class CandidateInfo {
        public int index;
        public String hamServerID;

        private CandidateInfo() {
        }

        public String toString() {
            return "CandidateInfo: index=" + this.index + " hamServerID=" + this.hamServerID;
        }
    }
}

