/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.drs.message;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.drs.message.DRSByteStream;
import com.ibm.ws.drs.pool.DRSByteArrayPoolSet;
import com.ibm.ws.drs.pool.DRSPoolElementImpl;
import com.ibm.ws.drs.pool.DRSPoolElementIntf;
import com.ibm.ws.drs.utils.DRSUtils;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.ByteArrayInputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;

public class DRSBuffWrapper
extends DRSPoolElementImpl
implements Externalizable {
    private static final long serialVersionUID = -8795688920797285138L;
    private byte[] _buf;
    private DRSByteStream _byteStream;
    private ObjectOutputStream _oos;
    private static TraceComponent tc = Tr.register(DRSBuffWrapper.class.getName(), "DRS", "com.ibm.ws.drs.resources.drs");
    private static boolean _loggedVersion = false;
    private static long _numObjectsInstantiated = 0L;

    public DRSBuffWrapper() throws IOException {
        if (tc.isDebugEnabled() && !_loggedVersion) {
            Tr.debug(tc, "CMVC Version 1.15 5/19/05 11:33:13");
            _loggedVersion = true;
        }
        ++_numObjectsInstantiated;
    }

    public DRSBuffWrapper(DRSByteArrayPoolSet dRSByteArrayPoolSet) throws IOException {
        if (tc.isDebugEnabled() && !_loggedVersion) {
            Tr.debug(tc, "CMVC Version 1.15 5/19/05 11:33:13");
            _loggedVersion = true;
        }
        this._byteStream = new DRSByteStream(dRSByteArrayPoolSet);
        this._oos = new ObjectOutputStream(this._byteStream);
        ++_numObjectsInstantiated;
    }

    public byte[] getByteArray() {
        if (this._byteStream != null) {
            return this._byteStream.byteArray();
        }
        return this._buf;
    }

    public byte[] getByteArrayClone() {
        if (this._byteStream != null) {
            return this._byteStream.byteArrayClone();
        }
        byte[] byArray = new byte[this._buf.length];
        System.arraycopy(this._buf, 0, byArray, 0, this._buf.length);
        return byArray;
    }

    public int getByteArrayLength() {
        if (this._byteStream != null) {
            return this._byteStream.count();
        }
        return this._buf.length;
    }

    public boolean storeObject(Object object) {
        try {
            if (this._oos != null) {
                this._oos.writeObject(object);
            } else {
                this._buf = DRSUtils.getBytes(object);
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.drs.message.DRSBuffWrapper.storeObject", "1", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "storeObject: Exception while trying to serialize, t=" + throwable);
            }
            return false;
        }
        return true;
    }

    public Object retrieveObject() {
        Object object;
        block2: {
            object = null;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this._byteStream.byteArrayClone());
            ObjectInputStream objectInputStream = null;
            try {
                objectInputStream = new ObjectInputStream(byteArrayInputStream);
                object = objectInputStream.readObject();
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.drs.message.DRSBuffWrapper.retrieveObject", "1", this);
                if (!tc.isDebugEnabled()) break block2;
                Tr.debug(tc, "retrieveObject: Exception while trying to deserialize, t=" + throwable);
            }
        }
        return object;
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        if (this._byteStream != null) {
            this._byteStream.write(objectInput, n);
        } else {
            this._buf = new byte[n];
            int n2 = 0;
            for (int i = 0; i < n; i += n2) {
                n2 = objectInput.read(this._buf, i, n - i);
                if (n2 != -1) continue;
                throw new IOException("Could not retrieve ");
            }
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        if (this._byteStream != null) {
            objectOutput.writeInt(this._byteStream.count());
            objectOutput.write(this._byteStream.byteArray(), 0, this._byteStream.count());
        } else {
            objectOutput.writeInt(this._buf.length);
            objectOutput.write(this._buf);
        }
    }

    public DRSPoolElementIntf getNewInstance() {
        Tr.error(tc, "DRSBuffWrapper/getNewInstance: Error: This method should never be called for this object type.  Whenever a dcm is created, it must be passed a DRSByteArrayPoolSet object as a parameter.  This method is here only to satisfy the interface");
        return null;
    }

    public DRSPoolElementIntf getNewInstance(Object object) {
        DRSBuffWrapper dRSBuffWrapper = null;
        try {
            dRSBuffWrapper = new DRSBuffWrapper((DRSByteArrayPoolSet)object);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            Tr.error(tc, "drs.throwable", iOException);
        }
        return dRSBuffWrapper;
    }

    public void refreshContents() {
        String string = "refreshContents: ";
        if (this._byteStream != null) {
            try {
                this._oos.reset();
                this._byteStream.reset();
            }
            catch (IOException iOException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string + "IOException Thrown e=" + iOException);
                }
                iOException.printStackTrace();
                Tr.error(tc, "drs.throwable", iOException);
            }
        } else {
            this._buf = null;
        }
    }

    public void releaseContents() {
        if (this._byteStream != null) {
            this._byteStream.reset();
            this._byteStream = null;
            this._oos = null;
        } else {
            this._buf = null;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            stringBuffer.append("DRSBuffWrapper:").append("\n\t_numUses=").append(this.getNumUses()).append("\n\t_buf=").append(this._buf).append("\n\t_byteStream=").append(this._byteStream).append("\n\t_oos=").append(this._oos).append("\n\t_numObjectsInstantiated=").append(_numObjectsInstantiated);
        }
        catch (Throwable throwable) {
            return "Error. Could not append to StringBuffer in DRSBuffWrapper.";
        }
        return stringBuffer.toString();
    }
}

