/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.drs.message;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.drs.pool.DRSByteArrayPoolSet;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.OutputStream;

public class DRSByteStream
extends OutputStream {
    TraceComponent tc = Tr.register(DRSByteStream.class.getName(), "DRS", "com.ibm.ws.drs.resources.drs");
    private static boolean _loggedVersion = false;
    private byte[] _buf;
    private byte[] _backupBuf = null;
    private int _count = 0;
    private int _backupCount = 0;
    private DRSByteArrayPoolSet _bytePool;
    private static long _numObjectsInstantiated = 0L;

    public DRSByteStream(DRSByteArrayPoolSet dRSByteArrayPoolSet) {
        this(dRSByteArrayPoolSet, 4);
    }

    public DRSByteStream(DRSByteArrayPoolSet dRSByteArrayPoolSet, int n) {
        if (this.tc.isDebugEnabled() && !_loggedVersion) {
            Tr.debug(this.tc, "CMVC Version 1.6 4/2/05 11:25:29");
            _loggedVersion = true;
        }
        this._bytePool = dRSByteArrayPoolSet;
        if (n < 0) {
            throw new IllegalArgumentException("Negative initial size: " + n);
        }
        this._buf = new byte[n];
        ++_numObjectsInstantiated;
    }

    public synchronized void write(int n) throws IOException {
        int n2 = this._count + 1;
        if (n2 > this._buf.length) {
            this.growByteArray(Math.max(this._buf.length << 1, n2));
        }
        this._buf[this._count] = (byte)n;
        this._count = n2;
    }

    public synchronized void write(byte[] byArray, int n, int n2) {
        if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return;
        }
        int n3 = this._count + n2;
        if (n3 > this._buf.length) {
            this.growByteArray(Math.max(this._buf.length << 1, n3));
        }
        System.arraycopy(byArray, n, this._buf, this._count, n2);
        this._count = n3;
    }

    public synchronized void write(ObjectInput objectInput, int n) throws IOException {
        if (n < 0) {
            throw new IllegalArgumentException("Negative length: " + n);
        }
        int n2 = this._count + n;
        if (n2 > this._buf.length) {
            this.growByteArray(Math.max(this._buf.length << 1, n2));
        }
        int n3 = 0;
        for (int i = this._count; i < n2; i += n3) {
            n3 = objectInput.read(this._buf, i, n2 - i);
            if (n3 != -1) continue;
            throw new IOException("Could not read in from ObjectInput.");
        }
        this._count = n2;
    }

    public synchronized void reset() {
        if (this._backupBuf != null) {
            this._bytePool.retByteArray(this._buf);
            this._buf = this._backupBuf;
            this._count = this._backupCount;
            this._backupBuf = null;
            this._backupCount = 0;
        }
    }

    public synchronized byte[] byteArray() {
        return this._buf;
    }

    public synchronized byte[] byteArrayClone() {
        byte[] byArray = new byte[this._count];
        System.arraycopy(this._buf, 0, byArray, 0, this._count);
        return byArray;
    }

    public synchronized int size() {
        return this._buf.length;
    }

    public int count() {
        return this._count;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            stringBuffer.append("DRSByteStream:").append("\n_buf=").append(this._buf).append("\n_buf.length=").append(null == this._buf ? "n/a" : "" + this._buf.length).append("\n_count=").append(this._count).append("\n_backupBuf=").append(this._backupBuf).append("\n_backupBuf.length=").append(null == this._backupBuf ? "n/a" : "" + this._backupBuf.length).append("\n_backupCount=").append(this._backupCount).append("\n_bytePool=").append(null == this._bytePool ? "null" : "instantiated").append("\n_numObjectsInstantiated=").append(_numObjectsInstantiated);
        }
        catch (Throwable throwable) {
            return "Error. Could not append to StringBuffer in DRSByteStream.";
        }
        return stringBuffer.toString();
    }

    private void growByteArray(int n) {
        boolean bl;
        if (n < 0 || n < this._buf.length || this._count > this._buf.length) {
            throw new IllegalArgumentException("Illegal Arguments: size=" + n + " _count=" + this._count);
        }
        if (this._backupBuf == null) {
            this._backupBuf = this._buf;
            this._backupCount = this._count;
            bl = false;
        } else {
            bl = true;
        }
        byte[] byArray = this._bytePool.getByteArray(n);
        System.arraycopy(this._buf, 0, byArray, 0, this._count);
        if (bl) {
            this._bytePool.retByteArray(this._buf);
        }
        this._buf = byArray;
    }
}

