/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.drs.message;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.drs.message.DRSBuffWrapper;
import com.ibm.ws.drs.message.DRSCacheMsgImpl;
import com.ibm.ws.drs.pool.DRSByteArrayPoolSet;
import com.ibm.ws.drs.pool.DRSPool;
import com.ibm.ws.drs.utils.DRSCrypto;
import com.ibm.ws.util.WsObjectInputStream;
import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;

public class DRSMessageHelper {
    private static TraceComponent tc = Tr.register(DRSMessageHelper.class.getName(), "DRS", "com.ibm.ws.drs.resources.drs");
    private static boolean _loggedVersion = false;
    private boolean _useEncryption = false;
    private DRSCrypto _drsCrypto = null;
    private static DRSPool _dbwPool = null;

    public DRSMessageHelper(boolean bl, DRSCrypto dRSCrypto) {
        String string = "constructor: ";
        if (tc.isDebugEnabled() && !_loggedVersion) {
            Tr.debug(tc, "CMVC Version 1.5 8/7/06 07:12:52");
            _loggedVersion = true;
        }
        this._useEncryption = bl;
        this._drsCrypto = dRSCrypto;
        if (_dbwPool == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + "Instantiating byte pool.");
            }
            DRSByteArrayPoolSet dRSByteArrayPoolSet = new DRSByteArrayPoolSet();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + "Instantiating dbw pool.");
            }
            _dbwPool = new DRSPool(true, "com.ibm.ws.drs.message.DRSBuffWrapper", dRSByteArrayPoolSet, 100, "dbwPool");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DRSCacheMsgImpl extractDCM(byte[] byArray) {
        byte[] byArray2;
        String string = "extractDCM: ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry. message.length=" + byArray.length);
        }
        DRSCacheMsgImpl dRSCacheMsgImpl = null;
        ObjectInputStream objectInputStream = null;
        if (this._useEncryption) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + "Decrypting.");
            }
            byArray2 = this._drsCrypto.decrypt(byArray);
        } else {
            byArray2 = byArray;
        }
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + "Converting.");
            }
            objectInputStream = new WsObjectInputStream(new ByteArrayInputStream(byArray2));
            dRSCacheMsgImpl = (DRSCacheMsgImpl)objectInputStream.readObject();
        }
        catch (Throwable throwable) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Error. Caught throwable converting byte array to dcm. t=" + throwable);
            }
            throwable.printStackTrace();
            dRSCacheMsgImpl = null;
        }
        finally {
            if (null != objectInputStream) {
                try {
                    objectInputStream.close();
                }
                catch (Throwable throwable) {}
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Exit. dcm=" + dRSCacheMsgImpl);
        }
        return dRSCacheMsgImpl;
    }

    public byte[] getSerializedForm(DRSCacheMsgImpl dRSCacheMsgImpl) {
        String string = "getSerializedForm: ";
        boolean bl = false;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry. dcm=" + dRSCacheMsgImpl);
        }
        DRSBuffWrapper dRSBuffWrapper = (DRSBuffWrapper)_dbwPool.get();
        bl = dRSBuffWrapper.storeObject(dRSCacheMsgImpl);
        byte[] byArray = null;
        if (bl) {
            byArray = dRSBuffWrapper.getByteArrayClone();
            if (this._useEncryption) {
                byArray = this._drsCrypto.encrypt(byArray);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Error. storeObject returned false, serialization failed.");
        }
        _dbwPool.ret(dRSBuffWrapper);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Exit. Serialized buf[].size=" + byArray.length);
        }
        return byArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            stringBuffer.append("DRSMessageHelper:").append("\n_useEncryption=").append(this._useEncryption).append("\n_drsCrypto=").append(null == this._drsCrypto ? "null" : "instantiated").append("\n_dbwPool=").append(null == _dbwPool ? "null" : "instantiated");
        }
        catch (Throwable throwable) {
            return "Error. Could not append to StringBuffer in DRSDataStackSender.";
        }
        return stringBuffer.toString();
    }
}

