/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.drs.model;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.drs.DRSGlobals;
import com.ibm.ws.drs.model.DRSEntryMetaData;
import com.ibm.ws.drs.model.DRSGroup;
import com.ibm.ws.drs.utils.DRSUtils;
import com.ibm.wsspi.hamanager.GroupMemberId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;

public class DRSEntries {
    private static TraceComponent tc = Tr.register(DRSEntries.class.getName(), "DRS", "com.ibm.ws.drs.resources.drs");
    private static boolean _loggedVersion = false;
    private HashMap _entries = null;
    private Long _drsInstanceID = null;

    public DRSEntries(Long l) {
        if (tc.isDebugEnabled() && !_loggedVersion) {
            Tr.debug(tc, "CMVC Version 1.22 4/2/05 11:25:36");
            _loggedVersion = true;
        }
        this._entries = new HashMap();
        this._drsInstanceID = l;
    }

    public void createEntry(Object object, DRSGroup dRSGroup) {
        this.createEntry(object, dRSGroup, this._drsInstanceID, null);
    }

    public void createEntry(Object object, Long l) {
        this.createEntry(object, null, l, null);
    }

    public void createEntry(Object object, DRSGroup dRSGroup, Long l) {
        this.createEntry(object, dRSGroup, l, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createEntry(Object object, DRSGroup dRSGroup, Long l, HashMap hashMap) {
        String string = "createEntry(4 parms): ";
        DRSEntryMetaData dRSEntryMetaData = new DRSEntryMetaData(object);
        dRSEntryMetaData.setDRSGroup(dRSGroup);
        dRSEntryMetaData.setOwnerDRSInstanceID(l);
        if (null != hashMap) {
            dRSEntryMetaData.setHouserGMIDs(hashMap);
        }
        HashMap hashMap2 = this._entries;
        synchronized (hashMap2) {
            this._entries.put(object, dRSEntryMetaData);
        }
        if (16 > this._entries.size()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + "DRSEntries createEntry done, total table now:\n" + this.toString());
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, string + "DRSEntries createEntry done, numEntries now " + this._entries.size());
        }
    }

    public void updateEntry(Object object, Long l) {
        String string = "updateEntry(long): ";
        DRSEntryMetaData dRSEntryMetaData = this.getExistingEntry(object);
        dRSEntryMetaData.setOwnerDRSInstanceID(l);
        dRSEntryMetaData.setOrphanEntry(false);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, string + "emd=" + dRSEntryMetaData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHouserGMID(ArrayList arrayList, String string, GroupMemberId groupMemberId) {
        String string2 = "addHouserGMID: ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string2 + "Entry. numKeys=" + arrayList.size() + " houserServerName=" + string + " houserGMID=" + groupMemberId);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            Object e2 = arrayList.get(i);
            HashMap hashMap = this._entries;
            synchronized (hashMap) {
                Object object;
                if (!this._entries.containsKey(e2)) {
                    object = new HashMap<String, GroupMemberId>();
                    ((HashMap)object).put(string, groupMemberId);
                    this.createEntry(e2, null, null, (HashMap)object);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, string2 + "entryKey=" + e2 + " emd=" + (DRSEntryMetaData)this._entries.get(e2));
                    }
                } else {
                    object = (DRSEntryMetaData)this._entries.get(e2);
                    HashMap<String, GroupMemberId> hashMap2 = ((DRSEntryMetaData)object).getHouserGMIDsMap();
                    if (hashMap2 == null) {
                        hashMap2 = new HashMap<String, GroupMemberId>();
                        ((DRSEntryMetaData)object).setHouserGMIDs(hashMap2);
                    }
                    hashMap2.put(string, groupMemberId);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, string2 + "entryKey=" + e2 + " emd=" + object);
                    }
                }
                continue;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string2 + "Exit.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createOrUpdateEntries(ArrayList arrayList, HashMap hashMap, Long l) {
        String string = "createOrUpdateEntries(gmid): ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry. numKeys=" + arrayList.size() + " houserGMIDs=" + hashMap);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            Object e2 = arrayList.get(i);
            HashMap hashMap2 = this._entries;
            synchronized (hashMap2) {
                if (!this._entries.containsKey(e2)) {
                    this.createEntry(e2, null, l, hashMap);
                } else {
                    this.updateEntry(e2, null, l, hashMap);
                }
                continue;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Exit.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createOrUpdateEntry(Object object, DRSGroup dRSGroup, Long l) {
        String string = "createOrUpdateEntry: ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry. entryKey=" + object);
        }
        HashMap hashMap = this._entries;
        synchronized (hashMap) {
            if (!this.entryExists(object)) {
                this.createEntry(object, dRSGroup, l);
            } else {
                this.updateEntry(object, dRSGroup);
                this.updateEntry(object, l);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Exit.");
        }
    }

    public void updateEntry(Object object, DRSGroup dRSGroup) {
        String string = "updateEntry(group): ";
        DRSEntryMetaData dRSEntryMetaData = this.getExistingEntry(object);
        dRSEntryMetaData.setDRSGroup(dRSGroup);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, string + "emd=" + dRSEntryMetaData);
        }
    }

    public void updateEntry(Object object, HashMap hashMap) {
        String string = "updateEntry(GMIDs): ";
        DRSEntryMetaData dRSEntryMetaData = this.getExistingEntry(object);
        dRSEntryMetaData.setHouserGMIDs(hashMap);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, string + "emd=" + dRSEntryMetaData);
        }
    }

    public void updateEntry(Object object, DRSGroup dRSGroup, Long l, HashMap hashMap) {
        DRSEntryMetaData dRSEntryMetaData;
        String string = "updateEntry(4 parms): ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry. entryKey=" + object);
        }
        if (null == (dRSEntryMetaData = this.getExistingEntry(object))) {
            this.createEntry(object, dRSGroup, l, hashMap);
        } else {
            dRSEntryMetaData.setDRSGroup(dRSGroup);
            dRSEntryMetaData.setOwnerDRSInstanceID(l);
            dRSEntryMetaData.setOrphanEntry(false);
            dRSEntryMetaData.setHouserGMIDs(hashMap);
        }
        if (16 > this._entries.size()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + "DRSEntries updateEntry done, total table now:\n" + this.toString());
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, string + "DRSEntries updateEntry done, numEntries now " + this._entries.size());
        }
    }

    public void becomeOwner(Object object) {
        String string = "becomeOwner: ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry. entryKey=" + object);
        }
        DRSEntryMetaData dRSEntryMetaData = this.getExistingEntry(object);
        dRSEntryMetaData.setOwnerDRSInstanceID(this._drsInstanceID);
        dRSEntryMetaData.setOrphanEntry(false);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, string + "emd=" + dRSEntryMetaData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean entryExists(Object object) {
        boolean bl;
        String string = "entryExists: ";
        HashMap hashMap = this._entries;
        synchronized (hashMap) {
            bl = this._entries.containsKey(object);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, string + "Returning. exists=" + bl + " entryKey=" + object);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean findEntrySubString(String string) throws ClassCastException {
        String string2 = "findEntrySubString: ";
        boolean bl = false;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string2 + "Entry. key=" + string);
        }
        HashMap hashMap = null;
        Object object = this._entries;
        synchronized (object) {
            hashMap = (HashMap)this._entries.clone();
        }
        object = hashMap.keySet().iterator();
        String string3 = null;
        while (object.hasNext()) {
            string3 = (String)object.next();
            if (!string3.startsWith(string)) continue;
            bl = true;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string2 + "Exit. foundEntry=" + bl + " Key found:" + string3);
        }
        return bl;
    }

    public Long getEntryOwnerInstanceID(Object object) {
        String string = "getEntryOwnerInstanceID: ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry. entryKey.hashcode=" + object.hashCode());
        }
        Long l = null;
        DRSEntryMetaData dRSEntryMetaData = this.getExistingEntry(object);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, string + "entryMetaData=" + dRSEntryMetaData);
        }
        if (null != dRSEntryMetaData) {
            l = dRSEntryMetaData.getOwnerDRSInstanceID();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Returning. instanceID=" + l + " entryKey=" + object);
        }
        return l;
    }

    public boolean isMyEntry(Object object) {
        Long l;
        String string = "isMyEntry: ";
        boolean bl = false;
        DRSEntryMetaData dRSEntryMetaData = this.getExistingEntry(object);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, string + "entryMetaData=" + dRSEntryMetaData);
        }
        if (null != dRSEntryMetaData && (l = dRSEntryMetaData.getOwnerDRSInstanceID()) != null) {
            bl = l.equals(this._drsInstanceID);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, string + "Returning. isMyEntry=" + bl + " entryKey=" + object);
        }
        return bl;
    }

    public DRSGroup getDRSGroup(Object object) {
        String string = "getDRSGroup: ";
        DRSGroup dRSGroup = null;
        DRSEntryMetaData dRSEntryMetaData = this.getExistingEntry(object);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, string + "entryMetaData=" + dRSEntryMetaData);
        }
        if (null != dRSEntryMetaData) {
            dRSGroup = dRSEntryMetaData.getDRSGroup();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, string + "Returning. drsGroup=" + dRSGroup + " entryKey=" + object);
        }
        return dRSGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEntry(Object object) {
        HashMap hashMap = this._entries;
        synchronized (hashMap) {
            this._entries.remove(object);
        }
    }

    public void removeEntries(ArrayList arrayList) {
        for (int i = 0; i < arrayList.size(); ++i) {
            this.removeEntry(arrayList.get(i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nullGroupInEntries(DRSGroup dRSGroup) {
        String string = "nullGroupInEntries: ";
        String string2 = dRSGroup.getGroupName();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry. groupName=" + string2);
        }
        HashMap hashMap = this._entries;
        synchronized (hashMap) {
            Iterator iterator = this._entries.values().iterator();
            while (iterator.hasNext()) {
                DRSEntryMetaData dRSEntryMetaData = (DRSEntryMetaData)iterator.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string + "Found entry. entryMetaData=" + dRSEntryMetaData);
                }
                if (dRSEntryMetaData.getDRSGroup() == null || !string2.equals(dRSEntryMetaData.getDRSGroup().getGroupName())) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string + "Nulling group in entry. entryKey=" + dRSEntryMetaData.getEntryKey());
                }
                dRSEntryMetaData.setDRSGroup(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOrphanEntries(DRSGroup dRSGroup) {
        String string = "getOrphanEntries: ";
        String string2 = dRSGroup.getGroupName();
        String string3 = DRSGlobals.getSingleton().getHamServerId();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry. groupName=" + string2);
        }
        HashMap hashMap = this._entries;
        synchronized (hashMap) {
            Iterator iterator = this._entries.values().iterator();
            while (iterator.hasNext()) {
                DRSEntryMetaData dRSEntryMetaData = (DRSEntryMetaData)iterator.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string + "Found entry. entryMetaData=" + dRSEntryMetaData);
                }
                if (dRSEntryMetaData.getDRSGroup() == null || !string2.equals(dRSEntryMetaData.getDRSGroup().getGroupName()) || !dRSEntryMetaData.getHouserGMIDsMap().containsKey(string3)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string + "Setting isOrphanEntry. entryKey=" + dRSEntryMetaData.getEntryKey());
                }
                dRSEntryMetaData.setOrphanEntry(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getOrphanEntries() {
        String string = "setOrphanEntries: ";
        ArrayList arrayList = new ArrayList();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry. ");
        }
        HashMap hashMap = this._entries;
        synchronized (hashMap) {
            Iterator iterator = this._entries.keySet().iterator();
            while (iterator.hasNext()) {
                Object k = iterator.next();
                DRSEntryMetaData dRSEntryMetaData = (DRSEntryMetaData)this._entries.get(k);
                if (null == dRSEntryMetaData || !dRSEntryMetaData.isOrphanEntry()) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string + "Found entry. entryMetaData=" + dRSEntryMetaData);
                }
                arrayList.add(k);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Exit. ret=" + arrayList);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getEntriesForGroup(DRSGroup dRSGroup) {
        String string = "getEntriesForGroup: ";
        ArrayList arrayList = new ArrayList();
        String string2 = dRSGroup.getGroupName();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry. desiredGroup=" + dRSGroup + " name=" + string2);
        }
        HashMap hashMap = this._entries;
        synchronized (hashMap) {
            Iterator iterator = this._entries.keySet().iterator();
            while (iterator.hasNext()) {
                Object k = iterator.next();
                DRSEntryMetaData dRSEntryMetaData = (DRSEntryMetaData)this._entries.get(k);
                DRSGroup dRSGroup2 = dRSEntryMetaData.getDRSGroup();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string + "entryMetaData=" + dRSEntryMetaData + "\ngroup=" + dRSGroup2);
                }
                if (null == dRSGroup2 || !string2.equals(dRSGroup2.getGroupName())) continue;
                arrayList.add(k);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Exit. ret=" + arrayList);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getMyEntryKeys() {
        String string = "getMyEntryKeys: ";
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry. _drsInstanceID=" + this._drsInstanceID);
        }
        HashMap hashMap = this._entries;
        synchronized (hashMap) {
            Iterator iterator = this._entries.values().iterator();
            while (iterator.hasNext()) {
                Long l;
                DRSEntryMetaData dRSEntryMetaData = (DRSEntryMetaData)iterator.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string + "entryMetaData=" + dRSEntryMetaData);
                }
                if (null == (l = dRSEntryMetaData.getOwnerDRSInstanceID()) || !l.equals(this._drsInstanceID)) continue;
                arrayList.add(dRSEntryMetaData.getEntryKey());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Exit. myKeys=" + arrayList);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getReplicaEntryKeys() {
        String string = "getReplicaEntryKeys: ";
        ArrayList<Object> arrayList = new ArrayList<Object>();
        String string2 = DRSGlobals.getSingleton().getHamServerId();
        DRSEntryMetaData dRSEntryMetaData = null;
        HashMap hashMap = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry. hamServerId=" + string2);
        }
        HashMap hashMap2 = this._entries;
        synchronized (hashMap2) {
            Iterator iterator = this._entries.values().iterator();
            while (iterator.hasNext()) {
                dRSEntryMetaData = (DRSEntryMetaData)iterator.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string + "entryMetaData=" + dRSEntryMetaData);
                }
                if ((hashMap = dRSEntryMetaData.getHouserGMIDsMap()) == null || !hashMap.containsKey(string2)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string + "Adding entry per serverID.");
                }
                arrayList.add(dRSEntryMetaData.getEntryKey());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Exit. keys=" + arrayList);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            stringBuffer.append("DRSEntries:");
            HashMap hashMap = this._entries;
            synchronized (hashMap) {
                int n = 0;
                stringBuffer.append("\nnumEntries=").append(this._entries.size());
                Iterator iterator = this._entries.keySet().iterator();
                while (iterator.hasNext()) {
                    Object k = iterator.next();
                    DRSEntryMetaData dRSEntryMetaData = (DRSEntryMetaData)this._entries.get(k);
                    stringBuffer.append("\nentryKey[").append(n).append("]=").append(k);
                    if (k instanceof byte[]) {
                        byte[] byArray = (byte[])k;
                        int n2 = 64 < byArray.length ? 64 : byArray.length;
                        stringBuffer.append("\n").append(DRSUtils.lineTraceString(byArray, n2));
                    }
                    stringBuffer.append("\nentry[").append(n).append("]=").append(dRSEntryMetaData.toString());
                    ++n;
                }
            }
        }
        catch (Throwable throwable) {
            return "Error. Could not append to StringBuffer in DRSEntries.";
        }
        return stringBuffer.toString();
    }

    public GroupMemberId[] getHouserGMIDsArray(Object object) {
        String string = "getHouserGMIDsArray: ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry. entryKey=" + object);
        }
        GroupMemberId[] groupMemberIdArray = null;
        DRSEntryMetaData dRSEntryMetaData = (DRSEntryMetaData)this._entries.get(object);
        if (null != dRSEntryMetaData) {
            groupMemberIdArray = dRSEntryMetaData.getHouserGMIDsArray();
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, string + "entryMetaData is null.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Exit. houserArray.length=" + groupMemberIdArray.length);
        }
        return groupMemberIdArray;
    }

    public HashMap getHouserGMIDs(Object object) {
        String string = "getHouserGMIDs: ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry. entryKey=" + object);
        }
        HashMap hashMap = null;
        DRSEntryMetaData dRSEntryMetaData = (DRSEntryMetaData)this._entries.get(object);
        if (null != dRSEntryMetaData) {
            hashMap = dRSEntryMetaData.getHouserGMIDsMap();
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, string + "entryMetaData is null.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Exit. houserGMIDs=" + hashMap);
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEntryMembers(LinkedList linkedList) {
        String string = "removeEntryMembers: ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry. removedMembers.size=" + linkedList.size());
        }
        if (0 < linkedList.size()) {
            HashMap hashMap = this._entries;
            synchronized (hashMap) {
                Iterator iterator = this._entries.keySet().iterator();
                while (iterator.hasNext()) {
                    Object k = iterator.next();
                    DRSEntryMetaData dRSEntryMetaData = (DRSEntryMetaData)this._entries.get(k);
                    dRSEntryMetaData.removeEntryMembers(linkedList);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Exit.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getNeedsAnnounce(Object object) {
        String string = "getNeedsAnnounce: ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry. entryKey=" + object);
        }
        boolean bl = false;
        HashMap hashMap = this._entries;
        synchronized (hashMap) {
            DRSEntryMetaData dRSEntryMetaData = (DRSEntryMetaData)this._entries.get(object);
            if (null != dRSEntryMetaData) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string + "Getting needsAnnounce.");
                }
                bl = dRSEntryMetaData.getNeedsAnnounce();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Exit. needsAnnounce=" + bl);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNeedsAnnounce(Object object, boolean bl) {
        String string = "getNeedsAnnounce(obj,bool): ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry. needsAnnounce=" + bl + " entryKey=" + object);
        }
        HashMap hashMap = this._entries;
        synchronized (hashMap) {
            DRSEntryMetaData dRSEntryMetaData = (DRSEntryMetaData)this._entries.get(object);
            if (null != dRSEntryMetaData) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string + "Setting needsAnnounce.");
                }
                dRSEntryMetaData.setNeedsAnnounce(bl);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Exit.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNeedsAnnounce(Long l, boolean bl) {
        String string = "setNeedsAnnounce(long,bool): ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry. instanceID=" + l + " needsAnnounce=" + bl);
        }
        HashMap hashMap = this._entries;
        synchronized (hashMap) {
            Iterator iterator = this._entries.keySet().iterator();
            while (iterator.hasNext()) {
                Object k = iterator.next();
                DRSEntryMetaData dRSEntryMetaData = (DRSEntryMetaData)this._entries.get(k);
                Long l2 = dRSEntryMetaData.getOwnerDRSInstanceID();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string + "entryMetaData=" + dRSEntryMetaData);
                }
                if (null == l2 || !l2.equals(l)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string + "Setting needsAnnounce.");
                }
                dRSEntryMetaData.setNeedsAnnounce(bl);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Exit.");
        }
    }

    public void setNeedsAnnounce(boolean bl) {
        this.setNeedsAnnounce(this._drsInstanceID, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DRSEntryMetaData getExistingEntry(Object object) {
        DRSEntryMetaData dRSEntryMetaData = null;
        HashMap hashMap = this._entries;
        synchronized (hashMap) {
            dRSEntryMetaData = (DRSEntryMetaData)this._entries.get(object);
        }
        return dRSEntryMetaData;
    }
}

