/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.drs.model;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.drs.DRSGlobals;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.drs.exception.DRSCongestedException;
import com.ibm.wsspi.hamanager.GroupMemberId;
import com.ibm.wsspi.hamanager.HAException;
import com.ibm.wsspi.hamanager.agent.Agent;
import com.ibm.wsspi.hamanager.agent.AgentClass;
import com.ibm.wsspi.hamanager.datastack.DataStackCongestionException;
import com.ibm.wsspi.hamanager.datastack.DataStackMemberException;
import com.ibm.wsspi.hamanager.datastack.DataStackMembershipChangingException;
import com.ibm.wsspi.hamanager.datastack.MsgQoS;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class DRSGroup {
    private static final String METHOD_GET_AGENT_TIMEOUT = "getAgent(timeout): ";
    private static TraceComponent tc = Tr.register(DRSGroup.class.getName(), "DRS", "com.ibm.ws.drs.resources.drs");
    private static boolean _loggedVersion = false;
    private String _groupName;
    private Agent _agent;
    private AgentClass _agentClass;
    private GroupMemberId[] _groupMembers = null;
    private HashMap _myGroupMemberID = null;
    private HashMap _partnerGroupMemberIDs = null;
    private Object _agentSetMutex = new Object();
    private static HashMap _hamExceptionList = null;

    public DRSGroup(String string) {
        String string2 = "constructor: ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string2 + "Entry. groupName=" + string);
        }
        if (tc.isDebugEnabled() && !_loggedVersion) {
            Tr.debug(tc, "CMVC Version 1.20.1.1 5/18/07 09:20:59");
            _loggedVersion = true;
        }
        this._groupName = string;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string2 + "Exit.");
        }
    }

    public String getGroupName() {
        return this._groupName;
    }

    public void setGroupName(String string) {
        this._groupName = string;
    }

    public Agent getAgent() {
        return this._agent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Agent getAgent(long l) {
        String string = METHOD_GET_AGENT_TIMEOUT;
        if (null == this._agent) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + "Waiting for agent to be set. timeoutMs=" + l);
            }
            Object object = this._agentSetMutex;
            synchronized (object) {
                if (null == this._agent) {
                    try {
                        this._agentSetMutex.wait(l);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        return this._agent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAgent(Agent agent) {
        this._agent = agent;
        Object object = this._agentSetMutex;
        synchronized (object) {
            this._agentSetMutex.notifyAll();
        }
    }

    public AgentClass getAgentClass() {
        return this._agentClass;
    }

    public void setAgentClass(AgentClass agentClass) {
        this._agentClass = agentClass;
    }

    public void send(byte[] byArray) throws DRSCongestedException {
        String string = "send: ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry. group=" + this + " message.length=" + (null == byArray ? -1 : byArray.length));
        }
        try {
            if (this._agent == null) {
                this._agentClass.sendMessage(MsgQoS.NORMAL_NOSELF, byArray);
            } else {
                this._agent.sendMessage(MsgQoS.NORMAL_NOSELF, byArray);
            }
        }
        catch (DataStackCongestionException dataStackCongestionException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + "Error. Caught throwable. t=" + dataStackCongestionException);
            }
            Long l = Long.getLong("DRS_CONGESTED_SLEEP_TIME", 333L);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + "Retrying sendMessage() after sleeping: " + l + "ms");
            }
            try {
                Thread.sleep(l);
                if (this._agent == null) {
                    this._agentClass.sendMessage(MsgQoS.NORMAL_NOSELF, byArray);
                } else {
                    this._agent.sendMessage(MsgQoS.NORMAL_NOSELF, byArray);
                }
            }
            catch (DataStackCongestionException dataStackCongestionException2) {
                throw new DRSCongestedException();
            }
            catch (DataStackMemberException dataStackMemberException) {
                if (this.logMessage(this.getInstanceName())) {
                    Tr.info(tc, "drs.throwable.messaging", new Object[]{this.getInstanceName(), dataStackMemberException.getLocalizedMessage()});
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string + "Error. Caught throwable. t=" + dataStackMemberException);
                    dataStackMemberException.printStackTrace();
                }
            }
            catch (DataStackMembershipChangingException dataStackMembershipChangingException) {
                if (this.logMessage(this.getInstanceName())) {
                    Tr.info(tc, "drs.throwable.messaging", new Object[]{this.getInstanceName(), dataStackMembershipChangingException.getLocalizedMessage()});
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string + "Error. Caught throwable. t=" + dataStackMembershipChangingException);
                    dataStackMembershipChangingException.printStackTrace();
                }
            }
            catch (Throwable throwable) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string + "Error. Caught throwable. t=" + throwable);
                }
                FFDCFilter.processException(throwable, "com.ibm.ws.drs.model.DRSGroup.send", "110", this);
                throwable.printStackTrace();
            }
        }
        catch (DataStackMemberException dataStackMemberException) {
            if (this.logMessage(this.getInstanceName())) {
                Tr.info(tc, "drs.throwable.messaging", new Object[]{this.getInstanceName(), dataStackMemberException.getLocalizedMessage()});
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + "Error. Caught throwable. t=" + dataStackMemberException);
            }
        }
        catch (DataStackMembershipChangingException dataStackMembershipChangingException) {
            if (this.logMessage(this.getInstanceName())) {
                Tr.info(tc, "drs.throwable.messaging", new Object[]{this.getInstanceName(), dataStackMembershipChangingException.getLocalizedMessage()});
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + "Error. Caught throwable. t=" + dataStackMembershipChangingException);
            }
        }
        catch (Throwable throwable) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + "Error. Caught throwable. t=" + throwable);
            }
            FFDCFilter.processException(throwable, "com.ibm.ws.drs.model.DRSGroup.send", "110", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Exit. ");
        }
    }

    public void send(byte[] byArray, GroupMemberId groupMemberId) throws DRSCongestedException, DataStackMemberException, DataStackMembershipChangingException {
        String string = "send(destination): ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry.agent=" + this._agent + " agentClass=" + this._agentClass + " message.length=" + (null == byArray ? -1 : byArray.length));
        }
        if (groupMemberId == null) {
            this.send(byArray);
            return;
        }
        try {
            if (this._agent == null) {
                this._agentClass.sendMessage(MsgQoS.NORMAL_NOSELF, groupMemberId, byArray);
            } else {
                this._agent.sendMessage(MsgQoS.NORMAL_NOSELF, groupMemberId, byArray);
            }
        }
        catch (DataStackCongestionException dataStackCongestionException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + "Error. Caught throwable. t=" + dataStackCongestionException);
            }
            Long l = Long.getLong("DRS_CONGESTED_SLEEP_TIME", 333L);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + "Retrying sendMessage() after sleeping: " + l + "ms");
            }
            try {
                Thread.sleep(l);
                if (this._agent == null) {
                    this._agentClass.sendMessage(MsgQoS.NORMAL_NOSELF, groupMemberId, byArray);
                } else {
                    this._agent.sendMessage(MsgQoS.NORMAL_NOSELF, groupMemberId, byArray);
                }
            }
            catch (DataStackCongestionException dataStackCongestionException2) {
                throw new DRSCongestedException();
            }
            catch (DataStackMemberException dataStackMemberException) {
                if (this.logMessage(this.getInstanceName())) {
                    Tr.info(tc, "drs.throwable.messaging", new Object[]{this.getInstanceName(), dataStackMemberException.getLocalizedMessage()});
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string + "Error. Caught throwable. t=" + dataStackMemberException);
                }
                throw dataStackMemberException;
            }
            catch (DataStackMembershipChangingException dataStackMembershipChangingException) {
                if (this.logMessage(this.getInstanceName())) {
                    Tr.info(tc, "drs.throwable.messaging", new Object[]{this.getInstanceName(), dataStackMembershipChangingException.getLocalizedMessage()});
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string + "Error. Caught throwable. t=" + dataStackMembershipChangingException);
                }
                throw dataStackMembershipChangingException;
            }
            catch (Throwable throwable) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string + "Error. Caught throwable. t=" + throwable);
                }
                FFDCFilter.processException(throwable, "com.ibm.ws.drs.model.DRSGroup.send", "105", this);
            }
        }
        catch (DataStackMemberException dataStackMemberException) {
            if (this.logMessage(this.getInstanceName())) {
                Tr.info(tc, "drs.throwable.messaging", new Object[]{this.getInstanceName(), dataStackMemberException.getLocalizedMessage()});
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + "Error. Caught throwable. t=" + dataStackMemberException);
            }
            throw dataStackMemberException;
        }
        catch (DataStackMembershipChangingException dataStackMembershipChangingException) {
            if (this.logMessage(this.getInstanceName())) {
                Tr.info(tc, "drs.throwable.messaging", new Object[]{this.getInstanceName(), dataStackMembershipChangingException.getLocalizedMessage()});
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + "Error. Caught throwable. t=" + dataStackMembershipChangingException);
            }
            throw dataStackMembershipChangingException;
        }
        catch (Throwable throwable) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + "Error. Caught throwable. t=" + throwable);
            }
            FFDCFilter.processException(throwable, "com.ibm.ws.drs.model.DRSGroup.send", "105", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Exit. ");
        }
    }

    public void send(byte[] byArray, GroupMemberId[] groupMemberIdArray) throws DRSCongestedException, DataStackMemberException, DataStackMembershipChangingException {
        String string = "send(destination[]): ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry. destination=" + groupMemberIdArray + " group=" + this + " message.length=" + (null == byArray ? -1 : byArray.length));
            if (groupMemberIdArray != null) {
                for (int i = 0; i < groupMemberIdArray.length; ++i) {
                    Tr.debug(tc, string + "destination[" + i + "]=" + groupMemberIdArray[i]);
                }
            }
        }
        if (groupMemberIdArray == null || groupMemberIdArray != null && groupMemberIdArray.length == 0) {
            this.send(byArray);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, string + "Exit. ");
            }
            return;
        }
        try {
            if (this._agent == null) {
                this._agentClass.sendMessage(MsgQoS.NORMAL_NOSELF, groupMemberIdArray, byArray);
            } else {
                this._agent.sendMessage(MsgQoS.NORMAL_NOSELF, groupMemberIdArray, byArray);
            }
        }
        catch (DataStackCongestionException dataStackCongestionException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + "Error. Caught throwable. t=" + dataStackCongestionException);
            }
            Long l = Long.getLong("DRS_CONGESTED_SLEEP_TIME", 333L);
            try {
                Thread.sleep(l);
                if (this._agent == null) {
                    this._agentClass.sendMessage(MsgQoS.NORMAL_NOSELF, groupMemberIdArray, byArray);
                } else {
                    this._agent.sendMessage(MsgQoS.NORMAL_NOSELF, groupMemberIdArray, byArray);
                }
            }
            catch (DataStackCongestionException dataStackCongestionException2) {
                throw new DRSCongestedException();
            }
            catch (DataStackMemberException dataStackMemberException) {
                if (this.logMessage(this.getInstanceName())) {
                    Tr.info(tc, "drs.throwable.messaging", new Object[]{this.getInstanceName(), dataStackMemberException.getLocalizedMessage()});
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string + "Error. Caught throwable. t=" + dataStackMemberException);
                }
                throw dataStackMemberException;
            }
            catch (DataStackMembershipChangingException dataStackMembershipChangingException) {
                if (this.logMessage(this.getInstanceName())) {
                    Tr.info(tc, "drs.throwable.messaging", new Object[]{this.getInstanceName(), dataStackMembershipChangingException.getLocalizedMessage()});
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string + "Error. Caught throwable. t=" + dataStackMembershipChangingException);
                }
                throw dataStackMembershipChangingException;
            }
            catch (Throwable throwable) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string + "Error. Caught throwable. t=" + throwable);
                }
                FFDCFilter.processException(throwable, "com.ibm.ws.drs.model.DRSGroup.send", "109", this);
            }
        }
        catch (DataStackMemberException dataStackMemberException) {
            if (this.logMessage(this.getInstanceName())) {
                Tr.info(tc, "drs.throwable.messaging", new Object[]{this.getInstanceName(), dataStackMemberException.getLocalizedMessage()});
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + "Error. Caught throwable. t=" + dataStackMemberException);
            }
            throw dataStackMemberException;
        }
        catch (DataStackMembershipChangingException dataStackMembershipChangingException) {
            if (this.logMessage(this.getInstanceName())) {
                Tr.info(tc, "drs.throwable.messaging", new Object[]{this.getInstanceName(), dataStackMembershipChangingException.getLocalizedMessage()});
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + "Error. Caught throwable. t=" + dataStackMembershipChangingException);
            }
            throw dataStackMembershipChangingException;
        }
        catch (Throwable throwable) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + "Error. Caught throwable. t=" + throwable);
            }
            FFDCFilter.processException(throwable, "com.ibm.ws.drs.model.DRSGroup.send", "109", this);
            throwable.printStackTrace();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Exit. ");
        }
    }

    public synchronized void setGroupMembers(GroupMemberId[] groupMemberIdArray, LinkedList linkedList) {
        String string;
        String string2 = "setGroupMembers: ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string2 + "Entry. group=" + this + "members: " + groupMemberIdArray);
        }
        if (null != linkedList && null != this._groupMembers) {
            linkedList.addAll(this.getRemovedMembers(this._groupMembers, groupMemberIdArray));
        } else {
            Tr.debug(tc, "not removing members");
        }
        this._groupMembers = groupMemberIdArray;
        if (null != this._groupMembers) {
            Tr.debug(tc, "_groupMembers not null");
        }
        if (null != (string = this.getThisServerId())) {
            this._partnerGroupMemberIDs = DRSGroup.extractPartnerGroupMemberIDs(groupMemberIdArray, string);
            this._myGroupMemberID = DRSGroup.extractMyGroupMemberID(groupMemberIdArray, string);
            if (!this._myGroupMemberID.isEmpty() && DRSGlobals.getSingleton().getMyGMID() == null) {
                GroupMemberId groupMemberId = (GroupMemberId)this._myGroupMemberID.get(string);
                DRSGlobals.getSingleton().setMyGMID(groupMemberId);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string2 + "Exit. ");
        }
    }

    public HashMap getMyGroupMemberID() {
        return this._myGroupMemberID;
    }

    public HashMap getPartnerGroupMemberIDs() {
        return this._partnerGroupMemberIDs;
    }

    public int getNumGroupMembers() {
        int n = 0;
        if (null != this._groupMembers) {
            n = this._groupMembers.length;
        }
        return n;
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            stringBuffer.append("DRSGroup: ").append("\n_groupName=").append(this._groupName).append("\n_agentClass=").append(this._agentClass).append("\n_agent=").append(this._agent).append("\n_myGroupMemberID=").append(this._myGroupMemberID).append("\n_partnerGroupMemberIDs=").append(this._partnerGroupMemberIDs);
        }
        catch (Exception exception) {
            return "" + exception;
        }
        return stringBuffer.toString();
    }

    private String getThisServerId() {
        String string;
        String string2;
        block11: {
            string2 = "getThisServerId: ";
            string = null;
            try {
                Map map = null;
                if (null != this._agent) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, string2 + "Using _agent.");
                    }
                    map = this._agent.getInstanceId();
                } else if (null != this._agentClass) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, string2 + "Using _agentClass.");
                    }
                    map = this._agentClass.getInstanceIdentifier();
                }
                if (null != map) {
                    string = (String)map.get("_ham.serverid");
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, string2 + "Using global HAM Server ID.");
                    }
                    string = DRSGlobals.getSingleton().getHamServerId();
                }
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block11;
                Tr.debug(tc, string2 + "Error. Caught exception extracting serverID from groupMember object. e=" + exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string2 + "Exit. thisServerId=" + string);
        }
        return string;
    }

    private LinkedList getRemovedMembers(GroupMemberId[] groupMemberIdArray, GroupMemberId[] groupMemberIdArray2) {
        int n;
        String string = "getRemovedMembers: ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry. originalMembers.length=" + groupMemberIdArray.length + " newMembers.length=" + groupMemberIdArray2.length);
        }
        for (n = 0; n < groupMemberIdArray.length; ++n) {
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, string + "originalMembers[" + n + "]=" + groupMemberIdArray[n]);
        }
        for (n = 0; n < groupMemberIdArray2.length; ++n) {
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, string + "newMembers[" + n + "]=" + groupMemberIdArray2[n]);
        }
        LinkedList<GroupMemberId> linkedList = new LinkedList<GroupMemberId>();
        for (int i = 0; i < groupMemberIdArray.length; ++i) {
            GroupMemberId groupMemberId = groupMemberIdArray[i];
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + "i=" + i + " originalMember=" + groupMemberId);
            }
            boolean bl = false;
            for (int j = 0; j < groupMemberIdArray2.length; ++j) {
                GroupMemberId groupMemberId2 = groupMemberIdArray2[j];
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string + "j=" + j + " newMember=" + groupMemberId2);
                }
                if (!groupMemberId.equals(groupMemberId2)) continue;
                bl = true;
                if (!tc.isDebugEnabled()) break;
                Tr.debug(tc, string + "Found match.");
                break;
            }
            if (bl) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + "i=" + i + " Adding removed member: " + groupMemberId);
            }
            linkedList.add(groupMemberId);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Exit. removedMembers.size=" + linkedList.size());
        }
        return linkedList;
    }

    private static HashMap extractMyGroupMemberID(GroupMemberId[] groupMemberIdArray, String string) {
        String string2 = "extractMyGroupMemberID: ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string2 + "Entry. thisServerId=" + string);
        }
        HashMap<String, GroupMemberId> hashMap = new HashMap<String, GroupMemberId>();
        try {
            for (int i = 0; i < groupMemberIdArray.length; ++i) {
                Map map = groupMemberIdArray[i].getMemberProperties();
                String string3 = (String)map.get("_ham.serverid");
                if (string3.equals(string)) {
                    hashMap.put(string3, groupMemberIdArray[i]);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, string2 + "Found match. i=" + i + " serverId=" + string3 + " GMID=" + groupMemberIdArray[i]);
                    continue;
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, string2 + "No match. i=" + i + " serverId=" + string3 + " GMID=" + groupMemberIdArray[i]);
            }
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.exit(tc, string2 + "Caught exception extracting serverID from groupMember object.  Returning null. e=" + exception);
            }
            hashMap = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string2 + "Exit. map.size=" + hashMap.size() + " map=" + hashMap);
        }
        return hashMap;
    }

    private static HashMap extractPartnerGroupMemberIDs(GroupMemberId[] groupMemberIdArray, String string) {
        HashMap hashMap;
        String string2 = "extractPartnerGroupMemberIDs: ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string2 + "Entry. ");
        }
        if (null != (hashMap = DRSGroup.convertArrayToHashMap(groupMemberIdArray))) {
            hashMap.remove(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string2 + "Exit. map.size=" + hashMap.size() + " map=" + hashMap);
        }
        return hashMap;
    }

    private static HashMap convertArrayToHashMap(GroupMemberId[] groupMemberIdArray) {
        String string = "convertArrayToHashMap: ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry. ");
        }
        HashMap<String, GroupMemberId> hashMap = new HashMap<String, GroupMemberId>();
        try {
            for (int i = 0; i < groupMemberIdArray.length; ++i) {
                Map map = groupMemberIdArray[i].getMemberProperties();
                String string2 = (String)map.get("_ham.serverid");
                hashMap.put(string2, groupMemberIdArray[i]);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, string + "Stored GMID. i=" + i + " serverId=" + string2 + " GMID=" + groupMemberIdArray[i]);
            }
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.exit(tc, string + "Caught exception extracting serverID from groupMember object.  Returning null. e=" + exception);
            }
            hashMap = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Exit. map.size=" + hashMap.size() + " map=" + hashMap);
        }
        return hashMap;
    }

    private String getInstanceName() {
        String string;
        Map map;
        block3: {
            map = null;
            string = new String();
            try {
                map = null != this._agent ? this._agent.getInstanceId() : this._agentClass.getInstanceIdentifier();
            }
            catch (HAException hAException) {
                if (!tc.isDebugEnabled()) break block3;
                Tr.exit(tc, "Caught exception extracting instanceID from AgentClass.  e=" + hAException);
            }
        }
        if (null != map) {
            string = (String)map.get("drs_inst_name");
        }
        return string;
    }

    private boolean logMessage(String string) {
        boolean bl = false;
        Integer n = Integer.getInteger("DRS_HAM_EXCEPTION_LOG_THRESHOLD", 10000);
        int n2 = n;
        if (null == _hamExceptionList) {
            _hamExceptionList = new HashMap();
        }
        if (!_hamExceptionList.containsKey(string)) {
            _hamExceptionList.put(string, new Long(System.currentTimeMillis()));
            bl = true;
        } else {
            long l = (Long)_hamExceptionList.get(string);
            if (System.currentTimeMillis() - l > (long)n2) {
                bl = true;
            }
            _hamExceptionList.put(string, new Long(System.currentTimeMillis()));
        }
        return bl;
    }
}

