/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.drs.model;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.drs.DRSDomain;
import com.ibm.ws.drs.DRSGlobals;
import com.ibm.ws.drs.DRSInstance;
import com.ibm.ws.drs.model.DRSGroup;
import com.ibm.ws.drs.utils.DRSConstants;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.cluster.ClusterObserver;
import com.ibm.wsspi.cluster.Identity;
import com.ibm.wsspi.drs.DRSEventObject;
import com.ibm.wsspi.hamanager.GroupMemberId;
import com.ibm.wsspi.hamanager.HAException;
import com.ibm.wsspi.hamanager.agent.Agent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class DRSGroups {
    private static TraceComponent tc = Tr.register(DRSGroups.class.getName(), "DRS", "com.ibm.ws.drs.resources.drs");
    private static boolean _loggedVersion = false;
    private DRSInstance _drsInstance = null;
    private HashMap _primaryGroups = null;
    private Iterator _primaryGroupsIterator = null;
    private HashMap _drsInstances = null;
    private HashMap _secondaryGroups = null;
    private boolean _transportIsCongested = false;
    private Object _transportCongestionMutex = new Object();
    private DRSEventObject _transportIsCongestedEvent = null;
    private DRSEventObject _transportNotCongestedEvent = null;
    private boolean _hamUp = false;
    private HashMap _wlmIdentities;
    private ClusterObserver _clusterObserver = null;
    private ArrayList _joinedSecondaries = null;
    private HashMap _promotees = null;

    public DRSGroups(DRSInstance dRSInstance) {
        String string = "constructor: ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry.");
        }
        if (tc.isDebugEnabled() && !_loggedVersion) {
            Tr.debug(tc, "CMVC Version 1.19.1.1 7/21/08 12:05:18");
            _loggedVersion = true;
        }
        this._drsInstance = dRSInstance;
        this._drsInstances = new HashMap();
        this._secondaryGroups = new HashMap();
        this._primaryGroups = new HashMap();
        this._primaryGroupsIterator = this._primaryGroups.values().iterator();
        this._wlmIdentities = new HashMap();
        this._transportIsCongestedEvent = new DRSEventObject(3, this);
        this._transportNotCongestedEvent = new DRSEventObject(4, this);
        this._joinedSecondaries = new ArrayList();
        this._promotees = new HashMap();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Exit.");
        }
    }

    public HashMap createAgentIdMap(int n) {
        String string = "createAgentIdMap: ";
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry. index=" + n);
        }
        String string2 = AdminServiceFactory.getAdminService().getProcessName();
        String string3 = this._drsInstance.getName();
        Long l = new Long(this._drsInstance.getInstanceId());
        String string4 = l.toString().substring(7);
        String string5 = string2 + "\\" + string3 + "\\" + string4 + "\\" + n;
        short s = this._drsInstance.getDRSMode();
        String string6 = new Short(s).toString();
        hashMap.put("drs_agent_id", string5);
        hashMap.put("drs_inst_id", l.toString());
        hashMap.put("drs_inst_name", this._drsInstance.getName());
        hashMap.put("drs_mode", string6);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Exit. agentId=" + hashMap);
        }
        return hashMap;
    }

    public void createPrimaryAgents() {
        String string = "createPrimaryAgents: ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry.");
        }
        DRSDomain dRSDomain = this._drsInstance.getDomain();
        short s = this._drsInstance.getDRSMode();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, string + "mode=" + DRSConstants.getDrsModeString(s));
        }
        int n = 1;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, string + "drsInstanceId=" + this._drsInstance.getInstanceId() + " numberOfAgents=" + n + " domain=" + (null == dRSDomain ? "null" : "instantiated"));
        }
        try {
            if (s != 2) {
                for (int i = 1; i <= n; ++i) {
                    HashMap hashMap = this.createAgentIdMap(i);
                    String string2 = (String)hashMap.get("drs_agent_id");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, string + "Creating new group. i=" + i + " idStr=" + string2);
                    }
                    DRSGroup dRSGroup = new DRSGroup(string2);
                    this.addPrimaryGroup(dRSGroup);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, string + "Creating agent.");
                    }
                    Agent agent = dRSDomain.getBroadcastGroup().getAgentClass().createInstance(hashMap, string2);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, string + "Created agent. agent=" + agent);
                    }
                    dRSGroup.setAgent(agent);
                    if (0 == s) {
                        DRSGlobals.getSingleton().getMbd().registerInterestWithWLMCluster(hashMap, this._clusterObserver);
                    }
                    if (this._drsInstance.joinClusterInvoked()) continue;
                    Identity identity = DRSGlobals.getSingleton().getMbd().joinWLMCluster(hashMap);
                    this.addWLMIdentity(hashMap, identity);
                }
            }
        }
        catch (HAException hAException) {
            hAException.printStackTrace();
            FFDCFilter.processException((Throwable)hAException, this.getClass().getName() + string, "1", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Exit.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPrimaryGroup(DRSGroup dRSGroup) {
        String string = "addDRSGroup(1 parm): ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry. agentName=" + dRSGroup.getGroupName());
        }
        HashMap hashMap = this._primaryGroups;
        synchronized (hashMap) {
            this._primaryGroups.put(dRSGroup.getGroupName(), dRSGroup);
            this._primaryGroupsIterator = this._primaryGroups.values().iterator();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Exit.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DRSGroup getPrimaryGroup(String string) {
        DRSGroup dRSGroup = null;
        HashMap hashMap = this._primaryGroups;
        synchronized (hashMap) {
            dRSGroup = (DRSGroup)this._primaryGroups.get(string);
        }
        return dRSGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePrimaryGroup(String string) {
        HashMap hashMap = this._primaryGroups;
        synchronized (hashMap) {
            this._primaryGroups.remove(string);
            this._primaryGroupsIterator = this._primaryGroups.values().iterator();
        }
    }

    public void removeGroup(String string) {
        this.removePrimaryGroup(string);
        this.removeSecondaryGroup(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DRSGroup getDRSGroup(String string) {
        DRSGroup dRSGroup = null;
        HashMap hashMap = this._primaryGroups;
        synchronized (hashMap) {
            dRSGroup = (DRSGroup)this._primaryGroups.get(string);
        }
        if (dRSGroup == null) {
            hashMap = this._secondaryGroups;
            synchronized (hashMap) {
                dRSGroup = (DRSGroup)this._secondaryGroups.get(string);
            }
        }
        return dRSGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DRSGroup getSecondaryGroup(String string) {
        DRSGroup dRSGroup = null;
        HashMap hashMap = this._secondaryGroups;
        synchronized (hashMap) {
            dRSGroup = (DRSGroup)this._secondaryGroups.get(string);
        }
        return dRSGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSecondaryGroup(DRSGroup dRSGroup) {
        String string = "addSecondaryGroup: ";
        String string2 = dRSGroup.getGroupName();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry. group=" + dRSGroup);
        }
        HashMap hashMap = this._secondaryGroups;
        synchronized (hashMap) {
            this._secondaryGroups.put(string2, dRSGroup);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Entry. group=" + dRSGroup);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSecondaryGroup(String string) {
        HashMap hashMap = this._secondaryGroups;
        synchronized (hashMap) {
            this._secondaryGroups.remove(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DRSGroup getNextPrimaryGroup() {
        String string = "getNextDRSGroup: ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry.");
        }
        DRSGroup dRSGroup = null;
        HashMap hashMap = this._primaryGroups;
        synchronized (hashMap) {
            if (!this._primaryGroupsIterator.hasNext()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string + "Getting new iterator.");
                }
                this._primaryGroupsIterator = this._primaryGroups.values().iterator();
            }
            if (this._primaryGroupsIterator.hasNext()) {
                dRSGroup = (DRSGroup)this._primaryGroupsIterator.next();
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + "Error. No primary groups.");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Exit. Returning group. " + (null == dRSGroup ? "group=null" : "groupName=" + dRSGroup.getGroupName()));
        }
        return dRSGroup;
    }

    public GroupMemberId getGroupMemberId(String string) {
        return (GroupMemberId)this._drsInstances.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDRSInstanceMap(GroupMemberId[] groupMemberIdArray) {
        HashMap hashMap = this._drsInstances;
        synchronized (hashMap) {
            this._drsInstances.clear();
            int n = groupMemberIdArray.length;
            for (int i = 0; i < n; ++i) {
                GroupMemberId groupMemberId = groupMemberIdArray[i];
                Map map = groupMemberId.getMemberProperties();
                String string = (String)map.get("drs_inst_id");
                this._drsInstances.put(string, groupMemberId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Identity getWLMIdentity(Map map) {
        HashMap hashMap = this._wlmIdentities;
        synchronized (hashMap) {
            return (Identity)this._wlmIdentities.get(map);
        }
    }

    public HashMap getWLMIdentities() {
        return (HashMap)this._wlmIdentities.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getWLMIdentityMaps() {
        ArrayList<Map> arrayList = new ArrayList<Map>();
        HashMap hashMap = this._wlmIdentities;
        synchronized (hashMap) {
            Iterator iterator = this._wlmIdentities.keySet().iterator();
            while (iterator.hasNext()) {
                Map map = (Map)iterator.next();
                arrayList.add(map);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWLMIdentity(Map map, Identity identity) {
        HashMap hashMap = this._wlmIdentities;
        synchronized (hashMap) {
            this._wlmIdentities.put(map, identity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWLMIdentity(Map map) {
        HashMap hashMap = this._wlmIdentities;
        synchronized (hashMap) {
            this._wlmIdentities.remove(map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsPrimaryGroup(String string) {
        HashMap hashMap = this._primaryGroups;
        synchronized (hashMap) {
            return this._primaryGroups.containsKey(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsSecondaryGroup(String string) {
        HashMap hashMap = this._secondaryGroups;
        synchronized (hashMap) {
            return this._secondaryGroups.containsKey(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfSecondaries() {
        HashMap hashMap = this._secondaryGroups;
        synchronized (hashMap) {
            return this._secondaryGroups.size();
        }
    }

    public ClusterObserver getClusterObserver() {
        return this._clusterObserver;
    }

    public void setClusterObserver(ClusterObserver clusterObserver) {
        this._clusterObserver = clusterObserver;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            stringBuffer.append("DRSGroups: ").append("\nhashcode=").append(this.hashCode()).append("\n_primaryGroups=").append(this._primaryGroups).append("\n_secondaryGroups=").append(this._secondaryGroups).append("\n_drsInstances=").append(this._drsInstances).append("\n_wlmIdentities=").append(this._wlmIdentities).append("\n_clusterObserver=").append(this._clusterObserver);
        }
        catch (Exception exception) {
            return "" + exception;
        }
        return stringBuffer.toString();
    }

    public boolean isTransportCongested() {
        return this._transportIsCongested;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTransportIsCongested(boolean bl) {
        String string = "setTransportIsCongested: ";
        Object object = this._transportCongestionMutex;
        synchronized (object) {
            if (!this._transportIsCongested && bl) {
                this._transportIsCongested = true;
                Tr.info(tc, "Replication instance " + this._drsInstance.getName() + " is congested. ");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string + "Calling DCMListener with DRS_CONGESTED event.");
                }
                this._drsInstance.getMsgListener().event(this._transportIsCongestedEvent);
            } else if (this._transportIsCongested && !bl) {
                this._transportIsCongested = false;
                Tr.info(tc, "Replication instance " + this._drsInstance.getName() + " is not congested. ");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string + "Calling DCMListener with NOT_CONGESTED event.");
                }
                this._drsInstance.getMsgListener().event(this._transportNotCongestedEvent);
            }
        }
    }

    public void setHamUp() {
        String string = "setHamUp: ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry. drsInstanceName=" + this._drsInstance.getName());
        }
        this._hamUp = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Exit.");
        }
    }

    public void setHamUp(boolean bl) {
        String string = "setHamUp(bool): ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry. drsInstanceName=" + this._drsInstance.getName() + " bool=" + bl);
        }
        this._hamUp = bl;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Exit.");
        }
    }

    public boolean isHamUp() {
        String string = "isHamUp: ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry. drsInstanceName=" + this._drsInstance.getName());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Exit. Returning hamUp=" + this._hamUp);
        }
        return this._hamUp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean allGroupsHavePartners() {
        String string = "allGroupsHavePartners: ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry. drsInstanceName=" + this._drsInstance.getName());
        }
        boolean bl = true;
        HashMap hashMap = this._primaryGroups;
        synchronized (hashMap) {
            if (this._primaryGroups.size() == 1) {
                Iterator iterator = this._primaryGroups.values().iterator();
                while (iterator.hasNext()) {
                    DRSGroup dRSGroup = (DRSGroup)iterator.next();
                    int n = dRSGroup.getNumGroupMembers();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, string + "num=" + n + " group=" + dRSGroup.getGroupName());
                    }
                    if (2 <= n) continue;
                    bl = false;
                    break;
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string + "All primary agents have not been created. num=" + this._primaryGroups.size() + " needed=" + 1);
                }
                bl = false;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Exit. Returning rc=" + bl);
        }
        return bl;
    }

    public ArrayList getJoinedSecondaries() {
        return this._joinedSecondaries;
    }

    public HashMap getPromotees() {
        return this._promotees;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownInstanceGroups() {
        Agent agent;
        DRSGroup dRSGroup;
        Iterator iterator;
        String string = "shutdownInstanceGroups: ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry. drsInstanceName=" + this._drsInstance.getName());
        }
        HashMap hashMap = this._primaryGroups;
        synchronized (hashMap) {
            iterator = this._primaryGroups.values().iterator();
            while (iterator.hasNext()) {
                dRSGroup = (DRSGroup)iterator.next();
                agent = dRSGroup.getAgent();
                Map map = agent.getInstanceId();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string + "Primary disjoined from WLM cluster:" + agent);
                }
                Identity identity = DRSGlobals.getSingleton().getMbd().disjoinWLMCluster(map);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string + "Primary to be destroyed:" + agent);
                }
                try {
                    agent.destroy();
                }
                catch (HAException hAException) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, string + "Caught exception destroying Agent.  Caught e=" + hAException);
                }
            }
        }
        hashMap = this._secondaryGroups;
        synchronized (hashMap) {
            iterator = this._secondaryGroups.values().iterator();
            while (iterator.hasNext()) {
                dRSGroup = (DRSGroup)iterator.next();
                agent = dRSGroup.getAgent();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string + "Secondary to be destroyed:" + agent);
                }
                try {
                    agent.destroySecondary();
                }
                catch (HAException hAException) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, string + "Caught exception destroying Agent.  Caught e=" + hAException);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Exit.");
        }
    }
}

