/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.drs.pool;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.drs.pool.DRSByteArrayPool;
import com.ibm.ws.drs.pool.DRSPoolStats;
import java.util.LinkedList;

public class DRSByteArrayPoolSet {
    private static TraceComponent tc = Tr.register(DRSByteArrayPoolSet.class.getName(), "DRS", "com.ibm.ws.drs.resources.drs");
    private int _numPools;
    private DRSByteArrayPool[] _pools = null;
    private DRSPoolStats _setStats = null;
    private long _numRetMissNonpooled = 0L;

    public DRSByteArrayPoolSet() {
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        linkedList.addLast(new Integer(1000));
        linkedList.addLast(new Integer(100));
        linkedList.addLast(new Integer(3300));
        linkedList.addLast(new Integer(33));
        linkedList.addLast(new Integer(10000));
        linkedList.addLast(new Integer(10));
        linkedList.addLast(new Integer(33000));
        linkedList.addLast(new Integer(6));
        linkedList.addLast(new Integer(100000));
        linkedList.addLast(new Integer(5));
        linkedList.addLast(new Integer(330000));
        linkedList.addLast(new Integer(4));
        linkedList.addLast(new Integer(1000000));
        linkedList.addLast(new Integer(3));
        linkedList.addLast(new Integer(3300000));
        linkedList.addLast(new Integer(2));
        linkedList.addLast(new Integer(10000000));
        linkedList.addLast(new Integer(1));
        this.init(linkedList);
    }

    public DRSByteArrayPoolSet(LinkedList linkedList) {
        this.init(linkedList);
    }

    public synchronized byte[] getByteArray(int n) {
        byte[] byArray = null;
        for (int i = 0; i < this._numPools; ++i) {
            if (n > this._pools[i].getArrayLength()) continue;
            byArray = (byte[])this._pools[i].get();
            ++this._setStats._numGetHits;
            break;
        }
        if (null == byArray) {
            byArray = new byte[n];
            ++this._setStats._numGetMiss;
        }
        return byArray;
    }

    public synchronized void retByteArray(byte[] byArray) {
        if (null == byArray) {
            Tr.error(tc, "DRSByteArrayPoolSet/retByteArray: Code Bug: Caller returned a null object.");
            return;
        }
        boolean bl = false;
        for (int i = 0; i < this._numPools; ++i) {
            if (byArray.length != this._pools[i].getArrayLength()) continue;
            this._pools[i].ret(byArray);
            bl = true;
            break;
        }
        if (bl) {
            ++this._setStats._numRetHits;
        } else if (byArray.length > this._pools[this._numPools - 1].getArrayLength()) {
            ++this._setStats._numRetMiss;
        } else {
            ++this._numRetMissNonpooled;
        }
    }

    public synchronized void analyzeStats() {
        String string = "analyzeStats: ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry.");
        }
        try {
            DRSPoolStats[] dRSPoolStatsArray = new DRSPoolStats[this._numPools];
            for (int i = 0; i < this._numPools; ++i) {
                dRSPoolStatsArray[i] = this._pools[i].getStatsClone();
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("DRSByteArrayPoolSet:").append(" _numRetMissNonpooled=").append(this._numRetMissNonpooled).append(" ").append(this._setStats);
            for (int i = 0; i < this._numPools; ++i) {
                DRSByteArrayPool dRSByteArrayPool = this._pools[i];
                stringBuffer.append("_pools[").append(i).append("]=").append(dRSByteArrayPool.toString());
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + stringBuffer.toString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Exit.");
        }
    }

    public synchronized void resetStats() {
        this._setStats.reset();
        ++this._numRetMissNonpooled;
        for (int i = 0; i < this._numPools; ++i) {
            DRSByteArrayPool dRSByteArrayPool = this._pools[i];
            dRSByteArrayPool.resetStats();
        }
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            stringBuffer.append("DRSByteArrayPoolSet: ").append("\n_numPools=").append(this._numPools).append("\n_numRetMissNonpooled=").append(this._numRetMissNonpooled).append("\n_setStats=").append(this._setStats);
            for (int i = 0; i < this._numPools; ++i) {
                DRSByteArrayPool dRSByteArrayPool = this._pools[i];
                stringBuffer.append("\npool[").append(i).append("]=").append(dRSByteArrayPool.toString());
            }
        }
        catch (Exception exception) {
            return "DRSByteArrayPoolSet." + exception;
        }
        return stringBuffer.toString();
    }

    private void init(LinkedList linkedList) {
        String string = "init: ";
        if (0 != linkedList.size() % 2) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + "init falied");
            }
            return;
        }
        this._numPools = linkedList.size() / 2;
        this._pools = new DRSByteArrayPool[this._numPools];
        this._setStats = new DRSPoolStats();
        int n = 0;
        while (0 < linkedList.size()) {
            int n2 = (Integer)linkedList.removeFirst();
            int n3 = (Integer)linkedList.removeFirst();
            this._pools[n] = new DRSByteArrayPool(n2, n3);
            ++n;
        }
    }
}

