/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.drs.pool;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.drs.pool.DRSPoolElementIntf;
import java.util.LinkedList;

public class DRSPool {
    private static TraceComponent tc = Tr.register(DRSPool.class.getName(), "DRS", "com.ibm.ws.drs.resources.drs");
    private LinkedList _list = null;
    private int _numElementsInitial = 0;
    private boolean _autoInstantiate = true;
    private DRSPoolElementIntf _instantiatorElement = null;
    private String _poolElementClassName = null;
    private Object _poolElementArg = null;
    private int _numWaitingThreads = 0;
    private long _recoveryLevel = 0L;
    private boolean _poolInitSucceeded = false;
    private String _poolName = "";

    public DRSPool(boolean bl, String string, Object object, int n, String string2) {
        String string3 = "constructor: ";
        this._autoInstantiate = bl;
        this._poolElementClassName = string;
        this._poolElementArg = object;
        this._numElementsInitial = n;
        this._poolName = string2;
        this._list = new LinkedList();
        this._numWaitingThreads = 0;
        this._recoveryLevel = (long)this.hashCode() + System.currentTimeMillis();
        if (this._autoInstantiate) {
            if (this._poolElementClassName == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string3 + "ERROR: Pool Element Class name cannot be null. poolName=" + string2);
                }
                return;
            }
        } else if (this._poolElementClassName == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string3 + "No PoolElementClass specified. Pool user is going to add objects manually. poolName=" + string2);
            }
            return;
        }
        try {
            Class<?> clazz = Class.forName(this._poolElementClassName);
            DRSPoolElementIntf dRSPoolElementIntf = (DRSPoolElementIntf)clazz.newInstance();
            if (0 < n) {
                for (int i = 0; i < n; ++i) {
                    DRSPoolElementIntf dRSPoolElementIntf2 = dRSPoolElementIntf.getNewInstance(this._poolElementArg);
                    dRSPoolElementIntf2.setRecoveryLevel(this._recoveryLevel);
                    this.add(dRSPoolElementIntf2);
                }
            }
            if (this._autoInstantiate) {
                this._instantiatorElement = dRSPoolElementIntf;
            }
        }
        catch (Throwable throwable) {
            Tr.error(tc, "drs.throwable", throwable);
            throwable.printStackTrace();
            Tr.debug(tc, string3 + "Error: Unable to create the pool:" + string2 + " throwable=" + throwable);
            return;
        }
        this._poolInitSucceeded = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(DRSPoolElementIntf dRSPoolElementIntf) {
        dRSPoolElementIntf.setPoolable(true);
        dRSPoolElementIntf.setInUse(false);
        dRSPoolElementIntf.setRecoveryLevel(this._recoveryLevel);
        DRSPool dRSPool = this;
        synchronized (dRSPool) {
            if (this._list.size() < this._numElementsInitial) {
                this._list.addLast(dRSPoolElementIntf);
            }
            if (0 < this._numWaitingThreads) {
                this.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DRSPoolElementIntf get() {
        DRSPoolElementIntf dRSPoolElementIntf = null;
        DRSPool dRSPool = this;
        synchronized (dRSPool) {
            if (0 < this._list.size()) {
                dRSPoolElementIntf = (DRSPoolElementIntf)this._list.removeFirst();
            } else if (this._autoInstantiate) {
                try {
                    dRSPoolElementIntf = this._instantiatorElement.getNewInstance(this._poolElementArg);
                    dRSPoolElementIntf.setRecoveryLevel(this._recoveryLevel);
                    dRSPoolElementIntf.setPoolable(false);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    Tr.error(tc, "drs.throwable", throwable);
                    Tr.debug(tc, "DRSPool/get: Error. Unable to create a poolElement. _poolName=" + this._poolName);
                }
            } else {
                while (0 >= this._list.size()) {
                    ++this._numWaitingThreads;
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (0 < this._numWaitingThreads) {
                        --this._numWaitingThreads;
                    }
                    if (0 >= this._list.size()) continue;
                    dRSPoolElementIntf = (DRSPoolElementIntf)this._list.removeFirst();
                    break;
                }
                if (0 < this._numWaitingThreads) {
                    this.notify();
                }
            }
        }
        if (dRSPoolElementIntf.getInUse()) {
            // empty if block
        }
        dRSPoolElementIntf.setInUse(true);
        return dRSPoolElementIntf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ret(DRSPoolElementIntf dRSPoolElementIntf) {
        if (!dRSPoolElementIntf.getPoolable()) {
            dRSPoolElementIntf.releaseContents();
            return;
        }
        if (!dRSPoolElementIntf.getInUse()) {
            dRSPoolElementIntf.releaseContents();
            return;
        }
        if (this._recoveryLevel != dRSPoolElementIntf.getRecoveryLevel()) {
            dRSPoolElementIntf.releaseContents();
            return;
        }
        dRSPoolElementIntf.refreshContents();
        DRSPool dRSPool = this;
        synchronized (dRSPool) {
            if (this._list.size() < this._numElementsInitial) {
                dRSPoolElementIntf.setInUse(false);
                this._list.addLast(dRSPoolElementIntf);
            }
            if (0 < this._numWaitingThreads) {
                this.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        DRSPool dRSPool = this;
        synchronized (dRSPool) {
            while (0 < this._list.size()) {
                DRSPoolElementIntf dRSPoolElementIntf = (DRSPoolElementIntf)this._list.removeFirst();
                dRSPoolElementIntf.releaseContents();
            }
        }
        this._recoveryLevel = (long)this.hashCode() + System.currentTimeMillis();
    }

    public int getNumElementsInitial() {
        return this._numElementsInitial;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumElementsCurrent() {
        int n = -1;
        if (null != this._list) {
            DRSPool dRSPool = this;
            synchronized (dRSPool) {
                n = this._list.size();
            }
        }
        return n;
    }

    public boolean isPoolInitSuccessful() {
        return this._poolInitSucceeded;
    }

    public long getRecoveryLevel() {
        return this._recoveryLevel;
    }
}

