/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.drs.pool;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.drs.pool.DRSPoolStats;

public abstract class DRSPrimitivePoolBase {
    protected static TraceComponent tc = Tr.register(DRSPrimitivePoolBase.class.getName(), "DRS", "com.ibm.ws.drs.resources.drs");
    private String _poolName = null;
    private int _numElementsMax = 0;
    private int _numElementsPresent = 0;
    private Object[] _pool = null;
    private DRSPoolStats _stats = null;

    public DRSPrimitivePoolBase(String string, int n) {
        this._poolName = string;
        this._numElementsMax = n;
        this._numElementsPresent = 0;
        this._pool = new Object[n];
        this._stats = new DRSPoolStats();
    }

    public int getNumElementsMax() {
        return this._numElementsMax;
    }

    public int getNumElementsPresent() {
        return this._numElementsPresent;
    }

    public DRSPoolStats getStatsClone() {
        return (DRSPoolStats)this._stats.clone();
    }

    public void resetStats() {
        this._stats.reset();
    }

    public Object get() {
        Object object = null;
        if (0 < this._numElementsPresent) {
            --this._numElementsPresent;
            object = this._pool[this._numElementsPresent];
            ++this._stats._numGetHits;
        } else {
            ++this._stats._numGetMiss;
        }
        return object;
    }

    public void ret(Object object) {
        if (null == object) {
            Tr.error(tc, "DRSPrimitivePoolBase/ret: Code Bug: Someone returned a null object to this pool. _poolName=" + this._poolName);
            return;
        }
        if (this._numElementsPresent < this._numElementsMax) {
            this._pool[this._numElementsPresent] = object;
            ++this._numElementsPresent;
            ++this._stats._numRetHits;
        } else {
            ++this._stats._numRetMiss;
        }
    }

    public String getName() {
        return this._poolName;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            stringBuffer.append(this._poolName).append(":").append("\n_numElementsMax=").append(this._numElementsMax).append("\n_numElementsPresent=").append(this._numElementsPresent).append("\n_stats=").append(this._stats);
        }
        catch (Exception exception) {
            return this._poolName + ": Error: Caught exception preparing toString. e=" + exception;
        }
        return stringBuffer.toString();
    }
}

