/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.drs.stack;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.drs.DRSInstance;
import com.ibm.ws.drs.managers.DRSBootstrapManager;
import com.ibm.ws.drs.managers.DRSSolicitor;
import com.ibm.ws.drs.message.DRSBootstrapMsgImpl;
import com.ibm.ws.drs.message.DRSCacheMsgImpl;
import com.ibm.ws.drs.model.DRSEntries;
import com.ibm.ws.drs.model.DRSGroup;
import com.ibm.ws.drs.model.DRSGroups;
import com.ibm.ws.drs.stack.DRSStack;
import com.ibm.ws.drs.stack.DRSStackLayerBase;
import com.ibm.ws.drs.utils.DRSConstants;
import com.ibm.wsspi.drs.DRSAnnounceRenounceListener;
import com.ibm.wsspi.drs.DRSCacheMsg;
import com.ibm.wsspi.drs.DRSCacheMsgListener;
import com.ibm.wsspi.drs.DRSJvmId;
import com.ibm.wsspi.drs.exception.DRSAckException;
import com.ibm.wsspi.drs.exception.DRSCongestedException;
import com.ibm.wsspi.drs.exception.DRSEntryNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class DRSClientCallback
extends DRSStackLayerBase {
    private static TraceComponent tc = Tr.register(DRSClientCallback.class.getName(), "DRS", "com.ibm.ws.drs.resources.drs");
    private static boolean _loggedVersion = false;
    private DRSCacheMsgListener _msgListener = null;
    private DRSAnnounceRenounceListener _announceRenounceListener = null;
    private DRSStack _getStack;
    private DRSStack _ackStack;
    private DRSStack _responseStack;
    private HashMap _pendingAcks;
    private long _drsInstanceId = 0L;
    private String _drsInstanceName = null;
    private DRSEntries _drsEntries = null;
    private DRSSolicitor _solicitor = null;
    private DRSBootstrapManager _bootstrapManager = null;
    private DRSGroup _broadcastGroup = null;
    private short _mode = 0;
    private DRSInstance _drsInstance = null;

    public DRSClientCallback(DRSInstance dRSInstance) {
        if (tc.isDebugEnabled() && !_loggedVersion) {
            Tr.debug(tc, "CMVC Version 1.17 12/7/06 08:33:39");
            _loggedVersion = true;
        }
        this._msgListener = dRSInstance.getMsgListener();
        if (this._msgListener instanceof DRSAnnounceRenounceListener) {
            this._announceRenounceListener = (DRSAnnounceRenounceListener)((Object)this._msgListener);
        }
        this._drsInstance = dRSInstance;
        this._getStack = dRSInstance.getGetStack();
        this._ackStack = dRSInstance.getAckStack();
        this._responseStack = dRSInstance.getResponseStack();
        this._pendingAcks = dRSInstance.getPendingAcks();
        this._drsInstanceId = dRSInstance.getInstanceId();
        this._drsInstanceName = dRSInstance.getName();
        this._drsEntries = dRSInstance.getDRSEntries();
        this._solicitor = dRSInstance.getSolicitor();
        this._bootstrapManager = dRSInstance.getBootstrapManager();
        this._mode = dRSInstance.getDRSMode();
        this._broadcastGroup = dRSInstance.getDomain().getBroadcastGroup();
    }

    public void setBootstrapManager(DRSBootstrapManager dRSBootstrapManager) {
        this._bootstrapManager = dRSBootstrapManager;
    }

    public void setSolicitor(DRSSolicitor dRSSolicitor) {
        this._solicitor = dRSSolicitor;
    }

    public DRSCacheMsg processSendMessage(DRSCacheMsg dRSCacheMsg) throws DRSAckException, DRSEntryNotFoundException {
        return dRSCacheMsg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DRSCacheMsg processRcvMessage(DRSCacheMsg dRSCacheMsg) {
        String string = "processRcvMessage: ";
        DRSCacheMsgImpl dRSCacheMsgImpl = (DRSCacheMsgImpl)dRSCacheMsg;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry. dcm=" + dRSCacheMsgImpl);
        }
        Long l = null;
        if (dRSCacheMsgImpl != null) {
            short s = dRSCacheMsgImpl.getAction();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + "action=" + DRSConstants.getActionString(s));
            }
            switch (s) {
                case 1: {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, string + "Calling DCMListener createEntry. entryKey=" + dRSCacheMsgImpl.entryKey);
                    }
                    this._msgListener.createEntry(dRSCacheMsgImpl.entryKey, dRSCacheMsgImpl.objValue);
                    break;
                }
                case 2: {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, string + "Calling DCMListener createEntryProp. entryKey=" + dRSCacheMsgImpl.entryKey + " propKey=" + dRSCacheMsgImpl.propKey);
                    }
                    this._msgListener.createEntryProp(dRSCacheMsgImpl.entryKey, dRSCacheMsgImpl.propKey, dRSCacheMsgImpl.objValue);
                    break;
                }
                case 3: {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, string + "Calling DCMListener updateEntry. entryKey=" + dRSCacheMsgImpl.entryKey);
                    }
                    this._msgListener.updateEntry(dRSCacheMsgImpl.entryKey, dRSCacheMsgImpl.objValue);
                    break;
                }
                case 4: {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, string + "Calling DCMListener updateEntryProp. entryKey=" + dRSCacheMsgImpl.entryKey + " propKey=" + dRSCacheMsgImpl.propKey);
                    }
                    this._msgListener.updateEntryProp(dRSCacheMsgImpl.entryKey, dRSCacheMsgImpl.propKey, dRSCacheMsgImpl.objValue);
                    break;
                }
                case 5: {
                    if (null != this._announceRenounceListener) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, string + "Calling AnnounceRenounceListener getEntry. entryKey=" + dRSCacheMsgImpl.entryKey + " jvmId=" + dRSCacheMsgImpl.objValue);
                        }
                        dRSCacheMsgImpl.objValue = this._announceRenounceListener.getEntry(dRSCacheMsgImpl.entryKey, (DRSJvmId)dRSCacheMsgImpl.objValue);
                    } else {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, string + "Calling DCMListener getEntry. entryKey=" + dRSCacheMsgImpl.entryKey);
                        }
                        dRSCacheMsgImpl.objValue = this._msgListener.getEntry(dRSCacheMsgImpl.entryKey);
                    }
                    dRSCacheMsgImpl.setAction((short)6);
                    this.generateResponseMessage(dRSCacheMsgImpl);
                    break;
                }
                case 6: {
                    this._getStack.processRcvMessage(dRSCacheMsgImpl);
                    break;
                }
                case 7: {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, string + "Calling DCMListener getEntryProp. entryKey=" + dRSCacheMsgImpl.entryKey + " propKey=" + dRSCacheMsgImpl.propKey);
                    }
                    dRSCacheMsgImpl.objValue = this._msgListener.getEntryProp(dRSCacheMsgImpl.entryKey, dRSCacheMsgImpl.propKey);
                    dRSCacheMsgImpl.setAction((short)8);
                    this.generateResponseMessage(dRSCacheMsgImpl);
                    break;
                }
                case 8: {
                    this._getStack.processRcvMessage(dRSCacheMsgImpl);
                    break;
                }
                case 9: {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, string + "Calling DCMListener removeEntry. entryKey=" + dRSCacheMsgImpl.entryKey);
                    }
                    this._msgListener.removeEntry(dRSCacheMsgImpl.entryKey);
                    break;
                }
                case 10: {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, string + "Calling DCMListener removeEntryProp. entryKey=" + dRSCacheMsgImpl.entryKey + " propKey=" + dRSCacheMsgImpl.propKey);
                    }
                    this._msgListener.removeEntryProp(dRSCacheMsgImpl.entryKey, dRSCacheMsgImpl.propKey, dRSCacheMsgImpl.objValue);
                    break;
                }
                case 12: {
                    this._getStack.processRcvMessage(dRSCacheMsgImpl);
                    break;
                }
                case 11: {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, string + "Calling DCMListener entryIDExists. entryKey=" + dRSCacheMsgImpl.entryKey);
                    }
                    boolean bl = this._msgListener.entryIDExists(dRSCacheMsgImpl.entryKey);
                    dRSCacheMsgImpl.objValue = new Boolean(bl);
                    dRSCacheMsgImpl.setAction((short)12);
                    this.generateResponseMessage(dRSCacheMsgImpl);
                    break;
                }
                case 14: {
                    this._getStack.processRcvMessage(dRSCacheMsgImpl);
                    break;
                }
                case 13: {
                    l = this._drsEntries.getEntryOwnerInstanceID(dRSCacheMsgImpl.entryKey);
                    if (l != null && this._drsInstanceId != l) {
                        if (!tc.isDebugEnabled()) break;
                        Tr.debug(tc, string + "ignoring request for " + dRSCacheMsgImpl);
                        break;
                    }
                    if (!tc.isDebugEnabled()) break;
                    Tr.debug(tc, string + "Calling DCMListener propIDExists. entryKey=" + dRSCacheMsgImpl.entryKey + " propKey=" + dRSCacheMsgImpl.propKey);
                    break;
                }
                case 15: {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, string + "_bootstrapManager=" + (null == this._bootstrapManager ? "null" : "instantiated"));
                    }
                    this._bootstrapManager.handleBootstrapRequest((DRSBootstrapMsgImpl)dRSCacheMsgImpl.objValue, dRSCacheMsgImpl.destinationAddress);
                    break;
                }
                case 21: {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, string + "_bootstrapManager=" + (null == this._bootstrapManager ? "null" : "instantiated"));
                    }
                    this._bootstrapManager.handleBootstrapResponse(dRSCacheMsgImpl);
                    break;
                }
                case 26: {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, string + "_solicitor=" + (null == this._solicitor ? "null" : "instantiated"));
                    }
                    this._solicitor.handleSolicitEntryRequest(dRSCacheMsgImpl.instanceID, (Map)dRSCacheMsgImpl.entryKey, dRSCacheMsgImpl.destinationAddress, (DRSBootstrapMsgImpl)dRSCacheMsgImpl.objValue);
                    break;
                }
                case 27: {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, string + "_solicitor=" + (null == this._solicitor ? "null" : "instantiated"));
                    }
                    this._solicitor.handleSolicitEntryResponse((DRSBootstrapMsgImpl)dRSCacheMsgImpl.objValue, new Long(dRSCacheMsgImpl.instanceID));
                    break;
                }
                case 20: {
                    this._ackStack.processRcvMessage(dRSCacheMsgImpl);
                    break;
                }
                case 22: {
                    if (null != this._announceRenounceListener) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, string + "Calling AnnounceRenounceListener announceEntries. jvmId=" + dRSCacheMsgImpl.entryKey);
                        }
                        this._announceRenounceListener.announceEntries((ArrayList)dRSCacheMsgImpl.objValue, (DRSJvmId)dRSCacheMsgImpl.entryKey);
                        break;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, string + "No announceRenounceListener available.");
                    }
                    this._drsEntries.createOrUpdateEntries((ArrayList)dRSCacheMsgImpl.objValue, (HashMap)dRSCacheMsgImpl.getPropKey(), new Long(dRSCacheMsgImpl.instanceID));
                    break;
                }
                case 23: {
                    if (null != this._announceRenounceListener) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, string + "Calling AnnounceRenounceListener renounceEntries.");
                        }
                        this._announceRenounceListener.renounceEntries((ArrayList)dRSCacheMsgImpl.objValue);
                    }
                    this._drsEntries.removeEntries((ArrayList)dRSCacheMsgImpl.objValue);
                    break;
                }
                case 24: {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, string + "Calling DCMListener broadcast. entryKey=" + dRSCacheMsgImpl.entryKey);
                    }
                    dRSCacheMsgImpl.objValue = this._msgListener.broadcast(dRSCacheMsgImpl.entryKey);
                    dRSCacheMsgImpl.setAction((short)25);
                    this.generateResponseMessage(dRSCacheMsgImpl);
                    break;
                }
                case 25: {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, string + "Calling DCMListener response. objValue=" + dRSCacheMsgImpl.objValue);
                    }
                    this._msgListener.response(dRSCacheMsgImpl.objValue);
                    break;
                }
                case 31: {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, string + "Received promoted backup msg from primary. objValue=" + dRSCacheMsgImpl.objValue);
                    }
                    DRSGroups dRSGroups = this._drsInstance.getDRSGroups();
                    HashMap hashMap = dRSGroups.getPromotees();
                    ArrayList arrayList = (ArrayList)dRSCacheMsgImpl.objValue;
                    String string2 = dRSCacheMsgImpl.getSenderServerID();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, string + "Adding promotees for server: " + string2);
                    }
                    HashMap hashMap2 = hashMap;
                    synchronized (hashMap2) {
                        hashMap.remove(string2);
                        if (arrayList.size() != 0) {
                            hashMap.put(string2, arrayList);
                        }
                        break;
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Exit. Returning dcm.");
        }
        return dRSCacheMsgImpl;
    }

    private DRSCacheMsgImpl generateResponseMessage(DRSCacheMsgImpl dRSCacheMsgImpl) {
        String string;
        block9: {
            string = "generateResponseMessage: ";
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, string + "Entry.");
            }
            dRSCacheMsgImpl.ackMsgId = dRSCacheMsgImpl.msgId;
            dRSCacheMsgImpl.populateContents(dRSCacheMsgImpl.drsDomainName, this._drsInstanceId, dRSCacheMsgImpl.drsInstanceName, dRSCacheMsgImpl.getAction(), dRSCacheMsgImpl.entryKey, dRSCacheMsgImpl.propKey, dRSCacheMsgImpl.objValue);
            dRSCacheMsgImpl.drsGroup = this._broadcastGroup;
            dRSCacheMsgImpl.agentID = this._broadcastGroup.getGroupName();
            dRSCacheMsgImpl.setHamServerID();
            try {
                this._responseStack.processSendMessage(dRSCacheMsgImpl);
            }
            catch (DRSCongestedException dRSCongestedException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string + "Attempting a resend due to congestion.");
                }
                try {
                    this._responseStack.processSendMessage(dRSCacheMsgImpl);
                }
                catch (Throwable throwable) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, string + "Error. Congested resend failed. t=" + throwable);
                    }
                }
            }
            catch (Throwable throwable) {
                if (!tc.isDebugEnabled()) break block9;
                Tr.debug(tc, string + "Error. Caught throwable. t=" + throwable);
            }
        }
        dRSCacheMsgImpl.processingComplete = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Exit.");
        }
        return dRSCacheMsgImpl;
    }
}

