/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.drs.stack;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.drs.DRSInstance;
import com.ibm.ws.drs.message.DRSCacheMsgImpl;
import com.ibm.ws.drs.model.DRSEntries;
import com.ibm.ws.drs.model.DRSGroup;
import com.ibm.ws.drs.model.DRSGroups;
import com.ibm.ws.drs.stack.DRSStackLayerBase;
import com.ibm.ws.drs.utils.DRSConstants;
import com.ibm.wsspi.drs.DRSCacheMsg;
import com.ibm.wsspi.drs.exception.DRSAckException;
import com.ibm.wsspi.drs.exception.DRSEntryNotFoundException;

public class DRSGroupExtraction
extends DRSStackLayerBase {
    private static TraceComponent tc = Tr.register(DRSGroupExtraction.class.getName(), "DRS", "com.ibm.ws.drs.resources.drs");
    private static boolean _loggedVersion = false;
    private DRSEntries _entries = null;
    private DRSGroups _groups = null;

    public DRSGroupExtraction(DRSInstance dRSInstance) {
        if (tc.isDebugEnabled() && !_loggedVersion) {
            Tr.debug(tc, "CMVC Version 1.9 4/2/05 11:26:05");
            _loggedVersion = true;
        }
        this._entries = dRSInstance.getDRSEntries();
        this._groups = dRSInstance.getDRSGroups();
    }

    public DRSCacheMsg processSendMessage(DRSCacheMsg dRSCacheMsg) throws DRSAckException, DRSEntryNotFoundException {
        return dRSCacheMsg;
    }

    public DRSCacheMsg processRcvMessage(DRSCacheMsg dRSCacheMsg) {
        String string = "processRcvMessage: ";
        DRSCacheMsgImpl dRSCacheMsgImpl = (DRSCacheMsgImpl)dRSCacheMsg;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry.");
        }
        short s = dRSCacheMsgImpl.getAction();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, string + "action=" + DRSConstants.getActionString(s));
        }
        DRSGroup dRSGroup = this._groups.getDRSGroup(dRSCacheMsgImpl.agentID);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, string + "agentID=" + dRSCacheMsgImpl.agentID + " group=" + dRSGroup);
        }
        switch (s) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                if (null == dRSGroup && tc.isDebugEnabled()) {
                    Tr.debug(tc, string + "Warning. Group not found. agentID=" + dRSCacheMsgImpl.agentID);
                }
                this._entries.createOrUpdateEntry(dRSCacheMsgImpl.entryKey, dRSGroup, new Long(dRSCacheMsgImpl.instanceID));
                break;
            }
            case 9: {
                this._entries.removeEntry(dRSCacheMsgImpl.entryKey);
                break;
            }
            default: {
                if (!tc.isDebugEnabled()) break;
                Tr.debug(tc, string + "Ignoring action. Nothing to do. action=" + s);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Exit. Returning original dcm unchanged.");
        }
        return dRSCacheMsgImpl;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            stringBuffer.append("DRSGroupExtraction:").append("\n_entries=").append(null == this._entries ? "null" : "instantiated").append("\n_groups=").append(null == this._groups ? "null" : "instantiated").append("\nsuper=").append(super.toString());
        }
        catch (Throwable throwable) {
            return "Error. Could not append to StringBuffer in DRSGroupExtraction.";
        }
        return stringBuffer.toString();
    }
}

