/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.drs.stack;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.drs.message.DRSCacheMsgImpl;
import com.ibm.ws.drs.model.DRSEntries;
import com.ibm.ws.drs.model.DRSGroup;
import com.ibm.ws.drs.model.DRSGroups;
import com.ibm.ws.drs.stack.DRSStackLayerBase;
import com.ibm.wsspi.drs.DRSCacheMsg;

public class DRSGroupSelection
extends DRSStackLayerBase {
    private static TraceComponent tc = Tr.register(DRSGroupSelection.class.getName(), "DRS", "com.ibm.ws.drs.resources.drs");
    private static boolean _loggedVersion = false;
    protected DRSEntries _entries = null;
    private DRSGroups _groups = null;
    protected Long _drsInstanceID = null;

    public DRSGroupSelection(Long l, DRSEntries dRSEntries, DRSGroups dRSGroups) {
        if (tc.isDebugEnabled() && !_loggedVersion) {
            Tr.debug(tc, "CMVC Version 1.12 4/2/05 11:26:07");
            _loggedVersion = true;
        }
        this._drsInstanceID = l;
        this._entries = dRSEntries;
        this._groups = dRSGroups;
    }

    public DRSCacheMsg processSendMessage(DRSCacheMsg dRSCacheMsg) {
        String string = "processSendMessage: ";
        DRSCacheMsgImpl dRSCacheMsgImpl = (DRSCacheMsgImpl)dRSCacheMsg;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry. entryKey=" + dRSCacheMsgImpl.entryKey);
        }
        if (null != dRSCacheMsgImpl.destinationAddress) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, string + "Early exit. Destination already known.");
            }
            return dRSCacheMsgImpl;
        }
        if (dRSCacheMsgImpl.entryKey == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, string + "Exit Error. Group selection called with null entry key. dcm: " + dRSCacheMsgImpl);
            }
            return dRSCacheMsgImpl;
        }
        DRSGroup dRSGroup = null;
        if (!this._entries.entryExists(dRSCacheMsgImpl.entryKey)) {
            dRSGroup = this._groups.getNextPrimaryGroup();
            if (null == dRSGroup) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, string + "Exit. Error. No next primary group. Aborting dcm processing.");
                }
                dRSCacheMsgImpl.processingComplete = true;
                return dRSCacheMsgImpl;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + "New entry creation. Got next available group.");
            }
            this._entries.createEntry(dRSCacheMsgImpl.entryKey, dRSGroup, this._drsInstanceID, dRSGroup.getPartnerGroupMemberIDs());
            this._entries.setNeedsAnnounce(dRSCacheMsgImpl.entryKey, true);
        } else if (!this._entries.isMyEntry(dRSCacheMsgImpl.entryKey)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + "I do not presently own this entry. Setting myself as owner.");
            }
            if (null == (dRSGroup = this._groups.getNextPrimaryGroup())) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, string + "Exit. Error. Could not get next primary group. Terminating dcm processing.");
                }
                dRSCacheMsgImpl.processingComplete = true;
                this._entries.becomeOwner(dRSCacheMsgImpl.entryKey);
                return dRSCacheMsgImpl;
            }
            this._entries.updateEntry(dRSCacheMsgImpl.entryKey, dRSGroup, this._drsInstanceID, dRSGroup.getPartnerGroupMemberIDs());
            this._entries.setNeedsAnnounce(dRSCacheMsgImpl.entryKey, true);
        } else {
            dRSGroup = this._entries.getDRSGroup(dRSCacheMsgImpl.entryKey);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + "I own this entry. Using Group:" + dRSGroup);
            }
            if (this._entries.getNeedsAnnounce(dRSCacheMsgImpl.entryKey)) {
                this._entries.updateEntry(dRSCacheMsgImpl.entryKey, dRSGroup, this._drsInstanceID, dRSGroup.getPartnerGroupMemberIDs());
            }
        }
        dRSCacheMsgImpl.drsGroup = dRSGroup;
        dRSCacheMsgImpl.agentID = (String)dRSGroup.getAgent().getInstanceId().get("drs_agent_id");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Exit. drsGroup=" + dRSGroup);
        }
        return dRSCacheMsgImpl;
    }

    public DRSCacheMsg processRcvMessage(DRSCacheMsg dRSCacheMsg) {
        return dRSCacheMsg;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            stringBuffer.append("DRSGroupSelection:").append("\n_entries=").append(null == this._entries ? "null" : "instantiated").append("\nsuper=").append(super.toString());
        }
        catch (Throwable throwable) {
            return "Error. Could not append to StringBuffer in DRSGroupSelection.";
        }
        return stringBuffer.toString();
    }
}

