/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.drs.stack;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.drs.message.DRSCacheMsgImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.drs.DRSCacheMsg;
import com.ibm.wsspi.drs.DRSStackLayer;
import com.ibm.wsspi.drs.exception.DRSAckException;
import com.ibm.wsspi.drs.exception.DRSCongestedException;
import com.ibm.wsspi.hamanager.datastack.DataStackMemberException;
import com.ibm.wsspi.hamanager.datastack.DataStackMembershipChangingException;
import java.util.LinkedList;
import java.util.ListIterator;

public class DRSStack {
    private static TraceComponent tc = Tr.register(DRSStack.class.getName(), "DRS", "com.ibm.ws.drs.resources.drs");
    private static boolean _loggedVersion = false;
    private String _name = null;
    private LinkedList _stack;

    public DRSStack(String string) {
        String string2 = "constructor: ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string2 + "Entry. name=" + string);
        }
        if (tc.isDebugEnabled() && !_loggedVersion) {
            Tr.debug(tc, "CMVC Version 1.8 4/21/06 10:03:42");
            _loggedVersion = true;
        }
        this._name = string;
        this._stack = new LinkedList();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string2 + "Exit success.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTop(DRSStackLayer dRSStackLayer) {
        LinkedList linkedList = this._stack;
        synchronized (linkedList) {
            if (0 < this._stack.size()) {
                DRSStackLayer dRSStackLayer2 = (DRSStackLayer)this._stack.getFirst();
                dRSStackLayer2.setStackLayerAbove(dRSStackLayer);
                dRSStackLayer.setStackLayerBelow(dRSStackLayer2);
            }
            this._stack.addFirst(dRSStackLayer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBottom(DRSStackLayer dRSStackLayer) {
        LinkedList linkedList = this._stack;
        synchronized (linkedList) {
            if (0 < this._stack.size()) {
                DRSStackLayer dRSStackLayer2 = (DRSStackLayer)this._stack.getLast();
                dRSStackLayer2.setStackLayerBelow(dRSStackLayer);
                dRSStackLayer.setStackLayerAbove(dRSStackLayer2);
            }
            this._stack.addLast(dRSStackLayer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean swap(DRSStackLayer dRSStackLayer, String string) {
        String string2 = "swap: ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string2 + "Entry. _name=" + this._name + " old=" + string + " new=" + dRSStackLayer.getClass().getName() + " newLayer.hashcode=" + dRSStackLayer.hashCode());
        }
        boolean bl = false;
        LinkedList linkedList = this._stack;
        synchronized (linkedList) {
            DRSStackLayer dRSStackLayer2 = null;
            int n = -1;
            for (int i = 0; i < this._stack.size(); ++i) {
                dRSStackLayer2 = (DRSStackLayer)this._stack.get(i);
                if (dRSStackLayer2.getClass().getName().equals(string)) {
                    bl = true;
                    n = i;
                    if (!tc.isDebugEnabled()) break;
                    Tr.debug(tc, string2 + "Match. Found old stack layer. oldIndex=" + n);
                    break;
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, string2 + "No match. desired=" + string + " actual=" + dRSStackLayer2.getClass().getName());
            }
            if (bl) {
                DRSStackLayer dRSStackLayer3 = dRSStackLayer2.getStackLayerAbove();
                DRSStackLayer dRSStackLayer4 = dRSStackLayer2.getStackLayerBelow();
                dRSStackLayer.setStackLayerAbove(dRSStackLayer3);
                dRSStackLayer.setStackLayerBelow(dRSStackLayer4);
                if (null != dRSStackLayer3) {
                    dRSStackLayer3.setStackLayerBelow(dRSStackLayer);
                }
                if (null != dRSStackLayer4) {
                    dRSStackLayer4.setStackLayerAbove(dRSStackLayer);
                }
                this._stack.set(n, dRSStackLayer);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string2 + "Exit. Returning found=" + bl);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(String string) {
        String string2 = "contains: ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string2 + "Entry. _name=" + this._name + " desiredLayerName=" + string);
        }
        boolean bl = false;
        LinkedList linkedList = this._stack;
        synchronized (linkedList) {
            DRSStackLayer dRSStackLayer = null;
            for (int i = 0; i < this._stack.size(); ++i) {
                dRSStackLayer = (DRSStackLayer)this._stack.get(i);
                if (dRSStackLayer.getClass().getName().equals(string)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, string2 + "Match. Found stack layer.");
                    }
                    bl = true;
                    break;
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, string2 + "No match. desired=" + string + " actual=" + dRSStackLayer.getClass().getName());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string2 + "Exit. Returning:" + bl);
        }
        return bl;
    }

    public DRSCacheMsg processSendMessage(DRSCacheMsg dRSCacheMsg) throws Throwable {
        String string = "processSendMessage: ";
        DRSCacheMsgImpl dRSCacheMsgImpl = (DRSCacheMsgImpl)dRSCacheMsg;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry. _name=" + this._name);
        }
        for (int i = 0; i < this._stack.size(); ++i) {
            DRSStackLayer dRSStackLayer = (DRSStackLayer)this._stack.get(i);
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string + "Calling next stackLayer.");
                }
                dRSCacheMsgImpl = (DRSCacheMsgImpl)dRSStackLayer.processSendMessage(dRSCacheMsgImpl);
                if (!dRSCacheMsgImpl.processingComplete) continue;
                if (!tc.isDebugEnabled()) break;
                Tr.debug(tc, string + "Processing is complete. Breaking out of stack.");
                break;
            }
            catch (DRSCongestedException dRSCongestedException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string + "Error. Caught DRSCongestedException. t=" + dRSCongestedException);
                }
                throw dRSCongestedException;
            }
            catch (DRSAckException dRSAckException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string + "Error. Caught DRSAckException. t=" + dRSAckException);
                }
                throw dRSAckException;
            }
            catch (DataStackMemberException dataStackMemberException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string + "Error. Caught throwable. t=" + dataStackMemberException);
                }
                throw dataStackMemberException;
            }
            catch (DataStackMembershipChangingException dataStackMembershipChangingException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string + "Error. Caught throwable. t=" + dataStackMembershipChangingException);
                }
                throw dataStackMembershipChangingException;
            }
            catch (Throwable throwable) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string + "Error. Caught Throwable. t=" + throwable);
                }
                throw throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Exit.");
        }
        return dRSCacheMsgImpl;
    }

    public DRSCacheMsg processRcvMessage(DRSCacheMsg dRSCacheMsg) {
        String string = "processRcvMessage: ";
        DRSCacheMsgImpl dRSCacheMsgImpl = (DRSCacheMsgImpl)dRSCacheMsg;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry. _name=" + this._name);
        }
        for (int i = 0; i < this._stack.size(); ++i) {
            DRSStackLayer dRSStackLayer = (DRSStackLayer)this._stack.get(i);
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string + "Calling next stackLayer. ");
                }
                dRSCacheMsgImpl = (DRSCacheMsgImpl)dRSStackLayer.processRcvMessage(dRSCacheMsgImpl);
                if (!dRSCacheMsgImpl.processingComplete) continue;
                if (!tc.isDebugEnabled()) break;
                Tr.debug(tc, string + "Processing is complete. Breaking out of stack.");
                break;
            }
            catch (Throwable throwable) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string + "Error. Caught throwable. t=" + throwable);
                }
                FFDCFilter.processException(throwable, "com.ibm.ws.drs.stack.DRSStack.processRcvMessage", "104", this);
                throwable.printStackTrace();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Exit. Returning dcm.");
        }
        return dRSCacheMsgImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            stringBuffer.append("DRSStack. hashCode=").append(this.hashCode()).append("\nnumLayers=").append(this._stack.size()).append("\n_name=").append(this._name);
            ListIterator listIterator = null;
            Object object = this._stack;
            synchronized (object) {
                listIterator = this._stack.listIterator(0);
            }
            while (listIterator.hasNext()) {
                object = (DRSStackLayer)listIterator.next();
                stringBuffer.append("\n  Layer=").append(object.toString());
            }
        }
        catch (Throwable throwable) {
            return "Error. Could not append to StringBuffer in DRSStack.";
        }
        return stringBuffer.toString();
    }

    public void shutdownStack() {
        this._stack.clear();
    }
}

