/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.drs.stack;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.drs.DRSInstance;
import com.ibm.ws.drs.message.DRSCacheMsgImpl;
import com.ibm.ws.drs.message.DRSMessageHelper;
import com.ibm.ws.drs.pool.DRSPool;
import com.ibm.ws.drs.stack.DRSStackLayerBase;
import com.ibm.ws.drs.utils.DRSActionStats;
import com.ibm.ws.drs.utils.DRSConstants;
import com.ibm.ws.drs.utils.DRSSendMessageStats;
import com.ibm.wsspi.drs.DRSCacheMsg;
import com.ibm.wsspi.drs.exception.DRSAckException;
import com.ibm.wsspi.hamanager.datastack.DataStackMemberException;
import com.ibm.wsspi.hamanager.datastack.DataStackMembershipChangingException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;

public class DRSSyncAckSend
extends DRSStackLayerBase {
    private static TraceComponent tc = Tr.register(DRSSyncAckSend.class.getName(), "DRS", "com.ibm.ws.drs.resources.drs");
    private static boolean _loggedVersion = false;
    private DRSMessageHelper _messageHelper = null;
    private DRSActionStats _senderStats = null;
    private DRSPool _dcmPool = null;
    private HashMap _pendingAcks;
    private int _numberOfReplicas;
    private int _requestTimeout = 0;

    public DRSSyncAckSend(DRSInstance dRSInstance) {
        if (tc.isDebugEnabled() && !_loggedVersion) {
            Tr.debug(tc, "CMVC Version 1.13 6/5/06 13:50:59");
            _loggedVersion = true;
        }
        this._messageHelper = dRSInstance.getDomain().getMessageHelper();
        this._senderStats = dRSInstance.getDomain().getSentMessageStats();
        this._dcmPool = dRSInstance.getDcmPool();
        this._pendingAcks = dRSInstance.getPendingAcks();
        this._requestTimeout = dRSInstance.getDomain().getRequestTimeout();
        this._numberOfReplicas = dRSInstance.getDomain().getNumOfReplicas();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public DRSCacheMsg processSendMessage(DRSCacheMsg dRSCacheMsg) throws DRSAckException {
        Serializable serializable;
        String string = "processSendMessage: ";
        DRSCacheMsgImpl dRSCacheMsgImpl = (DRSCacheMsgImpl)dRSCacheMsg;
        long l = 0L;
        long l2 = 0L;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry. dcm.msgId=" + dRSCacheMsgImpl.msgId + " dcm.action=" + DRSConstants.getActionString(dRSCacheMsgImpl.getAction()));
        }
        Long l3 = new Long(dRSCacheMsgImpl.msgId);
        Object object = this._pendingAcks;
        // MONITORENTER : object
        this._pendingAcks.put(l3, dRSCacheMsgImpl);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, string + "Stored dcm in DRS instance's _pendingAcks table. key=" + l3 + " numPendingAcks=" + this._pendingAcks.size());
        }
        // MONITOREXIT : object
        this.calculateExpectedAcks(dRSCacheMsgImpl);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, string + "Sending request.");
        }
        l = System.currentTimeMillis();
        object = this._messageHelper.getSerializedForm(dRSCacheMsgImpl);
        if (null != object) {
            block50: {
                block49: {
                    this._senderStats.update(dRSCacheMsgImpl.getAction());
                    serializable = Long.getLong("DRS_STACKEXCEPTION_SLEEP_TIME", 333L);
                    try {
                        try {
                            dRSCacheMsgImpl.drsGroup.send((byte[])object, dRSCacheMsgImpl.destinationAddress);
                        }
                        catch (DataStackMemberException dataStackMemberException) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, string + "Error. Caught throwable. t=" + dataStackMemberException + " Retrying send");
                            }
                            try {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, string + "Retrying sendMessage() after sleeping: " + serializable + "ms");
                                }
                                Thread.sleep((Long)serializable);
                                this.calculateExpectedAcks(dRSCacheMsgImpl);
                                dRSCacheMsgImpl.drsGroup.send((byte[])object, dRSCacheMsgImpl.destinationAddress);
                            }
                            catch (Throwable throwable) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, string + "Error. Caught throwable. t=" + throwable);
                                }
                                HashMap hashMap = this._pendingAcks;
                                // MONITORENTER : hashMap
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, string + "Removing dcm from _pendingAcks table. key=" + l3 + " numPendingAcks(before)=" + this._pendingAcks.size());
                                }
                                this._pendingAcks.remove(l3);
                                // MONITOREXIT : hashMap
                                throw new DRSAckException();
                            }
                            Object var18_10 = null;
                            l2 = System.currentTimeMillis();
                            DRSSendMessageStats dRSSendMessageStats = null;
                            dRSSendMessageStats = null != dRSCacheMsgImpl.objValue ? new DRSSendMessageStats(l, l2, ((Object)object).length, dRSCacheMsgImpl.objValue.getClass().getName(), dRSCacheMsgImpl.drsInstanceName, dRSCacheMsgImpl.getAction()) : new DRSSendMessageStats(l, l2, ((Object)object).length, null, dRSCacheMsgImpl.drsInstanceName, dRSCacheMsgImpl.getAction());
                            this._senderStats.updateMessageStats(dRSSendMessageStats);
                            break block49;
                        }
                        catch (DataStackMembershipChangingException dataStackMemberException) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, string + "Error. Caught throwable. t=" + dataStackMemberException + " Retrying send");
                            }
                            try {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, string + "Retrying sendMessage() after sleeping: " + serializable + "ms");
                                }
                                Thread.sleep((Long)serializable);
                                this.calculateExpectedAcks(dRSCacheMsgImpl);
                                dRSCacheMsgImpl.drsGroup.send((byte[])object, dRSCacheMsgImpl.destinationAddress);
                            }
                            catch (Throwable throwable) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, string + "Error. Caught throwable. t=" + throwable);
                                }
                                HashMap hashMap = this._pendingAcks;
                                // MONITORENTER : hashMap
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, string + "Removing dcm from _pendingAcks table. key=" + l3 + " numPendingAcks(before)=" + this._pendingAcks.size());
                                }
                                this._pendingAcks.remove(l3);
                                // MONITOREXIT : hashMap
                                throw new DRSAckException();
                            }
                            Object var18_11 = null;
                            l2 = System.currentTimeMillis();
                            DRSSendMessageStats dRSSendMessageStats2 = null;
                            dRSSendMessageStats2 = null != dRSCacheMsgImpl.objValue ? new DRSSendMessageStats(l, l2, ((Object)object).length, dRSCacheMsgImpl.objValue.getClass().getName(), dRSCacheMsgImpl.drsInstanceName, dRSCacheMsgImpl.getAction()) : new DRSSendMessageStats(l, l2, ((Object)object).length, null, dRSCacheMsgImpl.drsInstanceName, dRSCacheMsgImpl.getAction());
                            this._senderStats.updateMessageStats(dRSSendMessageStats2);
                            break block49;
                        }
                        catch (Throwable dataStackMembershipChangingException) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, string + "Error. Caught throwable. t=" + dataStackMembershipChangingException);
                            }
                            HashMap throwable = this._pendingAcks;
                            // MONITORENTER : throwable
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, string + "Removing dcm from _pendingAcks table. key=" + l3 + " numPendingAcks(before)=" + this._pendingAcks.size());
                            }
                            this._pendingAcks.remove(l3);
                            // MONITOREXIT : throwable
                            throw new DRSAckException();
                        }
                        Object var18_9 = null;
                        l2 = System.currentTimeMillis();
                        DRSSendMessageStats dRSSendMessageStats = null;
                        dRSSendMessageStats = null != dRSCacheMsgImpl.objValue ? new DRSSendMessageStats(l, l2, ((Object)object).length, dRSCacheMsgImpl.objValue.getClass().getName(), dRSCacheMsgImpl.drsInstanceName, dRSCacheMsgImpl.getAction()) : new DRSSendMessageStats(l, l2, ((Object)object).length, null, dRSCacheMsgImpl.drsInstanceName, dRSCacheMsgImpl.getAction());
                        this._senderStats.updateMessageStats(dRSSendMessageStats);
                    }
                    catch (Throwable throwable) {
                        Object var18_12 = null;
                        l2 = System.currentTimeMillis();
                        DRSSendMessageStats dRSSendMessageStats3 = null;
                        dRSSendMessageStats3 = null != dRSCacheMsgImpl.objValue ? new DRSSendMessageStats(l, l2, ((Object)object).length, dRSCacheMsgImpl.objValue.getClass().getName(), dRSCacheMsgImpl.drsInstanceName, dRSCacheMsgImpl.getAction()) : new DRSSendMessageStats(l, l2, ((Object)object).length, null, dRSCacheMsgImpl.drsInstanceName, dRSCacheMsgImpl.getAction());
                        this._senderStats.updateMessageStats(dRSSendMessageStats3);
                        throw throwable;
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string + "Sent request. dcm=" + dRSCacheMsgImpl);
                }
                try {
                    DRSCacheMsgImpl throwable = dRSCacheMsgImpl;
                    // MONITORENTER : throwable
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, string + "Waiting for a response. timeout=" + this._requestTimeout);
                    }
                    dRSCacheMsgImpl.wait(this._requestTimeout);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, string + "Awakened after waiting for a response for " + dRSCacheMsgImpl);
                    }
                    // MONITOREXIT : throwable
                }
                catch (InterruptedException dRSCacheMsgImpl2) {
                    if (!tc.isDebugEnabled()) break block50;
                    Tr.debug(tc, string + "Error. Caught exception while waiting for a response.");
                }
            }
            int interruptedException = 0;
            ArrayList hashMap = dRSCacheMsgImpl.acks;
            // MONITORENTER : hashMap
            interruptedException = dRSCacheMsgImpl.acks.size();
            // MONITOREXIT : hashMap
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + "Analyzing number of acks. expected=" + dRSCacheMsgImpl.numOfExpectedAcks + " actual=" + interruptedException);
            }
            if (interruptedException < dRSCacheMsgImpl.numOfExpectedAcks) {
                if (!tc.isDebugEnabled()) throw new DRSAckException();
                Tr.debug(tc, string + "Received insufficient acks.");
                throw new DRSAckException();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + "Received all expected acks.");
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, string + "Serialization failed, message not sent.");
        }
        serializable = this._pendingAcks;
        // MONITORENTER : serializable
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, string + "Removing dcm from _pendingAcks table. key=" + l3 + " numPendingAcks(before)=" + this._pendingAcks.size());
        }
        this._pendingAcks.remove(l3);
        // MONITOREXIT : serializable
        return dRSCacheMsgImpl;
    }

    private void calculateExpectedAcks(DRSCacheMsgImpl dRSCacheMsgImpl) {
        int n = dRSCacheMsgImpl.drsGroup.getNumGroupMembers();
        dRSCacheMsgImpl.numOfExpectedAcks = this._numberOfReplicas <= 0 ? n : (n < this._numberOfReplicas ? n : this._numberOfReplicas);
    }

    public DRSCacheMsg processRcvMessage(DRSCacheMsg dRSCacheMsg) {
        String string = "processRcvMessage: ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry. Empty method.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Exit. dcm=" + dRSCacheMsg);
        }
        return dRSCacheMsg;
    }
}

