/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.drs.utils;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.drs.utils.DRSSendMessageStats;
import java.util.LinkedList;

public class DRSActionStats {
    TraceComponent tc = Tr.register(DRSActionStats.class.getName(), "DRS", "com.ibm.ws.drs.resources.drs");
    String name = null;
    private int _unknown = 0;
    private int _createEntry = 0;
    private int _createEntryProp = 0;
    private int _updateEntry = 0;
    private int _updateEntryProp = 0;
    private int _getEntryReq = 0;
    private int _getEntryRsp = 0;
    private int _getEntryPropReq = 0;
    private int _getEntryPropRsp = 0;
    private int _removeEntry = 0;
    private int _removeLocalEntry = 0;
    private int _removeEntryProp = 0;
    private int _entryIDExistsReq = 0;
    private int _entryIDExistsRsp = 0;
    private int _propIDExistsReq = 0;
    private int _propIDExistsRsp = 0;
    private int _bootstrapReq = 0;
    private int _bootstrapRsp = 0;
    private int _partTopic = 0;
    private int _otherEntryParts = 0;
    private int _leaving = 0;
    private int _ping = 0;
    private int _ack = 0;
    private int _announceEntries = 0;
    private int _renounceEntries = 0;
    private int _broadcast = 0;
    private int _response = 0;
    private int _solicitEntriesReq = 0;
    private int _solicitEntriesRsp = 0;
    private int _domainMetricsReq = 0;
    private int _domainMetricsRsp = 0;
    private int _promotedBackups = 0;
    private int _total = 0;
    private LinkedList messageStats = null;
    private boolean printMessageStats = false;
    private boolean statsLogging = false;
    private int loggingLevel = 0;

    public DRSActionStats(String string) {
        this.name = string;
        this.messageStats = new LinkedList();
        if (Boolean.getBoolean("ENABLE_DRS_STATS_LOGGING")) {
            this.statsLogging = true;
        }
        Integer n = Integer.getInteger("DRS_STATS_LOGGING_LVL", 0);
        this.loggingLevel = n;
    }

    public synchronized void update(int n) {
        switch (n) {
            case 1: {
                ++this._createEntry;
                break;
            }
            case 2: {
                ++this._createEntryProp;
                break;
            }
            case 3: {
                ++this._updateEntry;
                break;
            }
            case 4: {
                ++this._updateEntryProp;
                break;
            }
            case 5: {
                ++this._getEntryReq;
                break;
            }
            case 6: {
                ++this._getEntryRsp;
                break;
            }
            case 7: {
                ++this._getEntryPropReq;
                break;
            }
            case 8: {
                ++this._getEntryPropRsp;
                break;
            }
            case 9: {
                ++this._removeEntry;
                break;
            }
            case 30: {
                ++this._removeLocalEntry;
                break;
            }
            case 10: {
                ++this._removeEntryProp;
                break;
            }
            case 11: {
                ++this._entryIDExistsReq;
                break;
            }
            case 12: {
                ++this._entryIDExistsRsp;
                break;
            }
            case 13: {
                ++this._propIDExistsReq;
                break;
            }
            case 14: {
                ++this._propIDExistsRsp;
                break;
            }
            case 15: {
                ++this._bootstrapReq;
                break;
            }
            case 21: {
                ++this._bootstrapRsp;
                break;
            }
            case 16: {
                ++this._partTopic;
                break;
            }
            case 17: {
                ++this._otherEntryParts;
                break;
            }
            case 18: {
                ++this._leaving;
                break;
            }
            case 19: {
                ++this._ping;
                break;
            }
            case 20: {
                ++this._ack;
                break;
            }
            case 22: {
                ++this._announceEntries;
                break;
            }
            case 23: {
                ++this._renounceEntries;
                break;
            }
            case 24: {
                ++this._broadcast;
                break;
            }
            case 25: {
                ++this._response;
                break;
            }
            case 26: {
                ++this._solicitEntriesReq;
                break;
            }
            case 27: {
                ++this._solicitEntriesRsp;
                break;
            }
            case 28: {
                ++this._domainMetricsReq;
                break;
            }
            case 29: {
                ++this._domainMetricsRsp;
                break;
            }
            case 31: {
                ++this._promotedBackups;
                break;
            }
            default: {
                ++this._unknown;
            }
        }
        ++this._total;
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            stringBuffer.append(this.name).append(": tot=").append(this._total).append(" ce=").append(this._createEntry).append(" cep=").append(this._createEntryProp).append(" ue=").append(this._updateEntry).append(" uep=").append(this._updateEntryProp).append(" geRq=").append(this._getEntryReq).append(" geRs=").append(this._getEntryRsp).append(" gepRq=").append(this._getEntryPropReq).append(" gepRs=").append(this._getEntryPropRsp).append(" re=").append(this._removeEntry).append(" rle=").append(this._removeLocalEntry).append(" rep=").append(this._removeEntryProp).append(" eidRq=").append(this._entryIDExistsReq).append(" eidRs=").append(this._entryIDExistsRsp).append(" pidRq=").append(this._propIDExistsReq).append(" pidRs=").append(this._propIDExistsRsp).append(" bsRq=").append(this._bootstrapReq).append(" bsRs=").append(this._bootstrapRsp).append(" pt=").append(this._partTopic).append(" oep=").append(this._otherEntryParts).append(" lv=").append(this._leaving).append(" png=").append(this._ping).append(" ack=").append(this._ack).append(" ane=").append(this._announceEntries).append(" rne=").append(this._renounceEntries).append(" bcast=").append(this._broadcast).append(" resp=").append(this._response).append(" seRq=").append(this._solicitEntriesReq).append(" seRs=").append(this._solicitEntriesRsp).append(" dmRq=").append(this._domainMetricsReq).append(" dmRs=").append(this._domainMetricsRsp).append(" prom=").append(this._promotedBackups).append(" unk=").append(this._unknown);
        }
        catch (Exception exception) {
            return "Error formatting toString in DRSActionStats. e=" + exception;
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStats() {
        String string = "printStats: ";
        DRSSendMessageStats dRSSendMessageStats = null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        long l = 0L;
        if (this.tc.isDebugEnabled()) {
            Tr.debug(this.tc, string + this.toString());
        }
        if (this.tc.isDebugEnabled()) {
            Tr.debug(this.tc, string + "Logging Level: " + this.loggingLevel);
        }
        if (this.printMessageStats && this.loggingLevel > 0) {
            LinkedList linkedList = this.messageStats;
            synchronized (linkedList) {
                int n4 = this.messageStats.size();
                for (int i = 0; i < n4; ++i) {
                    dRSSendMessageStats = (DRSSendMessageStats)this.messageStats.remove(0);
                    if (i == 0) {
                        n2 = dRSSendMessageStats._size;
                        l = dRSSendMessageStats._startTime;
                    }
                    n3 += dRSSendMessageStats._size;
                    if (dRSSendMessageStats._size > n) {
                        n = dRSSendMessageStats._size;
                    }
                    if (dRSSendMessageStats._size < n2) {
                        n2 = dRSSendMessageStats._size;
                    }
                    if (this.loggingLevel != 2) continue;
                    Tr.info(this.tc, "msgStats " + dRSSendMessageStats.toString());
                }
                Tr.info(this.tc, "msgStats Max: " + n + " Min: " + n2 + " Avg: " + n3 / n4 + " Total: " + n3 + " Number of messages: " + n4 + " Block time: " + (dRSSendMessageStats._startTime - l));
                this.printMessageStats = false;
            }
        }
    }

    public synchronized int getTotal() {
        return this._total;
    }

    public boolean isDebugEnabled() {
        return this.tc.isDebugEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMessageStats(DRSSendMessageStats dRSSendMessageStats) {
        if (this.tc.isEntryEnabled()) {
            Tr.entry(this.tc, "updateMessageStats Entry.");
        }
        if (this.statsLogging && this.loggingLevel > 0) {
            Integer n = Integer.getInteger("DRS_DUMP_SEND_MSG_STATS", 50);
            LinkedList linkedList = this.messageStats;
            synchronized (linkedList) {
                this.messageStats.add(dRSSendMessageStats);
            }
            int n2 = this.messageStats.size();
            if (this.tc.isDebugEnabled()) {
                Tr.debug(this.tc, "updateMessageStats listSize=" + n2);
            }
            if (n2 >= n) {
                if (this.tc.isDebugEnabled()) {
                    Tr.debug(this.tc, "updateMessageStats setting flag to dump stats");
                }
                this.printMessageStats = true;
            }
        } else if (this.tc.isDebugEnabled()) {
            Tr.debug(this.tc, "updateMessageStats stats logging not enabled");
        }
        if (this.tc.isEntryEnabled()) {
            Tr.exit(this.tc, "updateMessageStats Exit.");
        }
    }
}

