/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.drs.utils;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.drs.utils.DRSUtils;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.Base64Coder;
import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;

public class DRSCrypto {
    private static TraceComponent tc = Tr.register(DRSCrypto.class.getName(), "DRS", "com.ibm.ws.drs.resources.drs");
    private static boolean _loggedVersion = false;
    private boolean initted;
    private Cipher enc_cp;
    private Cipher dec_cp;

    public DRSCrypto(boolean bl, SecretKey secretKey) {
        block11: {
            this.initted = false;
            this.enc_cp = null;
            this.dec_cp = null;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "constructor: use_3des->" + bl);
            }
            if (tc.isDebugEnabled() && !_loggedVersion) {
                Tr.debug(tc, "CMVC Version 1.8 5/24/05 17:25:17");
                _loggedVersion = true;
            }
            boolean bl2 = bl;
            SecretKey secretKey2 = secretKey;
            String string = Security.getProperty("DEFAULT_JCE_PROVIDER");
            if (null == string) {
                string = "IBMJCE";
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "using JCE provider: " + string);
            }
            if (!bl2 && (-1 != string.indexOf("FIPS") || "true".equals(Security.getProperty("USEFIPS_ENABLED")))) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "FIPS enabled, forcing 3DES.");
                }
                bl2 = true;
            }
            try {
                if (!bl2) {
                    this.enc_cp = Cipher.getInstance("DES/ECB/PKCS5Padding", string);
                    this.dec_cp = Cipher.getInstance("DES/ECB/PKCS5Padding", string);
                } else {
                    this.enc_cp = Cipher.getInstance("TripleDES/ECB/PKCS5Padding", string);
                    this.dec_cp = Cipher.getInstance("TripleDES/ECB/PKCS5Padding", string);
                }
                this.enc_cp.init(1, secretKey2);
                this.dec_cp.init(2, secretKey2);
                this.initted = true;
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.drs.utils.DRSCrypto", "1", this);
                if (!tc.isDebugEnabled()) break block11;
                Tr.debug(tc, "Initialization of crypto ciphers failed.");
                DRSUtils.debugPrintStackTrace(throwable);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "constructor: init->" + this.initted);
        }
    }

    public byte[] encrypt(byte[] byArray) {
        if (!this.initted) {
            return byArray;
        }
        try {
            return this.enc_cp.doFinal(byArray);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.drs.utils.DRSCrypto.encrypt", "1", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Encryption failed with " + byArray);
                DRSUtils.debugPrintStackTrace(throwable);
            }
            return byArray;
        }
    }

    public byte[] decrypt(byte[] byArray) {
        if (!this.initted) {
            return byArray;
        }
        try {
            return this.dec_cp.doFinal(byArray);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.drs.utils.DRSCrypto.decrypt", "1", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Decryption failed with " + byArray);
                DRSUtils.debugPrintStackTrace(throwable);
            }
            return byArray;
        }
    }

    public static SecretKey getSecretKey(String string) {
        SecretKey secretKey;
        block7: {
            ObjectInputStream objectInputStream;
            ByteArrayInputStream byteArrayInputStream;
            block6: {
                String string2 = "getSecretKey: ";
                secretKey = null;
                byteArrayInputStream = null;
                objectInputStream = null;
                try {
                    byte[] byArray = string.getBytes("UTF-8");
                    byte[] byArray2 = Base64Coder.base64Decode(byArray);
                    byteArrayInputStream = new ByteArrayInputStream(byArray2);
                    objectInputStream = new ObjectInputStream(byteArrayInputStream);
                    secretKey = (SecretKey)objectInputStream.readObject();
                }
                catch (Throwable throwable) {
                    Tr.error(tc, "drs.throwable", throwable);
                    if (!tc.isDebugEnabled()) break block6;
                    Tr.debug(tc, string2 + "Unable to generate SecretKey.");
                }
            }
            try {
                if (null != objectInputStream) {
                    objectInputStream.close();
                }
                if (null != byteArrayInputStream) {
                    byteArrayInputStream.close();
                }
            }
            catch (Throwable throwable) {
                if (!tc.isDebugEnabled()) break block7;
                Tr.debug(tc, "Failed to close stream: " + throwable);
            }
        }
        return secretKey;
    }
}

