/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.drs.utils;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;

public class DRSUtils {
    private static TraceComponent tc = Tr.register(DRSUtils.class.getName(), "DRS", "com.ibm.ws.drs.resources.drs");

    public static byte[] getBytes(Object object) throws Throwable {
        if (object instanceof byte[]) {
            return (byte[])object;
        }
        ByteArrayOutputStream byteArrayOutputStream = null;
        ObjectOutputStream objectOutputStream = null;
        byte[] byArray = new byte[]{};
        byteArrayOutputStream = new ByteArrayOutputStream();
        objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(object);
        byArray = byteArrayOutputStream.toByteArray();
        objectOutputStream.close();
        byteArrayOutputStream.close();
        return byArray;
    }

    private DRSUtils() {
    }

    public static String lineTraceString(byte[] byArray, int n) {
        String string = "";
        byte[] byArray2 = new byte[16];
        if (byArray.length < 1) {
            return string;
        }
        if (n < 1) {
            return string;
        }
        if (byArray.length < n) {
            return string;
        }
        int n2 = 0;
        while (n2 < n) {
            int n3;
            for (int i = 0; i < 16; ++i) {
                byArray2[i] = 0;
            }
            String string2 = "" + n2;
            switch (string2.length()) {
                case 1: {
                    string = string + "0000" + string2 + "   ";
                    break;
                }
                case 2: {
                    string = string + "000" + string2 + "   ";
                    break;
                }
                case 3: {
                    string = string + "00" + string2 + "   ";
                    break;
                }
                case 4: {
                    string = string + "0" + string2 + "   ";
                    break;
                }
                default: {
                    string = string + string2 + "   ";
                }
            }
            for (n3 = 0; n3 < 16; ++n3) {
                if (n2 < n) {
                    byArray2[n3] = byArray[n2];
                    string = string + DRSUtils.b2x(byArray2[n3]) + " ";
                } else {
                    string = string + ".. ";
                }
                ++n2;
                if (n3 != 7) continue;
                string = string + " ";
            }
            string = string + "  '";
            for (n3 = 0; n3 < 16; ++n3) {
                string = (char)byArray2[n3] >= ' ' && (char)byArray2[n3] <= '~' ? string + (char)byArray2[n3] : string + ".";
            }
            string = string + "'\n";
        }
        return string;
    }

    public static String b2x(byte by) {
        int n = by >> 4 & 0xF;
        int n2 = by & 0xF;
        String string = null;
        String string2 = null;
        switch (n) {
            case 0: {
                string = "0";
                break;
            }
            case 1: {
                string = "1";
                break;
            }
            case 2: {
                string = "2";
                break;
            }
            case 3: {
                string = "3";
                break;
            }
            case 4: {
                string = "4";
                break;
            }
            case 5: {
                string = "5";
                break;
            }
            case 6: {
                string = "6";
                break;
            }
            case 7: {
                string = "7";
                break;
            }
            case 8: {
                string = "8";
                break;
            }
            case 9: {
                string = "9";
                break;
            }
            case 10: {
                string = "A";
                break;
            }
            case 11: {
                string = "B";
                break;
            }
            case 12: {
                string = "C";
                break;
            }
            case 13: {
                string = "D";
                break;
            }
            case 14: {
                string = "E";
                break;
            }
            case 15: {
                string = "F";
            }
        }
        switch (n2) {
            case 0: {
                string2 = "0";
                break;
            }
            case 1: {
                string2 = "1";
                break;
            }
            case 2: {
                string2 = "2";
                break;
            }
            case 3: {
                string2 = "3";
                break;
            }
            case 4: {
                string2 = "4";
                break;
            }
            case 5: {
                string2 = "5";
                break;
            }
            case 6: {
                string2 = "6";
                break;
            }
            case 7: {
                string2 = "7";
                break;
            }
            case 8: {
                string2 = "8";
                break;
            }
            case 9: {
                string2 = "9";
                break;
            }
            case 10: {
                string2 = "A";
                break;
            }
            case 11: {
                string2 = "B";
                break;
            }
            case 12: {
                string2 = "C";
                break;
            }
            case 13: {
                string2 = "D";
                break;
            }
            case 14: {
                string2 = "E";
                break;
            }
            case 15: {
                string2 = "F";
            }
        }
        String string3 = string + string2;
        return string3;
    }

    public static void debugPrintStackTrace(Throwable throwable) {
        Tr.debug(tc, "Logging exception: " + throwable);
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            Tr.debug(tc, "  " + stackTraceElementArray[i].toString());
        }
    }
}

