/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.drs.ws390;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.applicationserver.webcontainer.DRSSettings;
import com.ibm.ws.drs.DRSDataXferImpl;
import com.ibm.ws.drs.DRSInstance;
import com.ibm.ws.drs.ws390.DRSBootstrapWrapper;
import com.ibm.ws.drs.ws390.DRSCacheMsgListenerWrapper;
import com.ibm.ws.drs.ws390.DRSControllerDataXferImpl;
import com.ibm.ws.drs.ws390.DRSControllerInstanceImpl;
import com.ibm.ws.drs.ws390.DRSControllerInstanceWrapper;
import com.ibm.ws.drs.ws390.DRSControllerSettings;
import com.ibm.ws.drs.ws390.DRSInstanceConfig;
import com.ibm.ws.drs.ws390.DRSInstanceTokenImpl;
import com.ibm.ws.drs.ws390.DRSPlatformHelper;
import com.ibm.ws.drs.ws390.DRSServantProxyFactoryImpl;
import com.ibm.ws.drs.ws390.DRSServantProxyWrapper;
import com.ibm.ws.drs.ws390.DRSSettingsWrapper;
import com.ibm.ws.drs.ws390.proxy.controller.DRSControllerProxy;
import com.ibm.ws.drs.ws390.proxy.controller.DRSControllerProxyHelper;
import com.ibm.ws.drs.ws390.proxy.controller.DRSControllerProxyImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.util.PlatformUtils;
import com.ibm.ws.runtime.component.MultibrokerDomainImpl;
import com.ibm.ws.util.ImplFactory;
import com.ibm.ws.util.JVMListenerInterface;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.wsspi.drs.DRSControllerDataXfer;
import com.ibm.wsspi.drs.DRSControllerInstance;
import com.ibm.wsspi.drs.DRSControllerInstanceFactory;
import com.ibm.wsspi.drs.DRSControllerInstanceFactoryConfig;
import com.ibm.wsspi.drs.DRSDataXfer;
import com.ibm.wsspi.drs.DRSInstanceToken;
import com.ibm.wsspi.drs.DRSInstanceTokenTable;
import com.ibm.wsspi.drs.DRSServantProxy;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class DRSControllerInstanceFactoryImpl
implements JVMListenerInterface {
    private static Integer factoryLock = new Integer(1);
    private static TraceComponent tc = Tr.register(DRSControllerInstanceFactoryImpl.class.getName(), "DRS", "com.ibm.ws.drs.resources.drs");
    private static DRSControllerInstanceFactoryImpl instanceFactory = null;
    private static Hashtable DRSControllerInstanceFactories = new Hashtable();
    private static boolean _loggedVersion = false;
    private Integer instanceLock;
    private Integer proxyLock;
    private Integer confirmLock;
    private Integer nextInstanceLock;
    private Integer nextServantLock;
    private LinkedList DRSDataXfers;
    private Integer DRSDataXfersLock;
    private HashMap DRSInstances;
    private HashMap DRSWrappers;
    private HashMap unRegisteredServants;
    private HashMap registeredServants;
    private DRSSettings drss;
    private PlatformUtils platformUtils;
    private MultibrokerDomainImpl _mbd;
    private DRSControllerProxyImpl drsControllerProxyImpl = null;
    private DRSControllerProxyHelper drsControllerProxyHelper = null;
    private DRSControllerProxy drsControllerProxy = null;
    private static Object CorbaProxyRef = null;
    private static boolean proxyIsInitialized = false;
    private long servantNumber;
    private long instanceNumber;
    private int dataXferOffsetNumber;
    private DRSInstanceTokenTable registeredServantTokens;
    private DRSInstanceTokenTable confirmedServantTokens;
    private boolean usingHAManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createDRSControllerProxy() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DRSControllerInstanceFactoryImpl:createDRSControllerProxy: Entry.");
        }
        Integer n = this.proxyLock;
        synchronized (n) {
            if (!proxyIsInitialized) {
                try {
                    this.drsControllerProxyHelper = DRSControllerProxyHelper.createInstance();
                    this.drsControllerProxyImpl = new DRSControllerProxyImpl();
                    this.drsControllerProxy = this.drsControllerProxyImpl;
                    CorbaProxyRef = this.drsControllerProxyImpl;
                    PlatformHelperFactory.getPlatformHelper().register_initial_reference(DRSPlatformHelper.getDRSControllerProxyId(), CorbaProxyRef);
                    proxyIsInitialized = true;
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ws.drs.ws390.DRSControllerInstanceFactoryImpl.createDRSControllerProxy", "175", this);
                    Tr.error(tc, "drs.throwable.contproxy", new Object[]{"DRSControllerInstanceFactoryImpl:createDRSControllerProxy: ", throwable});
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DRSControllerInstanceFactoryImpl:createDRSControllerProxy: Exit: proxyIsInitialized = " + proxyIsInitialized);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getNextServantNumber() {
        long l;
        Integer n = this.nextServantLock;
        synchronized (n) {
            ++this.servantNumber;
            if (this.servantNumber < 1L) {
                this.servantNumber = 1L;
            }
            l = this.servantNumber;
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getNextInstanceNumber() {
        long l;
        Integer n = this.nextInstanceLock;
        synchronized (n) {
            ++this.instanceNumber;
            if (this.instanceNumber < 1L) {
                this.instanceNumber = 1L;
            }
            l = this.instanceNumber;
        }
        return l;
    }

    private void setBaseConfig() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DRSControllerInstanceFactoryImpl:setBaseConfig: Entry.");
        }
        if (DRSPlatformHelper.isZOSBaseServer()) {
            this.usingHAManager = false;
        } else {
            this.usingHAManager = this._mbd.isHAManagerRunning();
            if (!this.usingHAManager) {
                Tr.error(tc, "drs.controller.initialization.hamanager.notfound", new Object[]{"DRSControllerInstanceFactoryImpl:setBaseConfig: "});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DRSControllerInstanceFactoryImpl:setBaseConfig: Exit - usingHAManager = " + this.usingHAManager);
        }
    }

    public boolean usingHAManager() {
        return this.usingHAManager;
    }

    private boolean isRegisteredStoken(String string) {
        boolean bl = false;
        if (string != null) {
            bl = this.confirmedServantTokens.containsStoken(string);
        }
        return bl;
    }

    private DRSControllerInstanceFactoryImpl(MultibrokerDomainImpl multibrokerDomainImpl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DRSControllerInstanceFactoryImpl:constructor: Entry.");
        }
        if (tc.isDebugEnabled() && !_loggedVersion) {
            Tr.debug(tc, "DRSControllerInstanceFactoryImpl:constructor: Version 1.13.1.1 10/27/08 12:45:28");
            _loggedVersion = true;
        }
        try {
            this.instanceLock = new Integer(2);
            this.proxyLock = new Integer(3);
            this.confirmLock = new Integer(4);
            this.DRSInstances = new HashMap();
            this.DRSWrappers = new HashMap();
            this.unRegisteredServants = new HashMap();
            this.registeredServants = new HashMap();
            this.DRSDataXfers = new LinkedList();
            this.DRSDataXfersLock = new Integer(8);
            this.nextInstanceLock = new Integer(10);
            this.nextServantLock = new Integer(11);
            this._mbd = multibrokerDomainImpl;
            this.platformUtils = (PlatformUtils)ImplFactory.loadImplFromKey(PlatformUtils.class);
            this.createDRSControllerProxy();
            this.servantNumber = 0L;
            this.instanceNumber = 0L;
            this.dataXferOffsetNumber = 0;
            this.registeredServantTokens = DRSControllerInstanceFactoryConfig.createDRSInstanceTokenTable("DRSControllerInstanceFactory", "registeredServantTokens");
            this.confirmedServantTokens = DRSControllerInstanceFactoryConfig.createDRSInstanceTokenTable("DRSControllerInstanceFactory", "confirmedServantTokens");
            this.setBaseConfig();
            AdminHelper.getPlatformHelper().registerListener(this);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.drs.ws390.DRSControllerInstanceFactoryImpl:constructor", "308", this);
            Tr.error(tc, "drs.throwable.controller", new Object[]{"DRSControllerInstanceFactoryImpl:constructor: ", throwable});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DRSControllerInstanceFactoryImpl:constructor: Exit.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int addToDRSControllerDataXferList(DRSControllerDataXfer dRSControllerDataXfer) {
        int n = -1;
        if (dRSControllerDataXfer != null) {
            Integer n2 = this.DRSDataXfersLock;
            synchronized (n2) {
                if (!this.DRSDataXfers.contains(dRSControllerDataXfer)) {
                    this.DRSDataXfers.addLast(dRSControllerDataXfer);
                }
                n = this.DRSDataXfers.indexOf(dRSControllerDataXfer);
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DRSControllerDataXfer getDRSControllerDataXferFromList(DRSInstanceTokenImpl dRSInstanceTokenImpl) {
        DRSControllerDataXfer dRSControllerDataXfer = null;
        if (dRSInstanceTokenImpl != null) {
            Integer n = this.DRSDataXfersLock;
            synchronized (n) {
                int n2 = dRSInstanceTokenImpl.getXferOffset();
                if (n2 >= 0 && n2 < this.DRSDataXfers.size()) {
                    dRSControllerDataXfer = (DRSControllerDataXfer)this.DRSDataXfers.get(n2);
                }
            }
        }
        return dRSControllerDataXfer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DRSControllerInstanceFactoryImpl createInstance(MultibrokerDomainImpl multibrokerDomainImpl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DRSControllerInstanceFactoryImpl:createInstance: Entry.");
        }
        Integer n = factoryLock;
        synchronized (n) {
            if (DRSPlatformHelper.isZOS_Control_Region()) {
                if (instanceFactory == null) {
                    instanceFactory = new DRSControllerInstanceFactoryImpl(multibrokerDomainImpl);
                }
            } else {
                Tr.error(tc, "drs.cont.environ", "DRSControllerInstanceFactoryImpl:createInstance: ");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DRSControllerInstanceFactoryImpl:createInstance: Exit.");
        }
        return instanceFactory;
    }

    public static DRSControllerInstanceFactoryImpl getInstance() {
        return instanceFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setControllerInstanceFactory(String string, DRSControllerInstanceFactory dRSControllerInstanceFactory) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DRSControllerInstanceFactoryImpl:setControllerInstanceFactory: Entry.");
        }
        if (string == null) {
            return;
        }
        if (dRSControllerInstanceFactory == null) {
            return;
        }
        if (DRSPlatformHelper.isZOS_Control_Region()) {
            Integer n = factoryLock;
            synchronized (n) {
                DRSControllerInstanceFactories.put(string, dRSControllerInstanceFactory);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DRSControllerInstanceFactoryImpl:setControllerInstanceFactory: Exit.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DRSInstanceToken createZOSControllerDRSInstance(DRSInstanceToken dRSInstanceToken, String string, DRSSettingsWrapper dRSSettingsWrapper, Map map, DRSInstanceConfig dRSInstanceConfig) {
        DRSControllerInstance dRSControllerInstance;
        DRSControllerInstanceFactory dRSControllerInstanceFactory;
        Object object;
        Object object2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DRSControllerInstanceFactoryImpl:createZOSControllerDRSInstance: Entry - id = " + string);
        }
        if (tc.isDebugEnabled()) {
            if (dRSInstanceToken != null) {
                Tr.debug(tc, "DRSControllerInstanceFactoryImpl:createZOSControllerDRSInstance: Token = " + dRSInstanceToken);
            } else {
                Tr.debug(tc, "DRSControllerInstanceFactoryImpl:createZOSControllerDRSInstance: Token = null");
            }
            if (string != null) {
                Tr.debug(tc, "DRSControllerInstanceFactoryImpl:createZOSControllerDRSInstance: Id = " + string);
            } else {
                Tr.debug(tc, "DRSControllerInstanceFactoryImpl:createZOSControllerDRSInstance: Id = null");
            }
            if (map != null) {
                object2 = map.keySet();
                object = object2.iterator();
                while (object.hasNext()) {
                    dRSControllerInstanceFactory = (DRSControllerInstanceFactory)object.next();
                    dRSControllerInstance = (DRSControllerInstance)map.get(dRSControllerInstanceFactory);
                    Tr.debug(tc, "DRSControllerInstanceFactoryImpl:createZOSControllerDRSInstance: miscParms: key = " + dRSControllerInstanceFactory + " value = " + dRSControllerInstance);
                }
            } else {
                Tr.debug(tc, "DRSControllerInstanceFactoryImpl:createZOSControllerDRSInstance: miscParms = null");
            }
        }
        object2 = null;
        object = null;
        if (DRSPlatformHelper.isZOS_Control_Region()) {
            dRSControllerInstanceFactory = null;
            dRSControllerInstance = null;
            DRSControllerDataXfer dRSControllerDataXfer = null;
            DRSControllerSettings dRSControllerSettings = new DRSControllerSettings();
            dRSControllerSettings.init(dRSSettingsWrapper);
            DRSControllerSettings dRSControllerSettings2 = dRSControllerSettings;
            DRSInstanceTokenImpl dRSInstanceTokenImpl = (DRSInstanceTokenImpl)dRSInstanceToken;
            Integer n = this.instanceLock;
            synchronized (n) {
                try {
                    if (dRSInstanceTokenImpl.getComplete()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "DRSControllerInstanceFactoryImpl:createZOSControllerDRSInstance:  Token already exists");
                        }
                        object2 = dRSInstanceToken;
                    } else if (this.DRSInstances.containsKey(string)) {
                        String string2 = dRSInstanceToken.getStoken();
                        boolean bl = this.isRegisteredStoken(string2);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "DRSControllerInstanceFactoryImpl:createZOSControllerDRSInstance:  Request by stoken " + string2 + ":" + bl + " for instance " + string + " already exists.");
                            Tr.debug(tc, "DRSControllerInstanceFactoryImpl:createZOSControllerDRSInstance:  Instance " + string + " already exists.");
                        }
                        DRSControllerInstance dRSControllerInstance2 = this.getDRSControllerInstance(string);
                        DRSControllerDataXfer dRSControllerDataXfer2 = dRSControllerInstance2.getDRSControllerDataXfer();
                        object = new DRSInstanceTokenImpl(string, dRSInstanceToken.getDomainName(), dRSInstanceToken.getServantUniqueId(), dRSInstanceToken.getStoken(), DRSPlatformHelper.getZOSUniqueId(), dRSControllerInstance2.getInstanceId());
                        int n2 = this.addToDRSControllerDataXferList(dRSControllerDataXfer2);
                        ((DRSInstanceTokenImpl)object).setXferOffset(n2);
                        ((DRSInstanceTokenImpl)object).setComplete(true);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "DRSControllerInstanceFactoryImpl:createZOSControllerDRSInstance:  New token created : " + ((DRSInstanceTokenImpl)object).toString());
                        }
                        object2 = object;
                        HashMap hashMap = null;
                        DRSControllerInstanceWrapper dRSControllerInstanceWrapper = null;
                        if (bl) {
                            if (this.unRegisteredServants.containsKey(string2)) {
                                Tr.error(tc, "drs.cont.factory.regInUnregtable", new Object[]{"DRSControllerInstanceFactoryImpl:createZOSControllerDRSInstance: ", string2});
                            }
                            if (!this.registeredServants.containsKey(string2)) {
                                Tr.error(tc, "drs.cont.factory.regNotinRegtable", new Object[]{"DRSControllerInstanceFactoryImpl:createZOSControllerDRSInstance: ", string2});
                            } else {
                                hashMap = (HashMap)this.registeredServants.get(string2);
                                dRSControllerInstanceWrapper = (DRSControllerInstanceWrapper)this.DRSWrappers.get(string);
                                dRSControllerInstanceWrapper.addServant((DRSInstanceToken)object2, true);
                                hashMap.put(string, dRSControllerInstanceWrapper);
                                this.registeredServants.put(string2, hashMap);
                            }
                        } else {
                            if (this.registeredServants.containsKey(string2)) {
                                Tr.error(tc, "drs.cont.factory.unregInRegtable", new Object[]{"DRSControllerInstanceFactoryImpl:createZOSControllerDRSInstance: ", string2});
                            }
                            if (!this.unRegisteredServants.containsKey(string2)) {
                                hashMap = new HashMap();
                                dRSControllerInstanceWrapper = (DRSControllerInstanceWrapper)this.DRSWrappers.get(string);
                                dRSControllerInstanceWrapper.addServant((DRSInstanceToken)object2, false);
                                hashMap.put(string, dRSControllerInstanceWrapper);
                                this.unRegisteredServants.put(string2, hashMap);
                            } else {
                                hashMap = (HashMap)this.unRegisteredServants.get(string2);
                                dRSControllerInstanceWrapper = (DRSControllerInstanceWrapper)this.DRSWrappers.get(string);
                                dRSControllerInstanceWrapper.addServant((DRSInstanceToken)object2, false);
                                hashMap.put(string, dRSControllerInstanceWrapper);
                                this.unRegisteredServants.put(string2, hashMap);
                            }
                        }
                    } else {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "DRSControllerInstanceFactoryImpl:createZOSControllerDRSInstance:  Instance " + string + " does not already exist.");
                            Tr.debug(tc, "DRSControllerInstanceFactoryImpl:createZOSControllerDRSInstance:  usingHAManager = " + this.usingHAManager);
                        }
                        if (dRSInstanceConfig.createDefaultControllerInstance()) {
                            long l = this.getNextInstanceNumber();
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "DRSControllerInstanceFactoryImpl:createZOSControllerDRSInstance:  Create a new default instance : unique id = " + l);
                            }
                            DRSCacheMsgListenerWrapper dRSCacheMsgListenerWrapper = new DRSCacheMsgListenerWrapper();
                            DRSBootstrapWrapper dRSBootstrapWrapper = new DRSBootstrapWrapper();
                            DRSControllerInstanceImpl dRSControllerInstanceImpl = new DRSControllerInstanceImpl(this.usingHAManager, l);
                            DRSControllerDataXferImpl dRSControllerDataXferImpl = null;
                            DRSInstance dRSInstance = null;
                            DRSDataXferImpl dRSDataXferImpl = null;
                            if (this.usingHAManager) {
                                DRSDataXfer dRSDataXfer = this._mbd.createInstance(string, dRSCacheMsgListenerWrapper, dRSBootstrapWrapper, (DRSSettings)dRSControllerSettings2, null, map);
                                dRSDataXferImpl = (DRSDataXferImpl)dRSDataXfer;
                                dRSInstance = dRSDataXferImpl.getInstance();
                                dRSControllerDataXferImpl = new DRSControllerDataXferImpl(dRSDataXferImpl, dRSInstance, dRSInstanceConfig, this.usingHAManager, l, dRSControllerInstanceImpl);
                            } else {
                                dRSControllerDataXferImpl = new DRSControllerDataXferImpl(null, null, dRSInstanceConfig, this.usingHAManager, l, dRSControllerInstanceImpl);
                            }
                            dRSCacheMsgListenerWrapper.init(dRSControllerDataXferImpl, dRSInstance, dRSInstanceConfig);
                            dRSBootstrapWrapper.init(dRSControllerDataXferImpl, dRSInstance, dRSInstanceConfig);
                            dRSControllerInstanceImpl.init(dRSControllerDataXferImpl, dRSInstance, dRSInstanceConfig);
                            object = new DRSInstanceTokenImpl(string, dRSInstanceToken.getDomainName(), dRSInstanceToken.getServantUniqueId(), dRSInstanceToken.getStoken(), DRSPlatformHelper.getZOSUniqueId(), dRSControllerInstanceImpl.getInstanceId());
                            int n3 = this.addToDRSControllerDataXferList(dRSControllerDataXferImpl);
                            ((DRSInstanceTokenImpl)object).setXferOffset(n3);
                            this.DRSInstances.put(string, dRSControllerInstanceImpl);
                            ((DRSInstanceTokenImpl)object).setComplete(true);
                            object2 = object;
                            dRSControllerInstance.getDRSInstanceTokenTable().addServant((DRSInstanceToken)object2);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "DRSControllerInstanceFactoryImpl:createZOSControllerDRSInstance:  Default Instance id = " + string + " added to DRSInstances.");
                            }
                            this.DRSInstances.put(string, dRSControllerInstanceImpl);
                        } else if (dRSInstanceConfig.createHttpSessionControllerInstance()) {
                            dRSControllerInstanceFactory = (DRSControllerInstanceFactory)DRSControllerInstanceFactories.get("HttpSession DRS Controller Instance");
                            if (dRSControllerInstanceFactory != null) {
                                String string3 = dRSInstanceToken.getStoken();
                                boolean bl = this.isRegisteredStoken(string3);
                                long l = this.getNextInstanceNumber();
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "DRSControllerInstanceFactoryImpl:createZOSControllerDRSInstance:  Create a new HttpSession Controller Instance : id = " + string + " ,unique id = " + l + " ,stoken = " + string3 + " ,registered = " + bl);
                                }
                                dRSControllerInstance = dRSControllerInstanceFactory.createDRSControllerInstance(string, (DRSSettings)dRSControllerSettings2, map, this.usingHAManager, l);
                                dRSControllerDataXfer = dRSControllerInstance.getDRSControllerDataXfer();
                                object = new DRSInstanceTokenImpl(string, dRSInstanceToken.getDomainName(), dRSInstanceToken.getServantUniqueId(), string3, DRSPlatformHelper.getZOSUniqueId(), dRSControllerInstance.getInstanceId());
                                int n4 = this.addToDRSControllerDataXferList(dRSControllerDataXfer);
                                ((DRSInstanceTokenImpl)object).setXferOffset(n4);
                                ((DRSInstanceTokenImpl)object).setComplete(true);
                                object2 = object;
                                HashMap hashMap = null;
                                DRSControllerInstanceWrapper dRSControllerInstanceWrapper = null;
                                if (bl) {
                                    if (this.unRegisteredServants.containsKey(string3)) {
                                        Tr.error(tc, "drs.cont.factory.regInUnregtable", new Object[]{"DRSControllerInstanceFactoryImpl:createZOSControllerDRSInstance: ", string3});
                                    }
                                    if (this.registeredServants.containsKey(string3)) {
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "DRSControllerInstanceFactoryImpl:createZOSControllerDRSInstance:  Stoken " + string3 + " was found in registeredServants.");
                                        }
                                        dRSControllerInstanceWrapper = new DRSControllerInstanceWrapper(string, dRSSettingsWrapper, map, dRSInstanceConfig, (DRSSettings)dRSControllerSettings2, this.usingHAManager, l, dRSControllerInstance, dRSControllerDataXfer, (DRSInstanceToken)object, true);
                                        hashMap = (HashMap)this.registeredServants.get(string3);
                                        hashMap.put(string, dRSControllerInstanceWrapper);
                                        this.registeredServants.put(string3, hashMap);
                                    } else {
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "DRSControllerInstanceFactoryImpl:createZOSControllerDRSInstance:  Stoken " + string3 + " was not found in registeredServants.");
                                        }
                                        dRSControllerInstanceWrapper = new DRSControllerInstanceWrapper(string, dRSSettingsWrapper, map, dRSInstanceConfig, (DRSSettings)dRSControllerSettings2, this.usingHAManager, l, dRSControllerInstance, dRSControllerDataXfer, (DRSInstanceToken)object, true);
                                        hashMap = new HashMap();
                                        hashMap.put(string, dRSControllerInstanceWrapper);
                                        this.registeredServants.put(string3, hashMap);
                                    }
                                } else {
                                    if (this.registeredServants.containsKey(string3)) {
                                        Tr.error(tc, "drs.cont.factory.unregInRegtable", new Object[]{"DRSControllerInstanceFactoryImpl:createZOSControllerDRSInstance: ", string3});
                                    }
                                    if (this.unRegisteredServants.containsKey(string3)) {
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "DRSControllerInstanceFactoryImpl:createZOSControllerDRSInstance:  Stoken " + string3 + " was found in unRegisteredServants.");
                                        }
                                        dRSControllerInstanceWrapper = new DRSControllerInstanceWrapper(string, dRSSettingsWrapper, map, dRSInstanceConfig, (DRSSettings)dRSControllerSettings2, this.usingHAManager, l, dRSControllerInstance, dRSControllerDataXfer, (DRSInstanceToken)object, false);
                                        hashMap = (HashMap)this.unRegisteredServants.get(string3);
                                        hashMap.put(string, dRSControllerInstanceWrapper);
                                        this.unRegisteredServants.put(string3, hashMap);
                                    } else {
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "DRSControllerInstanceFactoryImpl:createZOSControllerDRSInstance:  Stoken " + string3 + " was not found in unRegisteredServants.");
                                        }
                                        dRSControllerInstanceWrapper = new DRSControllerInstanceWrapper(string, dRSSettingsWrapper, map, dRSInstanceConfig, (DRSSettings)dRSControllerSettings2, this.usingHAManager, l, dRSControllerInstance, dRSControllerDataXfer, (DRSInstanceToken)object, false);
                                        hashMap = new HashMap();
                                        hashMap.put(string, dRSControllerInstanceWrapper);
                                        this.unRegisteredServants.put(string3, hashMap);
                                    }
                                }
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "DRSControllerInstanceFactoryImpl:createZOSControllerDRSInstance:  HttpSession Instance id = " + string + " , created by stoken = " + string3 + " has been added to the DRSInstances table.");
                                }
                                this.DRSInstances.put(string, dRSControllerInstance);
                                this.DRSWrappers.put(string, dRSControllerInstanceWrapper);
                            } else {
                                Tr.error(tc, "drs.cont.factory.loc", new Object[]{"DRSControllerInstanceFactoryImpl:createZOSControllerDRSInstance: ", "HttpSession DRS Controller Instance"});
                            }
                        } else if (dRSInstanceConfig.createDynacacheControllerInstance()) {
                            dRSControllerInstanceFactory = (DRSControllerInstanceFactory)DRSControllerInstanceFactories.get("Dynacache DRS Controller Instance");
                            if (dRSControllerInstanceFactory != null) {
                                String string4 = dRSInstanceToken.getStoken();
                                boolean bl = this.isRegisteredStoken(string4);
                                long l = this.getNextInstanceNumber();
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "DRSControllerInstanceFactoryImpl:createZOSControllerDRSInstance:  Create a Dynacache Controller Instance : id = " + string + " ,unique id = " + l + " ,stoken = " + string4 + " ,registered = " + bl);
                                }
                                dRSControllerInstance = dRSControllerInstanceFactory.createDRSControllerInstance(string, (DRSSettings)dRSControllerSettings2, map, this.usingHAManager, l);
                                dRSControllerDataXfer = dRSControllerInstance.getDRSControllerDataXfer();
                                object = new DRSInstanceTokenImpl(string, dRSInstanceToken.getDomainName(), dRSInstanceToken.getServantUniqueId(), string4, DRSPlatformHelper.getZOSUniqueId(), dRSControllerInstance.getInstanceId());
                                int n5 = this.addToDRSControllerDataXferList(dRSControllerDataXfer);
                                ((DRSInstanceTokenImpl)object).setXferOffset(n5);
                                ((DRSInstanceTokenImpl)object).setComplete(true);
                                object2 = object;
                                HashMap hashMap = null;
                                DRSControllerInstanceWrapper dRSControllerInstanceWrapper = null;
                                if (bl) {
                                    if (this.unRegisteredServants.containsKey(string4)) {
                                        Tr.error(tc, "drs.cont.factory.regInUnregtable", new Object[]{"DRSControllerInstanceFactoryImpl:createZOSControllerDRSInstance: ", string4});
                                    }
                                    if (this.registeredServants.containsKey(string4)) {
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "DRSControllerInstanceFactoryImpl:createZOSControllerDRSInstance:  Stoken " + string4 + " was found in registeredServants.");
                                        }
                                        dRSControllerInstanceWrapper = new DRSControllerInstanceWrapper(string, dRSSettingsWrapper, map, dRSInstanceConfig, (DRSSettings)dRSControllerSettings2, this.usingHAManager, l, dRSControllerInstance, dRSControllerDataXfer, (DRSInstanceToken)object, true);
                                        hashMap = (HashMap)this.registeredServants.get(string4);
                                        hashMap.put(string, dRSControllerInstanceWrapper);
                                        this.registeredServants.put(string4, hashMap);
                                    } else {
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "DRSControllerInstanceFactoryImpl:createZOSControllerDRSInstance:  Stoken " + string4 + " was not found in registeredServants.");
                                        }
                                        dRSControllerInstanceWrapper = new DRSControllerInstanceWrapper(string, dRSSettingsWrapper, map, dRSInstanceConfig, (DRSSettings)dRSControllerSettings2, this.usingHAManager, l, dRSControllerInstance, dRSControllerDataXfer, (DRSInstanceToken)object, true);
                                        hashMap = new HashMap();
                                        hashMap.put(string, dRSControllerInstanceWrapper);
                                        this.registeredServants.put(string4, hashMap);
                                    }
                                } else {
                                    if (this.registeredServants.containsKey(string4)) {
                                        Tr.error(tc, "drs.cont.factory.unregInRegtable", new Object[]{"DRSControllerInstanceFactoryImpl:createZOSControllerDRSInstance: ", string4});
                                    }
                                    if (this.unRegisteredServants.containsKey(string4)) {
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "DRSControllerInstanceFactoryImpl:createZOSControllerDRSInstance:  Stoken " + string4 + " was found in unRegisteredServants.");
                                        }
                                        dRSControllerInstanceWrapper = new DRSControllerInstanceWrapper(string, dRSSettingsWrapper, map, dRSInstanceConfig, (DRSSettings)dRSControllerSettings2, this.usingHAManager, l, dRSControllerInstance, dRSControllerDataXfer, (DRSInstanceToken)object, false);
                                        hashMap = (HashMap)this.unRegisteredServants.get(string4);
                                        hashMap.put(string, dRSControllerInstanceWrapper);
                                        this.unRegisteredServants.put(string4, hashMap);
                                    } else {
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "DRSControllerInstanceFactoryImpl:createZOSControllerDRSInstance:  Stoken " + string4 + " was found in unRegisteredServants.");
                                        }
                                        dRSControllerInstanceWrapper = new DRSControllerInstanceWrapper(string, dRSSettingsWrapper, map, dRSInstanceConfig, (DRSSettings)dRSControllerSettings2, this.usingHAManager, l, dRSControllerInstance, dRSControllerDataXfer, (DRSInstanceToken)object, false);
                                        hashMap = new HashMap();
                                        hashMap.put(string, dRSControllerInstanceWrapper);
                                        this.unRegisteredServants.put(string4, hashMap);
                                    }
                                }
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "DRSControllerInstanceFactoryImpl:createZOSControllerDRSInstance:  Dynacache Instance id = " + string + " , created by stoken = " + string4 + " has been added to DRSInstances table.");
                                }
                                this.DRSInstances.put(string, dRSControllerInstance);
                                this.DRSWrappers.put(string, dRSControllerInstanceWrapper);
                            } else {
                                Tr.error(tc, "drs.cont.factory.loc", new Object[]{"DRSControllerInstanceFactoryImpl:createZOSControllerDRSInstance: ", "Dynacache DRS Controller Instance"});
                            }
                        } else if (dRSInstanceConfig.createEJBContainerControllerInstance()) {
                            dRSControllerInstanceFactory = (DRSControllerInstanceFactory)DRSControllerInstanceFactories.get("EJB Container DRS Controller Instance");
                            if (dRSControllerInstanceFactory != null) {
                                String string5 = dRSInstanceToken.getStoken();
                                boolean bl = this.isRegisteredStoken(string5);
                                long l = this.getNextInstanceNumber();
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "DRSControllerInstanceFactoryImpl:createZOSControllerDRSInstance:  Create an EJB Container Controller Instance : id = " + string + " ,unique id = " + l + " ,stoken = " + string5 + " ,registered = " + bl);
                                }
                                dRSControllerInstance = dRSControllerInstanceFactory.createDRSControllerInstance(string, (DRSSettings)dRSControllerSettings2, map, this.usingHAManager, l);
                                dRSControllerDataXfer = dRSControllerInstance.getDRSControllerDataXfer();
                                object = new DRSInstanceTokenImpl(string, dRSInstanceToken.getDomainName(), dRSInstanceToken.getServantUniqueId(), string5, DRSPlatformHelper.getZOSUniqueId(), dRSControllerInstance.getInstanceId());
                                int n6 = this.addToDRSControllerDataXferList(dRSControllerDataXfer);
                                ((DRSInstanceTokenImpl)object).setXferOffset(n6);
                                ((DRSInstanceTokenImpl)object).setComplete(true);
                                object2 = object;
                                HashMap hashMap = null;
                                DRSControllerInstanceWrapper dRSControllerInstanceWrapper = null;
                                if (bl) {
                                    if (this.unRegisteredServants.containsKey(string5)) {
                                        Tr.error(tc, "drs.cont.factory.regInUnregtable", new Object[]{"DRSControllerInstanceFactoryImpl:createZOSControllerDRSInstance: ", string5});
                                    }
                                    if (this.registeredServants.containsKey(string5)) {
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "DRSControllerInstanceFactoryImpl:createZOSControllerDRSInstance:  Stoken " + string5 + " was found in registeredServants.");
                                        }
                                        dRSControllerInstanceWrapper = new DRSControllerInstanceWrapper(string, dRSSettingsWrapper, map, dRSInstanceConfig, (DRSSettings)dRSControllerSettings2, this.usingHAManager, l, dRSControllerInstance, dRSControllerDataXfer, (DRSInstanceToken)object, true);
                                        hashMap = (HashMap)this.registeredServants.get(string5);
                                        hashMap.put(string, dRSControllerInstanceWrapper);
                                        this.registeredServants.put(string5, hashMap);
                                    } else {
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "DRSControllerInstanceFactoryImpl:createZOSControllerDRSInstance:  Stoken " + string5 + " was not found in registeredServants.");
                                        }
                                        dRSControllerInstanceWrapper = new DRSControllerInstanceWrapper(string, dRSSettingsWrapper, map, dRSInstanceConfig, (DRSSettings)dRSControllerSettings2, this.usingHAManager, l, dRSControllerInstance, dRSControllerDataXfer, (DRSInstanceToken)object, true);
                                        hashMap = new HashMap();
                                        hashMap.put(string, dRSControllerInstanceWrapper);
                                        this.registeredServants.put(string5, hashMap);
                                    }
                                } else {
                                    if (this.registeredServants.containsKey(string5)) {
                                        Tr.error(tc, "drs.cont.factory.unregInRegtable", new Object[]{"DRSControllerInstanceFactoryImpl:createZOSControllerDRSInstance: ", string5});
                                    }
                                    if (this.unRegisteredServants.containsKey(string5)) {
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "DRSControllerInstanceFactoryImpl:createZOSControllerDRSInstance:  Stoken " + string5 + " was found in unRegisteredServants.");
                                        }
                                        dRSControllerInstanceWrapper = new DRSControllerInstanceWrapper(string, dRSSettingsWrapper, map, dRSInstanceConfig, (DRSSettings)dRSControllerSettings2, this.usingHAManager, l, dRSControllerInstance, dRSControllerDataXfer, (DRSInstanceToken)object, false);
                                        hashMap = (HashMap)this.unRegisteredServants.get(string5);
                                        hashMap.put(string, dRSControllerInstanceWrapper);
                                        this.unRegisteredServants.put(string5, hashMap);
                                    } else {
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "DRSControllerInstanceFactoryImpl:createZOSControllerDRSInstance:  Stoken " + string5 + " was not found in unRegisteredServants.");
                                        }
                                        dRSControllerInstanceWrapper = new DRSControllerInstanceWrapper(string, dRSSettingsWrapper, map, dRSInstanceConfig, (DRSSettings)dRSControllerSettings2, this.usingHAManager, l, dRSControllerInstance, dRSControllerDataXfer, (DRSInstanceToken)object, false);
                                        hashMap = new HashMap();
                                        hashMap.put(string, dRSControllerInstanceWrapper);
                                        this.unRegisteredServants.put(string5, hashMap);
                                    }
                                }
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "DRSControllerInstanceFactoryImpl:createZOSControllerDRSInstance:  Instance id = " + string + " added to DRSInstances.");
                                }
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "DRSControllerInstanceFactoryImpl:createZOSControllerDRSInstance:  EJBContainer Instance id = " + string + " , created by stoken = " + string5 + " has been added to DRSInstances table.");
                                }
                                this.DRSInstances.put(string, dRSControllerInstance);
                                this.DRSWrappers.put(string, dRSControllerInstanceWrapper);
                            } else {
                                Tr.error(tc, "drs.cont.factory.loc", new Object[]{"DRSControllerInstanceFactoryImpl:createZOSControllerDRSInstance: ", "EJB Container DRS Controller Instance"});
                            }
                        } else {
                            Tr.error(tc, "drs.cont.factory.type", "DRSControllerInstanceFactoryImpl:createZOSControllerDRSInstance: ");
                        }
                    }
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ws.drs.ws390.DRSControllerInstanceFactoryImpl.createZOSControllerDRSInstance", "1208", this);
                    Tr.error(tc, "drs.throwable.controller", new Object[]{"DRSControllerInstanceFactoryImpl:createZOSControllerDRSInstance: ", throwable});
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DRSControllerInstanceFactoryImpl:createZOSControllerDRSInstance: Exit rc = " + (object2 == null ? "null" : object2.toString()));
        }
        return object2;
    }

    public DRSControllerDataXfer getDRSControllerDataXfer(DRSInstanceToken dRSInstanceToken) {
        DRSControllerDataXfer dRSControllerDataXfer = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DRSControllerInstanceFactoryImpl:getDRSControllerDataXfer: Entry - id = " + dRSInstanceToken);
        }
        if (DRSPlatformHelper.isZOS_Control_Region() && dRSInstanceToken != null) {
            try {
                DRSInstanceTokenImpl dRSInstanceTokenImpl = (DRSInstanceTokenImpl)dRSInstanceToken;
                dRSControllerDataXfer = this.getDRSControllerDataXferFromList(dRSInstanceTokenImpl);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.drs.ws390.DRSControllerInstanceFactoryImpl.getDRSControllerDataXfer", "1241", this);
                Tr.error(tc, "drs.throwable.controller", new Object[]{"DRSControllerInstanceFactoryImpl:getDRSControllerDataXfer: ", throwable});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DRSControllerInstanceFactoryImpl:getDRSControllerDataXfer: Exit - rc = " + (dRSControllerDataXfer == null ? "not found" : "found"));
        }
        return dRSControllerDataXfer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DRSControllerInstance getDRSControllerInstance(String string) {
        DRSControllerInstance dRSControllerInstance = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DRSControllerInstanceFactoryImpl:getDRSControllerInstance: Entry - id = " + string);
        }
        if (DRSPlatformHelper.isZOS_Control_Region()) {
            Integer n = this.instanceLock;
            synchronized (n) {
                dRSControllerInstance = (DRSControllerInstance)this.DRSInstances.get(string);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DRSControllerInstanceFactoryImpl:getDRSControllerInstance: Exit - rc = " + (dRSControllerInstance == null ? "not found" : "found"));
        }
        return dRSControllerInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DRSInstanceTokenImpl registerServant(DRSInstanceTokenImpl dRSInstanceTokenImpl) {
        DRSInstanceTokenImpl dRSInstanceTokenImpl2 = null;
        if (dRSInstanceTokenImpl == null) {
            Tr.error(tc, "drs.cont.factory.token", "DRSControllerInstanceFactoryImpl:registerServant: ");
        } else {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "DRSControllerInstanceFactoryImpl:registerServant: Entry: token = " + dRSInstanceTokenImpl);
            }
            if (DRSPlatformHelper.isZOS_Control_Region()) {
                Integer n = this.instanceLock;
                synchronized (n) {
                    if (this.registeredServantTokens.containsToken(dRSInstanceTokenImpl)) {
                        Tr.error(tc, "drs.cont.factory.tokexists", "DRSControllerInstanceFactoryImpl:registerServant: ");
                    } else {
                        dRSInstanceTokenImpl2 = new DRSInstanceTokenImpl("Servant Validation Token", "ZOS - register servant", dRSInstanceTokenImpl.getServantUniqueId(), dRSInstanceTokenImpl.getStoken(), DRSPlatformHelper.getZOSUniqueId(), this.getNextServantNumber());
                        dRSInstanceTokenImpl2.setConfirmed(false);
                        this.registeredServantTokens.addServant(dRSInstanceTokenImpl2);
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DRSControllerInstanceFactoryImpl:registerServant: Exit: rc = " + dRSInstanceTokenImpl2);
        }
        return dRSInstanceTokenImpl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyInstances(String string) {
        DRSControllerInstanceWrapper dRSControllerInstanceWrapper = null;
        HashMap hashMap = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DRSControllerInstanceFactoryImpl:notifyInstances: Entry: stoken = " + string);
        }
        if (string == null && tc.isEntryEnabled()) {
            Tr.exit(tc, "DRSControllerInstanceFactoryImpl:notifyInstances: Exit: token = null");
            return;
        }
        Integer n = this.instanceLock;
        synchronized (n) {
            if (this.unRegisteredServants.containsKey(string)) {
                hashMap = (HashMap)this.unRegisteredServants.remove(string);
                if (hashMap != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "DRSControllerInstanceFactoryImpl:notifyInstances:  instance(s) found in unRegisteredServants for stoken = " + string);
                    }
                    Set set = hashMap.keySet();
                    Iterator iterator = set.iterator();
                    while (iterator.hasNext()) {
                        String string2 = (String)iterator.next();
                        dRSControllerInstanceWrapper = (DRSControllerInstanceWrapper)hashMap.get(string2);
                        if (dRSControllerInstanceWrapper != null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "DRSControllerInstanceFactoryImpl:notifyInstances:  registration complete for servant(" + string + ") instance(" + string2 + ")");
                            }
                            dRSControllerInstanceWrapper.registrationComplete(string);
                            continue;
                        }
                        Tr.error(tc, "DRSControllerInstanceFactoryImpl:notifyInstances:  wrapper is null for stoken = " + string + " id = " + string2);
                    }
                    this.registeredServants.put(string, hashMap);
                } else {
                    Tr.error(tc, "DRSControllerInstanceFactoryImpl:notifyInstances:  can not get unregistered entry for " + string);
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "DRSControllerInstanceFactoryImpl:notifyInstances:  can not locate unregistered entry for " + string);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DRSControllerInstanceFactoryImpl:notifyInstances: Exit");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DRSInstanceTokenImpl confirmServantRegistration(DRSInstanceTokenImpl dRSInstanceTokenImpl) {
        DRSInstanceTokenImpl dRSInstanceTokenImpl2;
        block20: {
            dRSInstanceTokenImpl2 = null;
            try {
                if (dRSInstanceTokenImpl == null) {
                    if (tc.isEntryEnabled()) {
                        Tr.entry(tc, "DRSControllerInstanceFactoryImpl:confirmServantRegistration: Entry: token = null");
                    }
                    break block20;
                }
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "DRSControllerInstanceFactoryImpl:confirmServantRegistration: Entry: token = " + dRSInstanceTokenImpl);
                }
                if (DRSPlatformHelper.isZOS_Control_Region()) {
                    if (this.registeredServantTokens.containsToken(dRSInstanceTokenImpl)) {
                        Integer n = this.instanceLock;
                        synchronized (n) {
                            this.registeredServantTokens.deleteServant(dRSInstanceTokenImpl);
                            DRSServantProxy dRSServantProxy = DRSServantProxyFactoryImpl.getInstance().createProxyForSpecificServant(dRSInstanceTokenImpl);
                            if (dRSServantProxy != null) {
                                DRSServantProxyWrapper dRSServantProxyWrapper = (DRSServantProxyWrapper)dRSServantProxy;
                                byte[] byArray = dRSServantProxyWrapper.getServantRegistrationToken();
                                if (byArray != null) {
                                    Object object = DRSServantProxyFactoryImpl.getInstance().getObject(byArray);
                                    if (object != null) {
                                        DRSInstanceTokenImpl dRSInstanceTokenImpl3 = (DRSInstanceTokenImpl)object;
                                        if (dRSInstanceTokenImpl.equals(dRSInstanceTokenImpl3)) {
                                            dRSInstanceTokenImpl2 = new DRSInstanceTokenImpl("Servant Validation Token", "ZOS - servant registration confirmed", dRSInstanceTokenImpl.getServantUniqueId(), dRSInstanceTokenImpl.getStoken(), DRSPlatformHelper.getZOSUniqueId(), dRSInstanceTokenImpl.getDRSInstanceID());
                                            dRSInstanceTokenImpl2.setConfirmed(true);
                                            this.confirmedServantTokens.addServant(dRSInstanceTokenImpl2);
                                            if (tc.isDebugEnabled()) {
                                                Tr.debug(tc, "DRSControllerInstanceFactoryImpl:confirmServantRegistration:  Successfully confirmed Servant: rc = " + dRSInstanceTokenImpl2);
                                            }
                                            Tr.info(tc, "drs.servant.confirmed", dRSInstanceTokenImpl2.getStoken());
                                            this.notifyInstances(dRSInstanceTokenImpl2.getStoken());
                                        } else {
                                            Tr.error(tc, "drs.cont.factory.tokenNoMatch", new Object[]{"DRSControllerInstanceFactoryImpl:confirmServantRegistration: ", dRSInstanceTokenImpl, dRSInstanceTokenImpl3});
                                        }
                                    } else {
                                        Tr.error(tc, "drs.cont.factory.noBytetoObj", "DRSControllerInstanceFactoryImpl:confirmServantRegistration: ");
                                    }
                                } else {
                                    Tr.error(tc, "drs.cont.factory.byteArrayNull", "DRSControllerInstanceFactoryImpl:confirmServantRegistration: ");
                                }
                            } else {
                                Tr.error(tc, "drs.cont.factory.noGetProxy", new Object[]{"DRSControllerInstanceFactoryImpl:confirmServantRegistration: ", dRSInstanceTokenImpl});
                            }
                            break block20;
                        }
                    }
                    Tr.error(tc, "drs.cont.factory.noGetTokenInReg", new Object[]{"DRSControllerInstanceFactoryImpl:confirmServantRegistration: ", dRSInstanceTokenImpl});
                    break block20;
                }
                Tr.error(tc, "drs.cont.factory.incorrEnvironment", "DRSControllerInstanceFactoryImpl:confirmServantRegistration: ");
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.drs.ws390.DRSControllerInstanceFactoryImpl.confirmServantRegistration", "1441", this);
                Tr.error(tc, "drs.throwable.controller", new Object[]{"DRSControllerInstanceFactoryImpl:confirmServantRegistration: ", throwable});
                dRSInstanceTokenImpl2 = null;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DRSControllerInstanceFactoryImpl:confirmServantRegistration: Exit: rc = " + dRSInstanceTokenImpl2);
        }
        return dRSInstanceTokenImpl2;
    }

    public void unregisterServant(DRSInstanceToken dRSInstanceToken) {
        if (dRSInstanceToken == null) {
            Tr.error(tc, "drs.cont.factory.token", "DRSControllerInstanceFactoryImpl:unregisterServant: ");
        } else {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "DRSControllerInstanceFactoryImpl:unregisterServant: Entry: token = " + dRSInstanceToken);
            }
            Tr.info(tc, "drs.servant.shutdown", dRSInstanceToken.getStoken());
            if (DRSPlatformHelper.isZOS_Control_Region()) {
                this.removeTerminatedServant(dRSInstanceToken.getStoken());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DRSControllerInstanceFactoryImpl:unregisterServant: Exit");
        }
    }

    public void servantTerminated(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DRSControllerInstanceFactoryImpl:servantTerminated: Entry: stoken = " + (string == null ? "null" : string));
        }
        if (string != null && DRSPlatformHelper.isZOS_Control_Region()) {
            Tr.info(tc, "drs.servant.terminated", string);
            this.removeTerminatedServant(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DRSControllerInstanceFactoryImpl:servantTerminated: Exit: stoken = " + (string == null ? "null" : string));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeTerminatedServant(String string) {
        if (string == null) {
            Tr.error(tc, "drs.cont.factory.token", "DRSControllerInstanceFactoryImpl:removeTerminatedServant: ");
        } else {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "DRSControllerInstanceFactoryImpl:removeTerminatedServant: Entry: stoken = " + string);
            }
            Integer n = this.instanceLock;
            synchronized (n) {
                HashMap hashMap = null;
                try {
                    DRSControllerInstanceWrapper dRSControllerInstanceWrapper;
                    String string2;
                    Iterator iterator;
                    Set set;
                    if (this.unRegisteredServants.containsKey(string) && (hashMap = (HashMap)this.unRegisteredServants.remove(string)) != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "DRSControllerInstanceFactoryImpl:removeTerminatedServant:  stoken = " + string + " found in unRegisteredServants");
                        }
                        set = hashMap.keySet();
                        iterator = set.iterator();
                        while (iterator.hasNext()) {
                            string2 = (String)iterator.next();
                            dRSControllerInstanceWrapper = (DRSControllerInstanceWrapper)this.DRSWrappers.get(string2);
                            dRSControllerInstanceWrapper.deleteServant(string);
                        }
                    }
                    if (this.registeredServants.containsKey(string) && (hashMap = (HashMap)this.registeredServants.remove(string)) != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "DRSControllerInstanceFactoryImpl:removeTerminatedServant:  stoken = " + string + " found in registeredServants");
                        }
                        set = hashMap.keySet();
                        iterator = set.iterator();
                        while (iterator.hasNext()) {
                            string2 = (String)iterator.next();
                            dRSControllerInstanceWrapper = (DRSControllerInstanceWrapper)this.DRSWrappers.get(string2);
                            dRSControllerInstanceWrapper.deleteServant(string);
                        }
                    }
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ws.drs.ws390.DRSControllerInstanceFactoryImpl.removeTerminatedServant", "1560", this);
                    Tr.error(tc, "drs.throwable.controller", new Object[]{"DRSControllerInstanceFactoryImpl:removeTerminatedServant: ", throwable});
                }
                this.registeredServantTokens.deleteServant(string);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DRSControllerInstanceFactoryImpl:removeTerminatedServant: Exit.");
        }
    }

    public HashMap getDRSWrappers() {
        return this.DRSWrappers;
    }
}

