/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.drs.ws390;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.applicationserver.webcontainer.DRSSettings;
import com.ibm.ws.drs.DRSDataXferImpl;
import com.ibm.ws.drs.DRSInstance;
import com.ibm.ws.drs.ws390.DRSInstanceConfig;
import com.ibm.ws.drs.ws390.DRSInstanceTokenTableImpl;
import com.ibm.ws.drs.ws390.DRSSettingsWrapper;
import com.ibm.wsspi.drs.DRSControllerDataXfer;
import com.ibm.wsspi.drs.DRSControllerInstance;
import com.ibm.wsspi.drs.DRSDataXfer;
import com.ibm.wsspi.drs.DRSEventObject;
import com.ibm.wsspi.drs.DRSInstanceToken;
import com.ibm.wsspi.drs.DRSInstanceTokenTable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class DRSControllerInstanceWrapper
implements Runnable {
    private static TraceComponent tc = Tr.register(DRSControllerInstanceWrapper.class.getName(), "DRS", "com.ibm.ws.drs.resources.drs");
    private static boolean _loggedVersion = false;
    private DRSInstanceTokenTable unRegisteredServants;
    private DRSInstanceTokenTable registeredServants;
    private String instanceName;
    private String instanceIdentifier;
    private long instanceId;
    private long uniqueInstanceId;
    private String id;
    private DRSSettingsWrapper settingsWrapper;
    private Map miscParms;
    private DRSInstanceConfig instConfig;
    private DRSSettings drsSettings;
    private boolean usingHAManager;
    private long instNumber;
    private DRSControllerInstance instance;
    private DRSControllerDataXfer xfer;
    private Integer lock;
    private boolean isRegistered;
    private DRSDataXfer baseXfer;
    private DRSDataXferImpl ddxImpl;
    private DRSInstance baseInstance;
    private DRSEventObject isUpEvent;
    private DRSEventObject isDownEvent;
    private Thread wrapperThread;
    private Integer postWorkLock;
    private HashMap servantsToAdd;
    private HashMap servantsToDelete;
    private boolean keepRunning;
    private Integer threadLock;

    public DRSControllerInstanceWrapper(String string, DRSSettingsWrapper dRSSettingsWrapper, Map map, DRSInstanceConfig dRSInstanceConfig, DRSSettings dRSSettings, boolean bl, long l, DRSControllerInstance dRSControllerInstance, DRSControllerDataXfer dRSControllerDataXfer, DRSInstanceToken dRSInstanceToken, boolean bl2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DRSControllerInstanceWrapper:constructor: Entry - id = " + this.id);
        }
        if (tc.isDebugEnabled() && !_loggedVersion) {
            Tr.debug(tc, "DRSControllerInstanceWrapper: Version 1.2.1.1 11/4/08 08:59:29");
            _loggedVersion = true;
        }
        this.keepRunning = true;
        this.lock = new Integer(997);
        this.postWorkLock = new Integer(999);
        this.threadLock = new Integer(995);
        this.servantsToAdd = new HashMap();
        this.servantsToDelete = new HashMap();
        this.wrapperThread = new Thread(this);
        this.wrapperThread.setDaemon(true);
        final ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                DRSControllerInstanceWrapper.this.wrapperThread.setContextClassLoader(classLoader);
                return null;
            }
        });
        this.servantsToAdd = new HashMap();
        this.servantsToDelete = new HashMap();
        this.id = string;
        this.settingsWrapper = dRSSettingsWrapper;
        this.miscParms = map;
        this.instConfig = dRSInstanceConfig;
        this.drsSettings = dRSSettings;
        this.usingHAManager = bl;
        this.instNumber = l;
        this.instance = dRSControllerInstance;
        this.xfer = dRSControllerDataXfer;
        this.isUpEvent = new DRSEventObject(1, this);
        this.isDownEvent = new DRSEventObject(2, this);
        this.baseXfer = this.xfer.getBaseDRSDataXfer();
        if (this.usingHAManager) {
            this.ddxImpl = (DRSDataXferImpl)this.baseXfer;
            this.baseInstance = this.ddxImpl.getInstance();
            this.instanceName = this.baseXfer.getInstanceName();
            this.instanceId = this.baseXfer.getInstanceId();
        } else {
            this.ddxImpl = null;
            this.baseInstance = null;
            this.instanceName = this.id;
            this.instanceId = this.instNumber;
        }
        this.instanceIdentifier = this.instanceName + ":" + this.instanceId + ":" + this.instNumber;
        this.unRegisteredServants = new DRSInstanceTokenTableImpl(this.instanceIdentifier, "unRegisteredServants");
        this.registeredServants = new DRSInstanceTokenTableImpl(this.instanceIdentifier, "registeredServants");
        if (bl2) {
            this.registeredServants.addServant(dRSInstanceToken);
            this.postAddServant(dRSInstanceToken);
        } else {
            this.unRegisteredServants.addServant(dRSInstanceToken);
        }
        this.wrapperThread.start();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DRSControllerInstanceWrapper:constructor: Exit");
        }
    }

    private DRSEventObject createEvent() {
        String string = "DRSControllerInstanceWrapper:createEvent/" + this.instanceIdentifier + "/";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry");
        }
        DRSEventObject dRSEventObject = null;
        dRSEventObject = this.usingHAManager ? (this.ddxImpl.isReplicationUp() ? this.isUpEvent : this.isDownEvent) : this.isUpEvent;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, string + " event = " + dRSEventObject);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Exit - event = " + dRSEventObject);
        }
        return dRSEventObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registrationComplete(String string) {
        String string2 = "DRSControllerInstanceWrapper:registrationComplete/" + this.instanceIdentifier + "/";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string2 + "Entry - stoken = " + string);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, string2 + " stoken = " + string);
        }
        Integer n = this.lock;
        synchronized (n) {
            Iterator iterator = this.unRegisteredServants.getIterator();
            while (iterator.hasNext()) {
                DRSInstanceToken dRSInstanceToken = (DRSInstanceToken)iterator.next();
                if (!dRSInstanceToken.getStoken().equals(string)) continue;
                this.unRegisteredServants.deleteServant(dRSInstanceToken);
                this.registeredServants.addServant(dRSInstanceToken);
                this.postAddServant(dRSInstanceToken);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string2 + "Exit");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addServant(DRSInstanceToken dRSInstanceToken, boolean bl) {
        String string = "DRSControllerInstanceWrapper:addServant/" + this.instanceIdentifier + "/";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry - token = " + dRSInstanceToken + " registered = " + bl);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, string + " token = " + dRSInstanceToken + " registered = " + bl);
        }
        if (dRSInstanceToken != null) {
            Integer n = this.lock;
            synchronized (n) {
                if (bl) {
                    this.registeredServants.addServant(dRSInstanceToken);
                    this.postAddServant(dRSInstanceToken);
                } else {
                    this.unRegisteredServants.addServant(dRSInstanceToken);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Exit");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteServant(String string) {
        String string2 = "DRSControllerInstanceWrapper:deleteServant/" + this.instanceIdentifier + "/";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string2 + "Entry - stoken = " + string);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, string2 + " stoken = " + string);
        }
        if (string != null) {
            Integer n = this.lock;
            synchronized (n) {
                if (this.registeredServants.containsStoken(string)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, string2 + " stoken = " + string + " found in oldtokens");
                    }
                    this.registeredServants.deleteServant(string);
                    this.postDeleteServant(string);
                } else {
                    this.unRegisteredServants.deleteServant(string);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string2 + "Exit");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postAddServant(DRSInstanceToken dRSInstanceToken) {
        String string = "DRSControllerInstanceWrapper:postAddServant/" + this.instanceIdentifier + "/";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry - token = " + dRSInstanceToken);
        }
        if (dRSInstanceToken != null) {
            Integer n = this.postWorkLock;
            synchronized (n) {
                this.servantsToAdd.put(dRSInstanceToken.getStoken(), dRSInstanceToken);
                this.postWorkLock.notifyAll();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Exit");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postDeleteServant(String string) {
        String string2 = "DRSControllerInstanceWrapper:postDeleteServant/" + this.instanceIdentifier + "/";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string2 + "Entry - stoken = " + string);
        }
        if (string != null) {
            Integer n = this.postWorkLock;
            synchronized (n) {
                if (this.servantsToAdd.containsKey(string)) {
                    this.servantsToAdd.remove(string);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, string2 + "stoken = " + string + " found in add table");
                    }
                } else {
                    this.servantsToDelete.put(string, string);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, string2 + "stoken = " + string + " added to delete table");
                    }
                }
                this.postWorkLock.notifyAll();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string2 + "Exit");
        }
    }

    public void setKeepRunning(boolean bl) {
        this.keepRunning = bl;
    }

    boolean getKeepRunning() {
        return this.keepRunning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        String string = "DRSControllerInstanceWrapper:run/" + this.instanceIdentifier + "/";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry.");
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = true;
        DRSInstanceToken dRSInstanceToken = null;
        String string2 = null;
        while (this.getKeepRunning()) {
            dRSInstanceToken = null;
            string2 = null;
            bl2 = false;
            Integer n = this.postWorkLock;
            synchronized (n) {
                String string3;
                Set set;
                Iterator iterator;
                if (this.servantsToAdd.isEmpty() && this.servantsToDelete.isEmpty()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, string + "about to wait for work");
                    }
                    try {
                        this.postWorkLock.wait();
                    }
                    catch (Throwable throwable) {
                    }
                    finally {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, string + "back from wait for work");
                        }
                    }
                }
                if (bl3) {
                    bl3 = false;
                    if (!this.servantsToAdd.isEmpty() && (iterator = (set = this.servantsToAdd.keySet()).iterator()).hasNext() && (dRSInstanceToken = (DRSInstanceToken)this.servantsToAdd.remove(string3 = (String)iterator.next())) != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, string + "found token to add : " + dRSInstanceToken);
                        }
                        bl2 = true;
                        bl = true;
                    }
                } else {
                    bl3 = true;
                    if (!this.servantsToDelete.isEmpty() && (iterator = (set = this.servantsToDelete.keySet()).iterator()).hasNext() && (string2 = (String)this.servantsToDelete.remove(string3 = (String)iterator.next())) != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, string + "found token to delete : " + string2);
                        }
                        bl2 = true;
                        bl = false;
                    }
                }
            }
            if (!bl2) continue;
            if (bl) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string + "about to addServant : " + dRSInstanceToken);
                }
                this.instance.addServant(dRSInstanceToken, this.isUpEvent);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, string + "completed addServant : " + dRSInstanceToken);
                continue;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + "about to deleteServant : " + string2);
            }
            this.instance.deleteServant(string2);
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, string + "completed deleteServant : " + string2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Exit");
        }
    }
}

