/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.drs.ws390;

import com.ibm.CORBA.iiop.ORB;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.applicationserver.webcontainer.DRSSettings;
import com.ibm.ws.drs.ws390.DRSCacheMsgListenerStub;
import com.ibm.ws.drs.ws390.DRSDataXferStub;
import com.ibm.ws.drs.ws390.DRSInstanceConfig;
import com.ibm.ws.drs.ws390.DRSInstanceStub;
import com.ibm.ws.drs.ws390.DRSInstanceTokenImpl;
import com.ibm.ws.drs.ws390.DRSPlatformHelper;
import com.ibm.ws.drs.ws390.DRSServantProxyHelper;
import com.ibm.ws.drs.ws390.DRSSettingsWrapper;
import com.ibm.ws.drs.ws390.proxy.controller.DRSControllerProxy;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.runtime.component.MultibrokerDomainImpl;
import com.ibm.ws.util.ServantInitializationListener;
import com.ibm.ws.util.ServantInitializedException;
import com.ibm.wsspi.cluster.ClusterObserver;
import com.ibm.wsspi.drs.DRSBootstrap;
import com.ibm.wsspi.drs.DRSCacheMsgListener;
import com.ibm.wsspi.drs.DRSDataXfer;
import com.ibm.wsspi.drs.DRSInstanceToken;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;

public class DRSInstanceFactory
implements ServantInitializationListener {
    private static Integer factoryLock = new Integer(1);
    private static TraceComponent tc = Tr.register(DRSInstanceFactory.class.getName(), "DRS", "com.ibm.ws.drs.resources.drs");
    private static DRSInstanceFactory instanceFactory = null;
    private static boolean _loggedVersion = false;
    private boolean initialized;
    private boolean destroyed;
    private boolean servantInitializationComplete;
    private boolean servantInitializationReceived;
    private Integer servantInitializationLock;
    private Integer instanceLock;
    private Integer proxyLock;
    private HashMap DRSInstanceStubs;
    private HashMap DRSDataXferStubs;
    private Object CorbaProxyRef;
    private boolean proxyCreated;
    private DRSControllerProxy drsControllerProxyReference;
    private MultibrokerDomainImpl _mbd;
    private DRSServantProxyHelper drsServantProxyHelper;
    private DRSInstanceTokenImpl registrationToken;
    private boolean servantRegistered;
    private boolean servantConfirmed;
    private boolean registrationComplete;
    private String initStoken;
    private String servantInitStoken;
    private Integer nextInstanceLock;
    private long instanceNumber;

    public static DRSInstanceFactory getInstance() {
        return instanceFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DRSInstanceFactory createInstance(MultibrokerDomainImpl multibrokerDomainImpl) {
        Integer n = factoryLock;
        synchronized (n) {
            if (DRSPlatformHelper.isZOS_Servant_Region() && instanceFactory == null) {
                instanceFactory = new DRSInstanceFactory(multibrokerDomainImpl);
            }
        }
        return instanceFactory;
    }

    private DRSInstanceFactory(MultibrokerDomainImpl multibrokerDomainImpl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DRSInstanceFactory.constructor: Entry.");
        }
        if (tc.isDebugEnabled() && !_loggedVersion) {
            Tr.debug(tc, "DRSInstanceFactory.constructor: Version 1.8 2/25/05 09:43:23");
            _loggedVersion = true;
        }
        this.DRSInstanceStubs = new HashMap();
        this.DRSDataXferStubs = new HashMap();
        this.instanceLock = new Integer(2);
        this.proxyLock = new Integer(3);
        this.servantInitializationLock = new Integer(4);
        this.CorbaProxyRef = null;
        this.proxyCreated = false;
        this.drsControllerProxyReference = null;
        this._mbd = multibrokerDomainImpl;
        this.drsServantProxyHelper = DRSServantProxyHelper.createInstance();
        this.registrationToken = null;
        this.servantRegistered = false;
        this.servantConfirmed = false;
        this.registrationComplete = false;
        this.servantInitStoken = null;
        this.nextInstanceLock = new Integer(55);
        this.instanceNumber = 0L;
        this.servantInitializationComplete = false;
        this.servantInitializationReceived = false;
        try {
            this.initStoken = DRSPlatformHelper.getZOSServantToken();
            this.doServantRegistration(this.initStoken);
            AdminHelper.getPlatformHelper().registerListener(this);
        }
        catch (ServantInitializedException servantInitializedException) {
            this.servantInitializationReceived = true;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.drs.ws390.DRSInstanceFactory:constructor", "223", this);
            Tr.error(tc, "drs.throwable.controller", new Object[]{"DRSInstanceFactory.constructor: ", throwable});
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "DRSInstanceFactory.constructor:  end of contstructor:  servantInitializationReceived = " + this.servantInitializationReceived + " servantInitializationComplete = " + this.servantInitializationComplete + " registrationComplete = " + this.registrationComplete + " proxyCreated = " + this.proxyCreated + " servantRegistered = " + this.servantRegistered + " servantConfirmed = " + this.servantConfirmed);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DRSInstanceFactory.constructor: Exit - registration complete = " + this.registrationComplete);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterServant() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DRSInstanceFactory.unregisterServant: Entry.");
        }
        Integer n = this.instanceLock;
        synchronized (n) {
            if (!this.proxyCreated) {
                this.createControllerProxyReference();
            }
            if (this.proxyCreated && this.registrationToken != null) {
                Tr.info(tc, "drs.servant.shutdown", this.registrationToken.getStoken());
                try {
                    this.drsControllerProxyReference.unregisterServant(this.registrationToken);
                    this.servantRegistered = false;
                    this.registrationToken = null;
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ws.drs.ws390.DRSInstanceFactory.unregisterServant", "261", this);
                    Tr.error(tc, "drs.throwable.controller", new Object[]{"DRSInstanceFactory.unregisterServant: ", throwable});
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DRSInstanceFactory.unregisterServant: Exit.");
        }
    }

    private void registerServant(String string) {
        block10: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "DRSInstanceFactory.registerServant: Entry - stoken = " + string);
            }
            String string2 = null;
            String string3 = null;
            if (string != null) {
                if (!this.servantRegistered) {
                    try {
                        string2 = DRSPlatformHelper.getZOSServantToken();
                        if (string2 == null) break block10;
                        if (string2.equals(string)) {
                            string3 = DRSPlatformHelper.getZOSUniqueId();
                            DRSInstanceTokenImpl dRSInstanceTokenImpl = new DRSInstanceTokenImpl("Servant Registration", "ZOS", string3, string);
                            DRSInstanceTokenImpl dRSInstanceTokenImpl2 = this.drsControllerProxyReference.registerServant(dRSInstanceTokenImpl);
                            if (dRSInstanceTokenImpl2 != null) {
                                this.setRegistrationToken(dRSInstanceTokenImpl2);
                                this.servantRegistered = true;
                            } else {
                                Tr.error(tc, "drs.cont.ifactory.regReturnNull", "DRSInstanceFactory.registerServant: ");
                            }
                            break block10;
                        }
                        Tr.error(tc, "drs.cont.ifactory.stokenNoMatch", new Object[]{"DRSInstanceFactory.registerServant: ", string, string2});
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException(throwable, "com.ibm.ws.drs.ws390.DRSInstanceFactory.registerServant", "308", this);
                        Tr.error(tc, "drs.throwable.controller", new Object[]{"DRSInstanceFactory.registerServant: ", throwable});
                    }
                }
            } else {
                Tr.error(tc, "drs.cont.factory.token", "DRSInstanceFactory.registerServant: ");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DRSInstanceFactory.registerServant: Exit.");
        }
    }

    private void doServantRegistration(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DRSInstanceFactory.doServantRegistration: Entry - stoken = " + string);
        }
        if (!this.proxyCreated) {
            this.createControllerProxyReference();
        }
        if (this.proxyCreated && !this.servantRegistered) {
            this.registerServant(string);
        }
        boolean bl = this.registrationComplete = this.proxyCreated && this.servantRegistered;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DRSInstanceFactory.doServantRegistration: Exit - registrationComplete = " + this.registrationComplete);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DRSControllerProxy getControllerProxyReference() {
        DRSControllerProxy dRSControllerProxy = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DRSInstanceFactory.getControllerProxyReference: Entry.");
        }
        Integer n = this.proxyLock;
        synchronized (n) {
            try {
                ORB oRB = DRSPlatformHelper.getZOSORB();
                this.CorbaProxyRef = oRB.resolve_initial_references(DRSPlatformHelper.getDRSControllerProxyId());
                dRSControllerProxy = (DRSControllerProxy)this.CorbaProxyRef;
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.drs.ws390.DRSInstanceFactory.getControllerProxyReference", "377", this);
                Tr.error(tc, "drs.throwable.cont.proxyref", new Object[]{"DRSInstanceFactory.getControllerProxyReference: ", throwable});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DRSInstanceFactory.getControllerProxyReference: Exit:  rc = " + (dRSControllerProxy == null ? "failure" : "success"));
        }
        return dRSControllerProxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createControllerProxyReference() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DRSInstanceFactory.createControllerProxyReference: Entry.");
        }
        Integer n = this.proxyLock;
        synchronized (n) {
            if (!this.proxyCreated) {
                try {
                    ORB oRB = DRSPlatformHelper.getZOSORB();
                    if (oRB != null) {
                        this.CorbaProxyRef = oRB.resolve_initial_references(DRSPlatformHelper.getDRSControllerProxyId());
                        this.drsControllerProxyReference = (DRSControllerProxy)this.CorbaProxyRef;
                        this.proxyCreated = true;
                    }
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ws.drs.ws390.DRSInstanceFactory.createControllerProxyReference", "420", this);
                    Tr.error(tc, "drs.throwable.cont.proxyref", new Object[]{"DRSInstanceFactory.createControllerProxyReference: ", throwable});
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DRSInstanceFactory.createControllerProxyReference: Exit:  proxyCreated is " + this.proxyCreated);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DRSInstanceToken createInstanceInControllerRegion(String string, DRSCacheMsgListener dRSCacheMsgListener, DRSBootstrap dRSBootstrap, DRSSettingsWrapper dRSSettingsWrapper, ClusterObserver clusterObserver, Map map, DRSInstanceConfig dRSInstanceConfig) {
        DRSInstanceToken dRSInstanceToken = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DRSInstanceFactory.createInstanceInControllerRegion: Entry.");
        }
        Integer n = this.proxyLock;
        synchronized (n) {
            if (!this.proxyCreated) {
                this.createControllerProxyReference();
            }
            String string2 = DRSPlatformHelper.getZOSUniqueId();
            String string3 = DRSPlatformHelper.getZOSServantToken();
            try {
                DRSInstanceTokenImpl dRSInstanceTokenImpl = new DRSInstanceTokenImpl(string, dRSSettingsWrapper.getMessageBrokerDomainName(), string2, string3);
                dRSInstanceToken = this.drsControllerProxyReference.createDRSInstance(dRSInstanceTokenImpl, string, dRSSettingsWrapper, map, dRSInstanceConfig);
                if (dRSInstanceToken == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "DRSInstanceFactory.createInstanceInControllerRegion:  failed to create new token.");
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "DRSInstanceFactory.createInstanceInControllerRegion:  successfully created new token: " + ((Object)dRSInstanceToken).toString());
                }
            }
            catch (RemoteException remoteException) {
                FFDCFilter.processException((Throwable)remoteException, "com.ibm.ws.drs.ws390.DRSInstanceFactory.createInstanceInControllerRegion", "488", this);
                Tr.error(tc, "drs.throwable.cont.crInstremote", new Object[]{"DRSInstanceFactory.createInstanceInControllerRegion: ", remoteException});
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.drs.ws390.DRSInstanceFactory.createInstanceInControllerRegion", "491", this);
                Tr.error(tc, "drs.throwable.cont.crInstance", new Object[]{"DRSInstanceFactory.createInstanceInControllerRegion: ", throwable});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DRSInstanceFactory.createInstanceInControllerRegion: Exit.");
        }
        return dRSInstanceToken;
    }

    private DRSInstanceConfig createInstanceConfig(Map map) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DRSInstanceFactory.createInstanceConfig: Entry.");
        }
        DRSInstanceConfig dRSInstanceConfig = new DRSInstanceConfig();
        if (map == null) {
            dRSInstanceConfig.setCreateDefaultControllerInstance();
        } else if (map.containsKey("Configure DRS Controller Instance")) {
            String string = (String)map.get("Configure DRS Controller Instance");
            if (string.equals("HttpSession DRS Controller Instance")) {
                dRSInstanceConfig.setCreateHttpSessionControllerInstance();
            } else if (string.equals("Dynacache DRS Controller Instance")) {
                dRSInstanceConfig.setCreateDynacacheControllerInstance();
            } else if (string.equals("EJB Container DRS Controller Instance")) {
                dRSInstanceConfig.setCreateEJBContainerControllerInstance();
            } else if (string.equals("Default DRS Controller Instance")) {
                dRSInstanceConfig.setCreateDefaultControllerInstance();
            } else {
                dRSInstanceConfig.setCreateDefaultControllerInstance();
            }
        } else {
            dRSInstanceConfig.setCreateDefaultControllerInstance();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DRSInstanceFactory.createInstanceConfig: Exit.");
        }
        return dRSInstanceConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DRSDataXfer createZOSDRSInstanceStub(String string, DRSCacheMsgListener dRSCacheMsgListener, DRSBootstrap dRSBootstrap, DRSSettings dRSSettings, ClusterObserver clusterObserver, Map map) {
        DRSDataXferStub dRSDataXferStub = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DRSInstanceFactory.createZOSDRSInstanceStub: Entry: id = " + string);
        }
        if (DRSPlatformHelper.isZOS_Servant_Region()) {
            Integer n = this.instanceLock;
            synchronized (n) {
                try {
                    DRSInstanceConfig dRSInstanceConfig = this.createInstanceConfig(map);
                    DRSSettingsWrapper dRSSettingsWrapper = new DRSSettingsWrapper(dRSSettings);
                    DRSInstanceToken dRSInstanceToken = this.createInstanceInControllerRegion(string, dRSCacheMsgListener, dRSBootstrap, dRSSettingsWrapper, clusterObserver, map, dRSInstanceConfig);
                    if (dRSInstanceToken != null) {
                        DRSInstanceStub dRSInstanceStub = new DRSInstanceStub(string, dRSBootstrap, dRSSettings, map, dRSInstanceToken, dRSInstanceConfig, this.getNextInstanceNumber());
                        DRSCacheMsgListenerStub dRSCacheMsgListenerStub = new DRSCacheMsgListenerStub(dRSInstanceStub, dRSCacheMsgListener);
                        dRSDataXferStub = new DRSDataXferStub(dRSInstanceStub, this.drsControllerProxyReference, dRSInstanceToken);
                        dRSInstanceStub.setDRSDataXferStub(dRSDataXferStub);
                        dRSInstanceStub.setDRSCacheMsgListenerStub(dRSCacheMsgListenerStub);
                        this.DRSInstanceStubs.put(((Object)dRSInstanceToken).toString(), dRSInstanceStub);
                        this.DRSDataXferStubs.put(((Object)dRSInstanceToken).toString(), dRSDataXferStub);
                    }
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ws.drs.ws390.DRSInstanceFactory.createZOSDRSInstanceStub", "605", this);
                    Tr.error(tc, "drs.throwable.cont.crInstance", new Object[]{"DRSInstanceFactory.createZOSDRSInstanceStub: ", throwable});
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DRSInstanceFactory.createZOSDRSInstanceStub: Exit. id = " + string + " rc = " + (dRSDataXferStub == null ? "failed" : "success"));
        }
        return dRSDataXferStub;
    }

    public DRSDataXferStub getDRSDataXferStub(DRSInstanceToken dRSInstanceToken) {
        DRSDataXferStub dRSDataXferStub = null;
        if (dRSInstanceToken != null && DRSPlatformHelper.isZOS_Servant_Region() && dRSInstanceToken != null) {
            dRSDataXferStub = (DRSDataXferStub)this.DRSDataXferStubs.get(((Object)dRSInstanceToken).toString());
        }
        return dRSDataXferStub;
    }

    public DRSDataXfer getDRSDataXfer(DRSInstanceToken dRSInstanceToken) {
        DRSDataXferStub dRSDataXferStub = null;
        if (dRSInstanceToken != null && DRSPlatformHelper.isZOS_Servant_Region() && dRSInstanceToken != null) {
            dRSDataXferStub = (DRSDataXferStub)this.DRSDataXferStubs.get(((Object)dRSInstanceToken).toString());
        }
        return dRSDataXferStub;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DRSInstanceStub getDRSInstanceStub(DRSInstanceToken dRSInstanceToken) {
        DRSInstanceStub dRSInstanceStub = null;
        if (dRSInstanceToken != null && DRSPlatformHelper.isZOS_Servant_Region()) {
            Integer n = this.instanceLock;
            synchronized (n) {
                dRSInstanceStub = (DRSInstanceStub)this.DRSInstanceStubs.get(((Object)dRSInstanceToken).toString());
            }
        }
        return dRSInstanceStub;
    }

    public byte[] getServantRegistrationToken() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DRSInstanceFactory.getServantRegistrationToken: Entry");
        }
        byte[] byArray = new byte[]{};
        if (DRSPlatformHelper.isZOS_Servant_Region()) {
            if (this.registrationToken != null) {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "DRSInstanceFactory.getServantRegistrationToken:  Registration Token in SR = " + this.registrationToken);
                }
                try {
                    byArray = DRSPlatformHelper.getByteArray(this.registrationToken);
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ws.drs.ws390.DRSInstanceFactory.getServantRegistrationToken", "673", this);
                    Tr.error(tc, "drs.throwable.controller", new Object[]{"DRSInstanceFactory.getServantRegistrationToken: ", throwable});
                }
            } else {
                Tr.error(tc, "drs.cont.ifactory.regtokenNull", "DRSInstanceFactory.getServantRegistrationToken: ");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DRSInstanceFactory.getServantRegistrationToken: Exit");
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DRSInstanceTokenImpl getRegistrationToken() {
        DRSInstanceTokenImpl dRSInstanceTokenImpl = null;
        if (DRSPlatformHelper.isZOS_Servant_Region()) {
            Integer n = this.instanceLock;
            synchronized (n) {
                dRSInstanceTokenImpl = this.registrationToken;
            }
        }
        return dRSInstanceTokenImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setRegistrationToken(DRSInstanceTokenImpl dRSInstanceTokenImpl) {
        if (DRSPlatformHelper.isZOS_Servant_Region()) {
            Integer n = this.instanceLock;
            synchronized (n) {
                this.registrationToken = dRSInstanceTokenImpl;
            }
        }
    }

    public void unregisterServantRegion() {
        if (DRSPlatformHelper.isZOS_Servant_Region()) {
            this.unregisterServant();
        }
    }

    public void servantInitialized(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DRSInstanceFactory.servantInitialized: Entry: stoken = " + string);
        }
        this.servantInitializationReceived = true;
        this.servantInitStoken = string;
        if (!this.servantInitStoken.equals(this.initStoken)) {
            Tr.error(tc, "drs.cont.ifactory.stokenNoMatch", new Object[]{"DRSInstanceFactory.servantInitialized: ", this.servantInitStoken, this.initStoken});
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "DRSInstanceFactory.servantInitialized:  upon ServantInitialized invocation :  servantInitializationReceived = " + this.servantInitializationReceived + " servantInitializationComplete = " + this.servantInitializationComplete + " registrationComplete = " + this.registrationComplete + " proxyCreated = " + this.proxyCreated + " servantRegistered = " + this.servantRegistered + " servantConfirmed = " + this.servantConfirmed);
        }
        this.confirmServantRegistration(this.servantInitStoken);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "DRSInstanceFactory.servantInitialized:  after registration:  servantInitializationReceived = " + this.servantInitializationReceived + " servantInitializationComplete = " + this.servantInitializationComplete + " registrationComplete = " + this.registrationComplete + " proxyCreated = " + this.proxyCreated + " servantRegistered = " + this.servantRegistered + " servantConfirmed = " + this.servantConfirmed);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DRSInstanceFactory.servantInitialized: Exit");
        }
    }

    private void confirmServantRegistration(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DRSInstanceFactory.confirmServantRegistration: Entry - stoken = " + string);
        }
        if (this.servantInitializationReceived) {
            if (!this.proxyCreated) {
                this.createControllerProxyReference();
            }
            if (this.proxyCreated) {
                if (!this.servantRegistered) {
                    this.registerServant(string);
                }
                if (this.servantRegistered && !this.servantConfirmed) {
                    this.confirmRegistration();
                }
            }
        }
        boolean bl = this.servantInitializationComplete = this.registrationComplete && this.proxyCreated && this.servantInitializationReceived && this.servantRegistered && this.servantConfirmed;
        if (this.servantInitializationComplete) {
            Tr.info(tc, "drs.servant.confirmed", string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DRSInstanceFactory.confirmServantRegistration: Exit - servantInitializationComplete = " + this.servantInitializationComplete);
        }
    }

    private void confirmRegistration() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DRSInstanceFactory.confirmRegistration: Entry.");
        }
        if (!this.servantConfirmed) {
            try {
                DRSInstanceTokenImpl dRSInstanceTokenImpl = this.drsControllerProxyReference.confirmServantRegistration(this.registrationToken);
                if (dRSInstanceTokenImpl != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "DRSInstanceFactory.confirmRegistration:  Token returned from confirmServantRegistration = " + dRSInstanceTokenImpl);
                    }
                    if (dRSInstanceTokenImpl.getConfirmed()) {
                        this.servantConfirmed = true;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "DRSInstanceFactory.confirmRegistration:  Successful confirmation : confirmation token = " + dRSInstanceTokenImpl);
                        }
                        this.setRegistrationToken(dRSInstanceTokenImpl);
                    } else {
                        Tr.error(tc, "drs.cont.ifactory.confTokenNotConf", new Object[]{"DRSInstanceFactory.confirmRegistration: ", dRSInstanceTokenImpl});
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "DRSInstanceFactory.confirmRegistration:  Token returned from confirmServantRegistration = null");
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.drs.ws390.DRSInstanceFactory.confirmRegistration", "830", this);
                Tr.error(tc, "drs.throwable.controller", new Object[]{"DRSInstanceFactory.confirmRegistration: ", throwable});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DRSInstanceFactory.confirmRegistration: Exit.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getNextInstanceNumber() {
        long l;
        Integer n = this.nextInstanceLock;
        synchronized (n) {
            ++this.instanceNumber;
            if (this.instanceNumber < 1L) {
                this.instanceNumber = 1L;
            }
            l = this.instanceNumber;
        }
        return l;
    }
}

