/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.drs.ws390;

import com.ibm.wsspi.drs.DRSInstanceToken;
import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;

public class DRSInstanceTokenImpl
implements Serializable,
DRSInstanceToken {
    private static final long serialVersionUID = -662710385998391533L;
    private String packageId;
    private String id;
    private String key;
    private String domainName;
    private String servantUniqueId;
    private String serverUniqueId;
    private String stoken;
    private String controllerUniqueId;
    private Long drsInstanceID;
    private Boolean isComplete;
    private byte[] binaryStoken;
    private Boolean confirmed;
    private Integer xferOffset;
    private ConcurrentHashMap offsets;

    private void reset() {
        this.packageId = "com.ibm.ws.drs.ws390";
        this.id = "DRSInstanceTokenImpl";
        this.key = null;
        this.domainName = null;
        this.servantUniqueId = null;
        this.stoken = null;
        this.controllerUniqueId = null;
        this.drsInstanceID = null;
        this.serverUniqueId = null;
        this.isComplete = null;
        this.confirmed = new Boolean(false);
        this.xferOffset = null;
        this.offsets = new ConcurrentHashMap();
    }

    private byte[] convertStokenToBinary(String string) {
        char[] cArray = string.toUpperCase().toCharArray();
        byte[] byArray = new byte[cArray.length / 2];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = cArray[i * 2] >= '0' && cArray[i * 2] <= '9' ? (byte)((cArray[i * 2] - 48) * 16) : (byte)((cArray[i * 2] - 65 + 10) * 16);
            if (cArray[i * 2 + 1] >= '0' && cArray[i * 2 + 1] <= '9') {
                int n = i;
                byArray[n] = (byte)(byArray[n] + (cArray[i * 2 + 1] - 48));
                continue;
            }
            int n = i;
            byArray[n] = (byte)(byArray[n] + (cArray[i * 2 + 1] - 65 + 10));
        }
        return byArray;
    }

    public DRSInstanceTokenImpl(String string, String string2, String string3, String string4) {
        this.reset();
        this.key = new String(string);
        this.domainName = new String(string2);
        this.servantUniqueId = new String(string3);
        this.stoken = new String(string4);
        this.binaryStoken = this.convertStokenToBinary(this.stoken);
        this.isComplete = new Boolean(false);
    }

    public DRSInstanceTokenImpl(String string, String string2, String string3, String string4, String string5, Long l) {
        this.reset();
        this.key = new String(string);
        this.domainName = new String(string2);
        this.servantUniqueId = new String(string3);
        this.stoken = new String(string4);
        this.binaryStoken = this.convertStokenToBinary(this.stoken);
        this.controllerUniqueId = new String(string5);
        this.drsInstanceID = l;
        this.isComplete = new Boolean(false);
    }

    public DRSInstanceTokenImpl(String string, String string2, String string3, String string4, String string5, long l) {
        this.reset();
        this.key = new String(string);
        this.domainName = new String(string2);
        this.servantUniqueId = new String(string3);
        this.stoken = new String(string4);
        this.binaryStoken = this.convertStokenToBinary(this.stoken);
        this.controllerUniqueId = new String(string5);
        this.drsInstanceID = new Long(l);
        this.isComplete = new Boolean(false);
    }

    String getId() {
        return this.id;
    }

    String getPackageId() {
        return this.packageId;
    }

    public String getKey() {
        return this.key;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public String getServantUniqueId() {
        return this.servantUniqueId;
    }

    public String getServerUniqueId() {
        return this.serverUniqueId;
    }

    public String getControllerUniqueId() {
        return this.controllerUniqueId;
    }

    public String getStoken() {
        return this.stoken;
    }

    public byte[] getBinaryStoken() {
        return this.binaryStoken;
    }

    public Long getDRSInstanceID() {
        return this.drsInstanceID;
    }

    void setXferOffset(int n) {
        this.xferOffset = new Integer(n);
    }

    void setInstanceOffset(String string, int n) {
        if (string != null && n >= 0) {
            this.offsets.put(string, new Integer(n));
        }
    }

    int getXferOffset() {
        if (this.xferOffset == null) {
            return -1;
        }
        return this.xferOffset;
    }

    int getInstanceOffset(String string) {
        Integer n;
        int n2 = -1;
        if (string != null && (n = (Integer)this.offsets.get(string)) != null) {
            n2 = n;
        }
        return n2;
    }

    void deleteInstanceOffset(String string) {
        if (string != null) {
            this.offsets.remove(string);
        }
    }

    boolean getComplete() {
        return this.isComplete;
    }

    void setComplete(boolean bl) {
        this.isComplete = new Boolean(bl);
    }

    boolean getConfirmed() {
        boolean bl = false;
        if (this.confirmed != null) {
            bl = this.confirmed;
        }
        return bl;
    }

    void setConfirmed(boolean bl) {
        this.confirmed = new Boolean(bl);
    }

    public boolean equals(DRSInstanceToken dRSInstanceToken) {
        DRSInstanceTokenImpl dRSInstanceTokenImpl = null;
        boolean bl = false;
        bl = dRSInstanceToken != null;
        if (bl) {
            try {
                dRSInstanceTokenImpl = (DRSInstanceTokenImpl)dRSInstanceToken;
            }
            catch (Throwable throwable) {
                bl = false;
            }
        }
        if (bl) {
            bl = this.id.equals(dRSInstanceTokenImpl.getId());
        }
        if (bl) {
            bl = this.packageId.equals(dRSInstanceTokenImpl.getPackageId());
        }
        if (bl) {
            boolean bl2 = bl = this.isComplete.booleanValue() == dRSInstanceTokenImpl.isComplete.booleanValue();
        }
        if (bl) {
            bl = this.key.equals(dRSInstanceTokenImpl.getKey());
        }
        if (bl) {
            bl = this.domainName == null ? dRSInstanceTokenImpl.getDomainName() == null : this.domainName.equals(dRSInstanceTokenImpl.getDomainName());
        }
        if (bl) {
            bl = this.servantUniqueId == null ? dRSInstanceTokenImpl.getServantUniqueId() == null : this.servantUniqueId.equals(dRSInstanceTokenImpl.getServantUniqueId());
        }
        if (bl) {
            bl = this.stoken == null ? dRSInstanceTokenImpl.getStoken() == null : this.stoken.equals(dRSInstanceTokenImpl.getStoken());
        }
        if (bl) {
            bl = this.controllerUniqueId == null ? dRSInstanceTokenImpl.getControllerUniqueId() == null : this.controllerUniqueId.equals(dRSInstanceTokenImpl.getControllerUniqueId());
        }
        if (bl) {
            bl = this.drsInstanceID == null ? dRSInstanceTokenImpl.getDRSInstanceID() == null : this.drsInstanceID.equals(dRSInstanceTokenImpl.getDRSInstanceID());
        }
        if (bl) {
            bl = this.xferOffset == null ? dRSInstanceTokenImpl.getXferOffset() < 0 : this.xferOffset.intValue() == dRSInstanceTokenImpl.getXferOffset();
        }
        return bl;
    }

    public String toString() {
        String string = this.id + ":";
        if (this.domainName != null) {
            string = string + ",domain_name=" + this.domainName;
        }
        if (this.drsInstanceID != null) {
            string = string + ",InstanceID=" + this.drsInstanceID;
        }
        if (this.stoken != null) {
            string = string + ",stoken=" + this.stoken;
        }
        return string;
    }

    public String contentsToString() {
        String string = this.packageId + "." + this.id + ":" + this.isComplete + ":";
        if (this.key != null) {
            string = string + "key=" + this.key;
        }
        if (this.domainName != null) {
            string = string + ",domain_name=" + this.domainName;
        }
        if (this.servantUniqueId != null) {
            string = string + ",servantUniqueId=" + this.servantUniqueId;
        }
        if (this.stoken != null) {
            string = string + ",stoken=" + this.stoken;
        }
        if (this.controllerUniqueId != null) {
            string = string + ",controllerUniqueId=" + this.controllerUniqueId;
        }
        if (this.drsInstanceID != null) {
            string = string + ",DRS_Instance_ID=" + this.drsInstanceID;
        }
        if (this.xferOffset != null) {
            string = string + ",xferoffset=" + this.xferOffset;
        }
        return string;
    }
}

