/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.drs.ws390;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.drs.ws390.DRSInstanceTokenImpl;
import com.ibm.wsspi.drs.DRSInstanceToken;
import com.ibm.wsspi.drs.DRSInstanceTokenTable;
import java.util.Iterator;

public class DRSInstanceTokenTableImpl
implements DRSInstanceTokenTable {
    private static final int INITIAL_SIZE = 200;
    private static final int ARRAY_INCREMENT = 100;
    private static long uniqueTableId = 0L;
    private static final Integer uniqueTableIdLock = new Integer(3579);
    private static boolean _loggedVersion = false;
    private static TraceComponent tc = Tr.register(DRSInstanceTokenTableImpl.class.getName(), "DRS", "com.ibm.ws.drs.resources.drs");
    private Integer lock;
    private int currentArraySize;
    private DRSInstanceTokenImpl[] tokenArray;
    private int numberOfTokens;
    private String containerName;
    private String tableName;
    private String instanceOffsetName;
    private long uniqueId;

    public DRSInstanceTokenTableImpl(String string, String string2) {
        this(200, string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DRSInstanceTokenTableImpl(int n, String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DRSInstanceTokenTableImpl:constructor: Entry -  container name = " + string + " ,table name = " + string2);
        }
        if (tc.isDebugEnabled() && !_loggedVersion) {
            Tr.debug(tc, "DRSControllerInstanceFactoryImpl: Version 1.4 2/1/06 18:48:50");
            _loggedVersion = true;
        }
        this.lock = new Integer(22);
        this.currentArraySize = n > 1 ? n : 200;
        this.tokenArray = new DRSInstanceTokenImpl[this.currentArraySize];
        for (int i = 0; i < this.currentArraySize; ++i) {
            this.tokenArray[i] = null;
        }
        this.numberOfTokens = 0;
        this.containerName = string;
        this.tableName = string2;
        Integer n2 = uniqueTableIdLock;
        synchronized (n2) {
            if (++uniqueTableId < 0L) {
                uniqueTableId = 1L;
            }
            this.uniqueId = uniqueTableId;
        }
        this.instanceOffsetName = this.uniqueId + ":" + this.containerName + ":" + this.tableName;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "DRSInstanceTokenTableImpl:constructor:  container name = " + this.containerName + " ,table name = " + this.tableName + " ,instanceOffsetName = " + this.instanceOffsetName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DRSInstanceTokenTableImpl:constructor: Exit -  container name = " + this.containerName + " ,table name = " + this.tableName + " ,instanceOffsetName = " + this.instanceOffsetName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        String string = "DRSInstanceTokenTableImpl:size/" + this.instanceOffsetName + "/";
        int n = 0;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry");
        }
        Integer n2 = this.lock;
        synchronized (n2) {
            n = this.numberOfTokens;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Exit - size = " + n);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        String string = "DRSInstanceTokenTableImpl:isEmpty/" + this.instanceOffsetName + "/";
        boolean bl = true;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry");
        }
        Integer n = this.lock;
        synchronized (n) {
            bl = this.numberOfTokens == 0;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Exit - rc = " + bl);
        }
        return bl;
    }

    public void addServant(DRSInstanceToken dRSInstanceToken) {
        DRSInstanceTokenImpl dRSInstanceTokenImpl;
        String string = "DRSInstanceTokenTableImpl:addServant/" + this.instanceOffsetName + "/";
        if (dRSInstanceToken == null) {
            throw new IllegalArgumentException(string + " token = null");
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry - token = " + dRSInstanceToken);
        }
        if ((dRSInstanceTokenImpl = (DRSInstanceTokenImpl)dRSInstanceToken).getInstanceOffset(this.instanceOffsetName) < 0) {
            this.addTokenToArray(dRSInstanceTokenImpl);
        }
    }

    public void deleteServant(DRSInstanceToken dRSInstanceToken) {
        DRSInstanceTokenImpl dRSInstanceTokenImpl;
        String string;
        String string2 = "DRSInstanceTokenTableImpl:deleteServant(T)/" + this.instanceOffsetName + "/";
        if (dRSInstanceToken == null) {
            throw new IllegalArgumentException(string2 + " token = null");
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string2 + "Entry - token = " + dRSInstanceToken);
        }
        if ((string = (dRSInstanceTokenImpl = (DRSInstanceTokenImpl)dRSInstanceToken).getStoken()) == null) {
            throw new IllegalStateException(string2 + " stoken = null");
        }
        this.removeServantFromArray(string);
    }

    public void deleteServant(String string) {
        String string2 = "DRSInstanceTokenTableImpl:deleteServant(S)/" + this.instanceOffsetName + "/";
        if (string == null) {
            throw new IllegalArgumentException(string2 + " stoken = null");
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string2 + "Entry - stoken = " + string);
        }
        this.removeServantFromArray(string);
    }

    public void clear() {
        this.removeAllTokensFromArray();
    }

    public boolean containsToken(DRSInstanceToken dRSInstanceToken) {
        String string = "DRSInstanceTokenTableImpl:containsToken/" + this.instanceOffsetName + "/";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry - token = " + dRSInstanceToken);
        }
        boolean bl = false;
        if (dRSInstanceToken != null) {
            DRSInstanceTokenImpl dRSInstanceTokenImpl = (DRSInstanceTokenImpl)dRSInstanceToken;
            bl = this.isTokenInArray(dRSInstanceTokenImpl);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Exit - token = " + dRSInstanceToken + " rc = " + bl);
        }
        return bl;
    }

    public boolean containsStoken(String string) {
        String string2 = "DRSInstanceTokenTableImpl:containsStoken/" + this.instanceOffsetName + "/";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string2 + "Entry - stoken = " + string);
        }
        boolean bl = false;
        if (string != null) {
            bl = this.isStokenInArray(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string2 + "Exit - stoken = " + string + " rc = " + bl);
        }
        return bl;
    }

    public Iterator getIterator() {
        return this.createIterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTokenToArray(DRSInstanceTokenImpl dRSInstanceTokenImpl) {
        String string = "DRSInstanceTokenTableImpl:addTokenToArray/" + this.instanceOffsetName + "/";
        boolean bl = false;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry - token = " + dRSInstanceTokenImpl);
        }
        Integer n = this.lock;
        synchronized (n) {
            if (this.numberOfTokens >= this.currentArraySize) {
                this.expandArray();
            }
            for (int i = 0; i < this.currentArraySize && !bl; ++i) {
                if (this.tokenArray[i] != null) continue;
                this.tokenArray[i] = dRSInstanceTokenImpl;
                dRSInstanceTokenImpl.setInstanceOffset(this.instanceOffsetName, i);
                ++this.numberOfTokens;
                bl = true;
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, string + " Token(" + dRSInstanceTokenImpl + ") inserted at position " + i + " , number of tokens = " + this.numberOfTokens);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Exit - inserted = " + bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceExistingTokenInArray(DRSInstanceTokenImpl dRSInstanceTokenImpl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DRSInstanceTokenTableImpl:replaceExistingTokenInArray: Entry - token = " + dRSInstanceTokenImpl);
        }
        Integer n = this.lock;
        synchronized (n) {
            int n2 = dRSInstanceTokenImpl.getInstanceOffset(this.instanceOffsetName);
            if (n2 >= 0) {
                if (this.tokenArray[n2] != null) {
                    this.tokenArray[n2] = dRSInstanceTokenImpl;
                } else {
                    Tr.error(tc, "drs.cont.tokentbl.tokenNotFound", new Object[]{"DRSInstanceTokenTableImpl:replaceExistingTokenInArray: ", dRSInstanceTokenImpl});
                }
            } else {
                Tr.error(tc, "drs.cont.tokentbl.tokenInstanceOffset", new Object[]{"DRSInstanceTokenTableImpl:replaceExistingTokenInArray: ", dRSInstanceTokenImpl});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeTokenFromArray(DRSInstanceTokenImpl dRSInstanceTokenImpl) {
        String string = "DRSInstanceTokenTableImpl:removeTokenFromArray/" + this.instanceOffsetName + "/";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry - token = " + dRSInstanceTokenImpl);
        }
        int n = -1;
        boolean bl = false;
        Integer n2 = this.lock;
        synchronized (n2) {
            n = dRSInstanceTokenImpl.getInstanceOffset(this.instanceOffsetName);
            if (n > 0 && this.tokenArray[n] != null && this.tokenArray[n].equals(dRSInstanceTokenImpl)) {
                this.tokenArray[n] = null;
                dRSInstanceTokenImpl.deleteInstanceOffset(this.instanceOffsetName);
                bl = true;
                --this.numberOfTokens;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string + " Token(" + dRSInstanceTokenImpl + ") deleted from position " + n + " , number of tokens = " + this.numberOfTokens);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Exit - removed = " + bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAllTokensFromArray() {
        Integer n = this.lock;
        synchronized (n) {
            for (int i = 0; i < this.currentArraySize; ++i) {
                if (this.tokenArray[i] == null) continue;
                this.tokenArray[i].deleteInstanceOffset(this.instanceOffsetName);
                this.tokenArray[i] = null;
                --this.numberOfTokens;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isTokenInArray(DRSInstanceTokenImpl dRSInstanceTokenImpl) {
        boolean bl = false;
        int n = -1;
        Integer n2 = this.lock;
        synchronized (n2) {
            n = dRSInstanceTokenImpl.getInstanceOffset(this.instanceOffsetName);
            if (n >= 0 && this.tokenArray[n] != null) {
                bl = this.tokenArray[n].equals(dRSInstanceTokenImpl);
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isStokenInArray(String string) {
        String string2 = "DRSInstanceTokenTableImpl:isStokenInArray/" + this.instanceOffsetName + "/";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string2 + "Entry - stoken = " + string);
        }
        boolean bl = false;
        Integer n = this.lock;
        synchronized (n) {
            for (int i = 0; i < this.currentArraySize; ++i) {
                if (this.tokenArray[i] == null || !this.tokenArray[i].getStoken().equals(string)) continue;
                bl = true;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string2 + "Exit - stoken = " + string + " rc = " + bl);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int searchForTokenInArray(DRSInstanceTokenImpl dRSInstanceTokenImpl) {
        int n = -1;
        Integer n2 = this.lock;
        synchronized (n2) {
            for (int i = 0; i < this.currentArraySize && n == -1; ++i) {
                if (this.tokenArray[i] == null || !this.tokenArray[i].equals(dRSInstanceTokenImpl)) continue;
                n = i;
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeServantFromArray(String string) {
        Integer n = this.lock;
        synchronized (n) {
            for (int i = 0; i < this.currentArraySize; ++i) {
                if (this.tokenArray[i] == null || !this.tokenArray[i].getStoken().equals(string)) continue;
                this.tokenArray[i].deleteInstanceOffset(this.instanceOffsetName);
                this.tokenArray[i] = null;
                --this.numberOfTokens;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expandArray() {
        String string = "DRSInstanceTokenTableImpl:expandArray/" + this.instanceOffsetName + "/";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry");
        }
        Integer n = this.lock;
        synchronized (n) {
            int n2;
            int n3 = this.currentArraySize + 100;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + " Current Size = " + this.currentArraySize + " New Size = " + n3);
            }
            DRSInstanceTokenImpl[] dRSInstanceTokenImplArray = new DRSInstanceTokenImpl[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                dRSInstanceTokenImplArray[n2] = null;
            }
            for (n2 = 0; n2 < this.currentArraySize; ++n2) {
                if (this.tokenArray[n2] == null) continue;
                dRSInstanceTokenImplArray[n2] = this.tokenArray[n2];
                this.tokenArray[n2] = null;
            }
            this.tokenArray = dRSInstanceTokenImplArray;
            this.currentArraySize = n3;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Exit");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterator createIterator() {
        Iterator iterator = null;
        Integer n = this.lock;
        synchronized (n) {
            if (this.numberOfTokens == 0) {
                EmptyDRSInstanceTokenIterator emptyDRSInstanceTokenIterator;
                iterator = emptyDRSInstanceTokenIterator = new EmptyDRSInstanceTokenIterator();
            } else {
                DRSInstanceTokenIterator dRSInstanceTokenIterator = new DRSInstanceTokenIterator(this.tokenArray);
                iterator = dRSInstanceTokenIterator;
            }
        }
        return iterator;
    }

    class EmptyDRSInstanceTokenIterator
    implements Iterator {
        private EmptyDRSInstanceTokenIterator() {
        }

        public boolean hasNext() {
            return false;
        }

        public Object next() {
            return null;
        }

        public void remove() {
        }
    }

    class DRSInstanceTokenIterator
    implements Iterator {
        private int current = 0;
        private int tokenArraySize = 0;
        private DRSInstanceTokenImpl[] tokenArray = null;

        private DRSInstanceTokenIterator(DRSInstanceTokenImpl[] dRSInstanceTokenImplArray) {
            int n;
            for (n = 0; n < dRSInstanceTokenImplArray.length; ++n) {
                if (dRSInstanceTokenImplArray[n] == null) continue;
                ++this.tokenArraySize;
            }
            if (this.tokenArraySize > 0) {
                this.tokenArray = new DRSInstanceTokenImpl[this.tokenArraySize];
                n = 0;
                for (int i = 0; i < dRSInstanceTokenImplArray.length; ++i) {
                    if (dRSInstanceTokenImplArray[i] == null) continue;
                    this.tokenArray[n++] = dRSInstanceTokenImplArray[i];
                }
            }
        }

        public boolean hasNext() {
            return this.current < this.tokenArraySize;
        }

        public Object next() {
            if (this.current >= this.tokenArraySize) {
                return null;
            }
            DRSInstanceTokenImpl dRSInstanceTokenImpl = this.tokenArray[this.current];
            this.tokenArray[this.current] = null;
            ++this.current;
            return dRSInstanceTokenImpl;
        }

        public void remove() {
        }
    }
}

