/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.drs.ws390;

import com.ibm.CORBA.iiop.ORB;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.runtime.ServerName;
import com.ibm.ws.util.PlatformHelperFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class DRSPlatformHelper {
    public static final String DRS_CONTROLLER_PROXY_ID = "DRSControllerProxy";
    private static boolean _loggedVersion = false;
    private static boolean initialized = false;
    private static Integer lock = new Integer(0);
    private static boolean _is_zOS = false;
    private static boolean _is_zOS_servant = false;
    private static boolean _is_zOS_controller = false;
    private static String processType = null;
    private static boolean isBaseServer = false;
    private static String stoken = null;
    private static TraceComponent tc = Tr.register(DRSPlatformHelper.class.getName(), "DRS", "com.ibm.servlet.resources.personalization");

    private DRSPlatformHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DRSPlatformHelper.init: Entry.");
        }
        if (tc.isDebugEnabled() && !_loggedVersion) {
            Tr.debug(tc, "DRSPlatformHelper.init: Version 1.4 12/2/04 15:54:51");
            _loggedVersion = true;
        }
        Integer n = lock;
        synchronized (n) {
            if (!initialized) {
                processType = AdminServiceFactory.getAdminService().getProcessType();
                if (processType != null) {
                    isBaseServer = processType.equals("UnManagedProcess");
                }
                if (_is_zOS = PlatformHelperFactory.getPlatformHelper().isZOS()) {
                    _is_zOS_controller = PlatformHelperFactory.getPlatformHelper().isControlJvm();
                    _is_zOS_servant = PlatformHelperFactory.getPlatformHelper().isServantJvm();
                } else {
                    _is_zOS_controller = false;
                    _is_zOS_servant = false;
                }
                initialized = true;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "DRSPlatformHelper.init: _is_zOS = " + _is_zOS);
                    Tr.debug(tc, "DRSPlatformHelper.init: _is_zOS_controller = " + _is_zOS_controller);
                    Tr.debug(tc, "DRSPlatformHelper.init: _is_zOS_servant = " + _is_zOS_servant);
                    Tr.debug(tc, "DRSPlatformHelper.init:  Process Type = " + processType);
                    Tr.debug(tc, "DRSPlatformHelper.init:  isBaseServer = " + isBaseServer);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DRSPlatformHelper.init: Exit");
        }
    }

    public static boolean isZOS() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DRSPlatformHelper.isZOS: Entry.");
        }
        if (!initialized) {
            DRSPlatformHelper.init();
        }
        boolean bl = _is_zOS;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DRSPlatformHelper.isZOS: Exit : rc = " + bl);
        }
        return bl;
    }

    public static boolean isZOS_Control_Region() {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DRSPlatformHelper.isZOS_Control_Region: Entry.");
        }
        if (!initialized) {
            DRSPlatformHelper.init();
        }
        boolean bl2 = bl = _is_zOS && _is_zOS_controller;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DRSPlatformHelper.isZOS_Control_Region: Exit : rc = " + bl);
        }
        return bl;
    }

    public static boolean isZOS_Servant_Region() {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DRSPlatformHelper.isZOS_Servant_Region: Entry.");
        }
        if (!initialized) {
            DRSPlatformHelper.init();
        }
        boolean bl2 = bl = _is_zOS && _is_zOS_servant;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DRSPlatformHelper.isZOS_Servant_Region: Exit : rc = " + bl);
        }
        return bl;
    }

    public static boolean shouldCreateDRSInstance() {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DRSPlatformHelper.shouldCreateDRSInstance: Entry.");
        }
        if (!initialized) {
            DRSPlatformHelper.init();
        }
        boolean bl2 = bl = !_is_zOS;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DRSPlatformHelper.shouldCreateDRSInstance: Exit : rc = " + bl);
        }
        return bl;
    }

    public static boolean shouldCreateZOSDRSServantInstance() {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DRSPlatformHelper.shouldCreateZOSDRSServantInstance: Entry.");
        }
        if (!initialized) {
            DRSPlatformHelper.init();
        }
        boolean bl2 = bl = _is_zOS && _is_zOS_servant;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DRSPlatformHelper.shouldCreateZOSDRSServantInstance: Exit : rc = " + bl);
        }
        return bl;
    }

    public static boolean shouldInitZOSControllerFactory() {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DRSPlatformHelper.shouldInitZOSControllerFactory: Entry.");
        }
        if (!initialized) {
            DRSPlatformHelper.init();
        }
        boolean bl2 = bl = _is_zOS && _is_zOS_controller;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DRSPlatformHelper.shouldInitZOSControllerFactory: Exit : rc = " + bl);
        }
        return bl;
    }

    public static boolean shouldInitZOSServantFactory() {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DRSPlatformHelper.shouldInitZOSServantFactory: Entry.");
        }
        if (!initialized) {
            DRSPlatformHelper.init();
        }
        boolean bl2 = bl = _is_zOS && _is_zOS_servant;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DRSPlatformHelper.shouldInitZOSServantFactory: Exit : rc = " + bl);
        }
        return bl;
    }

    public static boolean shouldCreateZOSDRSControllerInstance() {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DRSPlatformHelper.shouldCreateZOSDRSControllerInstance: Entry.");
        }
        if (!initialized) {
            DRSPlatformHelper.init();
        }
        boolean bl2 = bl = _is_zOS && _is_zOS_controller;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DRSPlatformHelper.shouldCreateZOSDRSControllerInstance: Exit : rc = " + bl);
        }
        return bl;
    }

    public static String getZOSUniqueId() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DRSPlatformHelper.getZOSUniqueId: Entry.");
        }
        String string = null;
        if (!initialized) {
            DRSPlatformHelper.init();
        }
        if (_is_zOS) {
            string = PlatformHelperFactory.getPlatformHelper().getUniqueId();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DRSPlatformHelper.getZOSUniqueId: Exit : unique id = " + string);
        }
        return string;
    }

    public static String getZOSServantToken() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DRSPlatformHelper.getZOSServantToken: Entry.");
        }
        String string = null;
        if (!initialized) {
            DRSPlatformHelper.init();
        }
        if (_is_zOS) {
            string = ServerName.getPrintableStoken();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DRSPlatformHelper.getZOSServantToken: Exit : token = " + string);
        }
        return string;
    }

    public static ORB getZOSORB() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DRSPlatformHelper.getZOSORB: Entry.");
        }
        ORB oRB = null;
        if (!initialized) {
            DRSPlatformHelper.init();
        }
        if (_is_zOS) {
            oRB = PlatformHelperFactory.getPlatformHelper().getGlobalORB();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DRSPlatformHelper.getZOSORB: Exit : " + (oRB == null ? "failure" : "success"));
        }
        return oRB;
    }

    public static String getDRSControllerProxyId() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DRSPlatformHelper.getDRSControllerProxyId: Entry : getDRSControllerProxyId = DRSControllerProxy");
        }
        return DRS_CONTROLLER_PROXY_ID;
    }

    public static boolean shouldCreateDRSServantProxyFactoryInstance() {
        boolean bl = false;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DRSPlatformHelper.shouldCreateDRSServantProxyFactoryInstance: Entry.");
        }
        if (!initialized) {
            DRSPlatformHelper.init();
        }
        boolean bl2 = bl = _is_zOS && _is_zOS_controller;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DRSPlatformHelper.shouldCreateDRSServantProxyFactoryInstance: Exit : rc = " + bl);
        }
        return bl;
    }

    public static byte[] getByteArray(Object object) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DRSPlatformHelper.getByteArray: Entry.");
        }
        byte[] byArray = new byte[]{};
        if (object != null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            byArray = byteArrayOutputStream.toByteArray();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DRSPlatformHelper.getByteArray: Exit.");
        }
        return byArray;
    }

    public static Object getObject(byte[] byArray) throws IOException, ClassNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DRSPlatformHelper.getObject: Entry.");
        }
        Object object = null;
        if (byArray != null && byArray.length > 0) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            object = objectInputStream.readObject();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DRSPlatformHelper.getObject: Exit : " + (object == null ? "failure" : "success"));
        }
        return object;
    }

    public static boolean isBaseServer() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DRSPlatformHelper.isBaseServer: Entry.");
        }
        if (!initialized) {
            DRSPlatformHelper.init();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DRSPlatformHelper.isBaseServer: Exit - isBaseServer = " + isBaseServer);
        }
        return isBaseServer;
    }

    public static boolean isZOSBaseServer() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DRSPlatformHelper.isZOSBaseServer: Entry.");
        }
        boolean bl = false;
        if (!initialized) {
            DRSPlatformHelper.init();
        }
        boolean bl2 = bl = _is_zOS && isBaseServer;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DRSPlatformHelper.isZOSBaseServer: Exit - isZOSBaseServer = " + bl);
        }
        return bl;
    }
}

