/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.drs.ws390;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.drs.ws390.DRSPlatformHelper;
import com.ibm.ws.drs.ws390.DRSServantProxyWrapper;
import com.ibm.ws.drs.ws390.proxy.servant.DRSServantProxyImpl;
import com.ibm.ws.drs.ws390.proxy.servant.DRSServantProxyOperations;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.util.PlatformUtils;
import com.ibm.ws.runtime.component.MultibrokerDomainImpl;
import com.ibm.ws.util.ImplFactory;
import com.ibm.wsspi.drs.DRSInstanceToken;
import com.ibm.wsspi.drs.DRSServantProxy;
import com.ibm.wsspi.drs.DRSServantProxyFactory;
import java.io.IOException;
import java.util.Iterator;

public class DRSServantProxyFactoryImpl
implements DRSServantProxyFactory {
    private static Integer factoryLock = new Integer(1);
    private static TraceComponent tc = Tr.register(DRSServantProxyFactoryImpl.class.getName(), "DRS", "com.ibm.ws.drs.resources.drs");
    private static DRSServantProxyFactoryImpl instanceFactory = null;
    private Integer instanceLock;
    private Integer proxyLock;
    private PlatformUtils platformUtils;
    private MultibrokerDomainImpl _mbd;

    private DRSServantProxyFactoryImpl(MultibrokerDomainImpl multibrokerDomainImpl) {
        this._mbd = multibrokerDomainImpl;
        this.instanceLock = new Integer(2);
        this.platformUtils = (PlatformUtils)ImplFactory.loadImplFromKey(PlatformUtils.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DRSServantProxyFactoryImpl createInstance(MultibrokerDomainImpl multibrokerDomainImpl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DRSServantProxyFactoryImpl.createInstance: Entry.");
        }
        Integer n = factoryLock;
        synchronized (n) {
            if (instanceFactory == null) {
                instanceFactory = new DRSServantProxyFactoryImpl(multibrokerDomainImpl);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DRSServantProxyFactoryImpl.createInstance: Exit");
        }
        return instanceFactory;
    }

    public static DRSServantProxyFactory getInstance() {
        return instanceFactory;
    }

    public DRSServantProxy createProxyForAnySingleServant() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DRSServantProxyFactoryImpl.createProxyForAnySingleServant: Entry.");
        }
        DRSServantProxyWrapper dRSServantProxyWrapper = null;
        DRSServantProxyOperations dRSServantProxyOperations = this.createProxyForAnySingleSR();
        if (dRSServantProxyOperations != null) {
            dRSServantProxyWrapper = new DRSServantProxyWrapper(dRSServantProxyOperations);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DRSServantProxyFactoryImpl.createProxyForAnySingleServant: Exit: " + (dRSServantProxyWrapper == null ? "failure" : "success"));
        }
        return dRSServantProxyWrapper;
    }

    public DRSServantProxy createProxyForSpecificServant(DRSInstanceToken dRSInstanceToken) {
        DRSServantProxyOperations dRSServantProxyOperations;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DRSServantProxyFactoryImpl.createProxyForSpecificServant: Entry.");
        }
        DRSServantProxyWrapper dRSServantProxyWrapper = null;
        if (dRSInstanceToken != null && (dRSServantProxyOperations = this.createProxyForSpecificSR(dRSInstanceToken)) != null) {
            dRSServantProxyWrapper = new DRSServantProxyWrapper(dRSServantProxyOperations);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DRSServantProxyFactoryImpl.createProxyForSpecificServant: Exit: " + (dRSServantProxyWrapper == null ? "failure" : "success"));
        }
        return dRSServantProxyWrapper;
    }

    public Iterator createProxysForAllCurrentServants() {
        Iterator iterator = null;
        return iterator;
    }

    private Iterator createProxysForAllCurrentSRs() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DRSServantProxyFactoryImpl.createProxysForAllCurrentSRs: Entry.");
        }
        Iterator iterator = this.platformUtils.getSRAggregator(new DRSServantProxyImpl(), true);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DRSControllerInstanceFactoryImpl:createCallbacksForAllCurrentSRs - exit");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DRSServantProxyFactoryImpl.createProxysForAllCurrentSRs: Exit: " + (iterator == null ? "failure" : "success"));
        }
        return iterator;
    }

    private DRSServantProxyOperations createProxyForAnySingleSR() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DRSServantProxyFactoryImpl.createProxyForAnySingleSR: Entry.");
        }
        Iterator iterator = this.platformUtils.getSRAggregator(new DRSServantProxyImpl(), false);
        DRSServantProxyOperations dRSServantProxyOperations = (DRSServantProxyOperations)iterator.next();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DRSServantProxyFactoryImpl.createProxyForAnySingleSR: Exit: " + (dRSServantProxyOperations == null ? "failure" : "success"));
        }
        return dRSServantProxyOperations;
    }

    private DRSServantProxyOperations createProxyForSpecificSR(DRSInstanceToken dRSInstanceToken) {
        DRSServantProxyOperations dRSServantProxyOperations;
        block6: {
            dRSServantProxyOperations = null;
            if (dRSInstanceToken == null) {
                return null;
            }
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "DRSServantProxyFactoryImpl:createProxyForSpecificSR: Entry: Stoken = " + dRSInstanceToken);
            }
            try {
                Iterator iterator = this.platformUtils.getSRAggregator(new DRSServantProxyImpl(), false, dRSInstanceToken.getBinaryStoken());
                dRSServantProxyOperations = (DRSServantProxyOperations)iterator.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "DRSServantProxyFactoryImpl:createProxyForSpecificSR: successfully created callback for " + dRSInstanceToken);
                }
            }
            catch (Throwable throwable) {
                if (!tc.isDebugEnabled()) break block6;
                FFDCFilter.processException(throwable, "com.ibm.ws.drs.ws390.DRSServantProxyFactoryImpl.createProxyForSpecificSR", "252", this);
                Tr.debug(tc, "DRSServantProxyFactoryImpl:createProxyForSpecificSR: Caught exception while trying to create a proxy to token " + dRSInstanceToken);
                Tr.debug(tc, "DRSServantProxyFactoryImpl:createProxyForSpecificSR: This exception is not necessarily an error.");
                Tr.error(tc, "drs.throwable.contcallback", new Object[]{"DRSServantProxyFactoryImpl:createProxyForSpecificSR: ", throwable});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DRSServantProxyFactoryImpl:createProxyForSpecificSR: Exit: " + (dRSServantProxyOperations == null ? "failure" : "success"));
        }
        return dRSServantProxyOperations;
    }

    public byte[] getByteArray(Object object) throws IOException {
        return DRSPlatformHelper.getByteArray(object);
    }

    public Object getObject(byte[] byArray) throws IOException, ClassNotFoundException {
        return DRSPlatformHelper.getObject(byArray);
    }
}

