/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.drs.ws390.externaldatastore;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.drs.ws390.DRSPlatformHelper;
import com.ibm.ws.drs.ws390.externaldatastore.DRSExternalDataStore;
import com.ibm.ws.drs.ws390.externaldatastore.DRSExternalDataStoreToken;
import com.ibm.ws.drs.ws390.externaldatastore.DRSExternalDataStoreTokenImpl;
import com.ibm.ws.drs.ws390.externaldatastore.DRSNativeExternalDataStore;
import com.ibm.ws.ffdc.FFDCFilter;
import java.util.Hashtable;

public class DRSExternalDataStoreImpl
implements DRSExternalDataStore {
    private static TraceComponent tc = Tr.register(DRSExternalDataStoreImpl.class.getName(), "DRS", "com.ibm.ws.drs.resources.drs");
    private static boolean _loggedVersion = false;
    private DRSNativeExternalDataStore nativeDataStore;
    private Integer lock;
    private Hashtable tokens;

    public DRSExternalDataStoreImpl(DRSNativeExternalDataStore dRSNativeExternalDataStore) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DRSExternalDataStoreImpl:constructor: Entry.");
        }
        if (tc.isDebugEnabled() && !_loggedVersion) {
            Tr.debug(tc, "DRSExternalDataStoreImpl:constructor: Version 1.6 2/25/05 09:43:30");
            _loggedVersion = true;
        }
        this.nativeDataStore = dRSNativeExternalDataStore;
        this.tokens = new Hashtable();
        this.lock = new Integer(54);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DRSExternalDataStoreImpl:constructor: Exit.");
        }
    }

    public DRSExternalDataStoreToken putData(byte[] byArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DRSExternalDataStoreImpl:putData: Entry.");
        }
        DRSExternalDataStoreToken dRSExternalDataStoreToken = null;
        if (DRSPlatformHelper.isZOS_Control_Region() && byArray != null && byArray.length > 0) {
            dRSExternalDataStoreToken = this.doPutData(byArray);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DRSExternalDataStoreImpl:putData: Exit - token = " + (dRSExternalDataStoreToken == null ? "null" : ((Object)dRSExternalDataStoreToken).toString()));
        }
        return dRSExternalDataStoreToken;
    }

    public byte[] getData(DRSExternalDataStoreToken dRSExternalDataStoreToken) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DRSExternalDataStoreImpl:getData: Entry.");
        }
        byte[] byArray = null;
        if (DRSPlatformHelper.isZOS_Control_Region() && dRSExternalDataStoreToken != null) {
            byArray = this.doGetData(dRSExternalDataStoreToken);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DRSExternalDataStoreImpl:getData: Exit.");
        }
        return byArray;
    }

    public byte[] removeData(DRSExternalDataStoreToken dRSExternalDataStoreToken) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DRSExternalDataStoreImpl:removeData: Entry.");
        }
        byte[] byArray = null;
        if (DRSPlatformHelper.isZOS_Control_Region() && dRSExternalDataStoreToken != null) {
            byArray = this.doRemoveData(dRSExternalDataStoreToken);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DRSExternalDataStoreImpl:removeData: Exit.");
        }
        return byArray;
    }

    public void deleteData(DRSExternalDataStoreToken dRSExternalDataStoreToken) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DRSExternalDataStoreImpl:deleteData: Entry.");
        }
        if (DRSPlatformHelper.isZOS_Control_Region() && dRSExternalDataStoreToken != null) {
            this.doDeleteData(dRSExternalDataStoreToken);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DRSExternalDataStoreImpl:deleteData: Exit.");
        }
    }

    public String getStats() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DRSExternalDataStoreImpl:getStats: Entry.");
        }
        String string = this.nativeDataStore.getStats() + ": NumberOfTokens=" + this.tokens.size();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DRSExternalDataStoreImpl:getStats: Exit");
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DRSExternalDataStoreToken doPutData(byte[] byArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DRSExternalDataStoreImpl:doPutData: Entry.");
        }
        DRSExternalDataStoreTokenImpl dRSExternalDataStoreTokenImpl = null;
        Integer n = this.lock;
        synchronized (n) {
            try {
                int n2 = byArray.length;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "DRSExternalDataStoreImpl:doPutData: Buffer Length = " + n2);
                }
                long l = this.nativeDataStore.putData(byArray, n2);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "DRSExternalDataStoreImpl:doPutData: Returned token = " + l);
                }
                if (l > 0L) {
                    dRSExternalDataStoreTokenImpl = new DRSExternalDataStoreTokenImpl(l, n2);
                    this.tokens.put(dRSExternalDataStoreTokenImpl, dRSExternalDataStoreTokenImpl);
                } else {
                    Tr.error(tc, "drs.externaldatastore.native.error", new Object[]{"DRSExternalDataStoreImpl:doPutData: ", new Long(l)});
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.drs.ws390.externaldatastore.DRSExternalDataStoreImpl.doPutData", "176", this);
                Tr.error(tc, "drs.throwable.controller", new Object[]{"DRSExternalDataStoreImpl:doPutData: ", throwable});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DRSExternalDataStoreImpl:doPutData: Exit - rc = " + (dRSExternalDataStoreTokenImpl == null ? "null" : ((Object)dRSExternalDataStoreTokenImpl).toString()));
        }
        return dRSExternalDataStoreTokenImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] doGetData(DRSExternalDataStoreToken dRSExternalDataStoreToken) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DRSExternalDataStoreImpl:doGetData: Entry - token = " + dRSExternalDataStoreToken);
        }
        byte[] byArray = null;
        Integer n = this.lock;
        synchronized (n) {
            try {
                int n2 = dRSExternalDataStoreToken.getDataLength();
                long l = dRSExternalDataStoreToken.getToken();
                byArray = new byte[n2];
                int n3 = this.nativeDataStore.getData(l, byArray, n2);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.drs.ws390.externaldatastore.DRSExternalDataStoreImpl.doGetData", "199", this);
                Tr.error(tc, "drs.throwable.controller", new Object[]{"DRSExternalDataStoreImpl:doGetData: ", throwable});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DRSExternalDataStoreImpl:doGetData: Exit - " + (byArray == null ? "data not found" : "returning requested data"));
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] doRemoveData(DRSExternalDataStoreToken dRSExternalDataStoreToken) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DRSExternalDataStoreImpl:doRemoveData: Entry - token = " + dRSExternalDataStoreToken);
        }
        byte[] byArray = null;
        Integer n = this.lock;
        synchronized (n) {
            try {
                byArray = this.doGetData(dRSExternalDataStoreToken);
                this.doDeleteData(dRSExternalDataStoreToken);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.drs.ws390.externaldatastore.DRSExternalDataStoreImpl.doRemoveData", "221", this);
                Tr.error(tc, "drs.throwable.controller", new Object[]{"DRSExternalDataStoreImpl:doRemoveData: ", throwable});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DRSExternalDataStoreImpl:doRemoveData: Exit.");
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doDeleteData(DRSExternalDataStoreToken dRSExternalDataStoreToken) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DRSExternalDataStoreImpl:doDeleteData: Entry.");
        }
        Integer n = this.lock;
        synchronized (n) {
            try {
                long l = dRSExternalDataStoreToken.getToken();
                int n2 = dRSExternalDataStoreToken.getDataLength();
                int n3 = this.nativeDataStore.deleteData(l, n2);
                this.tokens.remove(dRSExternalDataStoreToken);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.drs.ws390.externaldatastore.DRSExternalDataStoreImpl.doDeleteData", "242", this);
                Tr.error(tc, "drs.throwable.controller", new Object[]{"DRSExternalDataStoreImpl:doDeleteData: ", throwable});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DRSExternalDataStoreImpl:doDeleteData: Exit.");
        }
    }
}

