/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.drs.ws390.externaldatastore;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.drs.ws390.DRSPlatformHelper;
import com.ibm.ws.drs.ws390.externaldatastore.DRSExternalDataStore;
import com.ibm.ws.drs.ws390.externaldatastore.DRSExternalDataStoreToken;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.drs.exception.ws390.externaldatastore.DRSExternalDataStoreCapacityExceededException;
import com.ibm.wsspi.drs.exception.ws390.externaldatastore.DRSExternalDataStoreEnvironmentException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class DRSExternalHashMapImpl
implements Map {
    private static TraceComponent tc = Tr.register(DRSExternalHashMapImpl.class.getName(), "DRS", "com.ibm.ws.drs.resources.drs");
    private static boolean _loggedVersion = false;
    String mapName;
    DRSExternalDataStore dataStore;
    HashMap dataItems;
    Integer lock;
    boolean initialized;
    int size;

    public DRSExternalHashMapImpl(DRSExternalDataStore dRSExternalDataStore, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DRSExternalHashmapImpl.constructor: Entry - mapName = " + string);
        }
        if (tc.isDebugEnabled() && !_loggedVersion) {
            Tr.debug(tc, "DRSExternalHashmapImpl.constructor: Version 1.5 2/25/05 09:43:32");
            _loggedVersion = true;
        }
        this.dataStore = dRSExternalDataStore;
        this.dataItems = new HashMap();
        this.lock = new Integer(24);
        this.size = 0;
        this.mapName = string;
        this.initialized = true;
    }

    public String getMapName() {
        String string = null;
        if (this.initialized) {
            string = this.mapName;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        String string = "DRSExternalHashmapImpl.size/" + this.mapName + ": ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry.");
        }
        int n = 0;
        Integer n2 = this.lock;
        synchronized (n2) {
            if (!this.initialized) {
                throw new DRSExternalDataStoreEnvironmentException("External Hashmap " + this.mapName + " is no longer valid");
            }
            n = this.dataItems.size();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Exit - size = " + n);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        String string = "DRSExternalHashmapImpl.isEmpty/" + this.mapName + ": ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry.");
        }
        boolean bl = false;
        Integer n = this.lock;
        synchronized (n) {
            if (!this.initialized) {
                throw new DRSExternalDataStoreEnvironmentException("External Hashmap " + this.mapName + " is no longer valid");
            }
            bl = this.dataItems.isEmpty();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Exit - isEmpty = " + bl);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(Object object) {
        String string = "DRSExternalHashmapImpl.containsKey/" + this.mapName + ": ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry.");
        }
        boolean bl = true;
        Integer n = this.lock;
        synchronized (n) {
            if (!this.initialized) {
                throw new DRSExternalDataStoreEnvironmentException("External Hashmap " + this.mapName + " is no longer valid");
            }
            bl = this.dataItems.containsKey(object);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Exit - containsKey = " + bl);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set keySet() {
        String string = "DRSExternalHashmapImpl.keySet/" + this.mapName + ": ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry.");
        }
        Set set = null;
        Integer n = this.lock;
        synchronized (n) {
            if (!this.initialized) {
                throw new DRSExternalDataStoreEnvironmentException("External Hashmap " + this.mapName + " is no longer valid");
            }
            set = this.dataItems.keySet();
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(Object object, Object object2) {
        String string = "DRSExternalHashmapImpl.put/" + this.mapName + ": ";
        Object object3 = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry.");
        }
        if (object != null && object2 != null) {
            Integer n = this.lock;
            synchronized (n) {
                if (!this.initialized) {
                    throw new DRSExternalDataStoreEnvironmentException("External Hashmap " + this.mapName + " is no longer valid");
                }
                object3 = this.doPut(object, object2);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Exit - rc = " + (object3 == null ? "null" : "not null"));
        }
        return object3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object object) {
        String string = "DRSExternalHashmapImpl.get/" + this.mapName + ": ";
        Object object2 = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry.");
        }
        if (object != null) {
            Integer n = this.lock;
            synchronized (n) {
                if (!this.initialized) {
                    throw new DRSExternalDataStoreEnvironmentException("External Hashmap " + this.mapName + " is no longer valid");
                }
                try {
                    object2 = this.doGet(object);
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ws.drs.ws390.externaldatastore.DRSExternalHashMapImpl.get", "202", this);
                    Tr.error(tc, "drs.throwable.controller", new Object[]{string, throwable});
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Exit - rc = " + (object2 == null ? "null" : "not null"));
        }
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(Object object) {
        String string = "DRSExternalHashmapImpl.remove/" + this.mapName + ": ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry - key = " + object);
        }
        Object object2 = null;
        if (object != null) {
            Integer n = this.lock;
            synchronized (n) {
                if (!this.initialized) {
                    throw new DRSExternalDataStoreEnvironmentException("External Hashmap " + this.mapName + " is no longer valid");
                }
                try {
                    object2 = this.doRemove(object);
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ws.drs.ws390.externaldatastore.DRSExternalHashMapImpl.remove", "230", this);
                    Tr.error(tc, "drs.throwable.controller", new Object[]{string, throwable});
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Exit - rc = " + (object2 == null ? "null" : "not null"));
        }
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(String string) {
        String string2 = "DRSExternalHashmapImpl.containsKey/" + this.mapName + ": ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string2 + "Entry - key = " + string);
        }
        boolean bl = false;
        if (string != null) {
            Integer n = this.lock;
            synchronized (n) {
                if (!this.initialized) {
                    throw new DRSExternalDataStoreEnvironmentException("External Hashmap " + this.mapName + " is no longer valid");
                }
                bl = this.dataItems.containsKey(string);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string2 + "Exit - containsKey = " + bl);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        String string = "DRSExternalHashmapImpl.clear/" + this.mapName + ": ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry.");
        }
        Integer n = this.lock;
        synchronized (n) {
            if (!this.initialized) {
                throw new DRSExternalDataStoreEnvironmentException("External Hashmap " + this.mapName + " is no longer valid");
            }
            this.doDeleteAll();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Exit.");
        }
    }

    public boolean containsValue(Object object) {
        throw new UnsupportedOperationException();
    }

    public void putAll(Map map) {
        throw new UnsupportedOperationException();
    }

    public Collection values() {
        throw new UnsupportedOperationException();
    }

    public Set entrySet() {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object object) {
        throw new UnsupportedOperationException();
    }

    public int hashCode() {
        return super.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        String string = "DRSExternalHashmapImpl.destroy/" + this.mapName + ": ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry.");
        }
        Integer n = this.lock;
        synchronized (n) {
            this.doDeleteAll();
            this.dataStore = null;
            this.dataItems.clear();
            this.dataItems = null;
            this.size = 0;
            this.initialized = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Exit.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object doPut(Object object, Object object2) {
        String string = "DRSExternalHashmapImpl.doPut/" + this.mapName + ": ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry.");
        }
        boolean bl = false;
        Object object3 = null;
        Object object4 = this.lock;
        synchronized (object4) {
            try {
                byte[] byArray = this.doRemoveData(object);
                if (byArray != null) {
                    object3 = DRSPlatformHelper.getObject(byArray);
                }
                byte[] byArray2 = DRSPlatformHelper.getByteArray(object2);
                bl = this.doPutData(object, byArray2);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.drs.ws390.externaldatastore.DRSExternalHashMapImpl.doPut", "335", this);
                Tr.error(tc, "drs.throwable.controller", new Object[]{string, throwable});
            }
        }
        if (!bl) {
            object4 = "DRSExternalHashmapImpl: Unable to insert data into external store :" + this.mapName + " : " + this.dataStore.getStats();
            throw new DRSExternalDataStoreCapacityExceededException((String)object4);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Exit.");
        }
        return object3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object doGet(Object object) {
        String string = "DRSExternalHashmapImpl.doGet/" + this.mapName + ": ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry.");
        }
        Object object2 = null;
        Integer n = this.lock;
        synchronized (n) {
            try {
                byte[] byArray = this.doGetData(object);
                if (byArray != null) {
                    object2 = DRSPlatformHelper.getObject(byArray);
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.drs.ws390.externaldatastore.DRSExternalHashMapImpl.doGet", "362", this);
                Tr.error(tc, "drs.throwable.controller", new Object[]{string, throwable});
            }
        }
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object doRemove(Object object) {
        String string = "DRSExternalHashmapImpl.doRemove/" + this.mapName + ": ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry.");
        }
        Object object2 = null;
        Integer n = this.lock;
        synchronized (n) {
            try {
                byte[] byArray = this.doRemoveData(object);
                if (byArray != null) {
                    object2 = DRSPlatformHelper.getObject(byArray);
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.drs.ws390.externaldatastore.DRSExternalHashMapImpl.doRemove", "386", this);
                Tr.error(tc, "drs.throwable.controller", new Object[]{string, throwable});
            }
        }
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doPutData(Object object, byte[] byArray) {
        String string = "DRSExternalHashmapImpl.doPutData/" + this.mapName + ": ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry - key = " + object);
        }
        boolean bl = false;
        Integer n = this.lock;
        synchronized (n) {
            try {
                DRSExternalDataStoreToken dRSExternalDataStoreToken = this.dataStore.putData(byArray);
                if (dRSExternalDataStoreToken != null) {
                    this.dataItems.put(object, dRSExternalDataStoreToken);
                    bl = true;
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.drs.ws390.externaldatastore.DRSExternalHashMapImpl.doPutData", "409", this);
                Tr.error(tc, "drs.throwable.controller", new Object[]{string, throwable});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Exit - rc = " + bl);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] doGetData(Object object) {
        String string = "DRSExternalHashmapImpl.doGetData/" + this.mapName + ": ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry - key = " + object);
        }
        byte[] byArray = null;
        Integer n = this.lock;
        synchronized (n) {
            if (this.dataItems.containsKey(object)) {
                try {
                    DRSExternalDataStoreToken dRSExternalDataStoreToken = (DRSExternalDataStoreToken)this.dataItems.get(object);
                    byArray = this.dataStore.getData(dRSExternalDataStoreToken);
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ws.drs.ws390.externaldatastore.DRSExternalHashMapImpl.doGetData", "437", this);
                    Tr.error(tc, "drs.throwable.controller", new Object[]{string, throwable});
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Exit.");
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDeleteData(String string) {
        String string2 = "DRSExternalHashmapImpl.doDeleteData/" + this.mapName + ": ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string2 + "Entry - key = " + string);
        }
        Integer n = this.lock;
        synchronized (n) {
            try {
                DRSExternalDataStoreToken dRSExternalDataStoreToken = (DRSExternalDataStoreToken)this.dataItems.remove(string);
                this.dataStore.deleteData(dRSExternalDataStoreToken);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.drs.ws390.externaldatastore.DRSExternalHashMapImpl.doDeleteData", "466", this);
                Tr.error(tc, "drs.throwable.controller", new Object[]{string2, throwable});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string2 + "Exit.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] doRemoveData(Object object) {
        String string = "DRSExternalHashmapImpl.doRemoveData/" + this.mapName + ": ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry");
        }
        byte[] byArray = null;
        Integer n = this.lock;
        synchronized (n) {
            try {
                DRSExternalDataStoreToken dRSExternalDataStoreToken = (DRSExternalDataStoreToken)this.dataItems.remove(object);
                if (dRSExternalDataStoreToken != null) {
                    byArray = this.dataStore.removeData(dRSExternalDataStoreToken);
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.drs.ws390.externaldatastore.DRSExternalHashMapImpl.doRemoveData", "494", this);
                Tr.error(tc, "drs.throwable.controller", new Object[]{string, throwable});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Exit.");
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDeleteAll() {
        String string = "DRSExternalHashmapImpl.doDeleteAll/" + this.mapName + ": ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry.");
        }
        Integer n = this.lock;
        synchronized (n) {
            try {
                Set set = this.dataItems.keySet();
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    Object k = iterator.next();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, string + "Deleting key = " + k);
                    }
                    DRSExternalDataStoreToken dRSExternalDataStoreToken = (DRSExternalDataStoreToken)this.dataItems.get(k);
                    this.dataStore.deleteData(dRSExternalDataStoreToken);
                }
                this.dataItems.clear();
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.drs.ws390.externaldatastore.DRSExternalHashMapImpl.doDeleteAll", "535", this);
                Tr.error(tc, "drs.throwable.controller", new Object[]{string, throwable});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Exit.");
        }
    }
}

