/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.drs.ws390.externaldatastore;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.drs.ws390.externaldatastore.DRSNativeExternalDataStore;
import com.ibm.ws.ffdc.FFDCFilter;

public class DRSNativeExternalDataStoreImpl
implements DRSNativeExternalDataStore {
    private static TraceComponent tc = Tr.register(DRSNativeExternalDataStoreImpl.class.getName(), "DRS", "com.ibm.ws.drs.resources.drs");
    private static boolean _loggedVersion = false;
    private Integer lock;
    private long currentDataTotal;
    private long dataInTotal;
    private long dataInTotalWrapped;
    private long dataOutTotal;
    private long dataOutTotalWrapped;
    private long putTotal;
    private long getTotal;
    private long removeTotal;
    private long putWrapped;
    private long getWrapped;
    private long removeWrapped;
    private int create_rc;
    private boolean created;

    public DRSNativeExternalDataStoreImpl() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DRSNativeExternalDataStoreImpl:constructor: Entry.");
        }
        if (tc.isDebugEnabled() && !_loggedVersion) {
            Tr.debug(tc, "DRSNativeExternalDataStoreImpl:constructor: Version 1.5 2/25/05 09:43:35");
            _loggedVersion = true;
        }
        this.dataInTotal = 0L;
        this.dataOutTotal = 0L;
        this.currentDataTotal = 0L;
        this.putWrapped = 0L;
        this.getWrapped = 0L;
        this.removeWrapped = 0L;
        this.lock = new Integer(99);
        this.created = false;
        try {
            this.create_rc = this.nativeCreate();
            if (this.create_rc == 0) {
                this.created = true;
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.drs.ws390.externaldatastore.DRSNativeExternalDataStoreImpl:constructor", "100", this);
            Tr.error(tc, "drs.throwable.controller", new Object[]{"DRSNativeExternalDataStoreImpl:constructor: ", throwable});
            this.created = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DRSNativeExternalDataStoreImpl:constructor: Exit.");
        }
    }

    public long putData(byte[] byArray, int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DRSNativeExternalDataStoreImpl:putData: Entry.");
        }
        long l = -1L;
        if (byArray == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "DRSNativeExternalDataStoreImpl:putData: Buffer parameter is null");
            }
        } else if (byArray.length < 1) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "DRSNativeExternalDataStoreImpl:putData: Buffer length is 0");
            }
        } else if (n < 1) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "DRSNativeExternalDataStoreImpl:putData: Data length is 0");
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "DRSNativeExternalDataStoreImpl:putData: Put length = " + n);
            }
            l = this.doPutData(byArray, n);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DRSNativeExternalDataStoreImpl:putData: Exit - rc = " + l);
        }
        return l;
    }

    public int getData(long l, byte[] byArray, int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DRSNativeExternalDataStoreImpl:getData: Entry.");
        }
        int n2 = 0;
        if (byArray == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "DRSNativeExternalDataStoreImpl:getData: Buffer parameter is null");
            }
        } else if (byArray.length < 1) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "DRSNativeExternalDataStoreImpl:getData: Invalid Buffer length = " + byArray.length);
            }
        } else if (n < 1) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "DRSNativeExternalDataStoreImpl:getData: Invalid data length = " + n);
            }
        } else if (l < 1L) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "DRSNativeExternalDataStoreImpl:getData: Invalid token = " + l);
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "DRSNativeExternalDataStoreImpl:getData: Get length = " + n);
            }
            n2 = this.doGetData(l, byArray, n);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DRSNativeExternalDataStoreImpl:getData: Exit - rc = " + n2);
        }
        return n2;
    }

    public int deleteData(long l, int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DRSNativeExternalDataStoreImpl:deleteData: Entry.");
        }
        int n2 = 0;
        if (l < 1L) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "DRSNativeExternalDataStoreImpl:deleteData: Invalid token = " + l);
            }
        } else if (n < 1) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "DRSNativeExternalDataStoreImpl:deleteData: Invalid length = " + n);
            }
        } else {
            n2 = this.doRemoveData(l, n);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DRSNativeExternalDataStoreImpl:deleteData: Exit - rc = " + n2);
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long doPutData(byte[] byArray, int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DRSNativeExternalDataStoreImpl:doPutData: Entry.");
        }
        long l = 0L;
        Integer n2 = this.lock;
        synchronized (n2) {
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "DRSNativeExternalDataStoreImpl:doPutData: About to call nativePutData");
                }
                l = this.nativePutData(byArray, n);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "DRSNativeExternalDataStoreImpl:doPutData: Back from nativePutData : rc = " + l);
                }
                if (l != 0L) {
                    this.incrementDataInTotal(n);
                    this.incrementCurrentDataTotal(n);
                    ++this.putTotal;
                    if (this.putTotal < 0L) {
                        this.putTotal = 1L;
                        ++this.putWrapped;
                        if (this.putWrapped < 0L) {
                            this.putWrapped = 1L;
                        }
                    }
                } else {
                    Tr.error(tc, "drs.externaldatastore.native.error", new Object[]{"DRSNativeExternalDataStoreImpl:doPutData: ", new Long(l)});
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.drs.ws390.externaldatastore.DRSNativeExternalDataStoreImpl.doPutData", "233", this);
                Tr.error(tc, "drs.throwable.controller", new Object[]{"DRSNativeExternalDataStoreImpl:doPutData: ", throwable});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DRSNativeExternalDataStoreImpl:doPutData: Exit - rc = " + l);
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doGetData(long l, byte[] byArray, int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DRSNativeExternalDataStoreImpl:doGetData: Entry.");
        }
        int n2 = 0;
        Integer n3 = this.lock;
        synchronized (n3) {
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "DRSNativeExternalDataStoreImpl:doGetData: About to call nativeGetData: token = " + l);
                }
                if ((n2 = this.nativeGetData(l, n, byArray)) != 0) {
                    Tr.error(tc, "drs.externaldatastore.native.error", new Object[]{"DRSNativeExternalDataStoreImpl:doGetData: ", new Integer(n2)});
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "DRSNativeExternalDataStoreImpl:doGetData: Back from nativeGetData: token = " + l + " rc = " + n2);
                }
                ++this.getTotal;
                if (this.getTotal < 0L) {
                    this.getTotal = 1L;
                    ++this.getWrapped;
                    if (this.getWrapped < 0L) {
                        this.getWrapped = 1L;
                    }
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.drs.ws390.externaldatastore.DRSNativeExternalDataStoreImpl.doGetData", "270", this);
                Tr.error(tc, "drs.throwable.controller", new Object[]{"DRSNativeExternalDataStoreImpl:doGetData: ", throwable});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DRSNativeExternalDataStoreImpl:doGetData: Exit - rc = " + n2);
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doRemoveData(long l, int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DRSNativeExternalDataStoreImpl:doRemoveData: Entry.");
        }
        int n2 = 0;
        Integer n3 = this.lock;
        synchronized (n3) {
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "DRSNativeExternalDataStoreImpl:doRemoveData: About to call removeGetData : token = " + l + " len = " + n);
                }
                if ((n2 = this.nativeRemoveData(l, n)) != 0) {
                    Tr.error(tc, "drs.externaldatastore.native.error", new Object[]{"DRSNativeExternalDataStoreImpl:doRemoveData: ", new Integer(n2)});
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "DRSNativeExternalDataStoreImpl:doRemoveData: Back from removeGetData : token = " + l + " rc = " + n2);
                }
                this.decrementCurrentDataTotal(n);
                ++this.removeTotal;
                if (this.removeTotal < 0L) {
                    this.removeTotal = 1L;
                    ++this.removeWrapped;
                    if (this.removeWrapped < 0L) {
                        this.removeWrapped = 1L;
                    }
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.drs.ws390.externaldatastore.DRSNativeExternalDataStoreImpl.doRemoveData", "310", this);
                Tr.error(tc, "drs.throwable.controller", new Object[]{"DRSNativeExternalDataStoreImpl:doRemoveData: ", throwable});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DRSNativeExternalDataStoreImpl:doRemoveData: Exit - rc = " + n2);
        }
        return n2;
    }

    public String getStats() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DRSNativeExternalDataStoreImpl:getStats: Entry.");
        }
        String string = "DataSpace_created=" + this.created + "CurrentTotalData=" + this.currentDataTotal + "TotalDataIn=" + this.dataInTotal + "TotalDataInWrapped=" + this.dataInTotalWrapped + "TotalDataOut=" + this.dataOutTotal + "TotalDataOutWrapped=" + this.dataOutTotalWrapped + "NumberOfPuts=" + this.putTotal + "NumberOfPutsWrapped=" + this.putWrapped + "NumberOfGets=" + this.getTotal + "NumberOfGetsWrapped=" + this.getWrapped + "NumberOfRemoves=" + this.removeTotal + "NumberOfRemovesWrapped=" + this.removeWrapped;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DRSNativeExternalDataStoreImpl:getStats: Exit");
        }
        return string;
    }

    private void incrementDataInTotal(int n) {
        long l = n;
        if (this.dataInTotal + l < 0L) {
            ++this.dataInTotalWrapped;
            long l2 = Long.MAX_VALUE - this.dataInTotal;
            this.dataInTotal = (long)n - l2;
        } else {
            this.dataInTotal += (long)n;
        }
    }

    private void incrementCurrentDataTotal(int n) {
        long l = n;
        this.currentDataTotal += l;
        if (this.currentDataTotal < 0L) {
            this.currentDataTotal = Long.MAX_VALUE;
        }
    }

    private void decrementCurrentDataTotal(int n) {
        long l = n;
        this.currentDataTotal -= l;
        if (this.currentDataTotal < 0L) {
            this.currentDataTotal = 0L;
        }
    }

    private native long nativePutData(byte[] var1, int var2);

    private native int nativeGetData(long var1, int var3, byte[] var4);

    private native int nativeRemoveData(long var1, int var3);

    private native int nativeCreate();
}

