/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.drs.ws390.proxy.controller;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.drs.ws390.DRSControllerInstanceFactoryImpl;
import com.ibm.ws.drs.ws390.DRSInstanceConfig;
import com.ibm.ws.drs.ws390.DRSInstanceTokenImpl;
import com.ibm.ws.drs.ws390.DRSPlatformHelper;
import com.ibm.ws.drs.ws390.DRSSettingsWrapper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.cluster.ClusterServiceFactory;
import com.ibm.wsspi.cluster.Identity;
import com.ibm.wsspi.drs.DRSBootstrapMsg;
import com.ibm.wsspi.drs.DRSControllerDataXfer;
import com.ibm.wsspi.drs.DRSInstanceToken;
import com.ibm.wsspi.drs.DRSJvmId;
import com.ibm.wsspi.drs.exception.DRSCongestedException;
import com.ibm.wsspi.drs.exception.DRSNotReadyException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Map;

public class DRSControllerProxyHelper {
    private static DRSControllerProxyHelper helper = null;
    private static Integer factoryLock = new Integer(99);
    private static TraceComponent tc = Tr.register(DRSControllerProxyHelper.class.getName(), "DRS", "com.ibm.ws.drs.resources.drs");
    private static boolean _loggedVersion = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DRSControllerProxyHelper createInstance() {
        Integer n = factoryLock;
        synchronized (n) {
            if (helper == null) {
                helper = new DRSControllerProxyHelper();
            }
        }
        return helper;
    }

    public static DRSControllerProxyHelper getInstance() {
        return helper;
    }

    public DRSControllerProxyHelper() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DRSControllerProxyHelper.constructor: Entry.");
        }
        if (tc.isDebugEnabled() && !_loggedVersion) {
            Tr.debug(tc, "DRSControllerProxyHelper.constructor: Version 1.9 4/21/06 10:02:21");
            _loggedVersion = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DRSControllerProxyHelper.constructor: Exit.");
        }
    }

    public String getId() {
        return DRSPlatformHelper.getDRSControllerProxyId();
    }

    public void init() {
    }

    public DRSInstanceTokenImpl registerServant(DRSInstanceTokenImpl dRSInstanceTokenImpl) {
        return DRSControllerInstanceFactoryImpl.getInstance().registerServant(dRSInstanceTokenImpl);
    }

    public DRSInstanceTokenImpl confirmServantRegistration(DRSInstanceTokenImpl dRSInstanceTokenImpl) {
        return DRSControllerInstanceFactoryImpl.getInstance().confirmServantRegistration(dRSInstanceTokenImpl);
    }

    public void unregisterServant(DRSInstanceTokenImpl dRSInstanceTokenImpl) {
        DRSControllerInstanceFactoryImpl.getInstance().unregisterServant(dRSInstanceTokenImpl);
    }

    public DRSInstanceToken createDRSInstance(DRSInstanceToken dRSInstanceToken, String string, DRSSettingsWrapper dRSSettingsWrapper, Map map, DRSInstanceConfig dRSInstanceConfig) throws RemoteException {
        DRSInstanceToken dRSInstanceToken2 = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DRSControllerProxyHelper.createDRSInstance: Entry.");
        }
        try {
            dRSInstanceToken2 = DRSControllerInstanceFactoryImpl.getInstance().createZOSControllerDRSInstance(dRSInstanceToken, string, dRSSettingsWrapper, map, dRSInstanceConfig);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.drs.ws390.proxy.controller.DRSControllerProxyHelper.createDRSInstance", "176", this);
            Tr.error(tc, "drs.throwable.controller", new Object[]{"DRSControllerProxyHelper.createDRSInstance: ", throwable});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DRSControllerProxyHelper.createDRSInstance: Exit");
        }
        return dRSInstanceToken2;
    }

    public void createEntry(DRSInstanceToken dRSInstanceToken, Object object, Object object2) throws RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DRSControllerProxyHelper.createEntry: Entry.");
        }
        try {
            DRSControllerInstanceFactoryImpl dRSControllerInstanceFactoryImpl = DRSControllerInstanceFactoryImpl.getInstance();
            DRSControllerDataXfer dRSControllerDataXfer = dRSControllerInstanceFactoryImpl.getDRSControllerDataXfer(dRSInstanceToken);
            dRSControllerDataXfer.createEntry(dRSInstanceToken, object, object2);
        }
        catch (DRSCongestedException dRSCongestedException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "DRSControllerProxyHelper.createEntry: Exit - throwing RemoteException(DRSCongestedException)");
            }
            throw new RemoteException("DRSCongestedException", dRSCongestedException);
        }
        catch (DRSNotReadyException dRSNotReadyException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "DRSControllerProxyHelper.createEntry: Exit - throwing RemoteException(DRSNotReadyException)");
            }
            throw new RemoteException("DRSNotReadyException", dRSNotReadyException);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.drs.ws390.proxy.controller.DRSControllerProxyHelper.createEntry", "209", this);
            Tr.error(tc, "drs.throwable.controller", new Object[]{"DRSControllerProxyHelper.createEntry: ", throwable});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DRSControllerProxyHelper.createEntry: Exit");
        }
    }

    public void createEntryProp(DRSInstanceToken dRSInstanceToken, Object object, Object object2, Object object3) throws RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DRSControllerProxyHelper.createEntryProp: Entry.");
        }
        try {
            DRSControllerInstanceFactoryImpl dRSControllerInstanceFactoryImpl = DRSControllerInstanceFactoryImpl.getInstance();
            DRSControllerDataXfer dRSControllerDataXfer = dRSControllerInstanceFactoryImpl.getDRSControllerDataXfer(dRSInstanceToken);
            dRSControllerDataXfer.createEntryProp(dRSInstanceToken, object, object2, object3);
        }
        catch (DRSCongestedException dRSCongestedException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "DRSControllerProxyHelper.createEntryProp: Exit - throwing RemoteException(DRSCongestedException)");
            }
            throw new RemoteException("DRSCongestedException", dRSCongestedException);
        }
        catch (DRSNotReadyException dRSNotReadyException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "DRSControllerProxyHelper.createEntryProp: Exit - throwing RemoteException(DRSNotReadyException)");
            }
            throw new RemoteException("DRSNotReadyException", dRSNotReadyException);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.drs.ws390.proxy.controller.DRSControllerProxyHelper.createEntryProp", "239", this);
            Tr.error(tc, "drs.throwable.controller", new Object[]{"DRSControllerProxyHelper.createEntryProp: ", throwable});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DRSControllerProxyHelper.createEntryProp: Exit");
        }
    }

    public void updateEntry(DRSInstanceToken dRSInstanceToken, Object object, Object object2) throws RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DRSControllerProxyHelper.updateEntry: Entry.");
        }
        try {
            DRSControllerInstanceFactoryImpl dRSControllerInstanceFactoryImpl = DRSControllerInstanceFactoryImpl.getInstance();
            DRSControllerDataXfer dRSControllerDataXfer = dRSControllerInstanceFactoryImpl.getDRSControllerDataXfer(dRSInstanceToken);
            dRSControllerDataXfer.updateEntry(dRSInstanceToken, object, object2);
        }
        catch (DRSCongestedException dRSCongestedException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "DRSControllerProxyHelper.updateEntry: Exit - throwing RemoteException(DRSCongestedException)");
            }
            throw new RemoteException("DRSCongestedException", dRSCongestedException);
        }
        catch (DRSNotReadyException dRSNotReadyException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "DRSControllerProxyHelper.updateEntry: Exit - throwing RemoteException(DRSNotReadyException)");
            }
            throw new RemoteException("DRSNotReadyException", dRSNotReadyException);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.drs.ws390.proxy.controller.DRSControllerProxyHelper.updateEntry", "269", this);
            Tr.error(tc, "drs.throwable.controller", new Object[]{"DRSControllerProxyHelper.updateEntry: ", throwable});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DRSControllerProxyHelper.updateEntry: Exit");
        }
    }

    public void updateEntryProp(DRSInstanceToken dRSInstanceToken, Object object, Object object2, Object object3) throws RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DRSControllerProxyHelper.updateEntryProp: Entry.");
        }
        try {
            DRSControllerInstanceFactoryImpl dRSControllerInstanceFactoryImpl = DRSControllerInstanceFactoryImpl.getInstance();
            DRSControllerDataXfer dRSControllerDataXfer = dRSControllerInstanceFactoryImpl.getDRSControllerDataXfer(dRSInstanceToken);
            dRSControllerDataXfer.updateEntryProp(dRSInstanceToken, object, object2, object3);
        }
        catch (DRSCongestedException dRSCongestedException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "DRSControllerProxyHelper.updateEntryProp: Exit - throwing RemoteException(DRSCongestedException)");
            }
            throw new RemoteException("DRSCongestedException", dRSCongestedException);
        }
        catch (DRSNotReadyException dRSNotReadyException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "DRSControllerProxyHelper.updateEntryProp: Exit - throwing RemoteException(DRSNotReadyException)");
            }
            throw new RemoteException("DRSNotReadyException", dRSNotReadyException);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.drs.ws390.proxy.controller.DRSControllerProxyHelper.updateEntryProp", "299", this);
            Tr.error(tc, "drs.throwable.controller", new Object[]{"DRSControllerProxyHelper.updateEntryProp: ", throwable});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DRSControllerProxyHelper.updateEntryProp: Exit");
        }
    }

    public Object getEntry(DRSInstanceToken dRSInstanceToken, Object object) throws RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DRSControllerProxyHelper.getEntry: Entry.");
        }
        Object object2 = null;
        try {
            DRSControllerInstanceFactoryImpl dRSControllerInstanceFactoryImpl = DRSControllerInstanceFactoryImpl.getInstance();
            DRSControllerDataXfer dRSControllerDataXfer = dRSControllerInstanceFactoryImpl.getDRSControllerDataXfer(dRSInstanceToken);
            object2 = dRSControllerDataXfer.getEntry(dRSInstanceToken, object);
        }
        catch (DRSCongestedException dRSCongestedException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "DRSControllerProxyHelper.getEntry: Exit - throwing RemoteException(DRSCongestedException)");
            }
            throw new RemoteException("DRSCongestedException", dRSCongestedException);
        }
        catch (DRSNotReadyException dRSNotReadyException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "DRSControllerProxyHelper.getEntry: Exit - throwing RemoteException(DRSNotReadyException)");
            }
            throw new RemoteException("DRSNotReadyException", dRSNotReadyException);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.drs.ws390.proxy.controller.DRSControllerProxyHelper.getEntry", "330", this);
            Tr.error(tc, "drs.throwable.controller", new Object[]{"DRSControllerProxyHelper.getEntry: ", throwable});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DRSControllerProxyHelper.getEntry: Exit - rc = " + (object2 == null ? "null" : "not null"));
        }
        return object2;
    }

    public Object getEntry(DRSInstanceToken dRSInstanceToken, Object object, DRSJvmId dRSJvmId) throws RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DRSControllerProxyHelper.getEntry(with JvmId): Entry.");
        }
        Object object2 = null;
        try {
            DRSControllerInstanceFactoryImpl dRSControllerInstanceFactoryImpl = DRSControllerInstanceFactoryImpl.getInstance();
            DRSControllerDataXfer dRSControllerDataXfer = dRSControllerInstanceFactoryImpl.getDRSControllerDataXfer(dRSInstanceToken);
            object2 = dRSControllerDataXfer.getEntry(dRSInstanceToken, object, dRSJvmId);
        }
        catch (DRSCongestedException dRSCongestedException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "DRSControllerProxyHelper.getEntry(with JvmId): Exit - throwing RemoteException(DRSCongestedException)");
            }
            throw new RemoteException("DRSCongestedException", dRSCongestedException);
        }
        catch (DRSNotReadyException dRSNotReadyException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "DRSControllerProxyHelper.getEntry(with JvmId): Exit - throwing RemoteException(DRSNotReadyException)");
            }
            throw new RemoteException("DRSNotReadyException", dRSNotReadyException);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.drs.ws390.proxy.controller.DRSControllerProxyHelper.getEntry", "362", this);
            Tr.error(tc, "drs.throwable.controller", new Object[]{"DRSControllerProxyHelper.getEntry(with JvmId): ", throwable});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DRSControllerProxyHelper.getEntry(with JvmId): Exit - rc = " + (object2 == null ? "null" : "not null"));
        }
        return object2;
    }

    public Object getEntryProp(DRSInstanceToken dRSInstanceToken, Object object, Object object2) throws RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DRSControllerProxyHelper.getEntryProp: Entry.");
        }
        Object object3 = null;
        try {
            DRSControllerInstanceFactoryImpl dRSControllerInstanceFactoryImpl = DRSControllerInstanceFactoryImpl.getInstance();
            DRSControllerDataXfer dRSControllerDataXfer = dRSControllerInstanceFactoryImpl.getDRSControllerDataXfer(dRSInstanceToken);
            object3 = dRSControllerDataXfer.getEntryProp(dRSInstanceToken, object, object2);
        }
        catch (DRSCongestedException dRSCongestedException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "DRSControllerProxyHelper.getEntryProp: Exit - throwing RemoteException(DRSCongestedException)");
            }
            throw new RemoteException("DRSCongestedException", dRSCongestedException);
        }
        catch (DRSNotReadyException dRSNotReadyException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "DRSControllerProxyHelper.getEntryProp: Exit - throwing RemoteException(DRSNotReadyException)");
            }
            throw new RemoteException("DRSNotReadyException", dRSNotReadyException);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.drs.ws390.proxy.controller.DRSControllerProxyHelper.getEntryProp", "395", this);
            Tr.error(tc, "drs.throwable.controller", new Object[]{"DRSControllerProxyHelper.getEntryProp: ", throwable});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DRSControllerProxyHelper.getEntryProp: Exit - rc = " + (object3 == null ? "null" : "not null"));
        }
        return object3;
    }

    public void removeEntry(DRSInstanceToken dRSInstanceToken, Object object) throws RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DRSControllerProxyHelper.removeEntry: Entry.");
        }
        try {
            DRSControllerInstanceFactoryImpl dRSControllerInstanceFactoryImpl = DRSControllerInstanceFactoryImpl.getInstance();
            DRSControllerDataXfer dRSControllerDataXfer = dRSControllerInstanceFactoryImpl.getDRSControllerDataXfer(dRSInstanceToken);
            dRSControllerDataXfer.removeEntry(dRSInstanceToken, object);
        }
        catch (DRSCongestedException dRSCongestedException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "DRSControllerProxyHelper.removeEntry: Exit - throwing RemoteException(DRSCongestedException)");
            }
            throw new RemoteException("DRSCongestedException", dRSCongestedException);
        }
        catch (DRSNotReadyException dRSNotReadyException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "DRSControllerProxyHelper.removeEntry: Exit - throwing RemoteException(DRSNotReadyException)");
            }
            throw new RemoteException("DRSNotReadyException", dRSNotReadyException);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.drs.ws390.proxy.controller.DRSControllerProxyHelper.removeEntry", "426", this);
            Tr.error(tc, "drs.throwable.controller", new Object[]{"DRSControllerProxyHelper.removeEntry: ", throwable});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DRSControllerProxyHelper.removeEntry: Exit");
        }
    }

    public void removeLocalEntry(DRSInstanceToken dRSInstanceToken, Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DRSControllerProxyHelper.removeLocalEntry: Entry.");
        }
        try {
            DRSControllerInstanceFactoryImpl dRSControllerInstanceFactoryImpl = DRSControllerInstanceFactoryImpl.getInstance();
            DRSControllerDataXfer dRSControllerDataXfer = dRSControllerInstanceFactoryImpl.getDRSControllerDataXfer(dRSInstanceToken);
            dRSControllerDataXfer.removeLocalEntry(dRSInstanceToken, object);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.drs.ws390.proxy.controller.DRSControllerProxyHelper.removeEntry", "446", this);
            Tr.error(tc, "drs.throwable.controller", new Object[]{"DRSControllerProxyHelper.removeLocalEntry: ", throwable});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DRSControllerProxyHelper.removeLocalEntry: Exit");
        }
    }

    public void removeEntryProp(DRSInstanceToken dRSInstanceToken, Object object, Object object2, Object object3) throws RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DRSControllerProxyHelper.removeEntryProp: Entry.");
        }
        try {
            DRSControllerInstanceFactoryImpl dRSControllerInstanceFactoryImpl = DRSControllerInstanceFactoryImpl.getInstance();
            DRSControllerDataXfer dRSControllerDataXfer = dRSControllerInstanceFactoryImpl.getDRSControllerDataXfer(dRSInstanceToken);
            dRSControllerDataXfer.removeEntryProp(dRSInstanceToken, object, object2, object3);
        }
        catch (DRSCongestedException dRSCongestedException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "DRSControllerProxyHelper.removeEntryProp: Exit - throwing RemoteException(DRSCongestedException)");
            }
            throw new RemoteException("DRSCongestedException", dRSCongestedException);
        }
        catch (DRSNotReadyException dRSNotReadyException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "DRSControllerProxyHelper.removeEntryProp: Exit - throwing RemoteException(DRSNotReadyException)");
            }
            throw new RemoteException("DRSNotReadyException", dRSNotReadyException);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.drs.ws390.proxy.controller.DRSControllerProxyHelper.removeEntryProp", "456", this);
            Tr.error(tc, "drs.throwable.controller", new Object[]{"DRSControllerProxyHelper.removeEntryProp: ", throwable});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DRSControllerProxyHelper.removeEntryProp: Exit");
        }
    }

    public boolean entryIDExists(DRSInstanceToken dRSInstanceToken, Object object) throws RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DRSControllerProxyHelper.entryIDExists: Entry.");
        }
        boolean bl = false;
        try {
            DRSControllerInstanceFactoryImpl dRSControllerInstanceFactoryImpl = DRSControllerInstanceFactoryImpl.getInstance();
            DRSControllerDataXfer dRSControllerDataXfer = dRSControllerInstanceFactoryImpl.getDRSControllerDataXfer(dRSInstanceToken);
            bl = dRSControllerDataXfer.entryIDExists(dRSInstanceToken, object);
        }
        catch (DRSCongestedException dRSCongestedException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "DRSControllerProxyHelper.entryIDExists: Exit - throwing RemoteException(DRSCongestedException)");
            }
            throw new RemoteException("DRSCongestedException", dRSCongestedException);
        }
        catch (DRSNotReadyException dRSNotReadyException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "DRSControllerProxyHelper.entryIDExists: Exit - throwing RemoteException(DRSNotReadyException)");
            }
            throw new RemoteException("DRSNotReadyException", dRSNotReadyException);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.drs.ws390.proxy.controller.DRSControllerProxyHelper.entryIDExists", "487", this);
            Tr.error(tc, "drs.throwable.controller", new Object[]{"DRSControllerProxyHelper.entryIDExists: ", throwable});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DRSControllerProxyHelper.entryIDExists: Exit - rc = " + bl);
        }
        return bl;
    }

    public boolean entryIDExists(DRSInstanceToken dRSInstanceToken, Object object, boolean bl) throws RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DRSControllerProxyHelper.entryIDExists: Entry.");
        }
        boolean bl2 = false;
        try {
            DRSControllerInstanceFactoryImpl dRSControllerInstanceFactoryImpl = DRSControllerInstanceFactoryImpl.getInstance();
            DRSControllerDataXfer dRSControllerDataXfer = dRSControllerInstanceFactoryImpl.getDRSControllerDataXfer(dRSInstanceToken);
            bl2 = dRSControllerDataXfer.entryIDExists(dRSInstanceToken, object, bl);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.drs.ws390.proxy.controller.DRSControllerProxyHelper.entryIDExists", "509", this);
            Tr.error(tc, "drs.throwable.controller", new Object[]{"DRSControllerProxyHelper.entryIDExists: ", throwable});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DRSControllerProxyHelper.entryIDExists: Exit - rc = " + bl2);
        }
        return bl2;
    }

    public long getPartition(DRSInstanceToken dRSInstanceToken, Object object) throws RemoteException {
        long l = 0L;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DRSControllerProxyHelper.getPartition: Entry.");
        }
        try {
            DRSControllerInstanceFactoryImpl dRSControllerInstanceFactoryImpl = DRSControllerInstanceFactoryImpl.getInstance();
            DRSControllerDataXfer dRSControllerDataXfer = dRSControllerInstanceFactoryImpl.getDRSControllerDataXfer(dRSInstanceToken);
            l = dRSControllerDataXfer.getPartition(dRSInstanceToken, object);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.drs.ws390.proxy.controller.DRSControllerProxyHelper.getPartition", "535", this);
            Tr.error(tc, "drs.throwable.controller", new Object[]{"DRSControllerProxyHelper.getPartition: ", throwable});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DRSControllerProxyHelper.getPartition: Exit - rc = " + l);
        }
        return l;
    }

    public String getWLMIdentity(DRSInstanceToken dRSInstanceToken, Object object, boolean bl) throws RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DRSControllerProxyHelper.getWLMIdentity: Entry.");
        }
        String string = null;
        try {
            DRSControllerInstanceFactoryImpl dRSControllerInstanceFactoryImpl = DRSControllerInstanceFactoryImpl.getInstance();
            DRSControllerDataXfer dRSControllerDataXfer = dRSControllerInstanceFactoryImpl.getDRSControllerDataXfer(dRSInstanceToken);
            Identity identity = dRSControllerDataXfer.getWLMIdentity(dRSInstanceToken, object, bl);
            if (identity != null) {
                string = ClusterServiceFactory.getClusterService().identityToString(identity);
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.drs.ws390.proxy.controller.DRSControllerProxyHelper.getWLMIdentity", "557", this);
            Tr.error(tc, "drs.throwable.controller", new Object[]{"DRSControllerProxyHelper.getWLMIdentity: ", throwable});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DRSControllerProxyHelper.getWLMIdentity: Exit - rc = " + string);
        }
        return string;
    }

    public boolean shouldPull(DRSInstanceToken dRSInstanceToken, Object object) throws RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DRSControllerProxyHelper.shouldPull: Entry.");
        }
        boolean bl = false;
        try {
            DRSControllerInstanceFactoryImpl dRSControllerInstanceFactoryImpl = DRSControllerInstanceFactoryImpl.getInstance();
            DRSControllerDataXfer dRSControllerDataXfer = dRSControllerInstanceFactoryImpl.getDRSControllerDataXfer(dRSInstanceToken);
            bl = dRSControllerDataXfer.shouldPull(dRSInstanceToken, object);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.drs.ws390.proxy.controller.DRSControllerProxyHelper.shouldPull", "579", this);
            Tr.error(tc, "drs.throwable.controller", new Object[]{"DRSControllerProxyHelper.shouldPull: ", throwable});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DRSControllerProxyHelper.shouldPull: Exit - rc = " + bl);
        }
        return bl;
    }

    public void announceEntries(DRSInstanceToken dRSInstanceToken, ArrayList arrayList) throws RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DRSControllerProxyHelper.announceEntries: Entry.");
        }
        try {
            DRSControllerInstanceFactoryImpl dRSControllerInstanceFactoryImpl = DRSControllerInstanceFactoryImpl.getInstance();
            DRSControllerDataXfer dRSControllerDataXfer = dRSControllerInstanceFactoryImpl.getDRSControllerDataXfer(dRSInstanceToken);
            dRSControllerDataXfer.announceEntries(dRSInstanceToken, arrayList);
        }
        catch (DRSCongestedException dRSCongestedException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "DRSControllerProxyHelper.announceEntries: Exit - throwing RemoteException(DRSCongestedException)");
            }
            throw new RemoteException("DRSCongestedException", dRSCongestedException);
        }
        catch (DRSNotReadyException dRSNotReadyException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "DRSControllerProxyHelper.announceEntries: Exit - throwing RemoteException(DRSNotReadyException)");
            }
            throw new RemoteException("DRSNotReadyException", dRSNotReadyException);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.drs.ws390.proxy.controller.DRSControllerProxyHelper.announceEntries", "610", this);
            Tr.error(tc, "drs.throwable.controller", new Object[]{"DRSControllerProxyHelper.announceEntries: ", throwable});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DRSControllerProxyHelper.announceEntries: Exit");
        }
    }

    public DRSJvmId announceEntries(DRSInstanceToken dRSInstanceToken, ArrayList arrayList, String string) throws RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DRSControllerProxyHelper.announceEntries(with servant token): Entry.");
        }
        DRSJvmId dRSJvmId = null;
        try {
            DRSControllerInstanceFactoryImpl dRSControllerInstanceFactoryImpl = DRSControllerInstanceFactoryImpl.getInstance();
            DRSControllerDataXfer dRSControllerDataXfer = dRSControllerInstanceFactoryImpl.getDRSControllerDataXfer(dRSInstanceToken);
            dRSJvmId = dRSControllerDataXfer.announceEntries(dRSInstanceToken, arrayList, string);
        }
        catch (DRSCongestedException dRSCongestedException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "DRSControllerProxyHelper.announceEntries(with servant token): Exit - throwing RemoteException(DRSCongestedException)");
            }
            throw new RemoteException("DRSCongestedException", dRSCongestedException);
        }
        catch (DRSNotReadyException dRSNotReadyException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "DRSControllerProxyHelper.announceEntries(with servant token): Exit - throwing RemoteException(DRSNotReadyException)");
            }
            throw new RemoteException("DRSNotReadyException", dRSNotReadyException);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.drs.ws390.proxy.controller.DRSControllerProxyHelper.announceEntries", "642", this);
            Tr.error(tc, "drs.throwable.controller", new Object[]{"DRSControllerProxyHelper.announceEntries(with servant token): ", throwable});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DRSControllerProxyHelper.announceEntries(with servant token): Exit - rc = " + (dRSJvmId == null ? "null" : "not null"));
        }
        return dRSJvmId;
    }

    public void renounceEntries(DRSInstanceToken dRSInstanceToken, ArrayList arrayList) throws RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DRSControllerProxyHelper.renounceEntries: Entry.");
        }
        try {
            DRSControllerInstanceFactoryImpl dRSControllerInstanceFactoryImpl = DRSControllerInstanceFactoryImpl.getInstance();
            DRSControllerDataXfer dRSControllerDataXfer = dRSControllerInstanceFactoryImpl.getDRSControllerDataXfer(dRSInstanceToken);
            dRSControllerDataXfer.renounceEntries(dRSInstanceToken, arrayList);
        }
        catch (DRSCongestedException dRSCongestedException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "DRSControllerProxyHelper.renounceEntries: Exit - throwing RemoteException(DRSCongestedException)");
            }
            throw new RemoteException("DRSCongestedException", dRSCongestedException);
        }
        catch (DRSNotReadyException dRSNotReadyException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "DRSControllerProxyHelper.renounceEntries: Exit - throwing RemoteException(DRSNotReadyException)");
            }
            throw new RemoteException("DRSNotReadyException", dRSNotReadyException);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.drs.ws390.proxy.controller.DRSControllerProxyHelper.renounceEntries", "674", this);
            Tr.error(tc, "drs.throwable.controller", new Object[]{"DRSControllerProxyHelper.renounceEntries: ", throwable});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DRSControllerProxyHelper.renounceEntries: Exit");
        }
    }

    public void broadcast(DRSInstanceToken dRSInstanceToken, Object object) throws RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DRSControllerProxyHelper.broadcast: Entry.");
        }
        try {
            DRSControllerInstanceFactoryImpl dRSControllerInstanceFactoryImpl = DRSControllerInstanceFactoryImpl.getInstance();
            DRSControllerDataXfer dRSControllerDataXfer = dRSControllerInstanceFactoryImpl.getDRSControllerDataXfer(dRSInstanceToken);
            dRSControllerDataXfer.broadcast(dRSInstanceToken, object);
        }
        catch (DRSCongestedException dRSCongestedException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "DRSControllerProxyHelper.broadcast: Exit - throwing RemoteException(DRSCongestedException)");
            }
            throw new RemoteException("DRSCongestedException", dRSCongestedException);
        }
        catch (DRSNotReadyException dRSNotReadyException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "DRSControllerProxyHelper.broadcast: Exit - throwing RemoteException(DRSNotReadyException)");
            }
            throw new RemoteException("DRSNotReadyException", dRSNotReadyException);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.drs.ws390.proxy.controller.DRSControllerProxyHelper.broadcast", "704", this);
            Tr.error(tc, "drs.throwable.controller", new Object[]{"DRSControllerProxyHelper.broadcast: ", throwable});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DRSControllerProxyHelper.broadcast: Exit");
        }
    }

    public boolean isCongested(DRSInstanceToken dRSInstanceToken) throws RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DRSControllerProxyHelper.isCongested: Entry.");
        }
        boolean bl = false;
        try {
            DRSControllerInstanceFactoryImpl dRSControllerInstanceFactoryImpl = DRSControllerInstanceFactoryImpl.getInstance();
            DRSControllerDataXfer dRSControllerDataXfer = dRSControllerInstanceFactoryImpl.getDRSControllerDataXfer(dRSInstanceToken);
            bl = dRSControllerDataXfer.isCongested(dRSInstanceToken);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.drs.ws390.proxy.controller.DRSControllerProxyHelper.isCongested", "726", this);
            Tr.error(tc, "drs.throwable.controller", new Object[]{"DRSControllerProxyHelper.isCongested: ", throwable});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DRSControllerProxyHelper.isCongested: Exit - rc = " + bl);
        }
        return bl;
    }

    public boolean isReplicationUp(DRSInstanceToken dRSInstanceToken) throws RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DRSControllerProxyHelper.isReplicationUp: Entry.");
        }
        boolean bl = false;
        try {
            DRSControllerInstanceFactoryImpl dRSControllerInstanceFactoryImpl = DRSControllerInstanceFactoryImpl.getInstance();
            DRSControllerDataXfer dRSControllerDataXfer = dRSControllerInstanceFactoryImpl.getDRSControllerDataXfer(dRSInstanceToken);
            bl = dRSControllerDataXfer.isReplicationUp(dRSInstanceToken);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.drs.ws390.proxy.controller.DRSControllerProxyHelper.isReplicationUp", "748", this);
            Tr.error(tc, "drs.throwable.controller", new Object[]{"DRSControllerProxyHelper.isReplicationUp: ", throwable});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DRSControllerProxyHelper.isReplicationUp: Exit - rc = " + bl);
        }
        return bl;
    }

    public boolean isMyCopyCurrent(DRSInstanceToken dRSInstanceToken, Object object) throws RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DRSControllerProxyHelper.isMyCopyCurrent: Entry.");
        }
        boolean bl = false;
        try {
            DRSControllerInstanceFactoryImpl dRSControllerInstanceFactoryImpl = DRSControllerInstanceFactoryImpl.getInstance();
            DRSControllerDataXfer dRSControllerDataXfer = dRSControllerInstanceFactoryImpl.getDRSControllerDataXfer(dRSInstanceToken);
            bl = dRSControllerDataXfer.isMyCopyCurrent(dRSInstanceToken, object);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.drs.ws390.proxy.controller.DRSControllerProxyHelper.isMyCopyCurrent", "770", this);
            Tr.error(tc, "drs.throwable.controller", new Object[]{"DRSControllerProxyHelper.isMyCopyCurrent: ", throwable});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DRSControllerProxyHelper.isMyCopyCurrent: Exit - rc = " + bl);
        }
        return bl;
    }

    public void generateBootstrapResponse(DRSInstanceToken dRSInstanceToken, DRSBootstrapMsg dRSBootstrapMsg) throws RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DRSControllerProxyHelper.generateBootstrapResponse: Entry.");
        }
        try {
            DRSControllerInstanceFactoryImpl dRSControllerInstanceFactoryImpl = DRSControllerInstanceFactoryImpl.getInstance();
            DRSControllerDataXfer dRSControllerDataXfer = dRSControllerInstanceFactoryImpl.getDRSControllerDataXfer(dRSInstanceToken);
            dRSControllerDataXfer.generateBootstrapResponse(dRSInstanceToken, dRSBootstrapMsg);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.drs.ws390.proxy.controller.DRSControllerProxyHelper.generateBootstrapResponse", "794", this);
            Tr.error(tc, "drs.throwable.controller", new Object[]{"DRSControllerProxyHelper.generateBootstrapResponse: ", throwable});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DRSControllerProxyHelper.generateBootstrapResponse: Exit,");
        }
    }

    public void shutdownInstance(DRSInstanceToken dRSInstanceToken) throws RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DRSControllerProxyHelper.shutdownInstance: Entry.");
        }
        try {
            DRSControllerInstanceFactoryImpl dRSControllerInstanceFactoryImpl = DRSControllerInstanceFactoryImpl.getInstance();
            DRSControllerDataXfer dRSControllerDataXfer = dRSControllerInstanceFactoryImpl.getDRSControllerDataXfer(dRSInstanceToken);
            dRSControllerDataXfer.shutdownInstance(dRSInstanceToken);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.drs.ws390.proxy.controller.DRSControllerProxyHelper.shutdownInstance", "822", this);
            Tr.error(tc, "drs.throwable.controller", new Object[]{"DRSControllerProxyHelper.shutdownInstance: ", throwable});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DRSControllerProxyHelper.shutdownInstance: Exit");
        }
    }
}

