/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dwlm.client;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.dwlm.client.DWLMClientServiceContextImpl;
import com.ibm.ws.dwlm.client.RequestFlowInfoImpl;
import com.ibm.ws.dwlm.client.RequestMapperImpl;
import com.ibm.ws.dwlm.client.TargetSelectorImpl;
import com.ibm.ws.dwlm.client.mbean.DynamicRoute;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.odc.ODCPluginCfgGenerator;
import com.ibm.ws.odc.util.DoPrivUtil;
import com.ibm.wsspi.channel.framework.ChannelFramework;
import com.ibm.wsspi.channel.framework.ChannelFrameworkFactory;
import com.ibm.wsspi.dwlm.client.DWLMClient;
import com.ibm.wsspi.dwlm.client.DWLMClientServiceContext;
import com.ibm.wsspi.dwlm.client.RequestFlowInfo;
import com.ibm.wsspi.dwlm.client.RequestMapper;
import com.ibm.wsspi.dwlm.client.TargetDescriptor;
import com.ibm.wsspi.dwlm.client.TargetSelector;
import com.ibm.wsspi.http.channel.HttpRequestMessage;
import com.ibm.wsspi.odc.ODCHelper;
import com.ibm.wsspi.odc.ODCNode;
import com.ibm.wsspi.odc.ODCTransaction;
import com.ibm.wsspi.odc.ODCTree;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Vector;

public class DWLMClientImpl
implements DWLMClient,
ODCTransaction {
    public static final String[] PROPERTIES = new String[]{"client.register", "alias", "httpAffinityModules", "ODRPluginCfgAutoGenScope", "ODRPluginCfgChangeNotificationCommand"};
    public static final String DEFAULT_HTTP_AFFINITY_MODULES = "com.ibm.ws.http.wpf.HttpPartitionAffinityModule,com.ibm.ws.dwlm.client.HttpSessionAffinityModule";
    public static final String TC_GROUP = "DWLMClient";
    public static final String TC_MSGS = "com.ibm.ws.dwlm.client.nls.Messages";
    protected static final TraceComponent tc = Tr.register(DWLMClientImpl.class, "DWLMClient", "com.ibm.ws.dwlm.client.nls.Messages");
    protected static DWLMClientImpl instance = null;
    protected Properties props = new Properties();
    protected final ODCHelper odc;
    protected final ODCTree targetTree;
    protected RequestMapperImpl requestMapper = null;
    protected TargetSelectorImpl targetSelector = null;
    protected ODCPluginCfgGenerator pluginCfgGenerator = null;
    protected String clientRegister = null;
    protected String sslAlias = null;
    protected final String clientCell;
    protected final String clientNode;
    protected final String clientServer;
    protected String pluginCfgAutoGenScope = "none";
    protected String pluginCfgChangeNotificationCmd = null;
    protected final List rfiList = new ArrayList();
    protected final Vector dscList = new Vector();
    protected DynamicRoute routingMBean = null;
    protected boolean standalone;

    public DWLMClientImpl() throws Exception {
        this.clientCell = DoPrivUtil.getMyCellName();
        this.clientNode = DoPrivUtil.getMyNodeName();
        this.clientServer = DoPrivUtil.getMyServerName();
        this.standalone = AdminServiceFactory.getAdminService().getProcessType().equals("UnManagedProcess");
        this.odc = ODCHelper.getInstance();
        this.targetTree = this.odc.mgr.getTree("target", this.odc.cellGroup);
    }

    public boolean isEnabled() {
        return !this.standalone;
    }

    public void init(Properties properties) throws Exception {
        block11: {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "initializing properties");
            }
            for (int i = 0; i < PROPERTIES.length; ++i) {
                String string = PROPERTIES[i];
                String string2 = System.getProperty(string);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string + "=" + string2);
                }
                if (string2 != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "system property: " + string + "=" + string2);
                    }
                    this.props.setProperty(string, string2);
                    continue;
                }
                if (properties == null || (string2 = properties.getProperty(string)) == null) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "parameter property: " + string + "=" + string2);
                }
                this.props.setProperty(string, string2);
            }
            this.clientRegister = this.getProperty("client.register", "false");
            this.sslAlias = DoPrivUtil.getSSLProperties().getProperty("com.ibm.ssl.alias");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "sslAlias=" + this.sslAlias);
            }
            this.pluginCfgAutoGenScope = this.getProperty("ODRPluginCfgAutoGenScope", "none");
            this.pluginCfgChangeNotificationCmd = this.getProperty("ODRPluginCfgChangeNotificationCommand", null);
            this.initPluginCfgAutoGen();
            if (this.clientRegister.equalsIgnoreCase("true")) {
                ODCTree oDCTree = this.odc.mgr.getTree("proxy", this.odc.cellGroup);
                oDCTree.performTransaction(this, oDCTree);
            }
            if (this.routingMBean == null) {
                this.routingMBean = new DynamicRoute();
                try {
                    this.routingMBean.initialize();
                }
                catch (Exception exception) {
                    if (!tc.isDebugEnabled()) break block11;
                    Tr.debug(tc, "DynamicRoute could not be registered due to failures.");
                }
            }
        }
    }

    public void performODCTransaction(Object object) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "performODCTransaction");
        }
        ODCTree oDCTree = (ODCTree)object;
        String string = this.clientCell + "_" + this.clientNode + "_" + this.clientServer;
        ODCNode oDCNode = oDCTree.createNode(string, this.odc.proxy, oDCTree.getRoot());
        oDCNode.setProperty(this.odc.proxyCellName, (Object)this.clientCell);
        oDCNode.setProperty(this.odc.proxyNodeName, (Object)this.clientNode);
        oDCNode.setProperty(this.odc.proxyServerName, (Object)this.clientServer);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "performODCTransaction");
        }
    }

    public TargetDescriptor mapRequestToTarget(HttpRequestMessage httpRequestMessage, int n) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "mapRequestToTarget", httpRequestMessage);
        }
        ODCNode oDCNode = this.requestMapper.mapRequestToODCNode(httpRequestMessage, n);
        TargetDescriptor targetDescriptor = null;
        if (oDCNode != null) {
            targetDescriptor = this.targetSelector.select(oDCNode, httpRequestMessage);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "mapRequestToTarget", targetDescriptor);
        }
        return targetDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RequestMapper getRequestMapper() throws Exception {
        ODCTree oDCTree = this.targetTree;
        synchronized (oDCTree) {
            if (this.requestMapper == null) {
                this.requestMapper = this.createRequestMapper(this.targetTree);
            }
            return this.requestMapper;
        }
    }

    public synchronized TargetSelector getTargetSelector() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTargetSelector", this);
        }
        if (this.targetSelector == null) {
            if (tc.isDebugEnabled()) {
                Tr.exit(tc, "creating TargetSelector");
            }
            ChannelFramework channelFramework = ChannelFrameworkFactory.getChannelFramework();
            this.targetSelector = this.createTargetSelector(this.getTargetTree(), this.getMyOutboundSSLProps(), channelFramework);
            this.targetSelector.start(this.props.getProperty("httpAffinityModules", DEFAULT_HTTP_AFFINITY_MODULES));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTargetSelector", this.targetSelector);
        }
        return this.targetSelector;
    }

    public ODCTree getTargetTree() {
        return this.targetTree;
    }

    protected RequestMapperImpl createRequestMapper(ODCTree oDCTree) throws Exception {
        return new RequestMapperImpl(oDCTree);
    }

    protected TargetSelectorImpl createTargetSelector(ODCTree oDCTree, Properties properties, ChannelFramework channelFramework) throws Exception {
        return new TargetSelectorImpl(oDCTree, properties, channelFramework);
    }

    protected void initPluginCfgAutoGen() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initPluginCfgAutoGen");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "ODRPluginCfgAutoGenScope=" + this.pluginCfgAutoGenScope);
            Tr.debug(tc, "ODRPluginCfgChangeNotificationCommand=" + this.pluginCfgChangeNotificationCmd);
        }
        if (this.pluginCfgAutoGenScope.equalsIgnoreCase("none")) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "initPluginCfgAutoGen", "disabled");
            }
            return;
        }
        if (this.pluginCfgGenerator != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "initPluginCfgAutoGen", "already started");
            }
            return;
        }
        String string = null;
        String string2 = null;
        String string3 = null;
        if (!this.pluginCfgAutoGenScope.equalsIgnoreCase("all")) {
            if (this.pluginCfgAutoGenScope.equalsIgnoreCase("cell")) {
                string = this.clientCell;
            } else if (this.pluginCfgAutoGenScope.equalsIgnoreCase("node")) {
                string = this.clientCell;
                string2 = this.clientNode;
            } else if (this.pluginCfgAutoGenScope.equalsIgnoreCase("server")) {
                string = this.clientCell;
                string2 = this.clientNode;
                string3 = this.clientServer;
            } else {
                throw new ComponentDisabledException("invalid value for ODRPluginCfgAutoGenScope: '" + this.pluginCfgAutoGenScope + "'; must be one of: all, cell, node, server, or none");
            }
        }
        this.pluginCfgGenerator = new ODCPluginCfgGenerator(this.getTargetTree(), string, string2, string3);
        this.pluginCfgGenerator.setNotificationCommand(this.pluginCfgChangeNotificationCmd);
        this.pluginCfgGenerator.start();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initPluginCfgAutoGen", "started");
        }
    }

    protected Properties getMyOutboundSSLProps() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMyOutboundSSLProps");
        }
        Properties properties = DoPrivUtil.getSSLProperties();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMyOutboundSSLProps", properties);
        }
        return properties;
    }

    protected String getProperty(String string, String string2) {
        String string3;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getProperty", new Object[]{string, string2});
        }
        if ((string3 = this.props.getProperty(string)) == null || string3.length() == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "using default");
            }
            string3 = string2;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getProperty", string3);
        }
        return string3;
    }

    public RequestFlowInfo createRequestFlowInfo() {
        return this.obtainRequestFlowInfo();
    }

    public synchronized RequestFlowInfo obtainRequestFlowInfo() {
        int n = this.rfiList.size();
        if (n > 0) {
            return (RequestFlowInfo)this.rfiList.remove(n - 1);
        }
        return new RequestFlowInfoImpl(this);
    }

    public synchronized void releaseRequestFlowInfo(RequestFlowInfo requestFlowInfo) {
        if (this.rfiList.size() < 100) {
            this.rfiList.add(requestFlowInfo);
        }
    }

    public DWLMClientServiceContext createServiceContext() {
        return new DWLMClientServiceContextImpl(this);
    }

    public synchronized DWLMClientServiceContext obtainServiceContext() {
        DWLMClientServiceContext dWLMClientServiceContext;
        int n = this.dscList.size();
        if (n > 0 && !((DWLMClientServiceContextImpl)(dWLMClientServiceContext = (DWLMClientServiceContext)this.dscList.remove(n - 1))).isInUse()) {
            ((DWLMClientServiceContextImpl)dWLMClientServiceContext).setInUse(true);
            return dWLMClientServiceContext;
        }
        return this.createServiceContext();
    }

    public synchronized void releaseDWLMClientServiceContext(DWLMClientServiceContext dWLMClientServiceContext) throws Exception {
        if (this.dscList.size() < 100) {
            DWLMClientServiceContextImpl dWLMClientServiceContextImpl = (DWLMClientServiceContextImpl)dWLMClientServiceContext;
            if (dWLMClientServiceContextImpl.isInUse()) {
                dWLMClientServiceContextImpl.setInUse(false);
                this.dscList.add(dWLMClientServiceContext);
            } else {
                throw new Exception("Trying to re-release DWLMClientServiceContextImpl object " + dWLMClientServiceContext.toString());
            }
        }
    }
}

