/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dwlm.client;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.dwlm.client.DWLMClientImpl;
import com.ibm.ws.odc.cell.TargetTree;
import com.ibm.wsspi.dwlm.client.DWLMClientServiceContext;
import com.ibm.wsspi.dwlm.client.DWLMClientServiceContextInternal;
import com.ibm.wsspi.odc.ODCHelper;
import com.ibm.wsspi.odc.ODCNode;
import com.ibm.wsspi.odc.ODCTree;

public class DWLMClientServiceContextImpl
implements DWLMClientServiceContext,
DWLMClientServiceContextInternal {
    protected static final TraceComponent tc = Tr.register(DWLMClientServiceContextImpl.class, "DWLMClient", "com.ibm.ws.dwlm.client.nls.Messages");
    public static final boolean CACHING_ENABLED = false;
    private static final String[] IDS = new String[5];
    public static final String SLASH = "/";
    public static final String CELL = "cell=";
    public static final String APP = "application=";
    public static final String WM = "webModule=";
    public static final String WC = "workClass=";
    public static final String APPED = "applicationEdition=";
    public static final String DEP_IDS = "dep_ids";
    protected final DWLMClientImpl dwlmClient;
    protected boolean inUse;
    protected ODCNode cellNode;
    protected ODCNode applicationNode;
    protected ODCNode moduleNode;
    protected ODCNode clusterNode;
    protected ODCNode vHostGroupNode;
    protected ODCNode odcNode;
    protected Object object;
    protected String[] dependencyIds;
    protected StringBuffer sb = null;
    protected ODCTree targetTree;
    protected ODCHelper odc;

    public DWLMClientServiceContextImpl(DWLMClientImpl dWLMClientImpl) {
        this.dwlmClient = dWLMClientImpl;
        this.targetTree = TargetTree.getTree();
        this.inUse = true;
        try {
            this.odc = ODCHelper.getInstance();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public String[] getDependencyIds(ODCNode oDCNode) throws Exception {
        ODCNode oDCNode2 = oDCNode.getParent();
        String[] stringArray = (String[])oDCNode2.getTransientProperties().get(DEP_IDS);
        if (stringArray == null) {
            ODCNode oDCNode3 = oDCNode2.getParent();
            ODCNode oDCNode4 = oDCNode3.getParent();
            String string = oDCNode2.getName();
            String string2 = oDCNode3.getName();
            String string3 = oDCNode4.getName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "dependencyIds are built from ODC node.");
            }
            stringArray = new String[5];
            StringBuffer stringBuffer = new StringBuffer(64);
            stringBuffer.delete(0, stringBuffer.length());
            stringArray[0] = stringBuffer.append(CELL).append(string3).toString();
            stringBuffer.delete(0, stringBuffer.length());
            stringArray[1] = stringBuffer.append(APP).append(string3).append(SLASH).append(string2).toString();
            stringBuffer.delete(0, stringBuffer.length());
            stringArray[2] = stringBuffer.append(WM).append(string3).append(SLASH).append(string2).append(SLASH).append(string).toString();
            stringArray[3] = WC;
            stringArray[4] = APPED;
            oDCNode2.getTransientProperties().put(DEP_IDS, stringArray);
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "dependencyIds obtained from webModule ODCNode transient properties.");
        }
        return stringArray;
    }

    public void setDependencyIds(String[] stringArray) {
        System.arraycopy(stringArray, 0, this.dependencyIds, 0, stringArray.length);
    }

    public void setODCNode(ODCNode oDCNode) {
        this.odcNode = oDCNode;
        try {
            this.moduleNode = oDCNode.getParent();
            this.applicationNode = this.moduleNode.getParent();
            this.cellNode = this.applicationNode.getParent();
            this.initLinkedNodes();
            this.dependencyIds = this.getDependencyIds(this.odcNode);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public String[] getDependencyIds() {
        return this.dependencyIds;
    }

    public ODCNode getODCNode() {
        return this.odcNode;
    }

    public void release() throws Exception {
        this.odcNode = null;
        this.clusterNode = null;
        this.moduleNode = null;
        this.applicationNode = null;
        this.cellNode = null;
        this.vHostGroupNode = null;
        this.object = null;
        this.dwlmClient.releaseDWLMClientServiceContext(this);
    }

    public void setAttachment(Object object) {
        this.object = object;
    }

    public Object getAttachment() {
        return this.object;
    }

    public StringBuffer getBuffer() {
        return this.sb;
    }

    public ODCNode getCellNode() {
        return this.cellNode;
    }

    public void setCellNode(ODCNode oDCNode) {
        this.cellNode = oDCNode;
    }

    public ODCNode getApplicationNode() {
        return this.applicationNode;
    }

    public ODCNode getVirtualHostGroupNode() {
        return this.vHostGroupNode;
    }

    public void setApplicationNode(ODCNode oDCNode) {
        this.applicationNode = oDCNode;
    }

    public ODCNode getModuleNode() {
        return this.moduleNode;
    }

    public void setModuleNode(ODCNode oDCNode) {
        this.moduleNode = oDCNode;
    }

    public ODCNode getUriPatternNode() {
        return this.odcNode;
    }

    public ODCNode getClusterNode() {
        return this.clusterNode;
    }

    public void setClusterNode(ODCNode oDCNode) {
        this.clusterNode = oDCNode;
    }

    public boolean isFirstArrival() {
        return true;
    }

    public boolean isInUse() {
        return this.inUse;
    }

    public void setInUse(boolean bl) {
        this.inUse = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initLinkedNodes() throws Exception {
        ODCNode[] oDCNodeArray;
        ODCTree oDCTree = this.targetTree;
        synchronized (oDCTree) {
            this.moduleNode = this.targetTree.refreshNode(this.moduleNode);
            if (this.moduleNode == null) {
                throw new Exception("web module removed: " + this.moduleNode.getPath());
            }
            this.vHostGroupNode = this.moduleNode.getNode(this.odc.vhostGroup);
            oDCNodeArray = this.moduleNode.getNodes(this.odc.cluster);
        }
        if (oDCNodeArray.length == 0) {
            if (!this.isProxyRoutingRuleNode()) {
                throw new Exception("no cluster for module " + this.moduleNode.getPath());
            }
        } else {
            this.clusterNode = oDCNodeArray[0];
        }
        if (this.vHostGroupNode == null) {
            throw new Exception("no virtual host for module " + this.moduleNode.getPath());
        }
    }

    protected boolean isProxyRoutingRuleNode() throws Exception {
        boolean bl = false;
        if (this.moduleNode != null) {
            String string = (String)this.moduleNode.getProperty(this.odc.webModuleRedirectURL);
            Integer n = (Integer)this.moduleNode.getProperty(this.odc.webModuleFailureStatusCode);
            if (string != null && string.length() > 0 || n != null) {
                bl = true;
            }
        }
        return bl;
    }
}

