/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dwlm.client;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.dwlm.client.TargetClusterImpl;
import com.ibm.wsspi.dwlm.client.DWLMClientServiceContext;
import com.ibm.wsspi.dwlm.client.HttpTargetSelectorModule;
import com.ibm.wsspi.dwlm.client.PartitionIDData;
import com.ibm.wsspi.dwlm.client.TargetCluster;
import com.ibm.wsspi.dwlm.client.TargetServer;
import com.ibm.wsspi.http.channel.HttpRequestMessage;
import com.ibm.wsspi.odc.ODCHelper;
import com.ibm.wsspi.odc.ODCNode;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class HttpSessionAffinityModule
extends HttpTargetSelectorModule {
    private static final TraceComponent tc = Tr.register(HttpSessionAffinityModule.class, null, null);
    public static final String SSLJSESSIONID = "SSLJSESSION";
    public static final String JSESSIONID = "JSESSIONID";
    private static String[] sessionCookies = new String[]{"SSLJSESSION", "JSESSIONID"};
    protected static Map partitionIDDataMap = Collections.synchronizedMap(new HashMap());
    private static final char COLON = ':';
    private static PartitionIDData partitionIDData = PartitionIDData.EMPTY_PARTITION_ID_DATA;

    public String getName() {
        return "HttpSessionAffinity";
    }

    public TargetServer select(TargetCluster targetCluster, HttpRequestMessage httpRequestMessage) throws Exception {
        String string;
        int n;
        int n2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "select", new Object[]{targetCluster, httpRequestMessage});
        }
        String string2 = null;
        List list = null;
        String string3 = HttpSessionAffinityModule.getNonDefaultAppAffinityCookie(((TargetClusterImpl)targetCluster).getODCNode());
        if (string3 != null) {
            sessionCookies = new String[2];
            HttpSessionAffinityModule.sessionCookies[0] = SSLJSESSIONID;
            HttpSessionAffinityModule.sessionCookies[1] = string3;
        }
        for (n2 = 0; n2 < sessionCookies.length; ++n2) {
            byte[] byArray = httpRequestMessage.getCookieValue(sessionCookies[n2]);
            if (byArray == null) continue;
            string2 = new String(byArray);
            if (!tc.isDebugEnabled()) break;
            Tr.debug(tc, "cookieName=" + sessionCookies[n2] + ", sid=" + string2);
            break;
        }
        if (string2 == null && (n = (string = httpRequestMessage.getRequestURI()).indexOf("jsessionid")) >= 0 && string.length() > (n += 11)) {
            string2 = string.substring(n);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "URL encoding=" + string2);
            }
        }
        if (string2 == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "select", "no session affinity");
            }
            return null;
        }
        n2 = string2.indexOf(58);
        if (n2 < 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "select", "no colon in session ID: " + string2);
            }
            return null;
        }
        int n3 = string2.length();
        ++n2;
        while (n2 < n3) {
            int n4;
            TargetServer[] targetServerArray;
            TargetServer targetServer;
            String string4;
            int n5 = string2.indexOf(58, n2);
            if (n5 < 0) {
                string4 = string2.substring(n2);
                n2 = n3;
            } else {
                string4 = string2.substring(n2, n5 - 1);
                n2 = n5 + 1;
            }
            ODCNode oDCNode = ((TargetClusterImpl)targetCluster).getODCNode();
            String string5 = this.getCloneIDFromAnyPartitionIDData(string4);
            if (string5 != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "partition id is: " + string4);
                }
                string4 = string5;
            } else {
                list = httpRequestMessage.getAllCookieValues(JSESSIONID);
                boolean bl = false;
                if (list != null) {
                    for (int i = 0; i < list.size(); ++i) {
                        String string6 = (String)list.get(i);
                        if (string6 == null) continue;
                        string2 = string6;
                        bl = true;
                        if (!tc.isDebugEnabled()) break;
                        Tr.debug(tc, "Using the getAllCookieValues() call, cookieName=JSESSIONID, sid=" + string2);
                        break;
                    }
                    if (bl && (n2 = string2.indexOf(58)) > -1) {
                        n3 = string2.length();
                        ++n2;
                        continue;
                    }
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "clone id is: " + string4);
            }
            if ((targetServer = targetCluster.findServerByCloneId(string4)) == null) continue;
            if (targetServer.isAvailable()) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "select", targetServer);
                }
                return targetServer;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "breaking session affinity for " + string4 + " to " + targetServer);
            }
            if ((targetServerArray = targetCluster.getServers()).length == 0) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "select", "no servers in cluster");
                }
                return null;
            }
            int n6 = n4 = Math.abs(string4.hashCode()) % targetServerArray.length;
            do {
                if ((targetServer = targetServerArray[n6++]).isAvailable()) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "select", targetServer);
                    }
                    return targetServer;
                }
                if (n6 < targetServerArray.length) continue;
                n6 = 0;
            } while (n6 != n4);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "select", "no failover session affinity");
            }
            return null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "select", "no server with clone ID found");
        }
        return null;
    }

    public static String[] getSessionCookies() {
        return sessionCookies;
    }

    public static void setSessionCookies(String[] stringArray) {
        sessionCookies = stringArray;
    }

    public static void clearAllPartitionIDData() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "clearAllPartitionIDData");
        }
        partitionIDDataMap = Collections.synchronizedMap(new HashMap());
    }

    public static void setPartitionIDData(PartitionIDData partitionIDData, DWLMClientServiceContext dWLMClientServiceContext) {
        ODCNode oDCNode;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setPartitionIDData", new Object[]{partitionIDData, dWLMClientServiceContext});
        }
        if ((oDCNode = dWLMClientServiceContext.getClusterNode()) == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "Partition ID Data not set, no cluster node in context");
            }
            return;
        }
        String string = oDCNode.getPath();
        partitionIDDataMap.put(string, partitionIDData);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "Partition ID Data set to: " + partitionIDData);
        }
    }

    public static PartitionIDData getPartitionIDData(DWLMClientServiceContext dWLMClientServiceContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPartitionIDData", dWLMClientServiceContext);
        }
        if (dWLMClientServiceContext == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "Empty partition ID Data returned, no dwlm client context");
            }
            return PartitionIDData.EMPTY_PARTITION_ID_DATA;
        }
        ODCNode oDCNode = dWLMClientServiceContext.getClusterNode();
        if (oDCNode == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "Empty partition ID Data returned, no cluster node in context");
            }
            return PartitionIDData.EMPTY_PARTITION_ID_DATA;
        }
        String string = oDCNode.getPath();
        PartitionIDData partitionIDData = (PartitionIDData)partitionIDDataMap.get(string);
        if (partitionIDData != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getPartitionIDData returning " + partitionIDData);
            }
            return partitionIDData;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "Empty partition ID Data returned");
        }
        return PartitionIDData.EMPTY_PARTITION_ID_DATA;
    }

    protected String getCloneIDFromAnyPartitionIDData(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCloneIDFromAnyPartitionIDData", string);
        }
        Collection collection = partitionIDDataMap.values();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            PartitionIDData partitionIDData = (PartitionIDData)iterator.next();
            String string2 = (String)partitionIDData.getPartition2CloneIdMap().get(string);
            if (string2 == null) continue;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getCloneIDFromAnyPartitionIDData returning " + string2);
            }
            return string2;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCloneIDFromAnyPartitionIDData returning null");
        }
        return null;
    }

    public static String getNonDefaultAppAffinityCookie(ODCNode oDCNode) {
        String string = null;
        ODCNode oDCNode2 = null;
        try {
            Object object;
            ODCHelper oDCHelper = ODCHelper.getInstance();
            if (oDCNode.getType() == oDCHelper.uri) {
                object = oDCNode.getParent();
                oDCNode2 = object.getParent();
            } else if (oDCNode.getType() == oDCHelper.webModule) {
                oDCNode2 = oDCNode.getParent();
            }
            if (oDCNode2 != null) {
                string = (String)oDCNode2.getProperty(oDCHelper.appSessionAffinityCookie);
                object = oDCNode2.getProperty(oDCHelper.appSessionOverride);
                if (!string.equalsIgnoreCase(JSESSIONID) && ((Boolean)object).booleanValue()) {
                    return string;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static void setPartitionIDData(PartitionIDData partitionIDData) {
        HttpSessionAffinityModule.partitionIDData = partitionIDData;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Partition Data set to: ", partitionIDData);
        }
    }

    public static PartitionIDData getPartitionIDData() {
        return partitionIDData;
    }
}

